/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class SchedulerNode {
    private static final Log LOG = LogFactory.getLog(SchedulerNode.class);
    private Resource unallocatedResource = Resource.newInstance((int)0, (int)0);
    private Resource allocatedResource = Resource.newInstance((int)0, (int)0);
    private Resource totalResource;
    private RMContainer reservedContainer;
    private volatile int numContainers;
    private volatile ResourceUtilization containersUtilization = ResourceUtilization.newInstance((int)0, (int)0, (float)0.0f);
    private volatile ResourceUtilization nodeUtilization = ResourceUtilization.newInstance((int)0, (int)0, (float)0.0f);
    private final Map<ContainerId, ContainerInfo> launchedContainers = new HashMap<ContainerId, ContainerInfo>();
    private final RMNode rmNode;
    private final String nodeName;
    private final RMContext rmContext;
    private volatile Set<String> labels = null;
    private volatile Set<NodeAttribute> nodeAttributes = null;
    private volatile long lastHeartbeatMonotonicTime;

    public SchedulerNode(RMNode node, boolean usePortForNodeName, Set<String> labels) {
        this.rmNode = node;
        this.rmContext = node.getRMContext();
        this.unallocatedResource = Resources.clone((Resource)node.getTotalCapability());
        this.totalResource = Resources.clone((Resource)node.getTotalCapability());
        this.nodeName = usePortForNodeName ? this.rmNode.getHostName() + ":" + node.getNodeID().getPort() : this.rmNode.getHostName();
        this.labels = ImmutableSet.copyOf(labels);
        this.lastHeartbeatMonotonicTime = Time.monotonicNow();
    }

    public SchedulerNode(RMNode node, boolean usePortForNodeName) {
        this(node, usePortForNodeName, CommonNodeLabelsManager.EMPTY_STRING_SET);
    }

    public RMNode getRMNode() {
        return this.rmNode;
    }

    public synchronized void updateTotalResource(Resource resource) {
        this.totalResource = resource;
        this.unallocatedResource = Resources.subtract((Resource)this.totalResource, (Resource)this.allocatedResource);
    }

    public NodeId getNodeID() {
        return this.rmNode.getNodeID();
    }

    public String getHttpAddress() {
        return this.rmNode.getHttpAddress();
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getRackName() {
        return this.rmNode.getRackName();
    }

    public void allocateContainer(RMContainer rmContainer) {
        this.allocateContainer(rmContainer, false);
    }

    protected synchronized void allocateContainer(RMContainer rmContainer, boolean launchedOnNode) {
        Container container = rmContainer.getContainer();
        if (rmContainer.getExecutionType() == ExecutionType.GUARANTEED) {
            this.deductUnallocatedResource(container.getResource());
            ++this.numContainers;
        }
        this.launchedContainers.put(container.getId(), new ContainerInfo(rmContainer, launchedOnNode));
    }

    public synchronized Resource getUnallocatedResource() {
        return this.unallocatedResource;
    }

    public synchronized Resource getAllocatedResource() {
        return this.allocatedResource;
    }

    public synchronized Resource getTotalResource() {
        return this.totalResource;
    }

    public synchronized boolean isValidContainer(ContainerId containerId) {
        return this.launchedContainers.containsKey(containerId);
    }

    protected synchronized void updateResourceForReleasedContainer(Container container) {
        if (container.getExecutionType() == ExecutionType.GUARANTEED) {
            this.addUnallocatedResource(container.getResource());
            --this.numContainers;
        }
    }

    public synchronized void releaseContainer(ContainerId containerId, boolean releasedByNode) {
        ContainerInfo info = this.launchedContainers.get(containerId);
        if (info == null) {
            return;
        }
        if (!releasedByNode && info.launchedOnNode) {
            return;
        }
        this.launchedContainers.remove(containerId);
        Container container = info.container.getContainer();
        if (this.rmContext != null && this.rmContext.getAllocationTagsManager() != null) {
            this.rmContext.getAllocationTagsManager().removeContainer(container.getNodeId(), container.getId(), container.getAllocationTags());
        }
        this.updateResourceForReleasedContainer(container);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Released container " + container.getId() + " of capacity " + container.getResource() + " on host " + this.rmNode.getNodeAddress() + ", which currently has " + this.numContainers + " containers, " + this.getAllocatedResource() + " used and " + this.getUnallocatedResource() + " available, release resources=" + true));
        }
    }

    public synchronized void containerStarted(ContainerId containerId) {
        ContainerInfo info = this.launchedContainers.get(containerId);
        if (info != null) {
            info.launchedOnNode = true;
        }
    }

    private synchronized void addUnallocatedResource(Resource resource) {
        if (resource == null) {
            LOG.error((Object)("Invalid resource addition of null resource for " + this.rmNode.getNodeAddress()));
            return;
        }
        Resources.addTo((Resource)this.unallocatedResource, (Resource)resource);
        Resources.subtractFrom((Resource)this.allocatedResource, (Resource)resource);
    }

    @VisibleForTesting
    public synchronized void deductUnallocatedResource(Resource resource) {
        if (resource == null) {
            LOG.error((Object)("Invalid deduction of null resource for " + this.rmNode.getNodeAddress()));
            return;
        }
        Resources.subtractFrom((Resource)this.unallocatedResource, (Resource)resource);
        Resources.addTo((Resource)this.allocatedResource, (Resource)resource);
    }

    public abstract void reserveResource(SchedulerApplicationAttempt var1, SchedulerRequestKey var2, RMContainer var3);

    public abstract void unreserveResource(SchedulerApplicationAttempt var1);

    public String toString() {
        return "host: " + this.rmNode.getNodeAddress() + " #containers=" + this.getNumContainers() + " available=" + this.getUnallocatedResource() + " used=" + this.getAllocatedResource();
    }

    public int getNumContainers() {
        return this.numContainers;
    }

    public synchronized List<RMContainer> getCopiedListOfRunningContainers() {
        ArrayList<RMContainer> result = new ArrayList<RMContainer>(this.launchedContainers.size());
        for (ContainerInfo info : this.launchedContainers.values()) {
            result.add(info.container);
        }
        return result;
    }

    public synchronized List<RMContainer> getRunningContainersWithAMsAtTheEnd() {
        LinkedList<RMContainer> result = new LinkedList<RMContainer>();
        for (ContainerInfo info : this.launchedContainers.values()) {
            if (info.container.isAMContainer()) {
                result.addLast(info.container);
                continue;
            }
            result.addFirst(info.container);
        }
        return result;
    }

    protected synchronized RMContainer getContainer(ContainerId containerId) {
        RMContainer container = null;
        ContainerInfo info = this.launchedContainers.get(containerId);
        if (info != null) {
            container = info.container;
        }
        return container;
    }

    public synchronized RMContainer getReservedContainer() {
        return this.reservedContainer;
    }

    public synchronized void setReservedContainer(RMContainer reservedContainer) {
        this.reservedContainer = reservedContainer;
    }

    public synchronized void recoverContainer(RMContainer rmContainer) {
        if (rmContainer.getState().equals((Object)RMContainerState.COMPLETED)) {
            return;
        }
        this.allocateContainer(rmContainer, true);
    }

    public Set<String> getLabels() {
        return this.labels;
    }

    public void updateLabels(Set<String> labels) {
        this.labels = labels;
    }

    public String getPartition() {
        if (this.labels == null || this.labels.isEmpty()) {
            return "";
        }
        return this.labels.iterator().next();
    }

    public void setAggregatedContainersUtilization(ResourceUtilization containersUtilization) {
        this.containersUtilization = containersUtilization;
    }

    public ResourceUtilization getAggregatedContainersUtilization() {
        return this.containersUtilization;
    }

    public void setNodeUtilization(ResourceUtilization nodeUtilization) {
        this.nodeUtilization = nodeUtilization;
    }

    public ResourceUtilization getNodeUtilization() {
        return this.nodeUtilization;
    }

    public long getLastHeartbeatMonotonicTime() {
        return this.lastHeartbeatMonotonicTime;
    }

    public void notifyNodeUpdate() {
        this.lastHeartbeatMonotonicTime = Time.monotonicNow();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchedulerNode)) {
            return false;
        }
        SchedulerNode that = (SchedulerNode)o;
        return this.getNodeID().equals((Object)that.getNodeID());
    }

    public int hashCode() {
        return this.getNodeID().hashCode();
    }

    public Set<NodeAttribute> getNodeAttributes() {
        return this.nodeAttributes;
    }

    public void updateNodeAttributes(Set<NodeAttribute> attributes) {
        this.nodeAttributes = attributes;
    }

    private static class ContainerInfo {
        private final RMContainer container;
        private boolean launchedOnNode;

        public ContainerInfo(RMContainer container, boolean launchedOnNode) {
            this.container = container;
            this.launchedOnNode = launchedOnNode;
        }
    }
}

