/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityVector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractAutoCreatedLeafQueue
extends AbstractLeafQueue {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAutoCreatedLeafQueue.class);
    protected AbstractManagedParentQueue parent;

    public AbstractAutoCreatedLeafQueue(CapacitySchedulerQueueContext queueContext, String queueName, AbstractManagedParentQueue parent, CSQueue old) throws IOException {
        super(queueContext, queueName, parent, old);
        this.parent = parent;
    }

    public void setEntitlement(QueueEntitlement entitlement) throws SchedulerDynamicEditException {
        this.setEntitlement("", entitlement);
    }

    @Override
    protected Resource getMinimumAbsoluteResource(String queuePath, String label) {
        return super.getMinimumAbsoluteResource(this.queueContext.getConfiguration().getAutoCreatedQueueTemplateConfPrefix(this.getParent().getQueuePath()), label);
    }

    @Override
    protected Resource getMaximumAbsoluteResource(String queuePath, String label) {
        return super.getMaximumAbsoluteResource(this.queueContext.getConfiguration().getAutoCreatedQueueTemplateConfPrefix(this.getParent().getQueuePath()), label);
    }

    @Override
    protected boolean checkConfigTypeIsAbsoluteResource(String queuePath, String label) {
        return super.checkConfigTypeIsAbsoluteResource(this.queueContext.getConfiguration().getAutoCreatedQueueTemplateConfPrefix(this.getParent().getQueuePath()), label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntitlement(String nodeLabel, QueueEntitlement entitlement) throws SchedulerDynamicEditException {
        this.writeLock.lock();
        try {
            float capacity = entitlement.getCapacity();
            if (capacity < 0.0f || capacity > 1.0f) {
                throw new SchedulerDynamicEditException("Capacity demand is not in the [0,1] range: " + capacity);
            }
            this.setCapacity(nodeLabel, capacity);
            this.setAbsoluteCapacity(nodeLabel, this.getParent().getQueueCapacities().getAbsoluteCapacity(nodeLabel) * this.getQueueCapacities().getCapacity(nodeLabel));
            this.setMaxCapacity(nodeLabel, entitlement.getMaxCapacity());
            this.setConfiguredMinCapacityVector(nodeLabel, QueueCapacityVector.of(this.queueCapacities.getCapacity(nodeLabel) * 100.0f, QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE));
            this.setConfiguredMaxCapacityVector(nodeLabel, QueueCapacityVector.of(this.queueCapacities.getMaximumCapacity(nodeLabel) * 100.0f, QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE));
            if (LOG.isDebugEnabled()) {
                LOG.debug("successfully changed to " + capacity + " for queue " + this.getQueuePath());
            }
            CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this.queueContext.getClusterResource(), this, this.labelManager, nodeLabel);
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

