/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.AccessRequest;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.security.PrivilegedEntity;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueResourceQuotas;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractAutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueInfoProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueuePreemptionSettings;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUsageTracker;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.PlanQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueAllocationSettings;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueAppLifetimeAndLimitSettings;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityVector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueNodeLabelsSettings;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueStateHelper;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ReservationQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UserWeights;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ContainerAllocationProposal;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ResourceCommitRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.SchedulerContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.SimpleCandidateNodeSet;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCSQueue
implements CSQueue {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCSQueue.class);
    protected final QueueAllocationSettings queueAllocationSettings;
    volatile CSQueue parent;
    protected final QueuePath queuePath;
    protected QueueNodeLabelsSettings queueNodeLabelsSettings;
    private volatile QueueAppLifetimeAndLimitSettings queueAppLifetimeSettings;
    private CSQueuePreemptionSettings preemptionSettings;
    private volatile QueueState state = null;
    protected final PrivilegedEntity queueEntity;
    final ResourceCalculator resourceCalculator;
    Set<String> resourceTypes;
    final RMNodeLabelsManager labelManager;
    private String multiNodeSortingPolicyName = null;
    Map<AccessType, AccessControlList> acls = new HashMap<AccessType, AccessControlList>();
    volatile boolean reservationsContinueLooking;
    QueueCapacities queueCapacities;
    CSQueueUsageTracker usageTracker;
    protected CapacityConfigType capacityConfigType = CapacityConfigType.NONE;
    protected Map<String, QueueCapacityVector> configuredCapacityVectors;
    protected Map<String, QueueCapacityVector> configuredMaxCapacityVectors;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected CapacitySchedulerQueueContext queueContext;
    protected YarnAuthorizationProvider authorizer = null;
    protected ActivitiesManager activitiesManager;
    protected ReentrantReadWriteLock.ReadLock readLock;
    protected ReentrantReadWriteLock.WriteLock writeLock;
    volatile Priority priority = Priority.newInstance((int)0);
    private UserWeights userWeights = UserWeights.createEmpty();
    private boolean dynamicQueue = false;

    public AbstractCSQueue(CapacitySchedulerQueueContext queueContext, String queueName, CSQueue parent, CSQueue old) {
        this.parent = parent;
        this.queuePath = AbstractCSQueue.createQueuePath(parent, queueName);
        this.queueContext = queueContext;
        this.resourceCalculator = queueContext.getResourceCalculator();
        this.activitiesManager = queueContext.getActivitiesManager();
        this.labelManager = queueContext.getLabelManager();
        CSQueueMetrics metrics = old != null ? (CSQueueMetrics)old.getMetrics() : CSQueueMetrics.forQueue(this.getQueuePath(), parent, queueContext.getConfiguration().getEnableUserMetrics(), queueContext.getConfiguration());
        this.usageTracker = new CSQueueUsageTracker(metrics);
        this.queueCapacities = new QueueCapacities(parent == null);
        this.queueAllocationSettings = new QueueAllocationSettings(queueContext.getMinimumAllocation());
        this.queueEntity = new PrivilegedEntity(PrivilegedEntity.EntityType.QUEUE, this.getQueuePath());
        this.resourceTypes = new HashSet<String>();
        for (CapacitySchedulerConfiguration.AbsoluteResourceType type : CapacitySchedulerConfiguration.AbsoluteResourceType.values()) {
            this.resourceTypes.add(type.toString().toLowerCase());
        }
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        LOG.debug("Initialized {}: name={}, fullname={}", new Object[]{this.getClass().getSimpleName(), queueName, this.getQueuePath()});
    }

    private static QueuePath createQueuePath(CSQueue parent, String queueName) {
        if (parent == null) {
            return new QueuePath(null, queueName);
        }
        return new QueuePath(parent.getQueuePath(), queueName);
    }

    protected void setupConfigurableCapacities() {
        CSQueueUtils.loadCapacitiesByLabelsFromConf(this.queuePath, this.queueCapacities, this.queueContext.getConfiguration(), this.queueNodeLabelsSettings.getConfiguredNodeLabels());
    }

    @Override
    public String getQueuePath() {
        return this.queuePath.getFullPath();
    }

    @Override
    public QueuePath getQueuePathObject() {
        return this.queuePath;
    }

    @Override
    public float getCapacity() {
        return this.queueCapacities.getCapacity();
    }

    @Override
    public float getAbsoluteCapacity() {
        return this.queueCapacities.getAbsoluteCapacity();
    }

    @Override
    public float getAbsoluteMaximumCapacity() {
        return this.queueCapacities.getAbsoluteMaximumCapacity();
    }

    @Override
    public float getAbsoluteUsedCapacity() {
        return this.queueCapacities.getAbsoluteUsedCapacity();
    }

    @Override
    public float getMaximumCapacity() {
        return this.queueCapacities.getMaximumCapacity();
    }

    @Override
    public float getUsedCapacity() {
        return this.queueCapacities.getUsedCapacity();
    }

    @Override
    public Resource getUsedResources() {
        return this.usageTracker.getQueueUsage().getUsed();
    }

    public int getNumContainers() {
        return this.usageTracker.getNumContainers();
    }

    @Override
    public QueueState getState() {
        return this.state;
    }

    @Override
    public CSQueueMetrics getMetrics() {
        return this.usageTracker.getMetrics();
    }

    @Override
    public String getQueueShortName() {
        return this.queuePath.getLeafName();
    }

    @Override
    public String getQueueName() {
        return this.queuePath.getLeafName();
    }

    @Override
    public CSQueue getParent() {
        return this.parent;
    }

    @Override
    public void setParent(CSQueue newParentQueue) {
        this.parent = newParentQueue;
        this.getMetrics().setParentQueue(newParentQueue);
    }

    @Override
    public PrivilegedEntity getPrivilegedEntity() {
        return this.queueEntity;
    }

    public CapacitySchedulerQueueContext getQueueContext() {
        return this.queueContext;
    }

    @Override
    public Set<String> getAccessibleNodeLabels() {
        return this.queueNodeLabelsSettings.getAccessibleNodeLabels();
    }

    @Override
    public boolean hasAccess(QueueACL acl, UserGroupInformation user) {
        return this.authorizer.checkPermission(new AccessRequest(this.queueEntity, user, SchedulerUtils.toAccessType(acl), null, null, Server.getRemoteAddress(), null));
    }

    @VisibleForTesting
    void setMaxCapacity(float maximumCapacity) {
        this.internalSetMaximumCapacity(maximumCapacity, "");
    }

    void setMaxCapacity(String nodeLabel, float maximumCapacity) {
        this.internalSetMaximumCapacity(maximumCapacity, nodeLabel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSetMaximumCapacity(float maximumCapacity, String nodeLabel) {
        this.writeLock.lock();
        try {
            CSQueueUtils.checkMaxCapacity(this.queuePath, this.queueCapacities.getCapacity(nodeLabel), maximumCapacity);
            float absMaxCapacity = CSQueueUtils.computeAbsoluteMaximumCapacity(maximumCapacity, this.parent);
            CSQueueUtils.checkAbsoluteCapacity(this.queuePath, this.queueCapacities.getAbsoluteCapacity(nodeLabel), absMaxCapacity);
            this.queueCapacities.setMaximumCapacity(maximumCapacity);
            this.queueCapacities.setAbsoluteMaximumCapacity(absMaxCapacity);
            this.configuredMaxCapacityVectors.put("", QueueCapacityVector.of(maximumCapacity * 100.0f, QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public String getDefaultNodeLabelExpression() {
        return this.queueNodeLabelsSettings.getDefaultLabelExpression();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupQueueConfigs(Resource clusterResource) throws IOException {
        this.writeLock.lock();
        try {
            CapacitySchedulerConfiguration configuration = this.queueContext.getConfiguration();
            this.acls = configuration.getAcls(this.getQueuePath());
            if (this.isDynamicQueue() || this instanceof AbstractAutoCreatedLeafQueue) {
                this.setDynamicQueueProperties();
                this.setDynamicQueueACLProperties();
            }
            this.queueNodeLabelsSettings = new QueueNodeLabelsSettings(configuration, this.parent, this.queuePath, this.queueContext.getQueueManager().getConfiguredNodeLabelsForAllQueues());
            this.setupConfigurableCapacities();
            this.updateAbsoluteCapacities();
            this.updateConfigurableResourceLimits(clusterResource);
            this.queueAllocationSettings.setupMaximumAllocation(configuration, this.getQueuePath(), this.parent);
            QueueStateHelper.setQueueState(this);
            this.authorizer = YarnAuthorizationProvider.getInstance((Configuration)configuration);
            this.userWeights = this.getUserWeightsFromHierarchy();
            this.reservationsContinueLooking = configuration.getReservationContinueLook();
            this.configuredCapacityVectors = configuration.parseConfiguredResourceVector(this.queuePath.getFullPath(), this.queueNodeLabelsSettings.getConfiguredNodeLabels());
            this.configuredMaxCapacityVectors = configuration.parseConfiguredMaximumCapacityVector(this.queuePath.getFullPath(), this.queueNodeLabelsSettings.getConfiguredNodeLabels(), QueueCapacityVector.newInstance());
            if (this instanceof ReservationQueue || this instanceof PlanQueue) {
                for (String label : this.queueNodeLabelsSettings.getConfiguredNodeLabels()) {
                    this.setConfiguredMinCapacityVector(label, QueueCapacityVector.of(this.queueCapacities.getCapacity(label) * 100.0f, QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE));
                    this.setConfiguredMaxCapacityVector(label, QueueCapacityVector.of(this.queueCapacities.getMaximumCapacity(label) * 100.0f, QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE));
                }
            }
            for (String label : this.queueNodeLabelsSettings.getConfiguredNodeLabels()) {
                QueueCapacityVector capacityVector = this.configuredCapacityVectors.get(label);
                Set<QueueCapacityVector.ResourceUnitCapacityType> definedCapacityTypes = capacityVector.getDefinedCapacityTypes();
                if (definedCapacityTypes.size() != 1 || definedCapacityTypes.iterator().next() != QueueCapacityVector.ResourceUnitCapacityType.WEIGHT) continue;
                HashSet<Double> weights = new HashSet<Double>();
                for (String resourceName : capacityVector.getResourceNames()) {
                    weights.add(capacityVector.getResource(resourceName).getResourceValue());
                }
                if (weights.size() != 1) continue;
                this.queueCapacities.setWeight(label, ((Double)weights.iterator().next()).floatValue());
            }
            this.updateCapacityConfigType();
            CSQueueUtils.updateQueueStatistics(this.resourceCalculator, clusterResource, this, this.labelManager, null);
            this.preemptionSettings = new CSQueuePreemptionSettings(this, configuration);
            this.priority = configuration.getQueuePriority(this.getQueuePath());
            this.setMultiNodeSortingPolicyName(configuration.getMultiNodesSortingAlgorithmPolicy(this.getQueuePath()));
            this.queueAppLifetimeSettings = new QueueAppLifetimeAndLimitSettings(configuration, this, this.queuePath);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void setDynamicQueueProperties() {
        if (this.parent instanceof AbstractParentQueue && this.isDynamicQueue()) {
            ((AbstractParentQueue)this.parent).getAutoCreatedQueueTemplate().setTemplateEntriesForChild(this.queueContext.getConfiguration(), this.getQueuePath());
            String parentTemplate = String.format("%s.%s", this.parent.getQueuePath(), "auto-queue-creation-v2.template.");
            parentTemplate = parentTemplate.substring(0, parentTemplate.lastIndexOf("."));
            Set<String> parentNodeLabels = this.queueContext.getQueueManager().getConfiguredNodeLabelsForAllQueues().getLabelsByQueue(parentTemplate);
            if (parentNodeLabels != null) {
                if (parentNodeLabels.size() > 1) {
                    this.queueContext.getQueueManager().getConfiguredNodeLabelsForAllQueues().setLabelsByQueue(this.getQueuePath(), new HashSet<String>(parentNodeLabels));
                }
                for (String label : parentNodeLabels) {
                    float weightByLabel = this.queueContext.getConfiguration().getLabeledQueueWeight(this.queuePath, label);
                    if (weightByLabel != -1.0f) continue;
                    this.queueContext.getConfiguration().setLabeledQueueWeight(this.queuePath.getFullPath(), label, 1.0f);
                }
            }
        }
    }

    protected void setDynamicQueueACLProperties() {
    }

    private UserWeights getUserWeightsFromHierarchy() {
        UserWeights unionInheritedWeights = UserWeights.createEmpty();
        CSQueue parentQ = this.parent;
        if (parentQ != null) {
            unionInheritedWeights.addFrom(parentQ.getUserWeights());
        }
        unionInheritedWeights.addFrom(this.queueContext.getConfiguration().getAllUserWeightsForQueue(this.getQueuePath()));
        return unionInheritedWeights;
    }

    protected Resource getMinimumAbsoluteResource(String queuePath, String label) {
        return this.queueContext.getConfiguration().getMinimumResourceRequirement(label, queuePath, this.resourceTypes);
    }

    protected Resource getMaximumAbsoluteResource(String queuePath, String label) {
        return this.queueContext.getConfiguration().getMaximumResourceRequirement(label, queuePath, this.resourceTypes);
    }

    protected boolean checkConfigTypeIsAbsoluteResource(String queuePath, String label) {
        return this.queueContext.getConfiguration().checkConfigTypeIsAbsoluteResource(label, queuePath, this.resourceTypes);
    }

    protected void updateCapacityConfigType() {
        this.capacityConfigType = CapacityConfigType.NONE;
        for (String label : this.queueNodeLabelsSettings.getConfiguredNodeLabels()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("capacityConfigType is '{}' for queue {}", (Object)this.capacityConfigType, (Object)this.getQueuePath());
            }
            CapacityConfigType localType = CapacityConfigType.NONE;
            if (this.queueContext.getConfiguration().isLegacyQueueMode()) {
                localType = this.checkConfigTypeIsAbsoluteResource(this.getQueuePath(), label) ? CapacityConfigType.ABSOLUTE_RESOURCE : CapacityConfigType.PERCENTAGE;
            } else {
                Set<QueueCapacityVector.ResourceUnitCapacityType> definedCapacityTypes = this.getConfiguredCapacityVector(label).getDefinedCapacityTypes();
                if (definedCapacityTypes.size() == 1) {
                    QueueCapacityVector.ResourceUnitCapacityType next = definedCapacityTypes.iterator().next();
                    if (Objects.requireNonNull(next) == QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE) {
                        localType = CapacityConfigType.PERCENTAGE;
                    } else if (next == QueueCapacityVector.ResourceUnitCapacityType.ABSOLUTE) {
                        localType = CapacityConfigType.ABSOLUTE_RESOURCE;
                    } else if (next == QueueCapacityVector.ResourceUnitCapacityType.WEIGHT) {
                        localType = CapacityConfigType.PERCENTAGE;
                    }
                } else {
                    localType = CapacityConfigType.PERCENTAGE;
                }
            }
            if (this.capacityConfigType.equals((Object)CapacityConfigType.NONE)) {
                this.capacityConfigType = localType;
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("capacityConfigType is updated as '" + (Object)((Object)this.capacityConfigType) + "' for queue '" + this.getQueuePath());
                continue;
            }
            this.validateAbsoluteVsPercentageCapacityConfig(localType);
        }
    }

    protected void updateConfigurableResourceLimits(Resource clusterResource) {
        for (String label : this.queueNodeLabelsSettings.getConfiguredNodeLabels()) {
            Resource minResource = this.getMinimumAbsoluteResource(this.getQueuePath(), label);
            Resource maxResource = this.getMaximumAbsoluteResource(this.getQueuePath(), label);
            if (this.parent != null) {
                Resource parentMax = this.parent.getQueueResourceQuotas().getConfiguredMaxResource(label);
                this.validateMinResourceIsNotGreaterThanMaxResource(maxResource, parentMax, clusterResource, "Max resource configuration " + maxResource + " is greater than parents max value:" + parentMax + " in queue:" + this.getQueuePath());
                if (maxResource.equals((Object)Resources.none()) && !minResource.equals((Object)Resources.none()) && !parentMax.equals((Object)Resources.none())) {
                    maxResource = Resources.clone((Resource)parentMax);
                }
            }
            this.validateMinResourceIsNotGreaterThanMaxResource(minResource, maxResource, clusterResource, "Min resource configuration " + minResource + " is greater than its max value:" + maxResource + " in queue:" + this.getQueuePath());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updating absolute resource configuration for queue:{} as minResource={} and maxResource={}", new Object[]{this.getQueuePath(), minResource, maxResource});
            }
            this.usageTracker.getQueueResourceQuotas().setConfiguredMinResource(label, minResource);
            this.usageTracker.getQueueResourceQuotas().setConfiguredMaxResource(label, maxResource);
        }
    }

    private void validateMinResourceIsNotGreaterThanMaxResource(Resource minResource, Resource maxResource, Resource clusterResource, String validationError) {
        if (!maxResource.equals((Object)Resources.none()) && Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)minResource, (Resource)maxResource)) {
            throw new IllegalArgumentException(validationError);
        }
    }

    private void validateAbsoluteVsPercentageCapacityConfig(CapacityConfigType localType) {
        if (!this.queuePath.isRoot() && !this.capacityConfigType.equals((Object)localType) && this.queueContext.getConfiguration().isLegacyQueueMode()) {
            throw new IllegalArgumentException("Queue '" + this.getQueuePath() + "' should use either percentage based capacity configuration or absolute resource.");
        }
    }

    @Override
    public CapacityConfigType getCapacityConfigType() {
        return this.capacityConfigType;
    }

    @Override
    public Resource getEffectiveCapacity(String label) {
        return Resources.clone((Resource)this.getQueueResourceQuotas().getEffectiveMinResource(label));
    }

    @Override
    public Resource getEffectiveCapacityDown(String label, Resource factor) {
        return Resources.normalizeDown((ResourceCalculator)this.resourceCalculator, (Resource)this.getQueueResourceQuotas().getEffectiveMinResource(label), (Resource)this.queueAllocationSettings.getMinimumAllocation());
    }

    @Override
    public Resource getEffectiveMaxCapacity(String label) {
        return Resources.clone((Resource)this.getQueueResourceQuotas().getEffectiveMaxResource(label));
    }

    @Override
    public Resource getEffectiveMaxCapacityDown(String label, Resource factor) {
        return Resources.normalizeDown((ResourceCalculator)this.resourceCalculator, (Resource)this.getQueueResourceQuotas().getEffectiveMaxResource(label), (Resource)this.queueAllocationSettings.getMinimumAllocation());
    }

    @Override
    public QueueCapacityVector getConfiguredCapacityVector(String label) {
        return this.configuredCapacityVectors.get(label);
    }

    @Override
    public QueueCapacityVector getConfiguredMaxCapacityVector(String label) {
        return this.configuredMaxCapacityVectors.get(label);
    }

    @Override
    public void setConfiguredMinCapacityVector(String label, QueueCapacityVector minCapacityVector) {
        this.configuredCapacityVectors.put(label, minCapacityVector);
    }

    @Override
    public void setConfiguredMaxCapacityVector(String label, QueueCapacityVector maxCapacityVector) {
        this.configuredMaxCapacityVectors.put(label, maxCapacityVector);
    }

    protected QueueInfo getQueueInfo() {
        return CSQueueInfoProvider.getQueueInfo(this);
    }

    @Override
    @InterfaceAudience.Private
    public Resource getMaximumAllocation() {
        return this.queueAllocationSettings.getMaximumAllocation();
    }

    @Override
    @InterfaceAudience.Private
    public Resource getMinimumAllocation() {
        return this.queueAllocationSettings.getMinimumAllocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void allocateResource(Resource clusterResource, Resource resource, String nodePartition) {
        this.writeLock.lock();
        try {
            this.usageTracker.getQueueUsage().incUsed(nodePartition, resource);
            this.usageTracker.increaseNumContainers();
            CSQueueUtils.updateQueueStatistics(this.resourceCalculator, clusterResource, this, this.labelManager, nodePartition);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseResource(Resource clusterResource, Resource resource, String nodePartition) {
        this.writeLock.lock();
        try {
            this.usageTracker.getQueueUsage().decUsed(nodePartition, resource);
            CSQueueUtils.updateQueueStatistics(this.resourceCalculator, clusterResource, this, this.labelManager, nodePartition);
            this.usageTracker.decreaseNumContainers();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @InterfaceAudience.Private
    public boolean isReservationsContinueLooking() {
        return this.reservationsContinueLooking;
    }

    @InterfaceAudience.Private
    public Map<AccessType, AccessControlList> getACLs() {
        this.readLock.lock();
        try {
            Map<AccessType, AccessControlList> map = this.acls;
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    @InterfaceAudience.Private
    public boolean getPreemptionDisabled() {
        return this.preemptionSettings.isPreemptionDisabled();
    }

    @Override
    @InterfaceAudience.Private
    public boolean getIntraQueuePreemptionDisabled() {
        return this.preemptionSettings.isIntraQueuePreemptionDisabled();
    }

    @Override
    @InterfaceAudience.Private
    public boolean getIntraQueuePreemptionDisabledInHierarchy() {
        return this.preemptionSettings.isIntraQueuePreemptionDisabledInHierarchy();
    }

    @Override
    @InterfaceAudience.Private
    public QueueCapacities getQueueCapacities() {
        return this.queueCapacities;
    }

    @Override
    @InterfaceAudience.Private
    public ResourceUsage getQueueResourceUsage() {
        return this.usageTracker.getQueueUsage();
    }

    @Override
    public QueueResourceQuotas getQueueResourceQuotas() {
        return this.usageTracker.getQueueResourceQuotas();
    }

    @Override
    public ReentrantReadWriteLock.ReadLock getReadLock() {
        return this.readLock;
    }

    @Override
    public ReentrantReadWriteLock.WriteLock getWriteLock() {
        return this.writeLock;
    }

    private Resource getCurrentLimitResource(String nodePartition, Resource clusterResource, ResourceLimits currentResourceLimits, SchedulingMode schedulingMode) {
        if (schedulingMode == SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY) {
            Resource queueMaxResource = this.getQueueMaxResource(nodePartition);
            return Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)queueMaxResource, (Resource)currentResourceLimits.getLimit());
        }
        if (schedulingMode == SchedulingMode.IGNORE_PARTITION_EXCLUSIVITY) {
            return this.labelManager.getResourceByLabel(nodePartition, clusterResource);
        }
        return Resources.none();
    }

    Resource getQueueMaxResource(String nodePartition) {
        return this.getEffectiveMaxCapacity(nodePartition);
    }

    @VisibleForTesting
    boolean hasChildQueues() {
        List<CSQueue> childQueues = this.getChildQueues();
        return childQueues != null && !childQueues.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canAssignToThisQueue(Resource clusterResource, String nodePartition, ResourceLimits currentResourceLimits, Resource resourceCouldBeUnreserved, SchedulingMode schedulingMode) {
        this.readLock.lock();
        try {
            Resource nowTotalUsed;
            Resource currentLimitResource = this.getCurrentLimitResource(nodePartition, clusterResource, currentResourceLimits, schedulingMode);
            Resource usedExceptKillable = nowTotalUsed = this.usageTracker.getQueueUsage().getUsed(nodePartition);
            if (this.hasChildQueues()) {
                usedExceptKillable = Resources.subtract((Resource)nowTotalUsed, (Resource)this.getTotalKillableResource(nodePartition));
            }
            currentResourceLimits.setHeadroom(Resources.subtract((Resource)currentLimitResource, (Resource)usedExceptKillable));
            if (Resources.greaterThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)usedExceptKillable, (Resource)currentLimitResource)) {
                Resource newTotalWithoutReservedResource;
                if (this.reservationsContinueLooking && Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)resourceCouldBeUnreserved, (Resource)Resources.none()) && Resources.lessThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)(newTotalWithoutReservedResource = Resources.subtract((Resource)usedExceptKillable, (Resource)resourceCouldBeUnreserved)), (Resource)currentLimitResource)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("try to use reserved: " + this.getQueuePath() + " usedResources: " + this.usageTracker.getQueueUsage().getUsed() + ", clusterResources: " + clusterResource + ", reservedResources: " + resourceCouldBeUnreserved + ", capacity-without-reserved: " + newTotalWithoutReservedResource + ", maxLimitCapacity: " + currentLimitResource);
                    }
                    boolean bl = true;
                    return bl;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Failed to assign to queue: " + this.getQueuePath() + " nodePartition: " + nodePartition + ", usedResources: " + this.usageTracker.getQueueUsage().getUsed(nodePartition) + ", clusterResources: " + clusterResource + ", reservedResources: " + resourceCouldBeUnreserved + ", maxLimitCapacity: " + currentLimitResource + ", currTotalUsed:" + usedExceptKillable);
                }
                boolean bl = false;
                return bl;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Check assign to queue: " + this.getQueuePath() + " nodePartition: " + nodePartition + ", usedResources: " + this.usageTracker.getQueueUsage().getUsed(nodePartition) + ", clusterResources: " + clusterResource + ", currentUsedCapacity: " + Resources.divide((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)this.usageTracker.getQueueUsage().getUsed(nodePartition), (Resource)this.labelManager.getResourceByLabel(nodePartition, clusterResource)) + ", max-capacity: " + this.queueCapacities.getAbsoluteMaximumCapacity(nodePartition));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<String> getConfiguredNodeLabels() {
        return this.queueNodeLabelsSettings.getConfiguredNodeLabels();
    }

    private static String ensurePartition(String partition) {
        return Optional.ofNullable(partition).orElse("");
    }

    private void count(String partition, Resource resource, Counter counter, Counter parentCounter) {
        String checkedPartition = AbstractCSQueue.ensurePartition(partition);
        counter.count(checkedPartition, resource);
        Optional.ofNullable(parentCounter).ifPresent(c -> c.count(checkedPartition, resource));
    }

    private void countAndUpdate(String partition, Resource resource, Counter counter, CounterWithApp parentCounter) {
        String checkedPartition = AbstractCSQueue.ensurePartition(partition);
        counter.count(checkedPartition, resource);
        CSQueueUtils.updateUsedCapacity(this.resourceCalculator, this.labelManager.getResourceByLabel(checkedPartition, Resources.none()), checkedPartition, this);
        Optional.ofNullable(parentCounter).ifPresent(c -> c.count(checkedPartition, resource, null));
    }

    @Override
    public void incReservedResource(String partition, Resource reservedRes) {
        this.count(partition, reservedRes, this.usageTracker.getQueueUsage()::incReserved, this.parent == null ? null : this.parent::incReservedResource);
    }

    @Override
    public void decReservedResource(String partition, Resource reservedRes) {
        this.count(partition, reservedRes, this.usageTracker.getQueueUsage()::decReserved, this.parent == null ? null : this.parent::decReservedResource);
    }

    @Override
    public void incPendingResource(String nodeLabel, Resource resourceToInc) {
        this.count(nodeLabel, resourceToInc, this.usageTracker.getQueueUsage()::incPending, this.parent == null ? null : this.parent::incPendingResource);
    }

    @Override
    public void decPendingResource(String nodeLabel, Resource resourceToDec) {
        this.count(nodeLabel, resourceToDec, this.usageTracker.getQueueUsage()::decPending, this.parent == null ? null : this.parent::decPendingResource);
    }

    @Override
    public void incUsedResource(String nodeLabel, Resource resourceToInc, SchedulerApplicationAttempt application) {
        this.countAndUpdate(nodeLabel, resourceToInc, this.usageTracker.getQueueUsage()::incUsed, this.parent == null ? null : this.parent::incUsedResource);
    }

    @Override
    public void decUsedResource(String nodeLabel, Resource resourceToDec, SchedulerApplicationAttempt application) {
        this.countAndUpdate(nodeLabel, resourceToDec, this.usageTracker.getQueueUsage()::decUsed, this.parent == null ? null : this.parent::decUsedResource);
    }

    boolean hasPendingResourceRequest(String nodePartition, Resource cluster, SchedulingMode schedulingMode) {
        return SchedulerUtils.hasPendingResourceRequest(this.resourceCalculator, this.usageTracker.getQueueUsage(), nodePartition, cluster, schedulingMode);
    }

    @Override
    public Priority getDefaultApplicationPriority() {
        return null;
    }

    @Override
    public Set<String> getNodeLabelsForQueue() {
        HashSet<String> nodeLabels = new HashSet<String>();
        if (this.getAccessibleNodeLabels() != null && this.getAccessibleNodeLabels().contains("*")) {
            nodeLabels.addAll((Collection<String>)Sets.union(this.getQueueCapacities().getExistingNodeLabels(), this.getQueueResourceUsage().getExistingNodeLabels()));
        } else {
            nodeLabels.addAll(this.getAccessibleNodeLabels());
        }
        if (!nodeLabels.contains("")) {
            nodeLabels.add("");
        }
        return nodeLabels;
    }

    public Resource getTotalKillableResource(String partition) {
        return this.queueContext.getPreemptionManager().getKillableResource(this.getQueuePath(), partition);
    }

    public Iterator<RMContainer> getKillableContainers(String partition) {
        return this.queueContext.getPreemptionManager().getKillableContainers(this.getQueuePath(), partition);
    }

    @Override
    @VisibleForTesting
    public CSAssignment assignContainers(Resource clusterResource, FiCaSchedulerNode node, ResourceLimits resourceLimits, SchedulingMode schedulingMode) {
        return this.assignContainers(clusterResource, new SimpleCandidateNodeSet<FiCaSchedulerNode>(node), resourceLimits, schedulingMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accept(Resource cluster, ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> request) {
        boolean checkParentQueue = false;
        ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode> allocation = request.getFirstAllocatedOrReservedContainer();
        SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer = allocation.getAllocatedOrReservedContainer();
        if (allocation.getAllocateFromReservedContainer() == null) {
            Resource required = allocation.getAllocatedOrReservedResource();
            Resource netAllocated = Resources.subtract((Resource)required, (Resource)request.getTotalReleasedResource());
            this.readLock.lock();
            try {
                String partition = schedulerContainer.getNodePartition();
                Resource maxResourceLimit = allocation.getSchedulingMode() == SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY ? this.getQueueMaxResource(partition) : this.labelManager.getResourceByLabel(schedulerContainer.getNodePartition(), cluster);
                if (!Resources.fitsIn((ResourceCalculator)this.resourceCalculator, (Resource)Resources.add((Resource)this.usageTracker.getQueueUsage().getUsed(partition), (Resource)netAllocated), (Resource)maxResourceLimit)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Used resource=" + this.usageTracker.getQueueUsage().getUsed(partition) + " exceeded maxResourceLimit of the queue =" + maxResourceLimit);
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.readLock.unlock();
            }
            checkParentQueue = true;
        }
        if (this.parent != null && checkParentQueue) {
            return this.parent.accept(cluster, request);
        }
        return true;
    }

    @Override
    public void validateSubmitApplication(ApplicationId applicationId, String userName, String queue) throws AccessControlException {
    }

    @Override
    public void updateQueueState(QueueState queueState) {
        this.state = queueState;
    }

    @Override
    public void activateQueue() throws YarnException {
        block5: {
            this.writeLock.lock();
            try {
                if (this.getState() == QueueState.RUNNING) {
                    LOG.info("The specified queue:" + this.getQueuePath() + " is already in the RUNNING state.");
                    break block5;
                }
                CSQueue parentQueue = this.parent;
                if (parentQueue == null || parentQueue.getState() == QueueState.RUNNING) {
                    this.updateQueueState(QueueState.RUNNING);
                    break block5;
                }
                throw new YarnException("The parent Queue:" + parentQueue.getQueuePath() + " is not running. Please activate the parent queue first");
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    protected void appFinished() {
        this.writeLock.lock();
        try {
            if (this.getState() == QueueState.DRAINING && this.getNumApplications() == 0) {
                this.updateQueueState(QueueState.STOPPED);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Priority getPriority() {
        return this.priority;
    }

    @Override
    public UserWeights getUserWeights() {
        return this.userWeights;
    }

    public void recoverDrainingState() {
        this.writeLock.lock();
        try {
            if (this.getState() == QueueState.STOPPED) {
                this.updateQueueState(QueueState.DRAINING);
            }
            LOG.info("Recover draining state for queue " + this.getQueuePath());
            if (this.parent != null && this.parent.getState() == QueueState.STOPPED) {
                ((AbstractCSQueue)this.parent).recoverDrainingState();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public String getMultiNodeSortingPolicyName() {
        return this.multiNodeSortingPolicyName;
    }

    public void setMultiNodeSortingPolicyName(String policyName) {
        this.multiNodeSortingPolicyName = policyName;
    }

    @Override
    public long getMaximumApplicationLifetime() {
        return this.queueAppLifetimeSettings.getMaxApplicationLifetime();
    }

    @Override
    public long getDefaultApplicationLifetime() {
        return this.queueAppLifetimeSettings.getDefaultApplicationLifetime();
    }

    @Override
    public boolean getDefaultAppLifetimeWasSpecifiedInConfig() {
        return this.queueAppLifetimeSettings.isDefaultAppLifetimeWasSpecifiedInConfig();
    }

    public void setMaxParallelApps(int maxParallelApps) {
        this.queueAppLifetimeSettings.setMaxParallelApps(maxParallelApps);
    }

    @Override
    public int getMaxParallelApps() {
        return this.queueAppLifetimeSettings.getMaxParallelApps();
    }

    abstract int getNumRunnableApps();

    protected void updateAbsoluteCapacities() {
        QueueCapacities parentQueueCapacities = null;
        if (this.parent != null) {
            parentQueueCapacities = this.parent.getQueueCapacities();
        }
        CSQueueUtils.updateAbsoluteCapacitiesByNodeLabels(this.queueCapacities, parentQueueCapacities, this.queueCapacities.getExistingNodeLabels(), this.queueContext.getConfiguration().isLegacyQueueMode());
    }

    private Resource createNormalizedMinResource(Resource minResource, Map<String, Float> effectiveMinRatio) {
        Resource ret = Resource.newInstance((Resource)minResource);
        int maxLength = ResourceUtils.getNumberOfCountableResourceTypes();
        for (int i = 0; i < maxLength; ++i) {
            ResourceInformation nResourceInformation = minResource.getResourceInformation(i);
            Float ratio = effectiveMinRatio.get(nResourceInformation.getName());
            if (ratio == null) continue;
            ret.setResourceValue(i, (long)((float)nResourceInformation.getValue() * ratio.floatValue()));
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Updating min resource for Queue: " + this.getQueuePath() + " as " + ret.getResourceInformation(i) + ", Actual resource: " + nResourceInformation.getValue() + ", ratio: " + ratio);
        }
        return ret;
    }

    private Resource getOrInheritMaxResource(Resource resourceByLabel, String label) {
        Resource configuredMaxResource;
        Resource parentMaxResource = this.parent.getQueueResourceQuotas().getConfiguredMaxResource(label);
        if (parentMaxResource.equals((Object)Resources.none())) {
            parentMaxResource = this.parent.getQueueResourceQuotas().getEffectiveMaxResource(label);
        }
        if ((configuredMaxResource = this.getQueueResourceQuotas().getConfiguredMaxResource(label)).equals((Object)Resources.none())) {
            return Resources.clone((Resource)parentMaxResource);
        }
        return Resources.clone((Resource)Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)resourceByLabel, (Resource)configuredMaxResource, (Resource)parentMaxResource));
    }

    void deriveCapacityFromAbsoluteConfigurations(String label, Resource clusterResource) {
        float result = this.resourceCalculator.divide(clusterResource, this.usageTracker.getQueueResourceQuotas().getEffectiveMinResource(label), this.parent.getQueueResourceQuotas().getEffectiveMinResource(label));
        this.queueCapacities.setCapacity(label, Float.isInfinite(result) ? 0.0f : result);
        result = this.resourceCalculator.divide(clusterResource, this.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource(label), this.parent.getQueueResourceQuotas().getEffectiveMaxResource(label));
        this.queueCapacities.setMaximumCapacity(label, Float.isInfinite(result) ? 0.0f : result);
        this.queueCapacities.setAbsoluteCapacity(label, this.queueCapacities.getCapacity(label) * this.parent.getQueueCapacities().getAbsoluteCapacity(label));
        this.queueCapacities.setAbsoluteMaximumCapacity(label, this.queueCapacities.getMaximumCapacity(label) * this.parent.getQueueCapacities().getAbsoluteMaximumCapacity(label));
    }

    void updateEffectiveResources(Resource clusterResource) {
        for (String label : this.queueNodeLabelsSettings.getConfiguredNodeLabels()) {
            Resource newEffectiveMaxResource;
            Resource newEffectiveMinResource;
            Resource resourceByLabel = this.labelManager.getResourceByLabel(label, clusterResource);
            if (this.getCapacityConfigType().equals((Object)CapacityConfigType.ABSOLUTE_RESOURCE)) {
                newEffectiveMinResource = this.createNormalizedMinResource(this.usageTracker.getQueueResourceQuotas().getConfiguredMinResource(label), ((AbstractParentQueue)this.parent).getEffectiveMinRatio(label));
                newEffectiveMaxResource = this.getOrInheritMaxResource(resourceByLabel, label);
            } else {
                newEffectiveMinResource = Resources.multiply((Resource)resourceByLabel, (double)this.queueCapacities.getAbsoluteCapacity(label));
                newEffectiveMaxResource = Resources.multiply((Resource)resourceByLabel, (double)this.queueCapacities.getAbsoluteMaximumCapacity(label));
            }
            this.usageTracker.getQueueResourceQuotas().setEffectiveMinResource(label, newEffectiveMinResource);
            this.usageTracker.getQueueResourceQuotas().setEffectiveMaxResource(label, newEffectiveMaxResource);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updating queue:" + this.getQueuePath() + " with effective minimum resource=" + newEffectiveMinResource + "and effective maximum resource=" + newEffectiveMaxResource);
            }
            if (!this.getCapacityConfigType().equals((Object)CapacityConfigType.ABSOLUTE_RESOURCE)) continue;
            this.deriveCapacityFromAbsoluteConfigurations(label, clusterResource);
        }
    }

    @Override
    public boolean isDynamicQueue() {
        this.readLock.lock();
        try {
            boolean bl = this.dynamicQueue;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setDynamicQueue(boolean dynamicQueue) {
        this.writeLock.lock();
        try {
            this.dynamicQueue = dynamicQueue;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected String getCapacityOrWeightString() {
        if (this.queueCapacities.getWeight() != -1.0f) {
            return "weight=" + this.queueCapacities.getWeight() + ", normalizedWeight=" + this.queueCapacities.getNormalizedWeight();
        }
        return "capacity=" + this.queueCapacities.getCapacity();
    }

    public boolean isEligibleForAutoDeletion() {
        return false;
    }

    public boolean isInactiveDynamicQueue() {
        long idleDurationSeconds = (Time.monotonicNow() - this.getLastSubmittedTimestamp()) / 1000L;
        return this.isDynamicQueue() && this.isEligibleForAutoDeletion() && idleDurationSeconds > this.queueContext.getConfiguration().getAutoExpiredDeletionTime();
    }

    void updateLastSubmittedTimeStamp() {
        this.writeLock.lock();
        try {
            this.usageTracker.setLastSubmittedTimestamp(Time.monotonicNow());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @VisibleForTesting
    long getLastSubmittedTimestamp() {
        this.readLock.lock();
        try {
            long l = this.usageTracker.getLastSubmittedTimestamp();
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @VisibleForTesting
    void setLastSubmittedTimestamp(long lastSubmittedTimestamp) {
        this.writeLock.lock();
        try {
            this.usageTracker.setLastSubmittedTimestamp(lastSubmittedTimestamp);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @FunctionalInterface
    static interface CounterWithApp {
        public void count(String var1, Resource var2, SchedulerApplicationAttempt var3);
    }

    @FunctionalInterface
    static interface Counter {
        public void count(String var1, Resource var2);
    }

    public static enum CapacityConfigType {
        NONE,
        PERCENTAGE,
        ABSOLUTE_RESOURCE;

    }
}

