/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesLogger;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityDiagnosticConstant;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.AllocationState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedQueueTemplate;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueCapacityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy.QueueOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ContainerAllocationProposal;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ResourceCommitRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.SchedulerContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSet;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSetUtils;
import org.apache.hadoop.yarn.util.UnitsConversionUtil;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;

public abstract class AbstractParentQueue
extends AbstractCSQueue {
    private static final Log LOG = LogFactory.getLog(AbstractParentQueue.class);
    protected final List<CSQueue> childQueues;
    private final boolean rootQueue;
    private AtomicInteger numApplications = new AtomicInteger(0);
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private QueueOrderingPolicy queueOrderingPolicy;
    private long lastSkipQueueDebugLoggingTimestamp = -1L;
    private int runnableApps;
    private final boolean allowZeroCapacitySum;
    private AutoCreatedQueueTemplate autoCreatedQueueTemplate;
    private final Map<String, Map<String, Float>> effectiveMinResourceRatio = new ConcurrentHashMap<String, Map<String, Float>>();
    private static float PRECISION = 5.0E-4f;

    public AbstractParentQueue(CapacitySchedulerQueueContext queueContext, String queueName, CSQueue parent, CSQueue old) throws IOException {
        this(queueContext, queueName, parent, old, false);
    }

    public AbstractParentQueue(CapacitySchedulerQueueContext queueContext, String queueName, CSQueue parent, CSQueue old, boolean isDynamic) throws IOException {
        super(queueContext, queueName, parent, old);
        this.setDynamicQueue(isDynamic);
        this.rootQueue = parent == null;
        float rawCapacity = queueContext.getConfiguration().getNonLabeledQueueCapacity(this.queuePath);
        if (this.rootQueue && rawCapacity != 100.0f) {
            throw new IllegalArgumentException("Illegal capacity of " + rawCapacity + " for queue " + queueName + ". Must be " + 100.0f);
        }
        this.childQueues = new ArrayList<CSQueue>();
        this.allowZeroCapacitySum = queueContext.getConfiguration().getAllowZeroCapacitySum(this.getQueuePath());
    }

    private String getQueueOrderingPolicyConfigName() {
        return this.queueOrderingPolicy == null ? null : this.queueOrderingPolicy.getConfigName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setupQueueConfigs(Resource clusterResource) throws IOException {
        this.writeLock.lock();
        try {
            CapacitySchedulerConfiguration configuration = this.queueContext.getConfiguration();
            this.autoCreatedQueueTemplate = new AutoCreatedQueueTemplate(configuration, this.queuePath);
            super.setupQueueConfigs(clusterResource);
            StringBuilder aclsString = new StringBuilder();
            for (Map.Entry<AccessType, AccessControlList> e : this.getACLs().entrySet()) {
                aclsString.append(e.getKey()).append(":").append(e.getValue().getAclString());
            }
            StringBuilder labelStrBuilder = new StringBuilder();
            if (this.getAccessibleNodeLabels() != null) {
                for (String nodeLabel : this.getAccessibleNodeLabels()) {
                    labelStrBuilder.append(nodeLabel).append(",");
                }
            }
            this.queueOrderingPolicy = configuration.getQueueOrderingPolicy(this.getQueuePath(), this.parent == null ? null : ((AbstractParentQueue)this.parent).getQueueOrderingPolicyConfigName());
            this.queueOrderingPolicy.setQueues(this.childQueues);
            LOG.info((Object)(this.getQueueName() + ", " + this.getCapacityOrWeightString() + ", absoluteCapacity=" + this.getAbsoluteCapacity() + ", maxCapacity=" + this.getMaximumCapacity() + ", absoluteMaxCapacity=" + this.getAbsoluteMaximumCapacity() + ", state=" + this.getState() + ", acls=" + aclsString + ", labels=" + labelStrBuilder + "\n, reservationsContinueLooking=" + this.isReservationsContinueLooking() + ", orderingPolicy=" + this.getQueueOrderingPolicyConfigName() + ", priority=" + this.getPriority() + ", allowZeroCapacitySum=" + this.allowZeroCapacitySum));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    protected void setDynamicQueueACLProperties() {
        super.setDynamicQueueACLProperties();
        if (this.parent instanceof AbstractParentQueue) {
            this.acls.putAll(CapacitySchedulerConfiguration.getACLsForFlexibleAutoCreatedParentQueue(((AbstractParentQueue)this.parent).getAutoCreatedQueueTemplate()));
        }
    }

    public QueueCapacityType getCapacityConfigurationTypeForQueues(Collection<CSQueue> queues) throws IOException {
        boolean percentageIsSet = false;
        boolean weightIsSet = false;
        boolean absoluteMinResSet = false;
        StringBuilder diagMsg = new StringBuilder();
        for (CSQueue queue : queues) {
            for (String nodeLabel : this.queueCapacities.getExistingNodeLabels()) {
                float weightByLabel;
                float capacityByLabel = queue.getQueueCapacities().getCapacity(nodeLabel);
                if (capacityByLabel > 0.0f) {
                    percentageIsSet = true;
                }
                if ((weightByLabel = queue.getQueueCapacities().getWeight(nodeLabel)) >= 0.0f) {
                    weightIsSet = true;
                    diagMsg.append("{Queue=" + queue.getQueuePath() + ", label=" + nodeLabel + " uses weight mode}. ");
                }
                if (!queue.getQueueResourceQuotas().getConfiguredMinResource(nodeLabel).equals((Object)Resources.none())) {
                    absoluteMinResSet = true;
                    percentageIsSet = false;
                    diagMsg.append("{Queue=" + queue.getQueuePath() + ", label=" + nodeLabel + " uses absolute mode}. ");
                }
                if (!percentageIsSet) continue;
                diagMsg.append("{Queue=" + queue.getQueuePath() + ", label=" + nodeLabel + " uses percentage mode}. ");
            }
        }
        if (queues.iterator().hasNext() && !queues.iterator().next().getQueuePath().equals("root") && (percentageIsSet ? 1 : 0) + (weightIsSet ? 1 : 0) + (absoluteMinResSet ? 1 : 0) > 1) {
            throw new IOException("Parent queue '" + this.getQueuePath() + "' have children queue used mixed of  weight mode, percentage and absolute mode, it is not allowed, please double check, details:" + diagMsg.toString());
        }
        if (weightIsSet || queues.isEmpty()) {
            return QueueCapacityType.WEIGHT;
        }
        if (absoluteMinResSet) {
            return QueueCapacityType.ABSOLUTE_RESOURCE;
        }
        return QueueCapacityType.PERCENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setChildQueues(Collection<CSQueue> childQueues) throws IOException {
        this.writeLock.lock();
        try {
            boolean isLegacyQueueMode = this.queueContext.getConfiguration().isLegacyQueueMode();
            if (isLegacyQueueMode) {
                QueueCapacityType childrenCapacityType = this.getCapacityConfigurationTypeForQueues(childQueues);
                QueueCapacityType parentCapacityType = this.getCapacityConfigurationTypeForQueues((Collection<CSQueue>)ImmutableList.of((Object)this));
                if (childrenCapacityType == QueueCapacityType.ABSOLUTE_RESOURCE || parentCapacityType == QueueCapacityType.ABSOLUTE_RESOURCE) {
                    if (childrenCapacityType != parentCapacityType && !this.getQueuePath().equals("root")) {
                        throw new IOException("Parent=" + this.getQueuePath() + ": When absolute minResource is used, we must make sure both parent and child all use absolute minResource");
                    }
                    for (String nodeLabel : this.queueCapacities.getExistingNodeLabels()) {
                        Resource minRes = Resources.createResource((int)0, (int)0);
                        for (CSQueue queue : childQueues) {
                            Resources.addTo((Resource)minRes, (Resource)queue.getQueueResourceQuotas().getConfiguredMinResource(nodeLabel));
                        }
                        Resource resourceByLabel = this.labelManager.getResourceByLabel(nodeLabel, this.queueContext.getClusterResource());
                        Resource parentMinResource = this.usageTracker.getQueueResourceQuotas().getConfiguredMinResource(nodeLabel);
                        if (parentMinResource.equals((Object)Resources.none()) || !Resources.lessThan((ResourceCalculator)this.resourceCalculator, (Resource)resourceByLabel, (Resource)parentMinResource, (Resource)minRes)) continue;
                        throw new IOException("Parent Queues capacity: " + parentMinResource + " is less than to its children:" + minRes + " for queue:" + this.getQueueName());
                    }
                }
                if (childrenCapacityType == QueueCapacityType.PERCENT) {
                    float childrenPctSum = 0.0f;
                    for (String nodeLabel : this.queueCapacities.getExistingNodeLabels()) {
                        childrenPctSum = 0.0f;
                        for (CSQueue queue : childQueues) {
                            childrenPctSum += queue.getQueueCapacities().getCapacity(nodeLabel);
                        }
                        if (Math.abs(1.0f - childrenPctSum) > PRECISION) {
                            if (Math.abs(childrenPctSum) > PRECISION) {
                                throw new IOException("Illegal capacity sum of " + childrenPctSum + " for children of queue " + this.getQueueName() + " for label=" + nodeLabel + ". It should be either 0 or 1.0");
                            }
                            if (parentCapacityType != QueueCapacityType.PERCENT || !(Math.abs(this.queueCapacities.getCapacity(nodeLabel)) > PRECISION) || this.allowZeroCapacitySum) continue;
                            throw new IOException("Illegal capacity sum of " + childrenPctSum + " for children of queue " + this.getQueueName() + " for label=" + nodeLabel + ". It is set to 0, but parent percent != 0, and doesn't allow children capacity to set to 0");
                        }
                        if (parentCapacityType != QueueCapacityType.PERCENT || !(Math.abs(this.queueCapacities.getCapacity(nodeLabel)) <= 0.0f) || this.allowZeroCapacitySum) continue;
                        throw new IOException("Illegal capacity sum of " + childrenPctSum + " for children of queue " + this.getQueueName() + " for label=" + nodeLabel + ". queue=" + this.getQueueName() + " has zero capacity, but childqueues have positive capacities");
                    }
                }
            }
            this.childQueues.clear();
            this.childQueues.addAll(childQueues);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("setChildQueues: " + this.getChildQueuesToPrint()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueueInfo getQueueInfo(boolean includeChildQueues, boolean recursive) {
        this.readLock.lock();
        try {
            QueueInfo queueInfo = this.getQueueInfo();
            ArrayList<QueueInfo> childQueuesInfo = new ArrayList<QueueInfo>();
            if (includeChildQueues) {
                for (CSQueue child : this.childQueues) {
                    childQueuesInfo.add(child.getQueueInfo(recursive, recursive));
                }
            }
            queueInfo.setChildQueues(childQueuesInfo);
            QueueInfo queueInfo2 = queueInfo;
            return queueInfo2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueUserACLInfo getUserAclInfo(UserGroupInformation user) {
        this.readLock.lock();
        try {
            QueueUserACLInfo userAclInfo = (QueueUserACLInfo)this.recordFactory.newRecordInstance(QueueUserACLInfo.class);
            ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
            for (QueueACL operation : QueueACL.values()) {
                if (!this.hasAccess(operation, user)) continue;
                operations.add(operation);
            }
            userAclInfo.setQueueName(this.getQueuePath());
            userAclInfo.setUserAcls(operations);
            QueueUserACLInfo queueUserACLInfo = userAclInfo;
            return queueUserACLInfo;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        this.readLock.lock();
        try {
            ArrayList<QueueUserACLInfo> userAcls = new ArrayList<QueueUserACLInfo>();
            userAcls.add(this.getUserAclInfo(user));
            for (CSQueue child : this.childQueues) {
                userAcls.addAll(child.getQueueUserAclInfo(user));
            }
            ArrayList<QueueUserACLInfo> arrayList = userAcls;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        return this.getQueueName() + ": numChildQueue= " + this.childQueues.size() + ", " + this.getCapacityOrWeightString() + ", absoluteCapacity=" + this.queueCapacities.getAbsoluteCapacity() + ", usedResources=" + this.usageTracker.getQueueUsage().getUsed() + ", usedCapacity=" + this.getUsedCapacity() + ", numApps=" + this.getNumApplications() + ", numContainers=" + this.getNumContainers();
    }

    public CSQueue createNewQueue(String childQueuePath, boolean isLeaf) throws SchedulerDynamicEditException {
        try {
            String queueShortName = childQueuePath.substring(childQueuePath.lastIndexOf(".") + 1);
            AbstractCSQueue childQueue = isLeaf ? new LeafQueue(this.queueContext, queueShortName, this, null, true) : new ParentQueue(this.queueContext, queueShortName, this, null, true);
            childQueue.setDynamicQueue(true);
            return childQueue;
        }
        catch (IOException e) {
            throw new SchedulerDynamicEditException(e.toString());
        }
    }

    public void removeChildQueue(CSQueue queue) throws SchedulerDynamicEditException {
        this.writeLock.lock();
        try {
            if (!(queue instanceof AbstractCSQueue) || !((AbstractCSQueue)queue).isDynamicQueue()) {
                throw new SchedulerDynamicEditException("Queue " + this.getQueuePath() + " can not remove " + queue.getQueuePath() + " because it is not a dynamic queue");
            }
            if (queue.getParent() != this) {
                throw new SchedulerDynamicEditException("Queue " + this.getQueuePath() + " can not remove " + queue.getQueuePath() + " because it has a different parent queue");
            }
            this.childQueues.remove(queue);
            this.queueContext.getQueueManager().removeQueue(queue.getQueuePath());
            this.updateClusterResource(this.queueContext.getClusterResource(), new ResourceLimits(this.queueContext.getClusterResource()));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isEligibleForAutoQueueCreation() {
        return this.isDynamicQueue() || this.queueContext.getConfiguration().isAutoQueueCreationV2Enabled(this.getQueuePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reinitialize(CSQueue newlyParsedQueue, Resource clusterResource) throws IOException {
        this.writeLock.lock();
        try {
            if (newlyParsedQueue != this) {
                this.setDynamicQueue(false);
            }
            if (!(newlyParsedQueue instanceof AbstractParentQueue) || !newlyParsedQueue.getQueuePath().equals(this.getQueuePath())) {
                throw new IOException("Trying to reinitialize " + this.getQueuePath() + " from " + newlyParsedQueue.getQueuePath());
            }
            AbstractParentQueue newlyParsedParentQueue = (AbstractParentQueue)newlyParsedQueue;
            this.setupQueueConfigs(clusterResource);
            Map<String, CSQueue> currentChildQueues = this.getQueuesMap(this.childQueues);
            Map<String, CSQueue> newChildQueues = this.getQueuesMap(newlyParsedParentQueue.childQueues);
            for (String queue : Sets.difference(currentChildQueues.keySet(), newChildQueues.keySet())) {
                CSQueue candidate = currentChildQueues.get(queue);
                if (!(candidate instanceof AbstractCSQueue) || !((AbstractCSQueue)candidate).isDynamicQueue()) continue;
                candidate.reinitialize(candidate, clusterResource);
            }
            for (Map.Entry<String, CSQueue> e : newChildQueues.entrySet()) {
                String newChildQueueName = (String)e.getKey();
                CSQueue newChildQueue = (CSQueue)e.getValue();
                CSQueue childQueue = currentChildQueues.get(newChildQueueName);
                if (childQueue != null) {
                    if (childQueue instanceof AbstractLeafQueue && newChildQueue instanceof AbstractParentQueue || childQueue instanceof AbstractParentQueue && newChildQueue instanceof AbstractLeafQueue) {
                        newChildQueue.setParent(this);
                        currentChildQueues.put(newChildQueueName, newChildQueue);
                        CapacitySchedulerQueueManager queueManager = this.queueContext.getQueueManager();
                        queueManager.addQueue(newChildQueueName, newChildQueue);
                        continue;
                    }
                    childQueue.reinitialize(newChildQueue, clusterResource);
                    LOG.info((Object)(this.getQueuePath() + ": re-configured queue: " + childQueue));
                    continue;
                }
                newChildQueue.setParent(this);
                currentChildQueues.put(newChildQueueName, newChildQueue);
                LOG.info((Object)(this.getQueuePath() + ": added new child queue: " + newChildQueue));
            }
            Iterator<Map.Entry<String, CSQueue>> itr = currentChildQueues.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<String, CSQueue> e;
                e = itr.next();
                String queueName = e.getKey();
                if (newChildQueues.containsKey(queueName) || ((AbstractCSQueue)e.getValue()).isDynamicQueue()) continue;
                itr.remove();
            }
            this.setChildQueues(currentChildQueues.values());
            this.queueOrderingPolicy.setQueues(this.childQueues);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Map<String, CSQueue> getQueuesMap(List<CSQueue> queues) {
        HashMap<String, CSQueue> queuesMap = new HashMap<String, CSQueue>();
        for (CSQueue queue : queues) {
            queuesMap.put(queue.getQueuePath(), queue);
        }
        return queuesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitApplication(ApplicationId applicationId, String user, String queue) throws AccessControlException {
        this.writeLock.lock();
        try {
            this.validateSubmitApplication(applicationId, user, queue);
            this.addApplication(applicationId, user);
        }
        finally {
            this.writeLock.unlock();
        }
        if (this.parent != null) {
            try {
                this.parent.submitApplication(applicationId, user, queue);
            }
            catch (AccessControlException ace) {
                LOG.info((Object)("Failed to submit application to parent-queue: " + this.parent.getQueuePath()), (Throwable)ace);
                this.removeApplication(applicationId, user);
                throw ace;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateSubmitApplication(ApplicationId applicationId, String userName, String queue) throws AccessControlException {
        this.writeLock.lock();
        try {
            if (queue.equals(this.getQueueName())) {
                throw new AccessControlException("Cannot submit application to non-leaf queue: " + this.getQueueName());
            }
            if (this.getState() != QueueState.RUNNING) {
                throw new AccessControlException("Queue " + this.getQueuePath() + " is STOPPED. Cannot accept submission of application: " + applicationId);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void submitApplicationAttempt(FiCaSchedulerApp application, String userName) {
    }

    @Override
    public void submitApplicationAttempt(FiCaSchedulerApp application, String userName, boolean isMoveApp) {
        throw new UnsupportedOperationException("Submission of application attempt to parent queue is not supported");
    }

    @Override
    public void finishApplicationAttempt(FiCaSchedulerApp application, String queue) {
    }

    private void addApplication(ApplicationId applicationId, String user) {
        this.numApplications.incrementAndGet();
        LOG.info((Object)("Application added - appId: " + applicationId + " user: " + user + " leaf-queue of parent: " + this.getQueuePath() + " #applications: " + this.getNumApplications()));
    }

    @Override
    public void finishApplication(ApplicationId application, String user) {
        this.removeApplication(application, user);
        this.appFinished();
        if (this.parent != null) {
            this.parent.finishApplication(application, user);
        }
    }

    private void removeApplication(ApplicationId applicationId, String user) {
        this.numApplications.decrementAndGet();
        LOG.info((Object)("Application removed - appId: " + applicationId + " user: " + user + " leaf-queue of parent: " + this.getQueuePath() + " #applications: " + this.getNumApplications()));
    }

    private String getParentName() {
        return this.parent != null ? this.parent.getQueuePath() : "";
    }

    @Override
    public CSAssignment assignContainers(Resource clusterResource, CandidateNodeSet<FiCaSchedulerNode> candidates, ResourceLimits resourceLimits, SchedulingMode schedulingMode) {
        CSAssignment assignment;
        block8: {
            CSAssignment assignedToChild;
            FiCaSchedulerNode node;
            block10: {
                boolean isReserved;
                block9: {
                    node = CandidateNodeSetUtils.getSingleNode(candidates);
                    if (schedulingMode == SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY && !this.queueNodeLabelsSettings.isAccessibleToPartition(candidates.getPartition())) {
                        long now;
                        if (LOG.isDebugEnabled() && (now = System.currentTimeMillis()) - this.lastSkipQueueDebugLoggingTimestamp > 1000L) {
                            LOG.debug((Object)("Skip this queue=" + this.getQueuePath() + ", because it is not able to access partition=" + candidates.getPartition()));
                            this.lastSkipQueueDebugLoggingTimestamp = now;
                        }
                        ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, (SchedulerNode)node, this.getParentName(), this.getQueuePath(), ActivityState.REJECTED, "Queue is not able to access partition");
                        if (this.rootQueue) {
                            ActivitiesLogger.NODE.finishSkippedNodeAllocation(this.activitiesManager, node);
                        }
                        return CSAssignment.NULL_ASSIGNMENT;
                    }
                    if (!super.hasPendingResourceRequest(candidates.getPartition(), clusterResource, schedulingMode)) {
                        long now;
                        if (LOG.isDebugEnabled() && (now = System.currentTimeMillis()) - this.lastSkipQueueDebugLoggingTimestamp > 1000L) {
                            LOG.debug((Object)("Skip this queue=" + this.getQueuePath() + ", because it doesn't need more resource, schedulingMode=" + schedulingMode.name() + " node-partition=" + candidates.getPartition()));
                            this.lastSkipQueueDebugLoggingTimestamp = now;
                        }
                        ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, (SchedulerNode)node, this.getParentName(), this.getQueuePath(), ActivityState.SKIPPED, "Queue does not need more resource");
                        if (this.rootQueue) {
                            ActivitiesLogger.NODE.finishSkippedNodeAllocation(this.activitiesManager, node);
                        }
                        return CSAssignment.NULL_ASSIGNMENT;
                    }
                    assignment = new CSAssignment(Resources.createResource((int)0, (int)0), NodeType.NODE_LOCAL);
                    if (!this.canAssign(clusterResource, node)) break block8;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Trying to assign containers to child-queue of " + this.getQueuePath()));
                    }
                    if (super.canAssignToThisQueue(clusterResource, candidates.getPartition(), resourceLimits, Resources.createResource((long)this.getMetrics().getReservedMB(), (int)this.getMetrics().getReservedVirtualCores()), schedulingMode)) break block9;
                    ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, (SchedulerNode)node, this.getParentName(), this.getQueuePath(), ActivityState.REJECTED, "Queue hits max-capacity limit");
                    if (!this.rootQueue) break block8;
                    ActivitiesLogger.NODE.finishSkippedNodeAllocation(this.activitiesManager, node);
                    break block8;
                }
                assignedToChild = this.assignContainersToChildQueues(clusterResource, candidates, resourceLimits, schedulingMode);
                assignment.setType(assignedToChild.getType());
                assignment.setRequestLocalityType(assignedToChild.getRequestLocalityType());
                assignment.setExcessReservation(assignedToChild.getExcessReservation());
                assignment.setContainersToKill(assignedToChild.getContainersToKill());
                assignment.setFulfilledReservation(assignedToChild.isFulfilledReservation());
                assignment.setFulfilledReservedContainer(assignedToChild.getFulfilledReservedContainer());
                if (!Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)assignedToChild.getResource(), (Resource)Resources.none())) break block10;
                ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, (SchedulerNode)node, this.getParentName(), this.getQueuePath(), ActivityState.ACCEPTED, ActivityDiagnosticConstant.EMPTY);
                boolean bl = isReserved = assignedToChild.getAssignmentInformation().getReservationDetails() != null && !assignedToChild.getAssignmentInformation().getReservationDetails().isEmpty();
                if (this.rootQueue) {
                    ActivitiesLogger.NODE.finishAllocatedNodeAllocation(this.activitiesManager, node, assignedToChild.getAssignmentInformation().getFirstAllocatedOrReservedContainerId(), isReserved ? AllocationState.RESERVED : AllocationState.ALLOCATED);
                }
                Resources.addTo((Resource)assignment.getResource(), (Resource)assignedToChild.getResource());
                Resources.addTo((Resource)assignment.getAssignmentInformation().getAllocated(), (Resource)assignedToChild.getAssignmentInformation().getAllocated());
                Resources.addTo((Resource)assignment.getAssignmentInformation().getReserved(), (Resource)assignedToChild.getAssignmentInformation().getReserved());
                assignment.getAssignmentInformation().incrAllocations(assignedToChild.getAssignmentInformation().getNumAllocations());
                assignment.getAssignmentInformation().incrReservations(assignedToChild.getAssignmentInformation().getNumReservations());
                assignment.getAssignmentInformation().getAllocationDetails().addAll(assignedToChild.getAssignmentInformation().getAllocationDetails());
                assignment.getAssignmentInformation().getReservationDetails().addAll(assignedToChild.getAssignmentInformation().getReservationDetails());
                assignment.setIncreasedAllocation(assignedToChild.isIncreasedAllocation());
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug((Object)("assignedContainer reserved=" + isReserved + " queue=" + this.getQueuePath() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.usageTracker.getQueueUsage().getUsed() + " cluster=" + clusterResource));
                LOG.debug((Object)("ParentQ=" + this.getQueuePath() + " assignedSoFarInThisIteration=" + assignment.getResource() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity()));
                break block8;
            }
            assignment.setSkippedType(assignedToChild.getSkippedType());
            ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, (SchedulerNode)node, this.getParentName(), this.getQueuePath(), ActivityState.SKIPPED, ActivityDiagnosticConstant.EMPTY);
            if (!this.rootQueue) break block8;
            ActivitiesLogger.NODE.finishSkippedNodeAllocation(this.activitiesManager, node);
        }
        return assignment;
    }

    private boolean canAssign(Resource clusterResource, FiCaSchedulerNode node) {
        boolean accept;
        if (null == node) {
            return true;
        }
        boolean bl = accept = node.getReservedContainer() == null && Resources.greaterThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)Resources.add((Resource)node.getUnallocatedResource(), (Resource)node.getTotalKillableResources()), (Resource)this.queueAllocationSettings.getMinimumAllocation());
        if (!accept) {
            ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, (SchedulerNode)node, this.getParentName(), this.getQueueName(), ActivityState.REJECTED, () -> node.getReservedContainer() != null ? "Queue skipped because node has been reserved" : "Queue skipped because node resource is insufficient");
            if (this.rootQueue) {
                ActivitiesLogger.NODE.finishSkippedNodeAllocation(this.activitiesManager, node);
            }
        }
        return accept;
    }

    public ResourceLimits getResourceLimitsOfChild(CSQueue child, Resource clusterResource, ResourceLimits parentLimits, String nodePartition, boolean netLimit) {
        parentLimits.setLimit(Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)parentLimits.getLimit(), (Resource)this.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource(nodePartition)));
        Resource limit = parentLimits.getLimit();
        if (netLimit) {
            limit = parentLimits.getNetLimit();
        }
        Resource parentMaxAvailableResource = Resources.subtract((Resource)limit, (Resource)this.usageTracker.getQueueUsage().getUsed(nodePartition));
        Resources.addTo((Resource)parentMaxAvailableResource, (Resource)this.getTotalKillableResource(nodePartition));
        Resource childLimit = Resources.add((Resource)parentMaxAvailableResource, (Resource)child.getQueueResourceUsage().getUsed(nodePartition));
        childLimit = Resources.roundDown((ResourceCalculator)this.resourceCalculator, (Resource)childLimit, (Resource)this.queueAllocationSettings.getMinimumAllocation());
        return new ResourceLimits(childLimit);
    }

    private Iterator<CSQueue> sortAndGetChildrenAllocationIterator(String partition) {
        return this.queueOrderingPolicy.getAssignmentIterator(partition);
    }

    private CSAssignment assignContainersToChildQueues(Resource cluster, CandidateNodeSet<FiCaSchedulerNode> candidates, ResourceLimits limits, SchedulingMode schedulingMode) {
        CSAssignment assignment = CSAssignment.NULL_ASSIGNMENT;
        this.printChildQueues();
        Iterator<CSQueue> iter = this.sortAndGetChildrenAllocationIterator(candidates.getPartition());
        while (iter.hasNext()) {
            CSQueue childQueue = iter.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to assign to queue: " + childQueue.getQueuePath() + " stats: " + childQueue));
            }
            ResourceLimits childLimits = this.getResourceLimitsOfChild(childQueue, cluster, limits, candidates.getPartition(), true);
            CSAssignment childAssignment = childQueue.assignContainers(cluster, candidates, childLimits, schedulingMode);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Assigned to queue: " + childQueue.getQueuePath() + " stats: " + childQueue + " --> " + childAssignment.getResource() + ", " + (Object)((Object)childAssignment.getType())));
            }
            if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)cluster, (Resource)childAssignment.getResource(), (Resource)Resources.none())) {
                assignment = childAssignment;
                break;
            }
            if (childAssignment.getSkippedType() != CSAssignment.SkippedType.QUEUE_LIMIT) continue;
            if (assignment.getSkippedType() != CSAssignment.SkippedType.QUEUE_LIMIT) {
                assignment = childAssignment;
            }
            Resource blockedHeadroom = null;
            blockedHeadroom = childQueue instanceof AbstractLeafQueue ? childLimits.getHeadroom() : childLimits.getBlockedHeadroom();
            Resource resourceToSubtract = Resources.max((ResourceCalculator)this.resourceCalculator, (Resource)cluster, (Resource)blockedHeadroom, (Resource)Resources.none());
            limits.addBlockedHeadroom(resourceToSubtract);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Decrease parentLimits " + limits.getLimit() + " for " + this.getQueuePath() + " by " + resourceToSubtract + " as childQueue=" + childQueue.getQueuePath() + " is blocked"));
        }
        return assignment;
    }

    String getChildQueuesToPrint() {
        StringBuilder sb = new StringBuilder();
        for (CSQueue q : this.childQueues) {
            sb.append(q.getQueuePath() + " usedCapacity=(" + q.getUsedCapacity() + "),  label=(" + StringUtils.join(q.getAccessibleNodeLabels().iterator(), (String)",") + ")");
        }
        return sb.toString();
    }

    private void printChildQueues() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("printChildQueues - queue: " + this.getQueuePath() + " child-queues: " + this.getChildQueuesToPrint()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalReleaseResource(Resource clusterResource, FiCaSchedulerNode node, Resource releasedResource) {
        this.writeLock.lock();
        try {
            super.releaseResource(clusterResource, releasedResource, node.getPartition());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("completedContainer " + this + ", cluster=" + clusterResource));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void completedContainer(Resource clusterResource, FiCaSchedulerApp application, FiCaSchedulerNode node, RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event, CSQueue completedChildQueue, boolean sortQueues) {
        if (application != null) {
            this.internalReleaseResource(clusterResource, node, rmContainer.getContainer().getResource());
            if (this.parent != null) {
                this.parent.completedContainer(clusterResource, application, node, rmContainer, null, event, this, sortQueues);
            }
        }
    }

    @Override
    public void refreshAfterResourceCalculation(Resource clusterResource, ResourceLimits resourceLimits) {
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, clusterResource, this, this.labelManager, null);
        CSQueueUtils.updateConfiguredCapacityMetrics(this.resourceCalculator, this.labelManager.getResourceByLabel(null, clusterResource), "", this);
        LOG.info((Object)("Refresh after resource calculation (PARENT)" + this.queuePath + "\neffectiveMinResource = " + this.getEffectiveCapacity("") + "\neffectiveMaxResource = " + this.getEffectiveMaxCapacity("") + "\ncapacity = " + this.getCapacity() + "\nmaxCapacity = " + this.getMaximumCapacity() + "\nabsoluteCapacity = " + this.getAbsoluteCapacity() + "\nabsoluteMaxCapacity = " + this.getAbsoluteMaximumCapacity()));
    }

    @Override
    public void updateClusterResource(Resource clusterResource, ResourceLimits resourceLimits) {
        if (this.queueContext.getConfiguration().isLegacyQueueMode()) {
            this.updateClusterResourceLegacyMode(clusterResource, resourceLimits);
            return;
        }
        CapacitySchedulerQueueCapacityHandler handler = this.queueContext.getQueueManager().getQueueCapacityHandler();
        if (this.rootQueue) {
            handler.updateRoot(this, clusterResource);
            handler.updateChildren(clusterResource, this);
        } else {
            handler.updateChildren(clusterResource, this.getParent());
        }
    }

    public void updateClusterResourceLegacyMode(Resource clusterResource, ResourceLimits resourceLimits) {
        this.writeLock.lock();
        try {
            if (this.rootQueue) {
                for (String nodeLabel : this.queueCapacities.getExistingNodeLabels()) {
                    if (!(this.queueCapacities.getWeight(nodeLabel) > 0.0f)) continue;
                    this.queueCapacities.setNormalizedWeight(nodeLabel, 1.0f);
                }
            }
            this.updateAbsoluteCapacities();
            for (String nodeLabel : this.queueCapacities.getExistingNodeLabels()) {
                for (CSQueue queue : this.childQueues) {
                    if (!((AbstractCSQueue)queue).isDynamicQueue() || queue.getQueueCapacities().getWeight(nodeLabel) != -1.0f) continue;
                    queue.getQueueCapacities().setWeight(nodeLabel, 1.0f);
                }
            }
            if (this.getCapacityConfigurationTypeForQueues(this.childQueues) == QueueCapacityType.WEIGHT) {
                for (String nodeLabel : this.queueCapacities.getExistingNodeLabels()) {
                    float sumOfWeight = 0.0f;
                    for (CSQueue queue : this.childQueues) {
                        if (!queue.getQueueCapacities().getExistingNodeLabels().contains(nodeLabel)) continue;
                        float weight = Math.max(0.0f, queue.getQueueCapacities().getWeight(nodeLabel));
                        sumOfWeight += weight;
                    }
                    if (!((double)Math.abs(sumOfWeight) > 1.0E-6)) continue;
                    for (CSQueue queue : this.childQueues) {
                        if (!queue.getQueueCapacities().getExistingNodeLabels().contains(nodeLabel)) continue;
                        queue.getQueueCapacities().setNormalizedWeight(nodeLabel, queue.getQueueCapacities().getWeight(nodeLabel) / sumOfWeight);
                    }
                }
            }
            for (String label : this.queueNodeLabelsSettings.getConfiguredNodeLabels()) {
                this.calculateEffectiveResourcesAndCapacity(label, clusterResource);
            }
            for (CSQueue childQueue : this.childQueues) {
                ResourceLimits childLimits = this.getResourceLimitsOfChild(childQueue, clusterResource, resourceLimits, "", false);
                childQueue.updateClusterResource(clusterResource, childLimits);
            }
            CSQueueUtils.updateQueueStatistics(this.resourceCalculator, clusterResource, this, this.labelManager, null);
            CSQueueUtils.updateConfiguredCapacityMetrics(this.resourceCalculator, this.labelManager.getResourceByLabel(null, clusterResource), "", this);
        }
        catch (IOException e) {
            LOG.error((Object)"Fatal issue found: e", (Throwable)e);
            throw new YarnRuntimeException("Fatal issue during scheduling", (Throwable)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean hasChildQueues() {
        return true;
    }

    private void calculateEffectiveResourcesAndCapacity(String label, Resource clusterResource) {
        if (this.rootQueue) {
            Resource resourceByLabel = this.labelManager.getResourceByLabel(label, clusterResource);
            this.usageTracker.getQueueResourceQuotas().setEffectiveMinResource(label, resourceByLabel);
            this.usageTracker.getQueueResourceQuotas().setEffectiveMaxResource(label, resourceByLabel);
        } else {
            super.updateEffectiveResources(clusterResource);
        }
        this.recalculateEffectiveMinRatio(label, clusterResource);
    }

    private void recalculateEffectiveMinRatio(String label, Resource clusterResource) {
        Resource resourceByLabel = this.labelManager.getResourceByLabel(label, clusterResource);
        Resource configuredMinResources = Resource.newInstance((long)0L, (int)0);
        for (CSQueue childQueue : this.getChildQueues()) {
            Resources.addTo((Resource)configuredMinResources, (Resource)childQueue.getQueueResourceQuotas().getConfiguredMinResource(label));
        }
        Resource numeratorForMinRatio = null;
        if (this.getQueuePath().equals("root")) {
            if (!resourceByLabel.equals((Object)Resources.none()) && Resources.lessThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)resourceByLabel, (Resource)configuredMinResources)) {
                numeratorForMinRatio = resourceByLabel;
            }
        } else if (Resources.lessThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)this.usageTracker.getQueueResourceQuotas().getEffectiveMinResource(label), (Resource)configuredMinResources)) {
            numeratorForMinRatio = this.usageTracker.getQueueResourceQuotas().getEffectiveMinResource(label);
        }
        this.effectiveMinResourceRatio.put(label, this.getEffectiveMinRatio(configuredMinResources, numeratorForMinRatio));
    }

    private Map<String, Float> getEffectiveMinRatio(Resource configuredMinResources, Resource numeratorForMinRatio) {
        HashMap<String, Float> effectiveMinRatioPerResource = new HashMap<String, Float>();
        if (numeratorForMinRatio != null) {
            int maxLength = ResourceUtils.getNumberOfCountableResourceTypes();
            for (int i = 0; i < maxLength; ++i) {
                ResourceInformation nResourceInformation = numeratorForMinRatio.getResourceInformation(i);
                ResourceInformation dResourceInformation = configuredMinResources.getResourceInformation(i);
                long nValue = nResourceInformation.getValue();
                long dValue = UnitsConversionUtil.convert((String)dResourceInformation.getUnits(), (String)nResourceInformation.getUnits(), (long)dResourceInformation.getValue());
                if (dValue == 0L) continue;
                effectiveMinRatioPerResource.put(nResourceInformation.getName(), Float.valueOf((float)nValue / (float)dValue));
            }
        }
        return ImmutableMap.copyOf(effectiveMinRatioPerResource);
    }

    @Override
    public List<CSQueue> getChildQueues() {
        this.readLock.lock();
        try {
            ArrayList<CSQueue> arrayList = new ArrayList<CSQueue>(this.childQueues);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverContainer(Resource clusterResource, SchedulerApplicationAttempt attempt, RMContainer rmContainer) {
        if (rmContainer.getState().equals((Object)RMContainerState.COMPLETED)) {
            return;
        }
        if (rmContainer.getExecutionType() != ExecutionType.GUARANTEED) {
            return;
        }
        this.writeLock.lock();
        try {
            FiCaSchedulerNode node = this.queueContext.getNode(rmContainer.getContainer().getNodeId());
            this.allocateResource(clusterResource, rmContainer.getContainer().getResource(), node.getPartition());
        }
        finally {
            this.writeLock.unlock();
        }
        if (this.parent != null) {
            this.parent.recoverContainer(clusterResource, attempt, rmContainer);
        }
    }

    @Override
    public ActiveUsersManager getAbstractUsersManager() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectSchedulerApplications(Collection<ApplicationAttemptId> apps) {
        this.readLock.lock();
        try {
            for (CSQueue queue : this.childQueues) {
                queue.collectSchedulerApplications(apps);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void attachContainer(Resource clusterResource, FiCaSchedulerApp application, RMContainer rmContainer) {
        if (application != null) {
            FiCaSchedulerNode node = this.queueContext.getNode(rmContainer.getContainer().getNodeId());
            this.allocateResource(clusterResource, rmContainer.getContainer().getResource(), node.getPartition());
            LOG.info((Object)("movedContainer queueMoveIn=" + this.getQueuePath() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.usageTracker.getQueueUsage().getUsed() + " cluster=" + clusterResource));
            if (this.parent != null) {
                this.parent.attachContainer(clusterResource, application, rmContainer);
            }
        }
    }

    @Override
    public void detachContainer(Resource clusterResource, FiCaSchedulerApp application, RMContainer rmContainer) {
        if (application != null) {
            FiCaSchedulerNode node = this.queueContext.getNode(rmContainer.getContainer().getNodeId());
            super.releaseResource(clusterResource, rmContainer.getContainer().getResource(), node.getPartition());
            LOG.info((Object)("movedContainer queueMoveOut=" + this.getQueuePath() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.usageTracker.getQueueUsage().getUsed() + " cluster=" + clusterResource));
            if (this.parent != null) {
                this.parent.detachContainer(clusterResource, application, rmContainer);
            }
        }
    }

    @Override
    public int getNumApplications() {
        return this.numApplications.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void allocateResource(Resource clusterResource, Resource resource, String nodePartition) {
        this.writeLock.lock();
        try {
            super.allocateResource(clusterResource, resource, nodePartition);
            if (!this.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource(nodePartition).equals((Object)Resources.none())) {
                if (Resources.lessThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)this.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource(nodePartition), (Resource)this.usageTracker.getQueueUsage().getUsed(nodePartition))) {
                    this.killContainersToEnforceMaxQueueCapacity(nodePartition, clusterResource);
                }
            } else if (this.getQueueCapacities().getAbsoluteMaximumCapacity(nodePartition) < this.getQueueCapacities().getAbsoluteUsedCapacity(nodePartition)) {
                this.killContainersToEnforceMaxQueueCapacity(nodePartition, clusterResource);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void killContainersToEnforceMaxQueueCapacity(String partition, Resource clusterResource) {
        Iterator<RMContainer> killableContainerIter = this.getKillableContainers(partition);
        if (!killableContainerIter.hasNext()) {
            return;
        }
        Resource partitionResource = this.labelManager.getResourceByLabel(partition, null);
        Resource maxResource = this.getEffectiveMaxCapacity(partition);
        while (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)partitionResource, (Resource)this.usageTracker.getQueueUsage().getUsed(partition), (Resource)maxResource)) {
            RMContainer toKillContainer = killableContainerIter.next();
            FiCaSchedulerApp attempt = this.queueContext.getApplicationAttempt(toKillContainer.getContainerId().getApplicationAttemptId());
            FiCaSchedulerNode node = this.queueContext.getNode(toKillContainer.getAllocatedNode());
            if (null != attempt && null != node) {
                AbstractLeafQueue lq = attempt.getCSLeafQueue();
                lq.completedContainer(clusterResource, attempt, node, toKillContainer, SchedulerUtils.createPreemptedContainerStatus(toKillContainer.getContainerId(), "Container preempted by scheduler"), RMContainerEventType.KILL, null, false);
                LOG.info((Object)("Killed container=" + toKillContainer.getContainerId() + " from queue=" + lq.getQueuePath() + " to make queue=" + this.getQueuePath() + "'s max-capacity enforced"));
            }
            if (killableContainerIter.hasNext()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Resource cluster, ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> request) {
        if (request.anythingAllocatedOrReserved()) {
            ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode> allocation = request.getFirstAllocatedOrReservedContainer();
            SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer = allocation.getAllocatedOrReservedContainer();
            if (allocation.getAllocateFromReservedContainer() == null) {
                this.writeLock.lock();
                try {
                    this.allocateResource(cluster, allocation.getAllocatedOrReservedResource(), schedulerContainer.getNodePartition());
                    LOG.info((Object)("assignedContainer queue=" + this.getQueuePath() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.usageTracker.getQueueUsage().getUsed() + " cluster=" + cluster));
                }
                finally {
                    this.writeLock.unlock();
                }
            }
        }
        if (this.parent != null) {
            this.parent.apply(cluster, request);
        }
    }

    @Override
    public void stopQueue() {
        this.writeLock.lock();
        try {
            if (this.getNumApplications() > 0) {
                this.updateQueueState(QueueState.DRAINING);
            } else {
                this.updateQueueState(QueueState.STOPPED);
            }
            if (this.getChildQueues() != null) {
                for (CSQueue child : this.getChildQueues()) {
                    child.stopQueue();
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public QueueOrderingPolicy getQueueOrderingPolicy() {
        return this.queueOrderingPolicy;
    }

    @Override
    int getNumRunnableApps() {
        this.readLock.lock();
        try {
            int n = this.runnableApps;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    void incrementRunnableApps() {
        this.writeLock.lock();
        try {
            ++this.runnableApps;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void decrementRunnableApps() {
        this.writeLock.lock();
        try {
            --this.runnableApps;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    Map<String, Float> getEffectiveMinRatio(String label) {
        return this.effectiveMinResourceRatio.get(label);
    }

    @Override
    public boolean isEligibleForAutoDeletion() {
        return this.isDynamicQueue() && this.getChildQueues().size() == 0 && this.queueContext.getConfiguration().isAutoExpiredDeletionEnabled(this.getQueuePath());
    }

    public AutoCreatedQueueTemplate getAutoCreatedQueueTemplate() {
        return this.autoCreatedQueueTemplate;
    }

    public static enum QueueCapacityType {
        WEIGHT,
        ABSOLUTE_RESOURCE,
        PERCENT;

    }
}

