/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.QueueConfigurations;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueStatistics;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueResourceQuotas;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;

public final class CSQueueInfoProvider {
    private static final RecordFactory RECORD_FACTORY = RecordFactoryProvider.getRecordFactory(null);

    private CSQueueInfoProvider() {
    }

    public static QueueInfo getQueueInfo(AbstractCSQueue csQueue) {
        QueueInfo queueInfo = (QueueInfo)RECORD_FACTORY.newRecordInstance(QueueInfo.class);
        queueInfo.setQueueName(csQueue.getQueuePathObject().getLeafName());
        queueInfo.setQueuePath(csQueue.getQueuePathObject().getFullPath());
        queueInfo.setAccessibleNodeLabels(csQueue.getAccessibleNodeLabels());
        queueInfo.setCapacity(csQueue.getCapacity());
        queueInfo.setMaximumCapacity(csQueue.getMaximumCapacity());
        queueInfo.setQueueState(csQueue.getState());
        queueInfo.setDefaultNodeLabelExpression(csQueue.getDefaultNodeLabelExpression());
        queueInfo.setCurrentCapacity(csQueue.getUsedCapacity());
        queueInfo.setQueueStatistics(CSQueueInfoProvider.getQueueStatistics(csQueue));
        queueInfo.setPreemptionDisabled(csQueue.getPreemptionDisabled());
        queueInfo.setIntraQueuePreemptionDisabled(csQueue.getIntraQueuePreemptionDisabled());
        queueInfo.setQueueConfigurations(CSQueueInfoProvider.getQueueConfigurations(csQueue));
        queueInfo.setWeight(csQueue.getQueueCapacities().getWeight());
        queueInfo.setMaxParallelApps(csQueue.getMaxParallelApps());
        return queueInfo;
    }

    private static QueueStatistics getQueueStatistics(AbstractCSQueue csQueue) {
        QueueStatistics stats = (QueueStatistics)RECORD_FACTORY.newRecordInstance(QueueStatistics.class);
        CSQueueMetrics queueMetrics = csQueue.getMetrics();
        stats.setNumAppsSubmitted((long)queueMetrics.getAppsSubmitted());
        stats.setNumAppsRunning((long)queueMetrics.getAppsRunning());
        stats.setNumAppsPending((long)queueMetrics.getAppsPending());
        stats.setNumAppsCompleted((long)queueMetrics.getAppsCompleted());
        stats.setNumAppsKilled((long)queueMetrics.getAppsKilled());
        stats.setNumAppsFailed((long)queueMetrics.getAppsFailed());
        stats.setNumActiveUsers((long)queueMetrics.getActiveUsers());
        stats.setAvailableMemoryMB(queueMetrics.getAvailableMB());
        stats.setAllocatedMemoryMB(queueMetrics.getAllocatedMB());
        stats.setPendingMemoryMB(queueMetrics.getPendingMB());
        stats.setReservedMemoryMB(queueMetrics.getReservedMB());
        stats.setAvailableVCores((long)queueMetrics.getAvailableVirtualCores());
        stats.setAllocatedVCores((long)queueMetrics.getAllocatedVirtualCores());
        stats.setPendingVCores((long)queueMetrics.getPendingVirtualCores());
        stats.setReservedVCores((long)queueMetrics.getReservedVirtualCores());
        stats.setPendingContainers((long)queueMetrics.getPendingContainers());
        stats.setAllocatedContainers((long)queueMetrics.getAllocatedContainers());
        stats.setReservedContainers((long)queueMetrics.getReservedContainers());
        return stats;
    }

    private static Map<String, QueueConfigurations> getQueueConfigurations(AbstractCSQueue csQueue) {
        HashMap<String, QueueConfigurations> queueConfigurations = new HashMap<String, QueueConfigurations>();
        Set<String> nodeLabels = csQueue.getNodeLabelsForQueue();
        QueueResourceQuotas queueResourceQuotas = csQueue.getQueueResourceQuotas();
        for (String nodeLabel : nodeLabels) {
            QueueConfigurations queueConfiguration = (QueueConfigurations)RECORD_FACTORY.newRecordInstance(QueueConfigurations.class);
            QueueCapacities queueCapacities = csQueue.getQueueCapacities();
            float capacity = queueCapacities.getCapacity(nodeLabel);
            float absoluteCapacity = queueCapacities.getAbsoluteCapacity(nodeLabel);
            float maxCapacity = queueCapacities.getMaximumCapacity(nodeLabel);
            float absMaxCapacity = queueCapacities.getAbsoluteMaximumCapacity(nodeLabel);
            float maxAMPercentage = queueCapacities.getMaxAMResourcePercentage(nodeLabel);
            queueConfiguration.setCapacity(capacity);
            queueConfiguration.setAbsoluteCapacity(absoluteCapacity);
            queueConfiguration.setMaxCapacity(maxCapacity);
            queueConfiguration.setAbsoluteMaxCapacity(absMaxCapacity);
            queueConfiguration.setMaxAMPercentage(maxAMPercentage);
            queueConfiguration.setConfiguredMinCapacity(queueResourceQuotas.getConfiguredMinResource(nodeLabel));
            queueConfiguration.setConfiguredMaxCapacity(queueResourceQuotas.getConfiguredMaxResource(nodeLabel));
            queueConfiguration.setEffectiveMinCapacity(queueResourceQuotas.getEffectiveMinResource(nodeLabel));
            queueConfiguration.setEffectiveMaxCapacity(queueResourceQuotas.getEffectiveMaxResource(nodeLabel));
            queueConfigurations.put(nodeLabel, queueConfiguration);
        }
        return queueConfigurations;
    }
}

