/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;

public class ConfiguredNodeLabels {
    private final Map<String, Set<String>> configuredNodeLabelsByQueue;
    private static final Set<String> NO_LABEL = ImmutableSet.of((Object)"");

    public ConfiguredNodeLabels() {
        this.configuredNodeLabelsByQueue = new HashMap<String, Set<String>>();
    }

    public ConfiguredNodeLabels(CapacitySchedulerConfiguration conf) {
        this.configuredNodeLabelsByQueue = conf.getConfiguredNodeLabelsByQueue();
    }

    public Set<String> getLabelsByQueue(String queuePath) {
        Set<String> labels = this.configuredNodeLabelsByQueue.get(queuePath);
        if (labels == null) {
            return NO_LABEL;
        }
        return ImmutableSet.copyOf(labels);
    }

    public void setLabelsByQueue(String queuePath, Collection<String> nodeLabels) {
        this.configuredNodeLabelsByQueue.put(queuePath, new HashSet<String>(nodeLabels));
    }

    public Set<String> getAllConfiguredLabels() {
        Set<String> nodeLabels = this.configuredNodeLabelsByQueue.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (nodeLabels.size() == 0) {
            nodeLabels = NO_LABEL;
        }
        return nodeLabels;
    }
}

