/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.security.ConfiguredYarnAuthorizer;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.placement.schema.MappingRulesDescription;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ConfigurableResource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.ConversionException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.ConversionOptions;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigConverterParams;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigRuleHandler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSQueueConverter;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSQueueConverterBuilder;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSYarnSiteConverter;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.PreconditionException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.QueuePlacementConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSConfigToCSConfigConverter {
    public static final Logger LOG = LoggerFactory.getLogger((String)FSConfigToCSConfigConverter.class.getName());
    public static final String MAPPING_RULES_JSON = "mapping-rules.json";
    private static final String YARN_SITE_XML = "yarn-site.xml";
    private static final String CAPACITY_SCHEDULER_XML = "capacity-scheduler.xml";
    private static final String FAIR_SCHEDULER_XML = "fair-scheduler.xml";
    private Resource clusterResource;
    private boolean preemptionEnabled = false;
    private int queueMaxAppsDefault;
    private float queueMaxAMShareDefault;
    private Map<String, Integer> userMaxApps;
    private int userMaxAppsDefault;
    private boolean sizeBasedWeight = false;
    private ConversionOptions conversionOptions;
    private boolean drfUsed = false;
    private Configuration convertedYarnSiteConfig;
    private CapacitySchedulerConfiguration capacitySchedulerConfig;
    private FSConfigToCSConfigRuleHandler ruleHandler;
    private QueuePlacementConverter placementConverter;
    private OutputStream yarnSiteOutputStream;
    private OutputStream capacitySchedulerOutputStream;
    private OutputStream mappingRulesOutputStream;
    private boolean consoleMode = false;
    private boolean convertPlacementRules = true;
    private String outputDirectory;
    private boolean rulesToFile;
    private boolean usePercentages;
    private FSConfigToCSConfigConverterParams.PreemptionMode preemptionMode;

    public FSConfigToCSConfigConverter(FSConfigToCSConfigRuleHandler ruleHandler, ConversionOptions conversionOptions) {
        this.ruleHandler = ruleHandler;
        this.conversionOptions = conversionOptions;
        this.yarnSiteOutputStream = System.out;
        this.capacitySchedulerOutputStream = System.out;
        this.placementConverter = new QueuePlacementConverter();
    }

    public void convert(FSConfigToCSConfigConverterParams params) throws Exception {
        this.validateParams(params);
        this.clusterResource = this.getClusterResource(params);
        this.convertPlacementRules = params.isConvertPlacementRules();
        this.outputDirectory = params.getOutputDirectory();
        this.rulesToFile = params.isPlacementRulesToFile();
        this.usePercentages = params.isUsePercentages();
        this.preemptionMode = params.getPreemptionMode();
        this.prepareOutputFiles(params.isConsole());
        this.loadConversionRules(params.getConversionRulesConfig());
        Configuration inputYarnSiteConfig = this.getInputYarnSiteConfig(params);
        this.handleFairSchedulerConfig(params, inputYarnSiteConfig);
        this.convert(inputYarnSiteConfig);
    }

    private void prepareOutputFiles(boolean console) throws FileNotFoundException {
        if (console) {
            LOG.info("Console mode is enabled, {}, {} and {} will be only emitted to the console!", new Object[]{YARN_SITE_XML, CAPACITY_SCHEDULER_XML, MAPPING_RULES_JSON});
            this.consoleMode = true;
            return;
        }
        File yarnSiteXmlOutput = new File(this.outputDirectory, YARN_SITE_XML);
        File schedulerXmlOutput = new File(this.outputDirectory, CAPACITY_SCHEDULER_XML);
        LOG.info("Output directory for yarn-site.xml and capacity-scheduler.xml is: {}", (Object)this.outputDirectory);
        this.yarnSiteOutputStream = new FileOutputStream(yarnSiteXmlOutput);
        this.capacitySchedulerOutputStream = new FileOutputStream(schedulerXmlOutput);
    }

    private void validateParams(FSConfigToCSConfigConverterParams params) {
        if (params.getYarnSiteXmlConfig() == null) {
            throw new PreconditionException("yarn-site.xml configuration is not defined but it is mandatory!");
        }
        if (params.getOutputDirectory() == null && !params.isConsole()) {
            throw new PreconditionException("Output directory configuration is not defined but it is mandatory!");
        }
    }

    private Resource getClusterResource(FSConfigToCSConfigConverterParams params) {
        Resource resource = null;
        if (params.getClusterResource() != null) {
            ConfigurableResource configurableResource;
            try {
                configurableResource = FairSchedulerConfiguration.parseResourceConfigValue(params.getClusterResource());
            }
            catch (AllocationConfigurationException e) {
                throw new ConversionException("Error while parsing resource.", e);
            }
            resource = configurableResource.getResource();
        }
        return resource;
    }

    private void loadConversionRules(String rulesFile) throws IOException {
        if (rulesFile != null) {
            LOG.info("Reading conversion rules file from: " + rulesFile);
            this.ruleHandler.loadRulesFromFile(rulesFile);
        } else {
            LOG.info("Conversion rules file is not defined, using default conversion config!");
        }
        this.ruleHandler.initPropertyActions();
    }

    private Configuration getInputYarnSiteConfig(FSConfigToCSConfigConverterParams params) {
        YarnConfiguration conf = new YarnConfiguration();
        conf.addResource(new Path(params.getYarnSiteXmlConfig()));
        return conf;
    }

    private void handleFairSchedulerConfig(FSConfigToCSConfigConverterParams params, Configuration conf) {
        String fairSchedulerXmlConfig = params.getFairSchedulerXmlConfig();
        if (fairSchedulerXmlConfig != null) {
            LOG.info("Using explicitly defined fair-scheduler.xml");
        } else if (conf.get("yarn.scheduler.fair.allocation.file") != null) {
            LOG.info("Using fair-scheduler.xml defined in yarn-site.xml by key: yarn.scheduler.fair.allocation.file");
        } else {
            throw new PreconditionException("fair-scheduler.xml is not defined neither in yarn-site.xml(with property: yarn.scheduler.fair.allocation.file) nor directly with its own parameter!");
        }
        if (fairSchedulerXmlConfig != null) {
            conf.set("yarn.scheduler.fair.allocation.file", params.getFairSchedulerXmlConfig());
        }
    }

    @VisibleForTesting
    void convert(Configuration inputYarnSiteConfig) throws Exception {
        RMContextImpl ctx = new RMContextImpl();
        PlacementManager placementManager = new PlacementManager();
        ctx.setQueuePlacementManager(placementManager);
        Configuration fsConfig = new Configuration(inputYarnSiteConfig);
        fsConfig.setBoolean("yarn.scheduler.fair.migration.mode", true);
        fsConfig.setBoolean("yarn.scheduler.fair.no-terminal-rule.check", this.conversionOptions.isNoRuleTerminalCheck());
        fsConfig.setClass("yarn.authorization-provider", ConfiguredYarnAuthorizer.class, YarnAuthorizationProvider.class);
        FairScheduler fs = new FairScheduler();
        fs.setRMContext(ctx);
        fs.init(fsConfig);
        this.drfUsed = this.isDrfUsed(fs);
        AllocationConfiguration allocConf = fs.getAllocationConfiguration();
        this.queueMaxAppsDefault = allocConf.getQueueMaxAppsDefault();
        this.userMaxAppsDefault = allocConf.getUserMaxAppsDefault();
        this.userMaxApps = allocConf.getUserMaxApps();
        this.queueMaxAMShareDefault = allocConf.getQueueMaxAMShareDefault();
        this.convertedYarnSiteConfig = new Configuration(false);
        this.capacitySchedulerConfig = new CapacitySchedulerConfiguration(new Configuration(false));
        this.convertYarnSiteXml(inputYarnSiteConfig);
        this.convertCapacitySchedulerXml(fs);
        if (this.convertPlacementRules) {
            this.performRuleConversion(fs);
        }
        if (this.consoleMode) {
            System.out.println("======= capacity-scheduler.xml =======");
        }
        this.capacitySchedulerConfig.writeXml(this.capacitySchedulerOutputStream);
        if (this.consoleMode) {
            System.out.println();
            System.out.println("======= yarn-site.xml =======");
        }
        this.convertedYarnSiteConfig.writeXml(this.yarnSiteOutputStream);
    }

    private void convertYarnSiteXml(Configuration inputYarnSiteConfig) {
        FSYarnSiteConverter siteConverter = new FSYarnSiteConverter();
        siteConverter.convertSiteProperties(inputYarnSiteConfig, this.convertedYarnSiteConfig, this.drfUsed, this.conversionOptions.isEnableAsyncScheduler(), this.usePercentages, this.preemptionMode);
        this.preemptionEnabled = siteConverter.isPreemptionEnabled();
        this.sizeBasedWeight = siteConverter.isSizeBasedWeight();
        this.checkReservationSystem(inputYarnSiteConfig);
    }

    private void convertCapacitySchedulerXml(FairScheduler fs) {
        FSParentQueue rootQueue = fs.getQueueManager().getRootQueue();
        this.emitDefaultQueueMaxParallelApplications();
        this.emitDefaultUserMaxParallelApplications();
        this.emitUserMaxParallelApplications();
        this.emitDefaultMaxAMShare();
        this.emitDisablePreemptionForObserveOnlyMode();
        FSQueueConverter queueConverter = FSQueueConverterBuilder.create().withRuleHandler(this.ruleHandler).withCapacitySchedulerConfig(this.capacitySchedulerConfig).withPreemptionEnabled(this.preemptionEnabled).withSizeBasedWeight(this.sizeBasedWeight).withClusterResource(this.clusterResource).withQueueMaxAMShareDefault(this.queueMaxAMShareDefault).withQueueMaxAppsDefault(this.queueMaxAppsDefault).withConversionOptions(this.conversionOptions).withDrfUsed(this.drfUsed).withPercentages(this.usePercentages).build();
        queueConverter.convertQueueHierarchy(rootQueue);
        this.emitACLs(fs);
    }

    private void performRuleConversion(FairScheduler fs) throws IOException {
        LOG.info("Converting placement rules");
        PlacementManager placementManager = fs.getRMContext().getQueuePlacementManager();
        if (placementManager.getPlacementRules().size() > 0) {
            this.mappingRulesOutputStream = this.getOutputStreamForJson();
            MappingRulesDescription desc = this.placementConverter.convertPlacementPolicy(placementManager, this.ruleHandler, this.capacitySchedulerConfig, this.usePercentages);
            ObjectMapper mapper = new ObjectMapper();
            if (!this.consoleMode && this.rulesToFile) {
                mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, true);
            } else {
                mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
            }
            ObjectWriter writer = mapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
            if (this.consoleMode && this.rulesToFile) {
                System.out.println("======= mapping-rules.json =======");
            }
            writer.writeValue(this.mappingRulesOutputStream, (Object)desc);
            this.capacitySchedulerConfig.set("yarn.scheduler.capacity.mapping-rule-format", "json");
            this.capacitySchedulerConfig.setOverrideWithQueueMappings(true);
            if (!this.rulesToFile) {
                String json = ((ByteArrayOutputStream)this.mappingRulesOutputStream).toString(StandardCharsets.UTF_8.displayName());
                this.capacitySchedulerConfig.set("yarn.scheduler.capacity.mapping-rule-json", json);
            }
        } else {
            LOG.info("No rules to convert");
        }
    }

    private OutputStream getOutputStreamForJson() throws FileNotFoundException {
        if (this.consoleMode && this.rulesToFile) {
            return System.out;
        }
        if (this.rulesToFile) {
            File mappingRulesFile = new File(this.outputDirectory, MAPPING_RULES_JSON);
            return new FileOutputStream(mappingRulesFile);
        }
        return new ByteArrayOutputStream();
    }

    private void emitDefaultQueueMaxParallelApplications() {
        if (this.queueMaxAppsDefault != Integer.MAX_VALUE) {
            this.capacitySchedulerConfig.set("yarn.scheduler.capacity.max-parallel-apps", String.valueOf(this.queueMaxAppsDefault));
        }
    }

    private void emitDefaultUserMaxParallelApplications() {
        if (this.userMaxAppsDefault != Integer.MAX_VALUE) {
            this.capacitySchedulerConfig.set("yarn.scheduler.capacity.user.max-parallel-apps", String.valueOf(this.userMaxAppsDefault));
        }
    }

    private void emitUserMaxParallelApplications() {
        this.userMaxApps.forEach((user, apps) -> this.capacitySchedulerConfig.setInt("yarn.scheduler.capacity.user." + user + ".max-parallel-apps", (int)apps));
    }

    private void emitDefaultMaxAMShare() {
        if (this.queueMaxAMShareDefault == -1.0f) {
            this.capacitySchedulerConfig.setFloat("yarn.scheduler.capacity.maximum-am-resource-percent", 1.0f);
        } else {
            this.capacitySchedulerConfig.setFloat("yarn.scheduler.capacity.maximum-am-resource-percent", this.queueMaxAMShareDefault);
        }
    }

    private void emitDisablePreemptionForObserveOnlyMode() {
        if (this.preemptionMode == FSConfigToCSConfigConverterParams.PreemptionMode.OBSERVE_ONLY) {
            this.capacitySchedulerConfig.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.observe_only", true);
        }
    }

    private void emitACLs(FairScheduler fs) {
        fs.getAllocationConfiguration().getQueueAcls().forEach(this::generateQueueAcl);
    }

    private void generateQueueAcl(String queue, Map<AccessType, AccessControlList> access) {
        AccessControlList submitAcls = access.get(AccessType.SUBMIT_APP);
        AccessControlList adminAcls = access.get(AccessType.ADMINISTER_QUEUE);
        if (!submitAcls.getGroups().isEmpty() || !submitAcls.getUsers().isEmpty() || submitAcls.isAllAllowed()) {
            this.capacitySchedulerConfig.set("yarn.scheduler.capacity." + queue + ".acl_submit_applications", submitAcls.getAclString());
        }
        if (!adminAcls.getGroups().isEmpty() || !adminAcls.getUsers().isEmpty() || adminAcls.isAllAllowed()) {
            this.capacitySchedulerConfig.set("yarn.scheduler.capacity." + queue + ".acl_administer_queue", adminAcls.getAclString());
        }
    }

    private void checkReservationSystem(Configuration conf) {
        if (conf.getBoolean("yarn.resourcemanager.reservation-system.enable", false)) {
            this.ruleHandler.handleReservationSystem();
        }
    }

    private boolean isDrfUsed(FairScheduler fs) {
        FSParentQueue rootQueue = fs.getQueueManager().getRootQueue();
        AllocationConfiguration allocConf = fs.getAllocationConfiguration();
        String defaultPolicy = allocConf.getDefaultSchedulingPolicy().getName();
        return "DRF".equals(defaultPolicy) || this.isDrfUsedOnQueueLevel(rootQueue);
    }

    private boolean isDrfUsedOnQueueLevel(FSQueue queue) {
        String policy = queue.getPolicy().getName();
        boolean usesDrf = "DRF".equals(policy);
        if (usesDrf) {
            return true;
        }
        List<FSQueue> children = queue.getChildQueues();
        if (children != null) {
            for (FSQueue child : children) {
                usesDrf |= this.isDrfUsedOnQueueLevel(child);
            }
        }
        return usesDrf;
    }

    @VisibleForTesting
    Resource getClusterResource() {
        return this.clusterResource;
    }

    @VisibleForTesting
    void setClusterResource(Resource clusterResource) {
        this.clusterResource = clusterResource;
    }

    @VisibleForTesting
    FSConfigToCSConfigRuleHandler getRuleHandler() {
        return this.ruleHandler;
    }

    @VisibleForTesting
    Configuration getYarnSiteConfig() {
        return this.convertedYarnSiteConfig;
    }

    @VisibleForTesting
    Configuration getCapacitySchedulerConfig() {
        return this.capacitySchedulerConfig;
    }

    @VisibleForTesting
    void setConvertPlacementRules(boolean convertPlacementRules) {
        this.convertPlacementRules = convertPlacementRules;
    }

    @VisibleForTesting
    void setPlacementConverter(QueuePlacementConverter converter) {
        this.placementConverter = converter;
    }

    @VisibleForTesting
    void setConsoleMode(boolean console) {
        this.consoleMode = console;
    }
}

