/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.weightconversion;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.weightconversion.CapacityConverter;

public class WeightToWeightConverter
implements CapacityConverter {
    private static final String ROOT_QUEUE = "root";

    @Override
    public void convertWeightsForChildQueues(FSQueue queue, Configuration csConfig) {
        List<FSQueue> children = queue.getChildQueues();
        if (queue instanceof FSParentQueue || !children.isEmpty()) {
            if (queue.getName().equals(ROOT_QUEUE)) {
                csConfig.set(this.getProperty(queue), this.getWeightString(queue));
            }
            children.forEach(fsQueue -> csConfig.set(this.getProperty((FSQueue)fsQueue), this.getWeightString((FSQueue)fsQueue)));
            csConfig.setBoolean(this.getAutoCreateV2EnabledProperty(queue), true);
        }
    }

    private String getProperty(FSQueue queue) {
        return "yarn.scheduler.capacity." + queue.getName() + ".capacity";
    }

    private String getAutoCreateV2EnabledProperty(FSQueue queue) {
        return "yarn.scheduler.capacity." + queue.getName() + ".auto-queue-creation-v2.enabled";
    }

    private String getWeightString(FSQueue queue) {
        return Float.toString(queue.getWeight()) + "w";
    }
}

