/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.MultiNodeLookupPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayeredNodeUsageBinPackingPolicy<N extends SchedulerNode>
implements MultiNodeLookupPolicy<N> {
    private static final Logger LOG = LoggerFactory.getLogger(LayeredNodeUsageBinPackingPolicy.class);
    protected Map<String, Set<N>> nodesPerPartition = new ConcurrentHashMap<String, Set<N>>();
    protected Map<String, Float> nodeToScore = new HashMap<String, Float>();
    private final float normalLayerMinimumScore = 2000.0f;
    private final float normalLayerSlope = 3.0f;
    private final float busyLayerMaxScore = 1000.0f;
    private final float busyLayerSlope = -3.0f;
    private final float busyLayerThreshold = 0.6f;
    protected Comparator<N> comparator;

    public LayeredNodeUsageBinPackingPolicy(boolean debug) {
    }

    public LayeredNodeUsageBinPackingPolicy() {
        this.comparator = new Comparator<N>(){

            @Override
            public int compare(N o1, N o2) {
                float score1 = LayeredNodeUsageBinPackingPolicy.this.nodeToScore.get(((SchedulerNode)o1).getNodeID().toString()).floatValue();
                float score2 = LayeredNodeUsageBinPackingPolicy.this.nodeToScore.get(((SchedulerNode)o2).getNodeID().toString()).floatValue();
                float allocatedDiff = score2 - score1;
                if (allocatedDiff == 0.0f) {
                    return ((SchedulerNode)o1).getNodeID().compareTo(((SchedulerNode)o2).getNodeID());
                }
                return allocatedDiff > 0.0f ? 1 : -1;
            }
        };
    }

    private float calculateScore(N node) {
        LOG.debug("{}'s used resource is {}", (Object)((SchedulerNode)node).getNodeID().toString(), (Object)((SchedulerNode)node).getAllocatedResource());
        float nodeResourceUsage = this.getNodeResourceUsage(((SchedulerNode)node).getAllocatedResource(), ((SchedulerNode)node).getTotalResource());
        LOG.debug("{}'s resource usage is {}", (Object)((SchedulerNode)node).getNodeID().toString(), (Object)Float.valueOf(nodeResourceUsage));
        float score = this.scorer(nodeResourceUsage, 0.6f);
        LOG.debug("{}'s final score is {}", (Object)((SchedulerNode)node).getNodeID().toString(), (Object)Float.valueOf(score));
        return score;
    }

    public float scorer(float resourceUsage, float busyLayerThreshold) {
        if (resourceUsage < busyLayerThreshold && resourceUsage > 0.0f) {
            return 2000.0f + 3.0f * resourceUsage * 100.0f;
        }
        if (resourceUsage >= busyLayerThreshold) {
            return 1000.0f + -3.0f * resourceUsage * 100.0f;
        }
        return new Random().nextFloat() * 100.0f;
    }

    private float getNodeResourceUsage(Resource r, Resource base) {
        float cpuUsage;
        float memUsage = (float)r.getMemorySize() / (float)base.getMemorySize();
        return memUsage > (cpuUsage = (float)r.getVirtualCores() / (float)base.getVirtualCores()) ? memUsage : cpuUsage;
    }

    @Override
    public Iterator<N> getPreferredNodeIterator(Collection<N> nodes, String partition) {
        return this.getNodesPerPartition(partition).iterator();
    }

    @Override
    public void addAndRefreshNodesSet(Collection<N> nodes, String partition) {
        for (SchedulerNode node : nodes) {
            this.nodeToScore.put(node.getNodeID().toString(), Float.valueOf(this.calculateScore(node)));
        }
        ConcurrentSkipListSet<N> nodeList = new ConcurrentSkipListSet<N>(this.comparator);
        nodeList.addAll(nodes);
        this.nodesPerPartition.put(partition, Collections.unmodifiableSet(nodeList));
    }

    @Override
    public Set<N> getNodesPerPartition(String partition) {
        return this.nodesPerPartition.getOrDefault(partition, Collections.emptySet());
    }
}

