/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueResourceQuotas;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.PlanQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AutoQueueTemplatePropertiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerLeafQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfoList;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.LeafQueueTemplateInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.QueueAclInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.QueueAclsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.QueueCapacitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourcesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.helper.CapacitySchedulerInfoHelper;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={CapacitySchedulerLeafQueueInfo.class})
public class CapacitySchedulerQueueInfo {
    @XmlTransient
    static final float EPSILON = 1.0E-8f;
    protected String queuePath;
    protected float capacity;
    protected float usedCapacity;
    protected float maxCapacity;
    protected float absoluteCapacity;
    protected float absoluteMaxCapacity;
    protected float absoluteUsedCapacity;
    protected float weight;
    protected float normalizedWeight;
    protected int numApplications;
    protected int maxParallelApps;
    protected String queueName;
    protected boolean isAbsoluteResource;
    protected QueueState state;
    protected CapacitySchedulerQueueInfoList queues;
    protected ResourceInfo resourcesUsed;
    private boolean hideReservationQueues = false;
    protected ArrayList<String> nodeLabels = new ArrayList();
    protected long allocatedContainers;
    protected long reservedContainers;
    protected long pendingContainers;
    protected QueueCapacitiesInfo capacities;
    protected ResourcesInfo resources;
    protected ResourceInfo minEffectiveCapacity;
    protected ResourceInfo maxEffectiveCapacity;
    protected ResourceInfo maximumAllocation;
    protected QueueAclsInfo queueAcls;
    protected int queuePriority;
    protected String orderingPolicyInfo;
    protected boolean autoCreateChildQueueEnabled;
    protected LeafQueueTemplateInfo leafQueueTemplate;
    protected String mode;
    protected String queueType;
    protected String creationMethod;
    protected String autoCreationEligibility;
    protected String defaultNodeLabelExpression;
    protected AutoQueueTemplatePropertiesInfo autoQueueTemplateProperties = new AutoQueueTemplatePropertiesInfo();
    protected AutoQueueTemplatePropertiesInfo autoQueueParentTemplateProperties = new AutoQueueTemplatePropertiesInfo();
    protected AutoQueueTemplatePropertiesInfo autoQueueLeafTemplateProperties = new AutoQueueTemplatePropertiesInfo();

    CapacitySchedulerQueueInfo() {
    }

    CapacitySchedulerQueueInfo(CapacityScheduler cs, CSQueue q) {
        Set<String> labelSet;
        this.queuePath = q.getQueuePath();
        this.capacity = q.getCapacity() * 100.0f;
        this.usedCapacity = q.getUsedCapacity() * 100.0f;
        this.maxCapacity = q.getMaximumCapacity();
        if (this.maxCapacity < 1.0E-8f || this.maxCapacity > 1.0f) {
            this.maxCapacity = 1.0f;
        }
        this.maxCapacity *= 100.0f;
        this.absoluteCapacity = CapacitySchedulerQueueInfo.cap(q.getAbsoluteCapacity(), 0.0f, 1.0f) * 100.0f;
        this.absoluteMaxCapacity = CapacitySchedulerQueueInfo.cap(q.getAbsoluteMaximumCapacity(), 0.0f, 1.0f) * 100.0f;
        this.absoluteUsedCapacity = CapacitySchedulerQueueInfo.cap(q.getAbsoluteUsedCapacity(), 0.0f, 1.0f) * 100.0f;
        this.weight = q.getQueueCapacities().getWeight();
        this.normalizedWeight = q.getQueueCapacities().getNormalizedWeight();
        this.numApplications = q.getNumApplications();
        this.maxParallelApps = q.getMaxParallelApps();
        this.allocatedContainers = q.getMetrics().getAllocatedContainers();
        this.pendingContainers = q.getMetrics().getPendingContainers();
        this.reservedContainers = q.getMetrics().getReservedContainers();
        this.queueName = q.getQueueName();
        this.state = q.getState();
        this.defaultNodeLabelExpression = q.getDefaultNodeLabelExpression();
        this.resourcesUsed = new ResourceInfo(q.getUsedResources());
        if (q instanceof PlanQueue && !((PlanQueue)q).showReservationsAsQueues()) {
            this.hideReservationQueues = true;
        }
        if ((labelSet = q.getAccessibleNodeLabels()) != null) {
            this.nodeLabels.addAll(labelSet);
            Collections.sort(this.nodeLabels);
        }
        QueueCapacities qCapacities = q.getQueueCapacities();
        QueueResourceQuotas qResQuotas = q.getQueueResourceQuotas();
        this.populateQueueCapacities(qCapacities, qResQuotas);
        this.mode = CapacitySchedulerInfoHelper.getMode(q);
        this.queueType = CapacitySchedulerInfoHelper.getQueueType(q);
        this.creationMethod = CapacitySchedulerInfoHelper.getCreationMethod(q);
        this.autoCreationEligibility = CapacitySchedulerInfoHelper.getAutoCreationEligibility(q);
        ResourceUsage queueResourceUsage = q.getQueueResourceUsage();
        this.populateQueueResourceUsage(queueResourceUsage);
        this.minEffectiveCapacity = new ResourceInfo(q.getQueueResourceQuotas().getEffectiveMinResource());
        this.maxEffectiveCapacity = new ResourceInfo(q.getQueueResourceQuotas().getEffectiveMaxResource());
        this.maximumAllocation = new ResourceInfo(q.getMaximumAllocation());
        CapacitySchedulerConfiguration conf = cs.getConfiguration();
        this.queueAcls = new QueueAclsInfo();
        this.queueAcls.addAll(CapacitySchedulerQueueInfo.getSortedQueueAclInfoList(q, this.queuePath, conf));
        this.queuePriority = q.getPriority().getPriority();
        if (q instanceof AbstractParentQueue) {
            AbstractParentQueue queue = (AbstractParentQueue)q;
            this.orderingPolicyInfo = queue.getQueueOrderingPolicy().getConfigName();
            this.autoQueueTemplateProperties = CapacitySchedulerInfoHelper.getAutoCreatedTemplate(queue.getAutoCreatedQueueTemplate().getTemplateProperties());
            this.autoQueueParentTemplateProperties = CapacitySchedulerInfoHelper.getAutoCreatedTemplate(queue.getAutoCreatedQueueTemplate().getParentOnlyProperties());
            this.autoQueueLeafTemplateProperties = CapacitySchedulerInfoHelper.getAutoCreatedTemplate(queue.getAutoCreatedQueueTemplate().getLeafOnlyProperties());
        }
        this.autoCreateChildQueueEnabled = conf.isAutoCreateChildQueueEnabled(this.queuePath);
        this.leafQueueTemplate = new LeafQueueTemplateInfo(conf, this.queuePath);
        this.isAbsoluteResource = q.getCapacityConfigType() == AbstractCSQueue.CapacityConfigType.ABSOLUTE_RESOURCE;
    }

    public static ArrayList<QueueAclInfo> getSortedQueueAclInfoList(CSQueue queue, String queuePath, CapacitySchedulerConfiguration conf) {
        QueueAclInfo queueAcl;
        ArrayList<QueueAclInfo> queueAclsInfo = new ArrayList<QueueAclInfo>();
        for (Map.Entry<AccessType, AccessControlList> e : ((AbstractCSQueue)queue).getACLs().entrySet()) {
            queueAcl = new QueueAclInfo(e.getKey().toString(), e.getValue().getAclString());
            queueAclsInfo.add(queueAcl);
        }
        String aclApplicationMaxPriority = "acl_" + StringUtils.toLowerCase((String)AccessType.APPLICATION_MAX_PRIORITY.toString());
        String priorityAcls = conf.get(CapacitySchedulerConfiguration.getQueuePrefix(queuePath) + aclApplicationMaxPriority, "*");
        queueAcl = new QueueAclInfo(AccessType.APPLICATION_MAX_PRIORITY.toString(), priorityAcls);
        queueAclsInfo.add(queueAcl);
        queueAclsInfo.sort(Comparator.comparing(QueueAclInfo::getAccessType));
        return queueAclsInfo;
    }

    protected void populateQueueResourceUsage(ResourceUsage queueResourceUsage) {
        this.resources = new ResourcesInfo(queueResourceUsage, false);
    }

    protected void populateQueueCapacities(QueueCapacities qCapacities, QueueResourceQuotas qResQuotas) {
        this.capacities = new QueueCapacitiesInfo(qCapacities, qResQuotas, false);
    }

    public float getCapacity() {
        return this.capacity;
    }

    public float getUsedCapacity() {
        return this.usedCapacity;
    }

    public float getMaxCapacity() {
        return this.maxCapacity;
    }

    public float getAbsoluteCapacity() {
        return this.absoluteCapacity;
    }

    public float getAbsoluteMaxCapacity() {
        return this.absoluteMaxCapacity;
    }

    public float getAbsoluteUsedCapacity() {
        return this.absoluteUsedCapacity;
    }

    public int getNumApplications() {
        return this.numApplications;
    }

    public long getAllocatedContainers() {
        return this.allocatedContainers;
    }

    public long getReservedContainers() {
        return this.reservedContainers;
    }

    public long getPendingContainers() {
        return this.pendingContainers;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public boolean isAbsoluteResource() {
        return this.isAbsoluteResource;
    }

    public String getQueueState() {
        return this.state.toString();
    }

    public String getQueuePath() {
        return this.queuePath;
    }

    public CapacitySchedulerQueueInfoList getQueues() {
        if (this.hideReservationQueues) {
            return new CapacitySchedulerQueueInfoList();
        }
        return this.queues;
    }

    public ResourceInfo getResourcesUsed() {
        return this.resourcesUsed;
    }

    static float cap(float val, float low, float hi) {
        return Math.min(Math.max(val, low), hi);
    }

    public ArrayList<String> getNodeLabels() {
        return this.nodeLabels;
    }

    public QueueCapacitiesInfo getCapacities() {
        return this.capacities;
    }

    public ResourcesInfo getResources() {
        return this.resources;
    }

    public ResourceInfo getMinEffectiveCapacity() {
        return this.minEffectiveCapacity;
    }

    public ResourceInfo getMaxEffectiveCapacity() {
        return this.maxEffectiveCapacity;
    }

    public ResourceInfo getMaximumAllocation() {
        return this.maximumAllocation;
    }

    public QueueAclsInfo getQueueAcls() {
        return this.queueAcls;
    }

    public int getPriority() {
        return this.queuePriority;
    }

    public String getOrderingPolicyInfo() {
        return this.orderingPolicyInfo;
    }

    public boolean isLeafQueue() {
        return this.getQueues() == null;
    }

    public boolean isAutoCreateChildQueueEnabled() {
        return this.autoCreateChildQueueEnabled;
    }

    public LeafQueueTemplateInfo getLeafQueueTemplate() {
        return this.leafQueueTemplate;
    }

    public String getMode() {
        return this.mode;
    }

    public String getQueueType() {
        return this.queueType;
    }

    public float getWeight() {
        return this.weight;
    }

    public float getNormalizedWeight() {
        return this.normalizedWeight;
    }

    public int getMaxParallelApps() {
        return this.maxParallelApps;
    }

    public String getDefaultNodeLabelExpression() {
        return this.defaultNodeLabelExpression;
    }
}

