/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.apache.hadoop.yarn.util.resource.Resources;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PartitionQueueCapacitiesInfo {
    private String partitionName;
    private float capacity;
    private float usedCapacity;
    private float maxCapacity = 100.0f;
    private float absoluteCapacity;
    private float absoluteUsedCapacity;
    private float absoluteMaxCapacity = 100.0f;
    private float maxAMLimitPercentage;
    private float weight;
    private float normalizedWeight;
    private ResourceInfo configuredMinResource;
    private ResourceInfo configuredMaxResource;
    private ResourceInfo effectiveMinResource;
    private ResourceInfo effectiveMaxResource;

    public PartitionQueueCapacitiesInfo() {
    }

    public PartitionQueueCapacitiesInfo(String partitionName, float capacity, float usedCapacity, float maxCapacity, float absCapacity, float absUsedCapacity, float absMaxCapacity, float maxAMLimitPercentage, float weight, float normalizedWeight, Resource confMinRes, Resource confMaxRes, Resource effMinRes, Resource effMaxRes) {
        this.partitionName = partitionName;
        this.capacity = capacity;
        this.usedCapacity = usedCapacity;
        this.maxCapacity = maxCapacity;
        this.absoluteCapacity = absCapacity;
        this.absoluteUsedCapacity = absUsedCapacity;
        this.absoluteMaxCapacity = absMaxCapacity;
        this.maxAMLimitPercentage = maxAMLimitPercentage;
        this.weight = weight;
        this.normalizedWeight = normalizedWeight;
        this.configuredMinResource = new ResourceInfo(confMinRes);
        this.configuredMaxResource = new ResourceInfo(confMaxRes);
        this.effectiveMinResource = new ResourceInfo(effMinRes);
        this.effectiveMaxResource = new ResourceInfo(effMaxRes);
    }

    public float getCapacity() {
        return this.capacity;
    }

    public void setCapacity(float capacity) {
        this.capacity = capacity;
    }

    public float getUsedCapacity() {
        return this.usedCapacity;
    }

    public void setUsedCapacity(float usedCapacity) {
        this.usedCapacity = usedCapacity;
    }

    public float getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(float maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    public float getAbsoluteCapacity() {
        return this.absoluteCapacity;
    }

    public void setAbsoluteCapacity(float absoluteCapacity) {
        this.absoluteCapacity = absoluteCapacity;
    }

    public float getAbsoluteUsedCapacity() {
        return this.absoluteUsedCapacity;
    }

    public void setAbsoluteUsedCapacity(float absoluteUsedCapacity) {
        this.absoluteUsedCapacity = absoluteUsedCapacity;
    }

    public float getAbsoluteMaxCapacity() {
        return this.absoluteMaxCapacity;
    }

    public void setAbsoluteMaxCapacity(float absoluteMaxCapacity) {
        this.absoluteMaxCapacity = absoluteMaxCapacity;
    }

    public float getMaxAMLimitPercentage() {
        return this.maxAMLimitPercentage;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public float getNormalizedWeight() {
        return this.normalizedWeight;
    }

    public void setNormalizedWeight(float normalizedWeight) {
        this.normalizedWeight = normalizedWeight;
    }

    public void setMaxAMLimitPercentage(float maxAMLimitPercentage) {
        this.maxAMLimitPercentage = maxAMLimitPercentage;
    }

    public ResourceInfo getConfiguredMinResource() {
        return this.configuredMinResource;
    }

    public ResourceInfo getConfiguredMaxResource() {
        if (this.configuredMaxResource == null || this.configuredMaxResource.getResource().equals((Object)Resources.none())) {
            return null;
        }
        return this.configuredMaxResource;
    }

    public ResourceInfo getEffectiveMinResource() {
        return this.effectiveMinResource;
    }

    public ResourceInfo getEffectiveMaxResource() {
        return this.effectiveMaxResource;
    }
}

