/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHTableDescriptor {
    private static final Log LOG = LogFactory.getLog(TestHTableDescriptor.class);
    String[] legalTableNames = new String[]{"foo", "with-dash_under.dot", "_under_start_ok", "with-dash.with_underscore", "02-01-2012.my_table_01-02", "xyz._mytable_", "9_9_0.table_02", "dot1.dot2.table", "new.-mytable", "with-dash.with.dot", "legal..t2", "legal..legal.t2", "trailingdots..", "trailing.dots...", "ns:mytable", "ns:_mytable_", "ns:my_table_01-02"};
    String[] illegalTableNames = new String[]{".dot_start_illegal", "-dash_start_illegal", "spaces not ok", "-dash-.start_illegal", "new.table with space", "01 .table", "ns:-illegaldash", "new:.illegaldot", "new:illegalcolon1:", "new:illegalcolon1:2"};

    @Test(expected=IOException.class)
    public void testAddCoprocessorTwice() throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.META_TABLE_NAME);
        String cpName = "a.b.c.d";
        htd.addCoprocessor(cpName);
        htd.addCoprocessor(cpName);
    }

    @Test
    public void testAddCoprocessorWithSpecStr() throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.META_TABLE_NAME);
        String cpName = "a.b.c.d";
        boolean expected = false;
        try {
            htd.addCoprocessorWithSpec(cpName);
        }
        catch (IllegalArgumentException iae) {
            expected = true;
        }
        if (!expected) {
            Assert.fail();
        }
        try {
            htd.addCoprocessorWithSpec("file:///some/path|" + cpName);
        }
        catch (IllegalArgumentException iae) {
            expected = false;
        }
        if (expected) {
            Assert.fail();
        }
        String spec = "hdfs:///foo.jar|com.foo.FooRegionObserver|1001|arg1=1,arg2=2";
        try {
            htd.addCoprocessorWithSpec(spec);
        }
        catch (IllegalArgumentException iae) {
            expected = false;
        }
        if (expected) {
            Assert.fail();
        }
        try {
            htd.addCoprocessorWithSpec(spec);
        }
        catch (IOException ioe) {
            expected = true;
        }
        if (!expected) {
            Assert.fail();
        }
    }

    @Test
    public void testPb() throws DeserializationException, IOException {
        HTableDescriptor htd = new HTableDescriptor(HTableDescriptor.META_TABLEDESC);
        int v = 123;
        htd.setMaxFileSize(123L);
        htd.setDurability(Durability.ASYNC_WAL);
        htd.setReadOnly(true);
        htd.setRegionReplication(2);
        byte[] bytes = htd.toByteArray();
        HTableDescriptor deserializedHtd = HTableDescriptor.parseFrom((byte[])bytes);
        Assert.assertEquals((Object)htd, (Object)deserializedHtd);
        Assert.assertEquals((long)123L, (long)deserializedHtd.getMaxFileSize());
        Assert.assertTrue((boolean)deserializedHtd.isReadOnly());
        Assert.assertEquals((Object)Durability.ASYNC_WAL, (Object)deserializedHtd.getDurability());
        Assert.assertEquals((long)deserializedHtd.getRegionReplication(), (long)2L);
    }

    @Test
    public void testGetSetRemoveCP() throws Exception {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)"table"));
        String className = "org.apache.hadoop.hbase.coprocessor.BaseRegionObserver";
        desc.addCoprocessor(className);
        Assert.assertTrue((boolean)desc.hasCoprocessor(className));
        desc.removeCoprocessor(className);
        Assert.assertFalse((boolean)desc.hasCoprocessor(className));
    }

    @Test
    public void testSetListRemoveCP() throws Exception {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)"testGetSetRemoveCP"));
        String className1 = "org.apache.hadoop.hbase.coprocessor.BaseRegionObserver";
        String className2 = "org.apache.hadoop.hbase.coprocessor.SampleRegionWALObserver";
        Assert.assertTrue((desc.getCoprocessors().size() == 0 ? 1 : 0) != 0);
        desc.addCoprocessor(className1);
        Assert.assertTrue((desc.getCoprocessors().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)desc.getCoprocessors().contains(className1));
        desc.addCoprocessor(className2);
        Assert.assertTrue((desc.getCoprocessors().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)desc.getCoprocessors().contains(className2));
        desc.removeCoprocessor(className1);
        Assert.assertTrue((desc.getCoprocessors().size() == 1 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)desc.getCoprocessors().contains(className1));
        Assert.assertTrue((boolean)desc.getCoprocessors().contains(className2));
        desc.removeCoprocessor(className2);
        Assert.assertTrue((desc.getCoprocessors().size() == 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)desc.getCoprocessors().contains(className1));
        Assert.assertFalse((boolean)desc.getCoprocessors().contains(className2));
    }

    @Test
    public void testRemoveString() throws Exception {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)"table"));
        String key = "Some";
        String value = "value";
        desc.setValue(key, value);
        Assert.assertEquals((Object)value, (Object)desc.getValue(key));
        desc.remove(key);
        Assert.assertEquals(null, (Object)desc.getValue(key));
    }

    @Test
    public void testLegalHTableNames() {
        for (String tn : this.legalTableNames) {
            TableName.isLegalFullyQualifiedTableName((byte[])Bytes.toBytes((String)tn));
        }
    }

    @Test
    public void testIllegalHTableNames() {
        for (String tn : this.illegalTableNames) {
            try {
                TableName.isLegalFullyQualifiedTableName((byte[])Bytes.toBytes((String)tn));
                Assert.fail((String)("invalid tablename " + tn + " should have failed"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Test
    public void testLegalHTableNamesRegex() {
        for (String tn : this.legalTableNames) {
            TableName tName = TableName.valueOf((String)tn);
            Assert.assertTrue((String)("Testing: '" + tn + "'"), (boolean)Pattern.matches("(?:(?:(?:(?:[a-zA-Z_0-9]+)\\:)?)(?:(?:[a-zA-Z_0-9][a-zA-Z_0-9-.]*)))", tName.getNameAsString()));
        }
    }

    @Test
    public void testIllegalHTableNamesRegex() {
        for (String tn : this.illegalTableNames) {
            LOG.info((Object)("Testing: '" + tn + "'"));
            Assert.assertFalse((boolean)Pattern.matches("(?:(?:(?:(?:[a-zA-Z_0-9]+)\\:)?)(?:(?:[a-zA-Z_0-9][a-zA-Z_0-9-.]*)))", tn));
        }
    }

    @Test
    public void testGetMaxFileSize() {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)"table"));
        Assert.assertEquals((long)-1L, (long)desc.getMaxFileSize());
        desc.setMaxFileSize(1111L);
        Assert.assertEquals((long)1111L, (long)desc.getMaxFileSize());
    }

    @Test
    public void testGetMemStoreFlushSize() {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)"table"));
        Assert.assertEquals((long)-1L, (long)desc.getMemStoreFlushSize());
        desc.setMemStoreFlushSize(1111L);
        Assert.assertEquals((long)1111L, (long)desc.getMemStoreFlushSize());
    }

    @Test
    public void testAddGetRemoveConfiguration() throws Exception {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)"table"));
        String key = "Some";
        String value = "value";
        desc.setConfiguration(key, value);
        Assert.assertEquals((Object)value, (Object)desc.getConfigurationValue(key));
        desc.removeConfiguration(key);
        Assert.assertEquals(null, (Object)desc.getConfigurationValue(key));
    }

    @Test
    public void testModifyFamily() {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"table"));
        byte[] familyName = Bytes.toBytes((String)"cf");
        HColumnDescriptor hcd = new HColumnDescriptor(familyName);
        hcd.setBlocksize(1000);
        hcd.setDFSReplication((short)3);
        htd.addFamily(hcd);
        Assert.assertEquals((long)1000L, (long)htd.getFamily(familyName).getBlocksize());
        Assert.assertEquals((long)3L, (long)htd.getFamily(familyName).getDFSReplication());
        hcd = new HColumnDescriptor(familyName);
        hcd.setBlocksize(2000);
        hcd.setDFSReplication((short)1);
        htd.modifyFamily(hcd);
        Assert.assertEquals((long)2000L, (long)htd.getFamily(familyName).getBlocksize());
        Assert.assertEquals((long)1L, (long)htd.getFamily(familyName).getDFSReplication());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testModifyInexistentFamily() {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"table"));
        byte[] familyName = Bytes.toBytes((String)"cf");
        HColumnDescriptor hcd = new HColumnDescriptor(familyName);
        htd.modifyFamily(hcd);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddDuplicateFamilies() {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"table"));
        byte[] familyName = Bytes.toBytes((String)"cf");
        HColumnDescriptor hcd = new HColumnDescriptor(familyName);
        hcd.setBlocksize(1000);
        htd.addFamily(hcd);
        Assert.assertEquals((long)1000L, (long)htd.getFamily(familyName).getBlocksize());
        hcd = new HColumnDescriptor(familyName);
        hcd.setBlocksize(2000);
        htd.addFamily(hcd);
    }
}

