/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HTableMultiplexer;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@Category(value={SmallTests.class})
public class TestHTableMultiplexerViaMocks {
    private static final int NUM_RETRIES = 31;
    private HTableMultiplexer mockMultiplexer;
    private ClusterConnection mockConnection;
    private HRegionLocation mockRegionLocation;
    private HRegionInfo mockRegionInfo;
    private TableName tableName;
    private Put put;

    @Before
    public void setupTest() {
        this.mockMultiplexer = (HTableMultiplexer)Mockito.mock(HTableMultiplexer.class);
        this.mockConnection = (ClusterConnection)Mockito.mock(ClusterConnection.class);
        this.mockRegionLocation = (HRegionLocation)Mockito.mock(HRegionLocation.class);
        this.mockRegionInfo = (HRegionInfo)Mockito.mock(HRegionInfo.class);
        this.tableName = TableName.valueOf((String)"my_table");
        this.put = new Put(TestHTableMultiplexerViaMocks.getBytes("row1"));
        this.put.addColumn(TestHTableMultiplexerViaMocks.getBytes("f1"), TestHTableMultiplexerViaMocks.getBytes("q1"), TestHTableMultiplexerViaMocks.getBytes("v11"));
        this.put.addColumn(TestHTableMultiplexerViaMocks.getBytes("f1"), TestHTableMultiplexerViaMocks.getBytes("q2"), TestHTableMultiplexerViaMocks.getBytes("v12"));
        this.put.addColumn(TestHTableMultiplexerViaMocks.getBytes("f2"), TestHTableMultiplexerViaMocks.getBytes("q1"), TestHTableMultiplexerViaMocks.getBytes("v21"));
        Mockito.when((Object)this.mockMultiplexer.put((TableName)Matchers.any(TableName.class), (Put)Matchers.any(Put.class), Matchers.anyInt())).thenCallRealMethod();
        Mockito.when((Object)this.mockMultiplexer.getConnection()).thenReturn((Object)this.mockConnection);
        Mockito.when((Object)this.mockRegionLocation.getRegionInfo()).thenReturn((Object)this.mockRegionInfo);
        Mockito.when((Object)this.mockRegionInfo.getTable()).thenReturn((Object)this.tableName);
    }

    @Test
    public void useCacheOnInitialPut() throws Exception {
        this.mockMultiplexer.put(this.tableName, this.put, 31);
        ((HTableMultiplexer)Mockito.verify((Object)this.mockMultiplexer))._put(this.tableName, this.put, 31, false);
    }

    @Test
    public void nonNullLocationQueuesPut() throws Exception {
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        Mockito.when((Object)this.mockMultiplexer._put((TableName)Matchers.any(TableName.class), (Put)Matchers.any(Put.class), Matchers.anyInt(), Matchers.anyBoolean())).thenCallRealMethod();
        Mockito.when((Object)this.mockConnection.getRegionLocation(this.tableName, this.put.getRow(), false)).thenReturn((Object)this.mockRegionLocation);
        Mockito.when((Object)this.mockMultiplexer.getQueue(this.mockRegionLocation)).thenReturn(queue);
        Assert.assertTrue((String)"Put should have been queued", (boolean)this.mockMultiplexer.put(this.tableName, this.put, 31));
        Assert.assertEquals((long)1L, (long)queue.size());
        HTableMultiplexer.PutStatus ps = (HTableMultiplexer.PutStatus)queue.take();
        Assert.assertEquals((Object)this.put, (Object)ps.put);
        Assert.assertEquals((Object)this.mockRegionInfo, (Object)ps.regionInfo);
    }

    @Test
    public void ignoreCacheOnRetriedPut() throws Exception {
        HTableMultiplexer.FlushWorker mockFlushWorker = (HTableMultiplexer.FlushWorker)Mockito.mock(HTableMultiplexer.FlushWorker.class);
        ScheduledExecutorService mockExecutor = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        final AtomicInteger retryInQueue = new AtomicInteger(0);
        AtomicLong totalFailedPuts = new AtomicLong(0L);
        int maxRetryInQueue = 20;
        long delay = 100L;
        HTableMultiplexer.PutStatus ps = new HTableMultiplexer.PutStatus(this.mockRegionInfo, this.put, 31);
        Mockito.when((Object)mockFlushWorker.resubmitFailedPut((HTableMultiplexer.PutStatus)Matchers.any(HTableMultiplexer.PutStatus.class), (HRegionLocation)Matchers.any(HRegionLocation.class))).thenCallRealMethod();
        Mockito.when((Object)this.mockMultiplexer._put(this.tableName, this.put, 30, true)).thenReturn((Object)true);
        Mockito.when((Object)mockFlushWorker.getExecutor()).thenReturn((Object)mockExecutor);
        Mockito.when((Object)mockFlushWorker.getNextDelay(Matchers.anyInt())).thenReturn((Object)100L);
        Mockito.when((Object)mockFlushWorker.getMultiplexer()).thenReturn((Object)this.mockMultiplexer);
        Mockito.when((Object)mockFlushWorker.getRetryInQueue()).thenReturn((Object)retryInQueue);
        Mockito.when((Object)mockFlushWorker.getMaxRetryInQueue()).thenReturn((Object)20);
        Mockito.when((Object)mockFlushWorker.getTotalFailedPutCount()).thenReturn((Object)totalFailedPuts);
        Mockito.when(mockExecutor.schedule((Runnable)Matchers.any(Runnable.class), Mockito.eq((long)100L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))))).thenAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Assert.assertEquals((long)1L, (long)retryInQueue.get());
                Object[] args = invocation.getArguments();
                Assert.assertEquals((long)3L, (long)args.length);
                Assert.assertTrue((String)"Argument should be an instance of Runnable", (boolean)(args[0] instanceof Runnable));
                Runnable runnable = (Runnable)args[0];
                runnable.run();
                return null;
            }
        });
        Assert.assertTrue((String)"Put should have been rescheduled", (boolean)mockFlushWorker.resubmitFailedPut(ps, this.mockRegionLocation));
        ((HTableMultiplexer)Mockito.verify((Object)this.mockMultiplexer))._put(this.tableName, this.put, 30, true);
        Assert.assertEquals((long)0L, (long)totalFailedPuts.get());
        Assert.assertEquals((long)0L, (long)retryInQueue.get());
    }

    @Test
    public void testConnectionClosing() throws IOException {
        ((HTableMultiplexer)Mockito.doCallRealMethod().when((Object)this.mockMultiplexer)).close();
        Mockito.when((Object)this.mockConnection.isClosed()).thenReturn((Object)false);
        this.mockMultiplexer.close();
        ((ClusterConnection)Mockito.verify((Object)this.mockConnection)).close();
    }

    @Test
    public void testClosingAlreadyClosedConnection() throws IOException {
        ((HTableMultiplexer)Mockito.doCallRealMethod().when((Object)this.mockMultiplexer)).close();
        Mockito.when((Object)this.mockConnection.isClosed()).thenReturn((Object)true);
        this.mockMultiplexer.close();
        ((ClusterConnection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.times((int)0))).close();
    }

    private static byte[] getBytes(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }
}

