/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.util.Map;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={SecurityTests.class, SmallTests.class})
public class TestSaslUtil {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testInitSaslProperties() {
        Map props = SaslUtil.initSaslProperties((String)"integrity");
        Assert.assertEquals(props.get("javax.security.sasl.qop"), (Object)"auth-int");
        props = SaslUtil.initSaslProperties((String)"privacy,authentication");
        Assert.assertEquals(props.get("javax.security.sasl.qop"), (Object)"auth-conf,auth");
        props = SaslUtil.initSaslProperties((String)"integrity,authentication,privacy");
        Assert.assertEquals(props.get("javax.security.sasl.qop"), (Object)"auth-int,auth,auth-conf");
        this.exception.expect(IllegalArgumentException.class);
        props = SaslUtil.initSaslProperties((String)"xyz");
        Assert.assertEquals(props.get("javax.security.sasl.qop"), (Object)"auth");
        this.exception.expect(IllegalArgumentException.class);
        props = SaslUtil.initSaslProperties((String)"");
        Assert.assertEquals(props.get("javax.security.sasl.qop"), (Object)"auth");
    }
}

