/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.exceptions.X509Exception;
import org.apache.hadoop.hbase.io.crypto.tls.X509Util;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.ConnectionId;
import org.apache.hadoop.hbase.ipc.NettyRpcClientConfigHelper;
import org.apache.hadoop.hbase.ipc.NettyRpcConnection;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.SslContext;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class NettyRpcClient
extends AbstractRpcClient<NettyRpcConnection> {
    final EventLoopGroup group;
    final Class<? extends Channel> channelClass;
    private final boolean shutdownGroupWhenClose;
    private final AtomicReference<SslContext> sslContextForClient = new AtomicReference();

    public NettyRpcClient(Configuration configuration, String clusterId, SocketAddress localAddress, MetricsConnection metrics) {
        super(configuration, clusterId, localAddress, metrics);
        Pair<EventLoopGroup, Class<? extends Channel>> groupAndChannelClass = NettyRpcClientConfigHelper.getEventLoopConfig(this.conf);
        if (groupAndChannelClass == null) {
            int threadCount = this.conf.getInt("hbase.netty.eventloop.rpcclient.thread.count", 0);
            this.group = new NioEventLoopGroup(threadCount, (ThreadFactory)new DefaultThreadFactory("RPCClient(own)-NioEventLoopGroup", true, 5));
            this.channelClass = NioSocketChannel.class;
            this.shutdownGroupWhenClose = true;
        } else {
            this.group = (EventLoopGroup)groupAndChannelClass.getFirst();
            this.channelClass = (Class)groupAndChannelClass.getSecond();
            this.shutdownGroupWhenClose = false;
        }
    }

    public NettyRpcClient(Configuration configuration) {
        this(configuration, "default-cluster", null, null);
    }

    @Override
    protected NettyRpcConnection createConnection(ConnectionId remoteId) throws IOException {
        return new NettyRpcConnection(this, remoteId);
    }

    @Override
    protected void closeInternal() {
        if (this.shutdownGroupWhenClose) {
            this.group.shutdownGracefully();
        }
    }

    SslContext getSslContext() throws X509Exception, IOException {
        SslContext result = this.sslContextForClient.get();
        if (result == null && !this.sslContextForClient.compareAndSet(null, result = X509Util.createSslContextForClient((Configuration)this.conf))) {
            result = this.sslContextForClient.get();
        }
        return result;
    }
}

