/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStoreTracker;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class BitSetNode {
    private static final long WORD_MASK = -1L;
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int MAX_NODE_SIZE = 64;
    private boolean partial;
    private long[] modified;
    private long[] deleted;
    private long start;

    public void dump() {
        int j;
        int i;
        System.out.printf("%06d:%06d min=%d max=%d%n", this.getStart(), this.getEnd(), this.getActiveMinProcId(), this.getActiveMaxProcId());
        System.out.println("Modified:");
        for (i = 0; i < this.modified.length; ++i) {
            for (j = 0; j < 64; ++j) {
                System.out.print((this.modified[i] & 1L << j) != 0L ? "1" : "0");
            }
            System.out.println(" " + i);
        }
        System.out.println();
        System.out.println("Delete:");
        for (i = 0; i < this.deleted.length; ++i) {
            for (j = 0; j < 64; ++j) {
                System.out.print((this.deleted[i] & 1L << j) != 0L ? "1" : "0");
            }
            System.out.println(" " + i);
        }
        System.out.println();
    }

    public BitSetNode(long procId, boolean partial) {
        this.start = BitSetNode.alignDown(procId);
        int count = 1;
        this.modified = new long[count];
        this.deleted = new long[count];
        if (!partial) {
            Arrays.fill(this.deleted, -1L);
        }
        this.partial = partial;
        this.updateState(procId, false);
    }

    public BitSetNode(ProcedureProtos.ProcedureStoreTracker.TrackerNode data) {
        this.start = data.getStartId();
        int size = data.getUpdatedCount();
        assert (size == data.getDeletedCount());
        this.modified = new long[size];
        this.deleted = new long[size];
        for (int i = 0; i < size; ++i) {
            this.modified[i] = data.getUpdated(i);
            this.deleted[i] = data.getDeleted(i);
        }
        this.partial = false;
    }

    public BitSetNode(BitSetNode other, boolean resetDelete) {
        this.start = other.start;
        this.partial = resetDelete ? false : other.partial;
        this.modified = (long[])other.modified.clone();
        if (resetDelete) {
            this.deleted = new long[other.deleted.length];
            for (int i = 0; i < this.deleted.length; ++i) {
                int n = i;
                this.deleted[n] = this.deleted[n] | other.modified[i] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        } else {
            this.deleted = (long[])other.deleted.clone();
        }
    }

    public void insertOrUpdate(long procId) {
        this.updateState(procId, false);
    }

    public void delete(long procId) {
        this.updateState(procId, true);
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.start + (long)(this.modified.length << 6) - 1L;
    }

    public boolean contains(long procId) {
        return this.start <= procId && procId <= this.getEnd();
    }

    public ProcedureStoreTracker.DeleteState isDeleted(long procId) {
        int bitmapIndex = this.getBitmapIndex(procId);
        int wordIndex = bitmapIndex >> 6;
        if (wordIndex >= this.deleted.length) {
            return ProcedureStoreTracker.DeleteState.MAYBE;
        }
        return (this.deleted[wordIndex] & 1L << bitmapIndex) != 0L ? ProcedureStoreTracker.DeleteState.YES : ProcedureStoreTracker.DeleteState.NO;
    }

    public boolean isModified(long procId) {
        int bitmapIndex = this.getBitmapIndex(procId);
        int wordIndex = bitmapIndex >> 6;
        if (wordIndex >= this.modified.length) {
            return false;
        }
        return (this.modified[wordIndex] & 1L << bitmapIndex) != 0L;
    }

    public boolean isAllModified() {
        for (int i = 0; i < this.modified.length; ++i) {
            if ((this.modified[i] | this.deleted[i]) == -1L) continue;
            return false;
        }
        return true;
    }

    public long[] getActiveProcIds() {
        ArrayList<Long> procIds = new ArrayList<Long>();
        for (int wordIndex = 0; wordIndex < this.modified.length; ++wordIndex) {
            if (this.deleted[wordIndex] == -1L || this.modified[wordIndex] == 0L) continue;
            long baseProcId = this.getStart() + (long)(wordIndex << 6);
            for (int i = 0; i < 64; ++i) {
                long mask = 1L << i;
                if ((this.deleted[wordIndex] & mask) != 0L || (this.modified[wordIndex] & mask) == 0L) continue;
                procIds.add(baseProcId + (long)i);
            }
        }
        return procIds.stream().mapToLong(Long::longValue).toArray();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.deleted.length; ++i) {
            if (this.deleted[i] == -1L) continue;
            return false;
        }
        return true;
    }

    public void resetModified() {
        Arrays.fill(this.modified, 0L);
    }

    public void unsetPartialFlag() {
        this.partial = false;
        for (int i = 0; i < this.modified.length; ++i) {
            for (int j = 0; j < 64; ++j) {
                if ((this.modified[i] & 1L << j) != 0L) continue;
                int n = i;
                this.deleted[n] = this.deleted[n] | 1L << j;
            }
        }
    }

    public ProcedureProtos.ProcedureStoreTracker.TrackerNode convert() {
        ProcedureProtos.ProcedureStoreTracker.TrackerNode.Builder builder = ProcedureProtos.ProcedureStoreTracker.TrackerNode.newBuilder();
        builder.setStartId(this.start);
        for (int i = 0; i < this.modified.length; ++i) {
            builder.addUpdated(this.modified[i]);
            builder.addDeleted(this.deleted[i]);
        }
        return builder.build();
    }

    public boolean canGrow(long procId) {
        return Math.abs(procId - this.start) < 64L;
    }

    public boolean canMerge(BitSetNode rightNode) {
        assert (this.start < rightNode.start);
        return rightNode.getEnd() - this.start < 64L;
    }

    public void grow(long procId) {
        int i;
        int offset;
        int delta;
        if (procId < this.start) {
            long newStart = BitSetNode.alignDown(procId);
            offset = delta = (int)(this.start - newStart) >> 6;
            this.start = newStart;
        } else {
            long newEnd = BitSetNode.alignUp(procId + 1L);
            delta = (int)(newEnd - this.getEnd()) >> 6;
            offset = 0;
        }
        int oldSize = this.modified.length;
        long[] newBitmap = new long[oldSize + delta];
        for (i = 0; i < newBitmap.length; ++i) {
            newBitmap[i] = 0L;
        }
        System.arraycopy(this.modified, 0, newBitmap, offset, oldSize);
        this.modified = newBitmap;
        newBitmap = new long[this.deleted.length + delta];
        for (i = 0; i < newBitmap.length; ++i) {
            newBitmap[i] = this.partial ? 0L : -1L;
        }
        System.arraycopy(this.deleted, 0, newBitmap, offset, oldSize);
        this.deleted = newBitmap;
    }

    public void merge(BitSetNode rightNode) {
        int delta = (int)(rightNode.getEnd() - this.getEnd()) >> 6;
        int oldSize = this.modified.length;
        int newSize = delta - rightNode.modified.length;
        int offset = oldSize + newSize;
        long[] newBitmap = new long[oldSize + delta];
        System.arraycopy(this.modified, 0, newBitmap, 0, oldSize);
        System.arraycopy(rightNode.modified, 0, newBitmap, offset, rightNode.modified.length);
        this.modified = newBitmap;
        newBitmap = new long[oldSize + delta];
        System.arraycopy(this.deleted, 0, newBitmap, 0, oldSize);
        System.arraycopy(rightNode.deleted, 0, newBitmap, offset, rightNode.deleted.length);
        this.deleted = newBitmap;
        for (int i = 0; i < newSize; ++i) {
            this.modified[offset + i] = 0L;
            this.deleted[offset + i] = this.partial ? 0L : -1L;
        }
    }

    public String toString() {
        return "BitSetNode(" + this.getStart() + "-" + this.getEnd() + ")";
    }

    public long getActiveMinProcId() {
        long minProcId = this.start;
        for (int i = 0; i < this.deleted.length; ++i) {
            if (this.deleted[i] == 0L) {
                return minProcId;
            }
            if (this.deleted[i] != -1L) {
                for (int j = 0; j < 64; ++j) {
                    if ((this.deleted[i] & 1L << j) != 0L) continue;
                    return minProcId + (long)j;
                }
            }
            minProcId += 64L;
        }
        return -1L;
    }

    public long getActiveMaxProcId() {
        long maxProcId = this.getEnd();
        for (int i = this.deleted.length - 1; i >= 0; --i) {
            if (this.deleted[i] == 0L) {
                return maxProcId;
            }
            if (this.deleted[i] != -1L) {
                for (int j = 63; j >= 0; --j) {
                    if ((this.deleted[i] & 1L << j) != 0L) continue;
                    return maxProcId - (long)(63 - j);
                }
            }
            maxProcId -= 64L;
        }
        return -1L;
    }

    private int getBitmapIndex(long procId) {
        return (int)(procId - this.start);
    }

    void updateState(long procId, boolean isDeleted) {
        int bitmapIndex = this.getBitmapIndex(procId);
        int wordIndex = bitmapIndex >> 6;
        long value = 1L << bitmapIndex;
        int n = wordIndex;
        this.modified[n] = this.modified[n] | value;
        if (isDeleted) {
            int n2 = wordIndex;
            this.deleted[n2] = this.deleted[n2] | value;
        } else {
            int n3 = wordIndex;
            this.deleted[n3] = this.deleted[n3] & (value ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    private static long alignUp(long x) {
        return x + 63L & 0xFFFFFFFFFFFFFFC0L;
    }

    private static long alignDown(long x) {
        return x & 0xFFFFFFFFFFFFFFC0L;
    }
}

