/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HealthReport;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;

class HealthChecker {
    private static Log LOG = LogFactory.getLog(HealthChecker.class);
    private Shell.ShellCommandExecutor shexec = null;
    private String exceptionStackTrace;
    private static final String ERROR_PATTERN = "ERROR";
    private String healthCheckScript;
    private long scriptTimeout;

    HealthChecker() {
    }

    public void init(String location, long timeout) {
        this.healthCheckScript = location;
        this.scriptTimeout = timeout;
        ArrayList<String> execScript = new ArrayList<String>();
        execScript.add(this.healthCheckScript);
        this.shexec = new Shell.ShellCommandExecutor(execScript.toArray(new String[execScript.size()]), null, null, this.scriptTimeout);
        LOG.info((Object)("HealthChecker initialized with script at " + this.healthCheckScript + ", timeout=" + timeout));
    }

    public HealthReport checkHealth() {
        HealthCheckerExitStatus status = HealthCheckerExitStatus.SUCCESS;
        try {
            this.shexec.execute();
        }
        catch (Shell.ExitCodeException e) {
            LOG.warn((Object)("Caught exception : " + (Object)((Object)e) + ",exit code:" + e.getExitCode()));
            status = HealthCheckerExitStatus.FAILED_WITH_EXIT_CODE;
        }
        catch (IOException e) {
            LOG.warn((Object)("Caught exception : " + e));
            status = HealthCheckerExitStatus.FAILED_WITH_EXCEPTION;
            this.exceptionStackTrace = StringUtils.stringifyException((Throwable)e);
        }
        finally {
            if (this.shexec.isTimedOut()) {
                status = HealthCheckerExitStatus.TIMED_OUT;
            }
            if (status == HealthCheckerExitStatus.SUCCESS && this.hasErrors(this.shexec.getOutput())) {
                status = HealthCheckerExitStatus.FAILED;
            }
        }
        return new HealthReport(status, this.getHealthReport(status));
    }

    private boolean hasErrors(String output) {
        String[] splits;
        for (String split : splits = output.split("\n")) {
            if (!split.startsWith(ERROR_PATTERN)) continue;
            return true;
        }
        return false;
    }

    private String getHealthReport(HealthCheckerExitStatus status) {
        String healthReport = null;
        switch (status) {
            case SUCCESS: {
                healthReport = "Server is healthy.";
                break;
            }
            case TIMED_OUT: {
                healthReport = "Health script timed out";
                break;
            }
            case FAILED_WITH_EXCEPTION: {
                healthReport = this.exceptionStackTrace;
                break;
            }
            case FAILED_WITH_EXIT_CODE: {
                healthReport = "Health script failed with exit code.";
                break;
            }
            case FAILED: {
                healthReport = this.shexec.getOutput();
            }
        }
        return healthReport;
    }

    static enum HealthCheckerExitStatus {
        SUCCESS,
        TIMED_OUT,
        FAILED_WITH_EXIT_CODE,
        FAILED_WITH_EXCEPTION,
        FAILED;

    }
}

