/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.mapreduce;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupCopyService;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.impl.BackupManager;
import org.apache.hadoop.hbase.backup.util.BackupServerUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.snapshot.ExportSnapshot;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.DistCpOptions;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MapReduceBackupCopyService
implements BackupCopyService {
    private static final Log LOG = LogFactory.getLog(MapReduceBackupCopyService.class);
    private Configuration conf;
    private float progressDone = 0.1f;
    private long bytesCopied = 0L;
    private static float INIT_PROGRESS = 0.1f;
    private float subTaskPercntgInWholeTask = 1.0f;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public float getSubTaskPercntgInWholeTask() {
        return this.subTaskPercntgInWholeTask;
    }

    public void setSubTaskPercntgInWholeTask(float subTaskPercntgInWholeTask) {
        this.subTaskPercntgInWholeTask = subTaskPercntgInWholeTask;
    }

    static void updateProgress(BackupInfo backupContext, BackupManager backupManager, int newProgress, long bytesCopied) throws IOException {
        String backupProgressData = newProgress + "%";
        backupContext.setProgress(newProgress);
        backupManager.updateBackupInfo(backupContext);
        LOG.debug((Object)("Backup progress data \"" + backupProgressData + "\" has been updated to hbase:backup for " + backupContext.getBackupId()));
    }

    @Override
    public int copy(BackupInfo context, BackupManager backupManager, Configuration conf, BackupCopyService.Type copyType, String[] options) throws IOException {
        int res = 0;
        try {
            if (copyType == BackupCopyService.Type.FULL) {
                SnapshotCopy snapshotCp = new SnapshotCopy(context, context.getTableBySnapshot(options[1]));
                LOG.debug((Object)"Doing SNAPSHOT_COPY");
                snapshotCp.setConf(new Configuration(conf));
                res = snapshotCp.run(options);
            } else if (copyType == BackupCopyService.Type.INCREMENTAL) {
                Path dest;
                FileSystem destfs;
                LOG.debug((Object)"Doing COPY_TYPE_DISTCP");
                this.setSubTaskPercntgInWholeTask(1.0f);
                BackupDistCp distcp = new BackupDistCp(new Configuration(conf), null, context, backupManager);
                LOG.debug((Object)("DistCp options: " + Arrays.toString(options)));
                if (options.length == 2 && !(destfs = (dest = new Path(options[1])).getFileSystem(conf)).exists(dest)) {
                    destfs.mkdirs(dest);
                }
                res = distcp.run(options);
            }
            return res;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void cancelCopyJob(String jobId) throws IOException {
        JobID id = JobID.forName((String)jobId);
        Cluster cluster = new Cluster(this.getConf());
        try {
            Job job = cluster.getJob(id);
            if (job == null) {
                LOG.error((Object)("No job found for " + id));
            }
            if (job.isComplete() || job.isRetired()) {
                return;
            }
            job.killJob();
            LOG.debug((Object)("Killed job " + id));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    class BackupDistCp
    extends DistCp {
        private BackupInfo backupContext;
        private BackupManager backupManager;

        public BackupDistCp(Configuration conf, DistCpOptions options, BackupInfo backupContext, BackupManager backupManager) throws Exception {
            super(conf, options);
            this.backupContext = backupContext;
            this.backupManager = backupManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Job execute() throws Exception {
            Class<DistCp> classDistCp = DistCp.class;
            Method methodCreateMetaFolderPath = classDistCp.getDeclaredMethod("createMetaFolderPath", new Class[0]);
            Method methodCreateJob = classDistCp.getDeclaredMethod("createJob", new Class[0]);
            Method methodCreateInputFileListing = classDistCp.getDeclaredMethod("createInputFileListing", Job.class);
            Method methodCleanup = classDistCp.getDeclaredMethod("cleanup", new Class[0]);
            Field fieldInputOptions = classDistCp.getDeclaredField("inputOptions");
            Field fieldMetaFolder = classDistCp.getDeclaredField("metaFolder");
            Field fieldJobFS = classDistCp.getDeclaredField("jobFS");
            Field fieldSubmitted = classDistCp.getDeclaredField("submitted");
            methodCreateMetaFolderPath.setAccessible(true);
            methodCreateJob.setAccessible(true);
            methodCreateInputFileListing.setAccessible(true);
            methodCleanup.setAccessible(true);
            fieldInputOptions.setAccessible(true);
            fieldMetaFolder.setAccessible(true);
            fieldJobFS.setAccessible(true);
            fieldSubmitted.setAccessible(true);
            assert (fieldInputOptions.get((Object)this) != null);
            assert (this.getConf() != null);
            Job job = null;
            try {
                String newProgressStr;
                BigDecimal progressData;
                float newProgress;
                BackupDistCp backupDistCp = this;
                synchronized (backupDistCp) {
                    fieldMetaFolder.set((Object)this, methodCreateMetaFolderPath.invoke((Object)this, new Object[0]));
                    fieldJobFS.set((Object)this, ((Path)fieldMetaFolder.get((Object)this)).getFileSystem(this.getConf()));
                    job = (Job)methodCreateJob.invoke((Object)this, new Object[0]);
                }
                methodCreateInputFileListing.invoke((Object)this, job);
                List srcs = ((DistCpOptions)fieldInputOptions.get((Object)this)).getSourcePaths();
                long totalSrcLgth = 0L;
                for (Path aSrc : srcs) {
                    totalSrcLgth += BackupServerUtil.getFilesLength(aSrc.getFileSystem(this.getConf()), aSrc);
                }
                job.submit();
                fieldSubmitted.set((Object)this, true);
                int progressReportFreq = this.getConf().getInt("hbase.backup.progressreport.frequency", 500);
                float lastProgress = MapReduceBackupCopyService.this.progressDone;
                while (!job.isComplete()) {
                    newProgress = MapReduceBackupCopyService.this.progressDone + job.mapProgress() * MapReduceBackupCopyService.this.subTaskPercntgInWholeTask * (1.0f - INIT_PROGRESS);
                    if (newProgress > lastProgress) {
                        progressData = new BigDecimal(newProgress * 100.0f).setScale(1, 4);
                        newProgressStr = progressData + "%";
                        LOG.info((Object)("Progress: " + newProgressStr));
                        MapReduceBackupCopyService.updateProgress(this.backupContext, this.backupManager, progressData.intValue(), MapReduceBackupCopyService.this.bytesCopied);
                        LOG.debug((Object)("Backup progress data updated to hbase:backup: \"Progress: " + newProgressStr + ".\""));
                        lastProgress = newProgress;
                    }
                    Thread.sleep(progressReportFreq);
                }
                newProgress = MapReduceBackupCopyService.this.progressDone + job.mapProgress() * MapReduceBackupCopyService.this.subTaskPercntgInWholeTask * (1.0f - INIT_PROGRESS);
                progressData = new BigDecimal(newProgress * 100.0f).setScale(1, 4);
                newProgressStr = progressData + "%";
                LOG.info((Object)("Progress: " + newProgressStr));
                MapReduceBackupCopyService.this.progressDone = newProgress;
                MapReduceBackupCopyService.this.bytesCopied = MapReduceBackupCopyService.this.bytesCopied + totalSrcLgth;
                MapReduceBackupCopyService.updateProgress(this.backupContext, this.backupManager, progressData.intValue(), MapReduceBackupCopyService.this.bytesCopied);
                LOG.debug((Object)("Backup progress data updated to hbase:backup: \"Progress: " + newProgressStr + " - " + MapReduceBackupCopyService.this.bytesCopied + " bytes copied.\""));
            }
            finally {
                if (!fieldSubmitted.getBoolean((Object)this)) {
                    methodCleanup.invoke((Object)this, new Object[0]);
                }
            }
            String jobID = job.getJobID().toString();
            job.getConfiguration().set("distcp.job.id", jobID);
            LOG.debug((Object)("DistCp job-id: " + jobID));
            return job;
        }
    }

    class SnapshotCopy
    extends ExportSnapshot {
        private BackupInfo backupContext;
        private TableName table;

        public SnapshotCopy(BackupInfo backupContext, TableName table) {
            this.backupContext = backupContext;
            this.table = table;
        }

        public TableName getTable() {
            return this.table;
        }
    }
}

