/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoordinatedStateManagerFactory;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.coordination.BaseCoordinatedStateManager;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetricsMaster;
import org.apache.hadoop.hbase.procedure.MasterProcedureManager;
import org.apache.hadoop.hbase.procedure.Procedure;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinator;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinatorRpcs;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.zookeeper.KeeperException;

public class LogRollMasterProcedureManager
extends MasterProcedureManager {
    public static final String ROLLLOG_PROCEDURE_SIGNATURE = "rolllog-proc";
    public static final String ROLLLOG_PROCEDURE_NAME = "rolllog";
    public static final String BACKUP_WAKE_MILLIS_KEY = "hbase.backup.master.wake.millis";
    public static final String BACKUP_TIMEOUT_MILLIS_KEY = "hbase.backup.master.timeout.millis";
    public static final String BACKUP_POOL_THREAD_NUMBER_KEY = "hbase.backup.master.pool.thread.number";
    public static final int BACKUP_WAKE_MILLIS_DEFAULT = 500;
    public static final int BACKUP_TIMEOUT_MILLIS_DEFAULT = 60000;
    public static final int BACKUP_POOL_THREAD_NUMBER_DEFAULT = 8;
    private static final Log LOG = LogFactory.getLog(LogRollMasterProcedureManager.class);
    private MasterServices master;
    private ProcedureCoordinator coordinator;
    private boolean done;

    public void stop(String why) {
        LOG.info((Object)("stop: " + why));
    }

    public boolean isStopped() {
        return false;
    }

    @Override
    public void initialize(MasterServices master, MetricsMaster metricsMaster) throws KeeperException, IOException, UnsupportedOperationException {
        this.master = master;
        this.done = false;
        String name = master.getServerName().toString();
        Configuration conf = master.getConfiguration();
        long wakeFrequency = conf.getInt(BACKUP_WAKE_MILLIS_KEY, 500);
        long timeoutMillis = conf.getLong(BACKUP_TIMEOUT_MILLIS_KEY, 60000L);
        int opThreads = conf.getInt(BACKUP_POOL_THREAD_NUMBER_KEY, 8);
        ThreadPoolExecutor tpool = ProcedureCoordinator.defaultPool(name, opThreads);
        BaseCoordinatedStateManager coordManager = (BaseCoordinatedStateManager)CoordinatedStateManagerFactory.getCoordinatedStateManager(master.getConfiguration());
        coordManager.initialize(master);
        ProcedureCoordinatorRpcs comms = coordManager.getProcedureCoordinatorRpcs(this.getProcedureSignature(), name);
        this.coordinator = new ProcedureCoordinator(comms, tpool, timeoutMillis, wakeFrequency);
    }

    @Override
    public String getProcedureSignature() {
        return ROLLLOG_PROCEDURE_SIGNATURE;
    }

    @Override
    public void execProcedure(HBaseProtos.ProcedureDescription desc) throws IOException {
        Procedure proc;
        this.done = false;
        ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher(desc.getInstance());
        List<ServerName> serverNames = this.master.getServerManager().getOnlineServersList();
        ArrayList<String> servers = new ArrayList<String>();
        for (ServerName sn : serverNames) {
            servers.add(sn.toString());
        }
        List conf = desc.getConfigurationList();
        byte[] data = new byte[]{};
        if (conf.size() > 0) {
            data = ((HBaseProtos.NameStringPair)conf.get(0)).getValue().getBytes();
        }
        if ((proc = this.coordinator.startProcedure(monitor, desc.getInstance(), data, servers)) == null) {
            String msg = "Failed to submit distributed procedure for '" + desc.getInstance() + "'";
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
        try {
            proc.waitForCompleted();
            LOG.info((Object)("Done waiting - exec procedure for " + desc.getInstance()));
            LOG.info((Object)"Distributed roll log procedure is successful!");
            this.done = true;
        }
        catch (InterruptedException e) {
            ForeignException ee = new ForeignException("Interrupted while waiting for roll log procdure to finish", e);
            monitor.receive(ee);
            Thread.currentThread().interrupt();
        }
        catch (ForeignException e) {
            ForeignException ee = new ForeignException("Exception while waiting for roll log procdure to finish", e);
            monitor.receive(ee);
        }
        monitor.rethrowException();
    }

    @Override
    public boolean isProcedureDone(HBaseProtos.ProcedureDescription desc) throws IOException {
        return this.done;
    }
}

