/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.regionserver;

import java.util.HashMap;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.backup.impl.BackupSystemTable;
import org.apache.hadoop.hbase.backup.regionserver.LogRollBackupSubprocedurePool;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.procedure.ProcedureMember;
import org.apache.hadoop.hbase.procedure.Subprocedure;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;

public class LogRollBackupSubprocedure
extends Subprocedure {
    private static final Log LOG = LogFactory.getLog(LogRollBackupSubprocedure.class);
    private final RegionServerServices rss;
    private final LogRollBackupSubprocedurePool taskManager;
    private FSHLog hlog;
    private String backupRoot;

    public LogRollBackupSubprocedure(RegionServerServices rss, ProcedureMember member, ForeignExceptionDispatcher errorListener, long wakeFrequency, long timeout, LogRollBackupSubprocedurePool taskManager, byte[] data) {
        super(member, "rolllog", errorListener, wakeFrequency, timeout);
        LOG.info((Object)"Constructing a LogRollBackupSubprocedure.");
        this.rss = rss;
        this.taskManager = taskManager;
        if (data != null) {
            this.backupRoot = new String(data);
        }
    }

    private void rolllog() throws ForeignException {
        this.monitor.rethrowException();
        this.taskManager.submitTask(new RSRollLogTask());
        this.monitor.rethrowException();
        this.taskManager.waitForOutstandingTasks();
        this.monitor.rethrowException();
    }

    @Override
    public void acquireBarrier() throws ForeignException {
    }

    @Override
    public byte[] insideBarrier() throws ForeignException {
        this.rolllog();
        return null;
    }

    @Override
    public void cleanup(Exception e) {
        this.taskManager.abort("Aborting log roll subprocedure tasks for backup due to error", e);
    }

    public void releaseBarrier() {
    }

    class RSRollLogTask
    implements Callable<Void> {
        RSRollLogTask() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Void call() throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("++ DRPC started: " + LogRollBackupSubprocedure.this.rss.getServerName()));
            }
            LogRollBackupSubprocedure.this.hlog = (FSHLog)LogRollBackupSubprocedure.this.rss.getWAL(null);
            long filenum = LogRollBackupSubprocedure.this.hlog.getFilenum();
            LOG.info((Object)("Trying to roll log in backup subprocedure, current log number: " + filenum));
            LogRollBackupSubprocedure.this.hlog.rollWriter(true);
            LOG.info((Object)("After roll log in backup subprocedure, current log number: " + LogRollBackupSubprocedure.this.hlog.getFilenum()));
            ClusterConnection connection = LogRollBackupSubprocedure.this.rss.getConnection();
            try (BackupSystemTable table = new BackupSystemTable((Connection)connection);){
                HashMap serverTimestampMap = table.readRegionServerLastLogRollResult(LogRollBackupSubprocedure.this.backupRoot);
                String host = LogRollBackupSubprocedure.this.rss.getServerName().getHostname();
                int port = LogRollBackupSubprocedure.this.rss.getServerName().getPort();
                String server = host + ":" + port;
                Long sts = (Long)serverTimestampMap.get(host);
                if (sts != null && sts > filenum) {
                    LOG.warn((Object)("Won't update server's last roll log result: current=" + sts + " new=" + filenum));
                    Void void_ = null;
                    return void_;
                }
                table.writeRegionServerLastLogRollResult(server, Long.valueOf(filenum), LogRollBackupSubprocedure.this.backupRoot);
                Void void_ = null;
                return void_;
            }
            catch (Exception e) {
                LOG.error((Object)e);
                throw e;
            }
        }
    }
}

