/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;

@InterfaceAudience.Private
@SuppressWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public abstract class AbstractHFileReader
implements HFile.Reader,
Configurable {
    protected FSDataInputStream istream;
    protected FSDataInputStream istreamNoFsChecksum;
    protected HFileBlockIndex.BlockIndexReader dataBlockIndexReader;
    protected HFileBlockIndex.BlockIndexReader metaBlockIndexReader;
    protected final FixedFileTrailer trailer;
    protected final Compression.Algorithm compressAlgo;
    private boolean isPrimaryReplicaReader;
    protected HFileDataBlockEncoder dataBlockEncoder = NoOpDataBlockEncoder.INSTANCE;
    protected byte[] lastKey = null;
    protected int avgKeyLen = -1;
    protected int avgValueLen = -1;
    protected KeyValue.KVComparator comparator = new KeyValue.KVComparator();
    protected final long fileSize;
    protected final CacheConfig cacheConf;
    protected final Path path;
    protected final String name;
    protected HFile.FileInfo fileInfo;
    protected HFileSystem hfs;
    protected Configuration conf;

    @SuppressWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    protected AbstractHFileReader(Path path, FixedFileTrailer trailer, long fileSize, CacheConfig cacheConf, HFileSystem hfs, Configuration conf) {
        this.trailer = trailer;
        this.compressAlgo = trailer.getCompressionCodec();
        this.cacheConf = cacheConf;
        this.fileSize = fileSize;
        this.path = path;
        this.name = path.getName();
        this.hfs = hfs;
        this.conf = conf;
    }

    protected String toStringFirstKey() {
        return KeyValue.keyToString((byte[])this.getFirstKey());
    }

    protected String toStringLastKey() {
        return KeyValue.keyToString((byte[])this.getLastKey());
    }

    public abstract boolean isFileInfoLoaded();

    public String toString() {
        return "reader=" + this.path.toString() + (!this.isFileInfoLoaded() ? "" : ", compression=" + this.compressAlgo.getName() + ", cacheConf=" + this.cacheConf + ", firstKey=" + this.toStringFirstKey() + ", lastKey=" + this.toStringLastKey()) + ", avgKeyLen=" + this.avgKeyLen + ", avgValueLen=" + this.avgValueLen + ", entries=" + this.trailer.getEntryCount() + ", length=" + this.fileSize;
    }

    @Override
    public long length() {
        return this.fileSize;
    }

    @Override
    public HFileScanner getScanner(boolean cacheBlocks, boolean pread) {
        return this.getScanner(cacheBlocks, pread, false);
    }

    @Override
    public byte[] getFirstKey() {
        if (this.dataBlockIndexReader == null) {
            throw new BlockIndexNotLoadedException();
        }
        return this.dataBlockIndexReader.isEmpty() ? null : this.dataBlockIndexReader.getRootBlockKey(0);
    }

    @Override
    public byte[] getFirstRowKey() {
        byte[] firstKey = this.getFirstKey();
        if (firstKey == null) {
            return null;
        }
        return KeyValue.createKeyValueFromKey((byte[])firstKey).getRow();
    }

    @Override
    public byte[] getLastRowKey() {
        byte[] lastKey = this.getLastKey();
        if (lastKey == null) {
            return null;
        }
        return KeyValue.createKeyValueFromKey((byte[])lastKey).getRow();
    }

    @Override
    public long getEntries() {
        return this.trailer.getEntryCount();
    }

    @Override
    public KeyValue.KVComparator getComparator() {
        return this.comparator;
    }

    @Override
    public Compression.Algorithm getCompressionAlgorithm() {
        return this.compressAlgo;
    }

    @Override
    public long indexSize() {
        return (this.dataBlockIndexReader != null ? this.dataBlockIndexReader.heapSize() : 0L) + (this.metaBlockIndexReader != null ? this.metaBlockIndexReader.heapSize() : 0L);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public HFileBlockIndex.BlockIndexReader getDataBlockIndexReader() {
        return this.dataBlockIndexReader;
    }

    @Override
    public FixedFileTrailer getTrailer() {
        return this.trailer;
    }

    @Override
    public boolean isPrimaryReplicaReader() {
        return this.isPrimaryReplicaReader;
    }

    @Override
    public void setPrimaryReplicaReader(boolean isPrimaryReplicaReader) {
        this.isPrimaryReplicaReader = isPrimaryReplicaReader;
    }

    public HFile.FileInfo loadFileInfo() throws IOException {
        return this.fileInfo;
    }

    abstract HFileBlock.FSReader getUncachedBlockReader();

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public DataBlockEncoding getDataBlockEncoding() {
        return this.dataBlockEncoder.getDataBlockEncoding();
    }

    public abstract int getMajorVersion();

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    protected static abstract class Scanner
    implements HFileScanner {
        protected ByteBuffer blockBuffer;
        protected boolean cacheBlocks;
        protected final boolean pread;
        protected final boolean isCompaction;
        protected int currKeyLen;
        protected int currValueLen;
        protected int currMemstoreTSLen;
        protected long currMemstoreTS;
        protected int blockFetches;
        protected final HFile.Reader reader;

        public Scanner(HFile.Reader reader, boolean cacheBlocks, boolean pread, boolean isCompaction) {
            this.reader = reader;
            this.cacheBlocks = cacheBlocks;
            this.pread = pread;
            this.isCompaction = isCompaction;
        }

        @Override
        public boolean isSeeked() {
            return this.blockBuffer != null;
        }

        public String toString() {
            return "HFileScanner for reader " + String.valueOf(this.getReader());
        }

        protected void assertSeeked() {
            if (!this.isSeeked()) {
                throw new NotSeekedException();
            }
        }

        @Override
        public int seekTo(byte[] key) throws IOException {
            return this.seekTo(key, 0, key.length);
        }

        @Override
        public boolean seekBefore(byte[] key) throws IOException {
            return this.seekBefore(key, 0, key.length);
        }

        @Override
        public int reseekTo(byte[] key) throws IOException {
            return this.reseekTo(key, 0, key.length);
        }

        @Override
        public HFile.Reader getReader() {
            return this.reader;
        }

        @Override
        public void close() {
            if (!this.pread) {
                this.reader.unbufferStream();
            }
        }
    }

    public static class NotSeekedException
    extends IllegalStateException {
        public NotSeekedException() {
            super("Not seeked to a key/value");
        }
    }

    public static class BlockIndexNotLoadedException
    extends IllegalStateException {
        public BlockIndexNotLoadedException() {
            super("Block index not loaded");
        }
    }
}

