/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.SecureBulkLoadClient;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.HalfStoreFileReader;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.FsDelegationToken;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSHDFSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class LoadIncrementalHFiles
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(LoadIncrementalHFiles.class);
    private Admin hbAdmin;
    public static final String NAME = "completebulkload";
    public static final String MAX_FILES_PER_REGION_PER_FAMILY = "hbase.mapreduce.bulkload.max.hfiles.perRegion.perFamily";
    private static final String ASSIGN_SEQ_IDS = "hbase.mapreduce.bulkload.assign.sequenceNumbers";
    public static final String CREATE_TABLE_CONF_KEY = "create.table";
    public static final String SILENCE_CONF_KEY = "ignore.unmatched.families";
    public static final String ALWAYS_COPY_FILES = "always.copy.files";
    static final String TMP_DIR = ".tmp";
    private int maxFilesPerRegionPerFamily;
    private boolean assignSeqIds;
    private Set<String> unmatchedFamilies = new HashSet<String>();
    private FileSystem fs;
    private FsDelegationToken fsDelegationToken;
    private String bulkToken;
    private UserProvider userProvider;
    private int nrThreads;
    private Map<LoadQueueItem, ByteBuffer> retValue = null;

    private LoadIncrementalHFiles() {
    }

    public LoadIncrementalHFiles(Configuration conf) throws Exception {
        super(conf);
        this.initialize();
    }

    private void initialize() throws IOException {
        if (this.hbAdmin == null) {
            this.setConf(HBaseConfiguration.create((Configuration)this.getConf()));
            Configuration conf = this.getConf();
            conf.setFloat("hfile.block.cache.size", 0.0f);
            this.hbAdmin = new HBaseAdmin(conf);
            this.userProvider = UserProvider.instantiate((Configuration)conf);
            this.fsDelegationToken = new FsDelegationToken(this.userProvider, "renewer");
            this.assignSeqIds = conf.getBoolean(ASSIGN_SEQ_IDS, true);
            this.maxFilesPerRegionPerFamily = conf.getInt(MAX_FILES_PER_REGION_PER_FAMILY, 32);
            this.nrThreads = conf.getInt("hbase.loadincremental.threads.max", Runtime.getRuntime().availableProcessors());
        }
    }

    private void usage() {
        System.err.println("usage: completebulkload /path/to/hfileoutputformat-output tablename\n -Dcreate.table=no - can be used to avoid creation of table by this tool\n  Note: if you set this to 'no', then the target table must already exist in HBase\n -Dignore.unmatched.families=yes - can be used to ignore unmatched column families\n\n");
    }

    private static <TFamily> void visitBulkHFiles(FileSystem fs, Path bulkDir, BulkHFileVisitor<TFamily> visitor) throws IOException {
        if (!fs.exists(bulkDir)) {
            throw new FileNotFoundException("Bulkload dir " + bulkDir + " not found");
        }
        FileStatus[] familyDirStatuses = fs.listStatus(bulkDir);
        if (familyDirStatuses == null) {
            throw new FileNotFoundException("No families found in " + bulkDir);
        }
        for (FileStatus familyStat : familyDirStatuses) {
            FileStatus[] hfileStatuses;
            if (!familyStat.isDirectory()) {
                LOG.warn((Object)("Skipping non-directory " + familyStat.getPath()));
                continue;
            }
            Path familyDir = familyStat.getPath();
            byte[] familyName = familyDir.getName().getBytes();
            try {
                HColumnDescriptor.isLegalFamilyName((byte[])familyName);
            }
            catch (IllegalArgumentException e) {
                LOG.warn((Object)("Skipping invalid " + familyStat.getPath()));
                continue;
            }
            TFamily family = visitor.bulkFamily(familyName);
            for (FileStatus hfileStatus : hfileStatuses = fs.listStatus(familyDir)) {
                block13: {
                    if (!fs.isFile(hfileStatus.getPath())) {
                        LOG.warn((Object)("Skipping non-file " + hfileStatus));
                        continue;
                    }
                    Path hfile = hfileStatus.getPath();
                    String fileName = hfile.getName();
                    if (fileName.startsWith("_")) continue;
                    if (StoreFileInfo.isReference(fileName)) {
                        LOG.warn((Object)("Skipping reference " + fileName));
                        continue;
                    }
                    if (HFileLink.isHFileLink(fileName)) {
                        LOG.warn((Object)("Skipping HFileLink " + fileName));
                        continue;
                    }
                    try {
                        if (!HFile.isHFileFormat(fs, hfile)) {
                            LOG.warn((Object)("the file " + hfile + " doesn't seems to be an hfile. skipping"));
                        }
                        break block13;
                    }
                    catch (FileNotFoundException e) {
                        LOG.warn((Object)("the file " + hfile + " was removed"));
                    }
                    continue;
                }
                visitor.bulkHFile(family, hfileStatus);
            }
        }
    }

    private void populateLoadQueue(Deque<LoadQueueItem> ret, Map<byte[], List<Path>> map) throws IOException {
        for (Map.Entry<byte[], List<Path>> entry : map.entrySet()) {
            for (Path p : entry.getValue()) {
                ret.add(new LoadQueueItem(entry.getKey(), p));
            }
        }
    }

    private void discoverLoadQueue(final Deque<LoadQueueItem> ret, Path hfofDir, boolean validateHFile) throws IOException {
        this.fs = hfofDir.getFileSystem(this.getConf());
        LoadIncrementalHFiles.visitBulkHFiles(this.fs, hfofDir, new BulkHFileVisitor<byte[]>(){

            @Override
            public byte[] bulkFamily(byte[] familyName) {
                return familyName;
            }

            @Override
            public void bulkHFile(byte[] family, FileStatus hfile) throws IOException {
                long length = hfile.getLen();
                if (length > LoadIncrementalHFiles.this.getConf().getLong("hbase.hregion.max.filesize", 0x280000000L)) {
                    LOG.warn((Object)("Trying to bulk load hfile " + hfile.getPath() + " with size: " + length + " bytes can be problematic as it may lead to oversplitting."));
                }
                ret.add(new LoadQueueItem(family, hfile.getPath()));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBulkLoad(Path hfofDir, HTable table) throws TableNotFoundException, IOException {
        Admin admin = null;
        HTable t = table;
        HConnection conn = table.getConnection();
        boolean closeConnWhenFinished = false;
        try {
            if (conn instanceof ClusterConnection && ((ClusterConnection)conn).isManaged()) {
                LOG.warn((Object)"managed connection cannot be used for bulkload. Creating unmanaged connection.");
                conn = ConnectionFactory.createConnection((Configuration)table.getConfiguration());
                t = conn.getTable(table.getName());
                closeConnWhenFinished = true;
                if (conn instanceof ClusterConnection && ((ClusterConnection)conn).isManaged()) {
                    throw new RuntimeException("Failed to create unmanaged connection.");
                }
                admin = conn.getAdmin();
            } else {
                admin = conn.getAdmin();
            }
            try (RegionLocator rl = conn.getRegionLocator(t.getName());){
                this.doBulkLoad(hfofDir, admin, (Table)t, rl);
            }
        }
        finally {
            if (admin != null) {
                admin.close();
            }
            if (closeConnWhenFinished) {
                t.close();
                conn.close();
            }
        }
    }

    void cleanup(Admin admin, Deque<LoadQueueItem> queue, ExecutorService pool, SecureBulkLoadClient secureClient) throws IOException {
        this.fsDelegationToken.releaseDelegationToken();
        if (this.bulkToken != null && secureClient != null) {
            secureClient.cleanupBulkLoad(this.bulkToken);
        }
        if (pool != null) {
            pool.shutdown();
        }
        if (!queue.isEmpty()) {
            StringBuilder err = new StringBuilder();
            err.append("-------------------------------------------------\n");
            err.append("Bulk load aborted with some files not yet loaded:\n");
            err.append("-------------------------------------------------\n");
            for (LoadQueueItem q : queue) {
                err.append("  ").append(q.hfilePath).append('\n');
            }
            LOG.error((Object)err);
        }
    }

    public void doBulkLoad(Path hfofDir, Admin admin, Table table, RegionLocator regionLocator) throws TableNotFoundException, IOException {
        this.doBulkLoad(hfofDir, admin, table, regionLocator, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBulkLoad(Map<byte[], List<Path>> map, Admin admin, Table table, RegionLocator regionLocator, boolean silence, boolean copyFile) throws TableNotFoundException, IOException {
        SecureBulkLoadClient secureClient;
        ExecutorService pool;
        LinkedList<LoadQueueItem> queue;
        block5: {
            if (!admin.isTableAvailable(regionLocator.getName())) {
                throw new TableNotFoundException("Table " + table.getName() + " is not currently available.");
            }
            queue = new LinkedList<LoadQueueItem>();
            pool = null;
            secureClient = null;
            this.prepareHFileQueue(map, table, queue, silence);
            if (!queue.isEmpty()) break block5;
            LOG.warn((Object)"Bulk load operation did not get any files to load");
            this.cleanup(admin, queue, pool, secureClient);
            return;
        }
        try {
            pool = this.createExecutorService();
            for (Map.Entry<byte[], List<Path>> entry : map.entrySet()) {
                Iterator<Path> iterator = entry.getValue().iterator();
                if (!iterator.hasNext()) continue;
                Path p = iterator.next();
                this.fs = p.getFileSystem(table.getConfiguration());
            }
            secureClient = new SecureBulkLoadClient(table);
            this.retValue = this.performBulkLoad(admin, table, regionLocator, queue, pool, secureClient, copyFile);
        }
        catch (Throwable throwable) {
            this.cleanup(admin, queue, pool, secureClient);
            throw throwable;
        }
        this.cleanup(admin, queue, pool, secureClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBulkLoad(Path hfofDir, Admin admin, Table table, RegionLocator regionLocator, boolean silence, boolean copyFile) throws TableNotFoundException, IOException {
        SecureBulkLoadClient secureClient;
        ExecutorService pool;
        LinkedList<LoadQueueItem> queue;
        block5: {
            if (!admin.isTableAvailable(regionLocator.getName())) {
                throw new TableNotFoundException("Table " + table.getName() + "is not currently available.");
            }
            boolean validateHFile = this.getConf().getBoolean("hbase.loadincremental.validate.hfile", true);
            if (!validateHFile) {
                LOG.warn((Object)"You are skipping HFiles validation, it might cause some data loss if files are not correct. If you fail to read data from your table after using this option, consider removing the files and bulkload again without this option. See HBASE-13985");
            }
            queue = new LinkedList<LoadQueueItem>();
            pool = null;
            secureClient = null;
            try {
                this.prepareHFileQueue(hfofDir, table, queue, validateHFile, silence);
                if (!queue.isEmpty()) break block5;
                LOG.warn((Object)("Bulk load operation did not find any files to load in directory " + hfofDir.toUri() + ".  Does it contain files in " + "subdirectories that correspond to column family names?"));
            }
            catch (Throwable throwable) {
                this.cleanup(admin, queue, pool, secureClient);
                throw throwable;
            }
            this.cleanup(admin, queue, pool, secureClient);
            return;
        }
        pool = this.createExecutorService();
        secureClient = new SecureBulkLoadClient(table);
        this.retValue = this.performBulkLoad(admin, table, regionLocator, queue, pool, secureClient, copyFile);
        this.cleanup(admin, queue, pool, secureClient);
    }

    Map<LoadQueueItem, ByteBuffer> performBulkLoad(Admin admin, Table table, RegionLocator regionLocator, Deque<LoadQueueItem> queue, ExecutorService pool, SecureBulkLoadClient secureClient, boolean copyFile) throws IOException {
        int count = 0;
        this.fsDelegationToken.acquireDelegationToken(this.fs);
        if (this.isSecureBulkLoadEndpointAvailable()) {
            this.bulkToken = new SecureBulkLoadClient(table).prepareBulkLoad(table.getName());
        }
        Pair<Multimap<ByteBuffer, LoadQueueItem>, Set<String>> pair = null;
        HashMap<LoadQueueItem, ByteBuffer> item2RegionMap = new HashMap<LoadQueueItem, ByteBuffer>();
        while (!queue.isEmpty()) {
            int maxRetries;
            Pair startEndKeys = regionLocator.getStartEndKeys();
            if (count != 0) {
                LOG.info((Object)("Split occured while grouping HFiles, retry attempt " + count + " with " + queue.size() + " files remaining to group or split"));
            }
            if ((maxRetries = this.getConf().getInt("hbase.bulkload.retries.number", 10)) != 0 && count >= maxRetries) {
                throw new IOException("Retry attempted " + count + " times without completing, bailing out");
            }
            ++count;
            pair = this.groupOrSplitPhase(table, pool, queue, (Pair<byte[][], byte[][]>)startEndKeys);
            Multimap regionGroups = (Multimap)pair.getFirst();
            if (!this.checkHFilesCountPerRegionPerFamily((Multimap<ByteBuffer, LoadQueueItem>)regionGroups)) {
                throw new IOException("Trying to load more than " + this.maxFilesPerRegionPerFamily + " hfiles to one family of one region");
            }
            this.bulkLoadPhase(table, admin.getConnection(), pool, queue, (Multimap<ByteBuffer, LoadQueueItem>)regionGroups, copyFile, item2RegionMap);
        }
        if (queue != null && !queue.isEmpty()) {
            throw new RuntimeException("Bulk load aborted with some files not yet loaded.Please check log for more details.");
        }
        return item2RegionMap;
    }

    public void prepareHFileQueue(Path hfofDir, Table table, Deque<LoadQueueItem> queue, boolean validateHFile) throws IOException {
        this.prepareHFileQueue(hfofDir, table, queue, validateHFile, false);
    }

    public void prepareHFileQueue(Path hfilesDir, Table table, Deque<LoadQueueItem> queue, boolean validateHFile, boolean silence) throws IOException {
        this.discoverLoadQueue(queue, hfilesDir, validateHFile);
        this.validateFamiliesInHFiles(table, queue, silence);
    }

    public void prepareHFileQueue(Map<byte[], List<Path>> map, Table table, Deque<LoadQueueItem> queue, boolean silence) throws IOException {
        this.populateLoadQueue(queue, map);
        this.validateFamiliesInHFiles(table, queue, silence);
    }

    private ExecutorService createExecutorService() {
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder();
        builder.setNameFormat("LoadIncrementalHFiles-%1$d");
        ThreadPoolExecutor pool = new ThreadPoolExecutor(this.nrThreads, this.nrThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), builder.build());
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    private void validateFamiliesInHFiles(Table table, Deque<LoadQueueItem> queue, boolean silence) throws IOException {
        Collection families = table.getTableDescriptor().getFamilies();
        ArrayList<String> familyNames = new ArrayList<String>(families.size());
        for (HColumnDescriptor family : families) {
            familyNames.add(family.getNameAsString());
        }
        ArrayList<String> unmatchedFamilies = new ArrayList<String>();
        for (LoadQueueItem lqi : queue) {
            String familyNameInHFile = Bytes.toString((byte[])lqi.family);
            if (familyNames.contains(familyNameInHFile)) continue;
            unmatchedFamilies.add(familyNameInHFile);
        }
        if (unmatchedFamilies.size() > 0) {
            String msg = "Unmatched family names found: unmatched family names in HFiles to be bulkloaded: " + unmatchedFamilies + "; valid family names of table " + table.getName() + " are: " + familyNames;
            LOG.error((Object)msg);
            if (!silence) {
                throw new IOException(msg);
            }
        }
    }

    public void loadHFileQueue(Table table, Connection conn, Deque<LoadQueueItem> queue, Pair<byte[][], byte[][]> startEndKeys) throws IOException {
        this.loadHFileQueue(table, conn, queue, startEndKeys, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHFileQueue(Table table, Connection conn, Deque<LoadQueueItem> queue, Pair<byte[][], byte[][]> startEndKeys, boolean copyFile) throws IOException {
        ExecutorService pool = null;
        try {
            pool = this.createExecutorService();
            Multimap regionGroups = (Multimap)this.groupOrSplitPhase(table, pool, queue, startEndKeys).getFirst();
            this.bulkLoadPhase(table, conn, pool, queue, (Multimap<ByteBuffer, LoadQueueItem>)regionGroups, copyFile, null);
        }
        finally {
            if (pool != null) {
                pool.shutdown();
            }
        }
    }

    protected void bulkLoadPhase(final Table table, final Connection conn, ExecutorService pool, Deque<LoadQueueItem> queue, Multimap<ByteBuffer, LoadQueueItem> regionGroups, final boolean copyFile, Map<LoadQueueItem, ByteBuffer> item2RegionMap) throws IOException {
        HashSet<Future<List<LoadQueueItem>>> loadingFutures = new HashSet<Future<List<LoadQueueItem>>>();
        for (Map.Entry entry : regionGroups.asMap().entrySet()) {
            final byte[] first = ((ByteBuffer)entry.getKey()).array();
            final Collection lqis = (Collection)entry.getValue();
            Callable<List<LoadQueueItem>> call = new Callable<List<LoadQueueItem>>(){

                @Override
                public List<LoadQueueItem> call() throws Exception {
                    List<LoadQueueItem> toRetry = LoadIncrementalHFiles.this.tryAtomicRegionLoad(conn, table.getName(), first, lqis, copyFile);
                    return toRetry;
                }
            };
            if (item2RegionMap != null) {
                Iterator iterator = lqis.iterator();
                while (iterator.hasNext()) {
                    LoadQueueItem lqi = (LoadQueueItem)iterator.next();
                    item2RegionMap.put(lqi, (ByteBuffer)entry.getKey());
                }
            }
            loadingFutures.add(pool.submit(call));
        }
        for (Future future : loadingFutures) {
            try {
                List toRetry = (List)future.get();
                if (item2RegionMap != null) {
                    for (LoadQueueItem lqi : toRetry) {
                        item2RegionMap.remove(lqi);
                    }
                }
                queue.addAll(toRetry);
            }
            catch (ExecutionException e1) {
                Throwable t = e1.getCause();
                if (t instanceof IOException) {
                    throw new IOException("BulkLoad encountered an unrecoverable problem", t);
                }
                LOG.error((Object)"Unexpected execution exception during bulk load", (Throwable)e1);
                throw new IllegalStateException(t);
            }
            catch (InterruptedException e1) {
                LOG.error((Object)"Unexpected interrupted exception during bulk load", (Throwable)e1);
                throw (InterruptedIOException)new InterruptedIOException().initCause(e1);
            }
        }
    }

    private boolean checkHFilesCountPerRegionPerFamily(Multimap<ByteBuffer, LoadQueueItem> regionGroups) {
        for (Map.Entry e : regionGroups.asMap().entrySet()) {
            Collection lqis = (Collection)e.getValue();
            HashMap<byte[], MutableInt> filesMap = new HashMap<byte[], MutableInt>();
            for (LoadQueueItem lqi : lqis) {
                MutableInt count = (MutableInt)filesMap.get(lqi.family);
                if (count == null) {
                    count = new MutableInt();
                    filesMap.put(lqi.family, count);
                }
                count.increment();
                if (count.intValue() <= this.maxFilesPerRegionPerFamily) continue;
                LOG.error((Object)("Trying to load more than " + this.maxFilesPerRegionPerFamily + " hfiles to family " + Bytes.toStringBinary((byte[])lqi.family) + " of region with start key " + Bytes.toStringBinary((ByteBuffer)((ByteBuffer)e.getKey()))));
                return false;
            }
        }
        return true;
    }

    private Pair<Multimap<ByteBuffer, LoadQueueItem>, Set<String>> groupOrSplitPhase(final Table table, ExecutorService pool, Deque<LoadQueueItem> queue, final Pair<byte[][], byte[][]> startEndKeys) throws IOException {
        HashMultimap rgs = HashMultimap.create();
        final Multimap regionGroups = Multimaps.synchronizedMultimap((Multimap)rgs);
        HashSet<Object> missingHFiles = new HashSet<Object>();
        Pair pair = new Pair((Object)regionGroups, missingHFiles);
        HashSet<Future<Pair<List<LoadQueueItem>, String>>> splittingFutures = new HashSet<Future<Pair<List<LoadQueueItem>, String>>>();
        while (!queue.isEmpty()) {
            final LoadQueueItem item = queue.remove();
            Callable<Pair<List<LoadQueueItem>, String>> callable = new Callable<Pair<List<LoadQueueItem>, String>>(){

                @Override
                public Pair<List<LoadQueueItem>, String> call() throws Exception {
                    Pair<List<LoadQueueItem>, String> splits = LoadIncrementalHFiles.this.groupOrSplit((Multimap<ByteBuffer, LoadQueueItem>)regionGroups, item, table, (Pair<byte[][], byte[][]>)startEndKeys);
                    return splits;
                }
            };
            splittingFutures.add(pool.submit(callable));
        }
        for (Future future : splittingFutures) {
            try {
                Pair splits = (Pair)future.get();
                if (splits == null) continue;
                if (splits.getFirst() != null) {
                    queue.addAll((Collection)splits.getFirst());
                    continue;
                }
                missingHFiles.add(splits.getSecond());
            }
            catch (ExecutionException e1) {
                Throwable t = e1.getCause();
                if (t instanceof IOException) {
                    LOG.error((Object)"IOException during splitting", (Throwable)e1);
                    throw (IOException)t;
                }
                LOG.error((Object)"Unexpected execution exception during splitting", (Throwable)e1);
                throw new IllegalStateException(t);
            }
            catch (InterruptedException e1) {
                LOG.error((Object)"Unexpected interrupted exception during splitting", (Throwable)e1);
                throw (InterruptedIOException)new InterruptedIOException().initCause(e1);
            }
        }
        return pair;
    }

    private String getUniqueName() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    protected List<LoadQueueItem> splitStoreFile(LoadQueueItem item, Table table, byte[] startKey, byte[] splitKey) throws IOException {
        Path hfilePath = item.hfilePath;
        Path tmpDir = item.hfilePath.getParent();
        if (!tmpDir.getName().equals(TMP_DIR)) {
            tmpDir = new Path(tmpDir, TMP_DIR);
        }
        LOG.info((Object)("HFile at " + hfilePath + " no longer fits inside a single " + "region. Splitting..."));
        String uniqueName = this.getUniqueName();
        HColumnDescriptor familyDesc = table.getTableDescriptor().getFamily(item.family);
        Path botOut = new Path(tmpDir, uniqueName + ".bottom");
        Path topOut = new Path(tmpDir, uniqueName + ".top");
        LoadIncrementalHFiles.splitStoreFile(this.getConf(), hfilePath, familyDesc, splitKey, botOut, topOut);
        FileSystem fs = tmpDir.getFileSystem(this.getConf());
        fs.setPermission(tmpDir, FsPermission.valueOf((String)"-rwxrwxrwx"));
        fs.setPermission(botOut, FsPermission.valueOf((String)"-rwxrwxrwx"));
        fs.setPermission(topOut, FsPermission.valueOf((String)"-rwxrwxrwx"));
        ArrayList<LoadQueueItem> lqis = new ArrayList<LoadQueueItem>(2);
        lqis.add(new LoadQueueItem(item.family, botOut));
        lqis.add(new LoadQueueItem(item.family, topOut));
        try {
            tmpDir = item.hfilePath.getParent();
            if (tmpDir.getName().equals(TMP_DIR)) {
                fs.delete(item.hfilePath, false);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Unable to delete temporary split file " + item.hfilePath));
        }
        LOG.info((Object)("Successfully split into new HFiles " + botOut + " and " + topOut));
        return lqis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pair<List<LoadQueueItem>, String> groupOrSplit(Multimap<ByteBuffer, LoadQueueItem> regionGroups, LoadQueueItem item, Table table, Pair<byte[][], byte[][]> startEndKeys) throws IOException {
        boolean lastKeyInRange;
        int indexForCallable;
        byte[] last;
        byte[] first;
        Path hfilePath = item.hfilePath;
        if (this.fs == null) {
            this.fs = hfilePath.getFileSystem(this.getConf());
        }
        HFile.Reader hfr = null;
        try {
            hfr = HFile.createReader(this.fs, hfilePath, new CacheConfig(this.getConf()), this.getConf());
        }
        catch (FileNotFoundException fnfe) {
            LOG.debug((Object)"encountered", (Throwable)fnfe);
            return new Pair(null, (Object)hfilePath.getName());
        }
        try {
            hfr.loadFileInfo();
            first = hfr.getFirstRowKey();
            last = hfr.getLastRowKey();
        }
        finally {
            hfr.close();
        }
        LOG.info((Object)("Trying to load hfile=" + hfilePath + " first=" + Bytes.toStringBinary((byte[])first) + " last=" + Bytes.toStringBinary((byte[])last)));
        if (first == null || last == null) {
            assert (first == null && last == null);
            LOG.info((Object)("hfile " + hfilePath + " has no entries, skipping"));
            return null;
        }
        if (Bytes.compareTo((byte[])first, (byte[])last) > 0) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary((byte[])first) + " > " + Bytes.toStringBinary((byte[])last));
        }
        int idx = Arrays.binarySearch((Object[])startEndKeys.getFirst(), first, Bytes.BYTES_COMPARATOR);
        if (idx < 0) {
            idx = -(idx + 1) - 1;
        }
        if ((indexForCallable = idx) < 0) {
            throw new IOException("The first region info for table " + table.getName() + " cann't be found in hbase:meta.Please use hbck tool to fix it first.");
        }
        if (indexForCallable == ((byte[][])startEndKeys.getFirst()).length - 1 && !Bytes.equals((byte[])((byte[][])startEndKeys.getSecond())[indexForCallable], (byte[])HConstants.EMPTY_BYTE_ARRAY)) {
            throw new IOException("The last region info for table " + table.getName() + " cann't be found in hbase:meta.Please use hbck tool to fix it first.");
        }
        if (indexForCallable + 1 < ((byte[][])startEndKeys.getFirst()).length && Bytes.compareTo((byte[])((byte[][])startEndKeys.getSecond())[indexForCallable], (byte[])((byte[][])startEndKeys.getFirst())[indexForCallable + 1]) != 0) {
            throw new IOException("The endkey of one region for table " + table.getName() + " is not equal to the startkey of the next region in hbase:meta." + "Please use hbck tool to fix it first.");
        }
        boolean bl = lastKeyInRange = Bytes.compareTo((byte[])last, (byte[])((byte[][])startEndKeys.getSecond())[idx]) < 0 || Bytes.equals((byte[])((byte[][])startEndKeys.getSecond())[idx], (byte[])HConstants.EMPTY_BYTE_ARRAY);
        if (!lastKeyInRange) {
            List<LoadQueueItem> lqis = this.splitStoreFile(item, table, ((byte[][])startEndKeys.getFirst())[indexForCallable], ((byte[][])startEndKeys.getSecond())[indexForCallable]);
            return new Pair(lqis, null);
        }
        regionGroups.put((Object)ByteBuffer.wrap(((byte[][])startEndKeys.getFirst())[idx]), (Object)item);
        return null;
    }

    @Deprecated
    protected List<LoadQueueItem> tryAtomicRegionLoad(HConnection conn, byte[] tableName, byte[] first, Collection<LoadQueueItem> lqis) throws IOException {
        return this.tryAtomicRegionLoad((Connection)conn, TableName.valueOf((byte[])tableName), first, lqis, false);
    }

    protected List<LoadQueueItem> tryAtomicRegionLoad(final Connection conn, TableName tableName, byte[] first, final Collection<LoadQueueItem> lqis, final boolean copyFile) throws IOException {
        final ArrayList<Pair> famPaths = new ArrayList<Pair>(lqis.size());
        for (LoadQueueItem lqi : lqis) {
            if (this.unmatchedFamilies.contains(Bytes.toString((byte[])lqi.family))) continue;
            famPaths.add(Pair.newPair((Object)lqi.family, (Object)lqi.hfilePath.toString()));
        }
        RegionServerCallable<byte[]> svrCallable = new RegionServerCallable<byte[]>(conn, tableName, first){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public byte[] call(int callTimeout) throws Exception {
                SecureBulkLoadClient secureClient = null;
                boolean success = false;
                try {
                    LOG.debug((Object)("Going to connect to server " + this.getLocation() + " for row " + Bytes.toStringBinary((byte[])this.getRow()) + " with hfile group " + famPaths));
                    byte[] regionName = this.getLocation().getRegionInfo().getRegionName();
                    if (!LoadIncrementalHFiles.this.isSecureBulkLoadEndpointAvailable()) {
                        success = ProtobufUtil.bulkLoadHFile((ClientProtos.ClientService.BlockingInterface)this.getStub(), (List)famPaths, (byte[])regionName, (boolean)LoadIncrementalHFiles.this.assignSeqIds);
                    } else {
                        try (Table table = conn.getTable(this.getTableName());){
                            secureClient = new SecureBulkLoadClient(table);
                            success = secureClient.bulkLoadHFiles(famPaths, LoadIncrementalHFiles.this.fsDelegationToken.getUserToken(), LoadIncrementalHFiles.this.bulkToken, this.getLocation().getRegionInfo().getStartKey(), copyFile);
                        }
                    }
                    byte[] byArray = (byte[])(success ? regionName : null);
                    return byArray;
                }
                finally {
                    if (secureClient != null && !success) {
                        FileSystem targetFs = FileSystem.get((Configuration)LoadIncrementalHFiles.this.getConf());
                        if (LoadIncrementalHFiles.this.fs == null) {
                            LoadIncrementalHFiles.this.fs = ((LoadQueueItem)lqis.iterator().next()).hfilePath.getFileSystem(LoadIncrementalHFiles.this.getConf());
                        }
                        if (FSHDFSUtils.isSameHdfs(LoadIncrementalHFiles.this.getConf(), LoadIncrementalHFiles.this.fs, targetFs)) {
                            for (Pair el : famPaths) {
                                Path hfileStagingPath = null;
                                Path hfileOrigPath = new Path((String)el.getSecond());
                                try {
                                    hfileStagingPath = new Path(secureClient.getStagingPath(LoadIncrementalHFiles.this.bulkToken, (byte[])el.getFirst()), hfileOrigPath.getName());
                                    if (targetFs.rename(hfileStagingPath, hfileOrigPath)) {
                                        LOG.debug((Object)("Moved back file " + hfileOrigPath + " from " + hfileStagingPath));
                                        continue;
                                    }
                                    if (!targetFs.exists(hfileStagingPath)) continue;
                                    LOG.debug((Object)("Unable to move back file " + hfileOrigPath + " from " + hfileStagingPath));
                                }
                                catch (Exception ex) {
                                    LOG.debug((Object)("Unable to move back file " + hfileOrigPath + " from " + hfileStagingPath), (Throwable)ex);
                                }
                            }
                        }
                    }
                }
            }
        };
        try {
            ArrayList<LoadQueueItem> toRetry = new ArrayList<LoadQueueItem>();
            Configuration conf = this.getConf();
            byte[] region = (byte[])RpcRetryingCallerFactory.instantiate((Configuration)conf, null).newCaller().callWithRetries((RetryingCallable)svrCallable, Integer.MAX_VALUE);
            if (region == null) {
                LOG.warn((Object)("Attempt to bulk load region containing " + Bytes.toStringBinary((byte[])first) + " into table " + tableName + " with files " + lqis + " failed.  This is recoverable and they will be retried."));
                toRetry.addAll(lqis);
            }
            return toRetry;
        }
        catch (IOException e) {
            LOG.error((Object)("Encountered unrecoverable error from region server, additional details: " + svrCallable.getExceptionMessageAdditionalDetail()), (Throwable)e);
            throw e;
        }
    }

    private boolean isSecureBulkLoadEndpointAvailable() {
        String classes = this.getConf().get("hbase.coprocessor.region.classes", "");
        return classes.contains("org.apache.hadoop.hbase.security.access.SecureBulkLoadEndpoint");
    }

    static void splitStoreFile(Configuration conf, Path inFile, HColumnDescriptor familyDesc, byte[] splitKey, Path bottomOut, Path topOut) throws IOException {
        Reference topReference = Reference.createTopReference(splitKey);
        Reference bottomReference = Reference.createBottomReference(splitKey);
        LoadIncrementalHFiles.copyHFileHalf(conf, inFile, topOut, topReference, familyDesc);
        LoadIncrementalHFiles.copyHFileHalf(conf, inFile, bottomOut, bottomReference, familyDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyHFileHalf(Configuration conf, Path inFile, Path outFile, Reference reference, HColumnDescriptor familyDescriptor) throws IOException {
        FileSystem fs = inFile.getFileSystem(conf);
        CacheConfig cacheConf = new CacheConfig(conf);
        HalfStoreFileReader halfReader = null;
        StoreFile.Writer halfWriter = null;
        try {
            halfReader = new HalfStoreFileReader(fs, inFile, cacheConf, reference, conf);
            Map<byte[], byte[]> fileInfo = halfReader.loadFileInfo();
            int blocksize = familyDescriptor.getBlocksize();
            Compression.Algorithm compression = familyDescriptor.getCompression();
            BloomType bloomFilterType = familyDescriptor.getBloomFilterType();
            HFileContext hFileContext = new HFileContextBuilder().withCompression(compression).withChecksumType(HStore.getChecksumType(conf)).withBytesPerCheckSum(HStore.getBytesPerChecksum(conf)).withBlockSize(blocksize).withDataBlockEncoding(familyDescriptor.getDataBlockEncoding()).withIncludesTags(true).build();
            halfWriter = new StoreFile.WriterBuilder(conf, cacheConf, fs).withFilePath(outFile).withBloomType(bloomFilterType).withFileContext(hFileContext).build();
            HFileScanner scanner = halfReader.getScanner(false, false, false);
            scanner.seekTo();
            do {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)scanner.getKeyValue());
                halfWriter.append((Cell)kv);
            } while (scanner.next());
            for (Map.Entry<byte[], byte[]> entry : fileInfo.entrySet()) {
                if (!LoadIncrementalHFiles.shouldCopyHFileMetaKey(entry.getKey())) continue;
                halfWriter.appendFileInfo(entry.getKey(), entry.getValue());
            }
        }
        finally {
            if (halfWriter != null) {
                halfWriter.close();
            }
            if (halfReader != null) {
                halfReader.close(cacheConf.shouldEvictOnClose());
            }
        }
    }

    private static boolean shouldCopyHFileMetaKey(byte[] key) {
        if (Bytes.equals((byte[])key, (byte[])HFileDataBlockEncoder.DATA_BLOCK_ENCODING)) {
            return false;
        }
        return !HFile.isReservedFileInfoKey(key);
    }

    private boolean doesTableExist(TableName tableName) throws IOException {
        return this.hbAdmin.tableExists(tableName);
    }

    public static byte[][] inferBoundaries(TreeMap<byte[], Integer> bdryMap) {
        ArrayList<byte[]> keysArray = new ArrayList<byte[]>();
        int runningValue = 0;
        byte[] currStartKey = null;
        boolean firstBoundary = true;
        for (Map.Entry<byte[], Integer> item : bdryMap.entrySet()) {
            if (runningValue == 0) {
                currStartKey = item.getKey();
            }
            if ((runningValue += item.getValue().intValue()) != 0) continue;
            if (!firstBoundary) {
                keysArray.add(currStartKey);
            }
            firstBoundary = false;
        }
        return (byte[][])keysArray.toArray((T[])new byte[0][0]);
    }

    private void createTable(TableName tableName, String dirPath) throws IOException {
        Path hfofDir = new Path(dirPath);
        final FileSystem fs = hfofDir.getFileSystem(this.getConf());
        final HTableDescriptor htd = new HTableDescriptor(tableName);
        final TreeMap<byte[], Integer> map = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        LoadIncrementalHFiles.visitBulkHFiles(fs, hfofDir, new BulkHFileVisitor<HColumnDescriptor>(){

            @Override
            public HColumnDescriptor bulkFamily(byte[] familyName) {
                HColumnDescriptor hcd = new HColumnDescriptor(familyName);
                htd.addFamily(hcd);
                return hcd;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void bulkHFile(HColumnDescriptor hcd, FileStatus hfileStatus) throws IOException {
                Path hfile = hfileStatus.getPath();
                try (HFile.Reader reader = HFile.createReader(fs, hfile, new CacheConfig(LoadIncrementalHFiles.this.getConf()), LoadIncrementalHFiles.this.getConf());){
                    if (hcd.getCompressionType() != reader.getFileContext().getCompression()) {
                        hcd.setCompressionType(reader.getFileContext().getCompression());
                        LOG.info((Object)("Setting compression " + hcd.getCompressionType().name() + " for family " + hcd.toString()));
                    }
                    reader.loadFileInfo();
                    byte[] first = reader.getFirstRowKey();
                    byte[] last = reader.getLastRowKey();
                    LOG.info((Object)("Trying to figure out region boundaries hfile=" + hfile + " first=" + Bytes.toStringBinary((byte[])first) + " last=" + Bytes.toStringBinary((byte[])last)));
                    Integer value = map.containsKey(first) ? (Integer)map.get(first) : 0;
                    map.put(first, value + 1);
                    value = map.containsKey(last) ? (Integer)map.get(last) : 0;
                    map.put(last, value - 1);
                }
            }
        });
        byte[][] keys = LoadIncrementalHFiles.inferBoundaries(map);
        this.hbAdmin.createTable(htd, keys);
        LOG.info((Object)("Table " + tableName + " is available!!"));
    }

    /*
     * Exception decompiling
     */
    public Map<LoadQueueItem, ByteBuffer> run(String dirPath, Map<byte[], List<Path>> map, TableName tableName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int run(String[] args) throws Exception {
        if (args.length < 2) {
            this.usage();
            return -1;
        }
        String dirPath = args[0];
        TableName tableName = TableName.valueOf((String)args[1]);
        Map<LoadQueueItem, ByteBuffer> loaded = this.run(dirPath, null, tableName);
        if (loaded == null || !loaded.isEmpty()) {
            return 0;
        }
        return -1;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int ret = ToolRunner.run((Configuration)conf, (Tool)new LoadIncrementalHFiles(), (String[])args);
        System.exit(ret);
    }

    public void setBulkToken(String stagingDir) {
        this.bulkToken = stagingDir;
    }

    public static class LoadQueueItem {
        final byte[] family;
        final Path hfilePath;

        public LoadQueueItem(byte[] family, Path hfilePath) {
            this.family = family;
            this.hfilePath = hfilePath;
        }

        public String toString() {
            return "family:" + Bytes.toString((byte[])this.family) + " path:" + this.hfilePath.toString();
        }

        public byte[] getFamily() {
            return this.family;
        }

        public Path getFilePath() {
            return this.hfilePath;
        }
    }

    private static interface BulkHFileVisitor<TFamily> {
        public TFamily bulkFamily(byte[] var1) throws IOException;

        public void bulkHFile(TFamily var1, FileStatus var2) throws IOException;
    }
}

