/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.master.MetricsMasterProcSource;
import org.apache.hadoop.hbase.master.MetricsMasterProcSourceFactory;
import org.apache.hadoop.hbase.master.MetricsMasterQuotaSource;
import org.apache.hadoop.hbase.master.MetricsMasterQuotaSourceFactory;
import org.apache.hadoop.hbase.master.MetricsMasterSource;
import org.apache.hadoop.hbase.master.MetricsMasterSourceFactory;
import org.apache.hadoop.hbase.master.MetricsMasterWrapper;

@InterfaceStability.Evolving
@InterfaceAudience.Private
public class MetricsMaster {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private MetricsMasterSource masterSource;
    private MetricsMasterProcSource masterProcSource;
    private MetricsMasterQuotaSource masterQuotaSource;

    public MetricsMaster(MetricsMasterWrapper masterWrapper) {
        this.masterSource = ((MetricsMasterSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsMasterSourceFactory.class)).create(masterWrapper);
        this.masterProcSource = ((MetricsMasterProcSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsMasterProcSourceFactory.class)).create(masterWrapper);
        this.masterQuotaSource = ((MetricsMasterQuotaSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsMasterQuotaSourceFactory.class)).create(masterWrapper);
    }

    public MetricsMasterSource getMetricsSource() {
        return this.masterSource;
    }

    public MetricsMasterProcSource getMetricsProcSource() {
        return this.masterProcSource;
    }

    public MetricsMasterQuotaSource getMetricsQuotaSource() {
        return this.masterQuotaSource;
    }

    public void incrementRequests(long inc) {
        this.masterSource.incRequests(inc);
    }

    public void setNumSpaceQuotas(long numSpaceQuotas) {
        this.masterQuotaSource.updateNumSpaceQuotas(numSpaceQuotas);
    }

    public void setNumTableInSpaceQuotaViolation(long numTablesInViolation) {
        this.masterQuotaSource.updateNumTablesInSpaceQuotaViolation(numTablesInViolation);
    }

    public void setNumNamespacesInSpaceQuotaViolation(long numNamespacesInViolation) {
        this.masterQuotaSource.updateNumNamespacesInSpaceQuotaViolation(numNamespacesInViolation);
    }

    public void setNumRegionSizeReports(long numRegionReports) {
        this.masterQuotaSource.updateNumCurrentSpaceQuotaRegionSizeReports(numRegionReports);
    }

    public void incrementQuotaObserverTime(long executionTime) {
        this.masterQuotaSource.incrementSpaceQuotaObserverChoreTime(executionTime);
    }
}

