/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableStateManager;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.exceptions.HBaseException;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.procedure.DeleteTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public class CreateTableProcedure
extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.CreateTableState>
implements TableProcedureInterface {
    private static final Log LOG = LogFactory.getLog(CreateTableProcedure.class);
    private final AtomicBoolean aborted = new AtomicBoolean(false);
    private final ProcedurePrepareLatch syncLatch;
    private HTableDescriptor hTableDescriptor;
    private List<HRegionInfo> newRegions;
    private UserGroupInformation user;

    public CreateTableProcedure() {
        this.syncLatch = null;
    }

    public CreateTableProcedure(MasterProcedureEnv env, HTableDescriptor hTableDescriptor, HRegionInfo[] newRegions) throws IOException {
        this(env, hTableDescriptor, newRegions, null);
    }

    public CreateTableProcedure(MasterProcedureEnv env, HTableDescriptor hTableDescriptor, HRegionInfo[] newRegions, ProcedurePrepareLatch syncLatch) throws IOException {
        this.hTableDescriptor = hTableDescriptor;
        this.newRegions = newRegions != null ? Lists.newArrayList((Object[])newRegions) : null;
        this.user = env.getRequestUser().getUGI();
        this.setOwner(this.user.getShortUserName());
        this.syncLatch = syncLatch;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.CreateTableState state) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this + " execute state=" + state));
        } else {
            LOG.info((Object)(this + " execute state=" + state));
        }
        try {
            switch (state) {
                case CREATE_TABLE_PRE_OPERATION: {
                    boolean exists = !this.prepareCreate(env);
                    ProcedurePrepareLatch.releaseLatch(this.syncLatch, (Procedure)this);
                    if (exists) {
                        assert (this.isFailed()) : "the delete should have an exception here";
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    this.preCreate(env);
                    this.setNextState(MasterProcedureProtos.CreateTableState.CREATE_TABLE_WRITE_FS_LAYOUT);
                    break;
                }
                case CREATE_TABLE_WRITE_FS_LAYOUT: {
                    this.newRegions = CreateTableProcedure.createFsLayout(env, this.hTableDescriptor, this.newRegions);
                    this.setNextState(MasterProcedureProtos.CreateTableState.CREATE_TABLE_ADD_TO_META);
                    break;
                }
                case CREATE_TABLE_ADD_TO_META: {
                    this.newRegions = CreateTableProcedure.addTableToMeta(env, this.hTableDescriptor, this.newRegions);
                    this.setNextState(MasterProcedureProtos.CreateTableState.CREATE_TABLE_ASSIGN_REGIONS);
                    break;
                }
                case CREATE_TABLE_ASSIGN_REGIONS: {
                    CreateTableProcedure.assignRegions(env, this.getTableName(), this.newRegions);
                    this.setNextState(MasterProcedureProtos.CreateTableState.CREATE_TABLE_UPDATE_DESC_CACHE);
                    break;
                }
                case CREATE_TABLE_UPDATE_DESC_CACHE: {
                    CreateTableProcedure.updateTableDescCache(env, this.getTableName());
                    this.setNextState(MasterProcedureProtos.CreateTableState.CREATE_TABLE_POST_OPERATION);
                    break;
                }
                case CREATE_TABLE_POST_OPERATION: {
                    this.postCreate(env);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException | InterruptedException | HBaseException e) {
            LOG.error((Object)("Error trying to create table=" + this.getTableName() + " state=" + state), e);
            this.setFailure("master-create-table", e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.CreateTableState state) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this + " rollback state=" + state));
        }
        try {
            switch (state) {
                case CREATE_TABLE_POST_OPERATION: {
                    break;
                }
                case CREATE_TABLE_UPDATE_DESC_CACHE: {
                    DeleteTableProcedure.deleteTableDescriptorCache(env, this.getTableName());
                    break;
                }
                case CREATE_TABLE_ASSIGN_REGIONS: {
                    DeleteTableProcedure.deleteAssignmentState(env, this.getTableName());
                    break;
                }
                case CREATE_TABLE_ADD_TO_META: {
                    DeleteTableProcedure.deleteFromMeta(env, this.getTableName(), this.newRegions);
                    break;
                }
                case CREATE_TABLE_WRITE_FS_LAYOUT: {
                    DeleteTableProcedure.deleteFromFs(env, this.getTableName(), this.newRegions, false);
                    break;
                }
                case CREATE_TABLE_PRE_OPERATION: {
                    DeleteTableProcedure.deleteTableStates(env, this.getTableName());
                    ProcedurePrepareLatch.releaseLatch(this.syncLatch, (Procedure)this);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (HBaseException e) {
            LOG.warn((Object)("Failed rollback attempt step=" + state + " table=" + this.getTableName()), (Throwable)e);
            throw new IOException(e);
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed rollback attempt step=" + state + " table=" + this.getTableName()), (Throwable)e);
            throw e;
        }
    }

    protected MasterProcedureProtos.CreateTableState getState(int stateId) {
        return MasterProcedureProtos.CreateTableState.valueOf((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.CreateTableState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.CreateTableState getInitialState() {
        return MasterProcedureProtos.CreateTableState.CREATE_TABLE_PRE_OPERATION;
    }

    protected void setNextState(MasterProcedureProtos.CreateTableState state) {
        if (this.aborted.get()) {
            this.setAbortFailure("create-table", "abort requested");
        } else {
            super.setNextState((Object)state);
        }
    }

    @Override
    public TableName getTableName() {
        return this.hTableDescriptor.getTableName();
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.CREATE;
    }

    public boolean abort(MasterProcedureEnv env) {
        this.aborted.set(true);
        return true;
    }

    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (table=");
        sb.append(this.getTableName());
        sb.append(")");
    }

    public void serializeStateData(OutputStream stream) throws IOException {
        super.serializeStateData(stream);
        MasterProcedureProtos.CreateTableStateData.Builder state = MasterProcedureProtos.CreateTableStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.user)).setTableSchema(this.hTableDescriptor.convert());
        if (this.newRegions != null) {
            for (HRegionInfo hri : this.newRegions) {
                state.addRegionInfo(HRegionInfo.convert((HRegionInfo)hri));
            }
        }
        state.build().writeDelimitedTo(stream);
    }

    public void deserializeStateData(InputStream stream) throws IOException {
        super.deserializeStateData(stream);
        MasterProcedureProtos.CreateTableStateData state = MasterProcedureProtos.CreateTableStateData.parseDelimitedFrom((InputStream)stream);
        this.user = MasterProcedureUtil.toUserInfo(state.getUserInfo());
        this.hTableDescriptor = HTableDescriptor.convert((HBaseProtos.TableSchema)state.getTableSchema());
        if (state.getRegionInfoCount() == 0) {
            this.newRegions = null;
        } else {
            this.newRegions = new ArrayList<HRegionInfo>(state.getRegionInfoCount());
            for (HBaseProtos.RegionInfo hri : state.getRegionInfoList()) {
                this.newRegions.add(HRegionInfo.convert((HBaseProtos.RegionInfo)hri));
            }
        }
    }

    protected boolean acquireLock(MasterProcedureEnv env) {
        if (!env.isNamespaceManagerInitialized() && !this.getTableName().isSystemTable()) {
            return false;
        }
        return env.getProcedureQueue().tryAcquireTableWrite(this.getTableName(), "create table");
    }

    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureQueue().releaseTableWrite(this.getTableName());
    }

    private boolean prepareCreate(MasterProcedureEnv env) throws IOException {
        TableStateManager tsm;
        boolean skipTableStateCheck;
        TableName tableName = this.getTableName();
        if (MetaTableAccessor.tableExists((Connection)env.getMasterServices().getConnection(), (TableName)tableName)) {
            this.setFailure("master-create-table", (Throwable)new TableExistsException(this.getTableName()));
            return false;
        }
        boolean bl = skipTableStateCheck = !env.getMasterServices().isInitialized() && tableName.isSystemTable();
        if (!skipTableStateCheck && (tsm = env.getMasterServices().getAssignmentManager().getTableStateManager()).isTableState(tableName, true, ZooKeeperProtos.Table.State.ENABLING, ZooKeeperProtos.Table.State.ENABLED)) {
            LOG.warn((Object)("The table " + tableName + " does not exist in meta but has a znode. " + "run hbck to fix inconsistencies."));
            this.setFailure("master-create-table", (Throwable)new TableExistsException(this.getTableName()));
            return false;
        }
        return true;
    }

    private void preCreate(MasterProcedureEnv env) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost;
        if (!this.getTableName().isSystemTable()) {
            ProcedureSyncWait.getMasterQuotaManager(env).checkNamespaceTableAndRegionQuota(this.getTableName(), this.newRegions.size());
        }
        if ((cpHost = env.getMasterCoprocessorHost()) != null) {
            final HRegionInfo[] regions = this.newRegions == null ? null : this.newRegions.toArray(new HRegionInfo[this.newRegions.size()]);
            this.user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    cpHost.preCreateTableHandler(CreateTableProcedure.this.hTableDescriptor, regions);
                    return null;
                }
            });
        }
    }

    private void postCreate(MasterProcedureEnv env) throws IOException, InterruptedException {
        final MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            final HRegionInfo[] regions = this.newRegions == null ? null : this.newRegions.toArray(new HRegionInfo[this.newRegions.size()]);
            this.user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    cpHost.postCreateTableHandler(CreateTableProcedure.this.hTableDescriptor, regions);
                    return null;
                }
            });
        }
    }

    protected static List<HRegionInfo> createFsLayout(MasterProcedureEnv env, final HTableDescriptor hTableDescriptor, List<HRegionInfo> newRegions) throws IOException {
        return CreateTableProcedure.createFsLayout(env, hTableDescriptor, newRegions, new CreateHdfsRegions(){

            @Override
            public List<HRegionInfo> createHdfsRegions(MasterProcedureEnv env, Path tableRootDir, TableName tableName, List<HRegionInfo> newRegions) throws IOException {
                HRegionInfo[] regions = newRegions != null ? newRegions.toArray(new HRegionInfo[newRegions.size()]) : null;
                return ModifyRegionUtils.createRegions(env.getMasterConfiguration(), tableRootDir, hTableDescriptor, regions, null);
            }
        });
    }

    protected static List<HRegionInfo> createFsLayout(MasterProcedureEnv env, HTableDescriptor hTableDescriptor, List<HRegionInfo> newRegions, CreateHdfsRegions hdfsRegionHandler) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        Path tempdir = mfs.getTempDir();
        Path tempTableDir = FSUtils.getTableDir(tempdir, hTableDescriptor.getTableName());
        new FSTableDescriptors(env.getMasterConfiguration()).createTableDescriptorForTableDirectory(tempTableDir, hTableDescriptor, false);
        newRegions = hdfsRegionHandler.createHdfsRegions(env, tempdir, hTableDescriptor.getTableName(), newRegions);
        Path tableDir = FSUtils.getTableDir(mfs.getRootDir(), hTableDescriptor.getTableName());
        FileSystem fs = mfs.getFileSystem();
        LOG.info((Object)("Deleting " + tableDir));
        if (!fs.delete(tableDir, true) && fs.exists(tableDir)) {
            throw new IOException("Couldn't delete " + tableDir);
        }
        LOG.info((Object)("Renaming " + tempTableDir + " to " + tableDir));
        if (!fs.rename(tempTableDir, tableDir)) {
            throw new IOException("Unable to move table from temp=" + tempTableDir + " to hbase root=" + tableDir);
        }
        LOG.info((Object)("Done renaming " + tempTableDir));
        return newRegions;
    }

    protected static List<HRegionInfo> addTableToMeta(MasterProcedureEnv env, HTableDescriptor hTableDescriptor, List<HRegionInfo> regions) throws IOException {
        if (regions != null && regions.size() > 0) {
            ProcedureSyncWait.waitMetaRegions(env);
            CreateTableProcedure.addRegionsToMeta(env, hTableDescriptor, regions);
            List<HRegionInfo> newRegions = CreateTableProcedure.addReplicas(env, hTableDescriptor, regions);
            if (hTableDescriptor.getRegionReplication() > 1) {
                ServerRegionReplicaUtil.setupRegionReplicaReplication(env.getMasterConfiguration());
            }
            return newRegions;
        }
        return regions;
    }

    private static List<HRegionInfo> addReplicas(MasterProcedureEnv env, HTableDescriptor hTableDescriptor, List<HRegionInfo> regions) {
        int numRegionReplicas = hTableDescriptor.getRegionReplication() - 1;
        if (numRegionReplicas <= 0) {
            return regions;
        }
        ArrayList<HRegionInfo> hRegionInfos = new ArrayList<HRegionInfo>((numRegionReplicas + 1) * regions.size());
        for (int i = 0; i < regions.size(); ++i) {
            for (int j = 1; j <= numRegionReplicas; ++j) {
                hRegionInfos.add(RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)regions.get(i), (int)j));
            }
        }
        hRegionInfos.addAll(regions);
        return hRegionInfos;
    }

    protected static void assignRegions(MasterProcedureEnv env, TableName tableName, List<HRegionInfo> regions) throws HBaseException, IOException {
        ProcedureSyncWait.waitRegionServers(env);
        AssignmentManager assignmentManager = env.getMasterServices().getAssignmentManager();
        assignmentManager.getTableStateManager().setTableState(tableName, ZooKeeperProtos.Table.State.ENABLING);
        ModifyRegionUtils.assignRegions(assignmentManager, regions);
        assignmentManager.getTableStateManager().setTableState(tableName, ZooKeeperProtos.Table.State.ENABLED);
    }

    protected static void addRegionsToMeta(MasterProcedureEnv env, HTableDescriptor hTableDescriptor, List<HRegionInfo> regionInfos) throws IOException {
        MetaTableAccessor.addRegionsToMeta((Connection)env.getMasterServices().getConnection(), regionInfos, (int)hTableDescriptor.getRegionReplication());
    }

    protected static void updateTableDescCache(MasterProcedureEnv env, TableName tableName) throws IOException {
        env.getMasterServices().getTableDescriptors().get(tableName);
    }

    protected static interface CreateHdfsRegions {
        public List<HRegionInfo> createHdfsRegions(MasterProcedureEnv var1, Path var2, TableName var3, List<HRegionInfo> var4) throws IOException;
    }
}

