/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.procedure.MasterDDLOperationHelper;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.protobuf.generated.TableProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public class DeleteColumnFamilyProcedure
extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.DeleteColumnFamilyState>
implements TableProcedureInterface {
    private static final Log LOG = LogFactory.getLog(DeleteColumnFamilyProcedure.class);
    private final AtomicBoolean aborted = new AtomicBoolean(false);
    private HTableDescriptor unmodifiedHTableDescriptor;
    private TableName tableName;
    private byte[] familyName;
    private boolean hasMob;
    private UserGroupInformation user;
    private List<HRegionInfo> regionInfoList;
    private Boolean traceEnabled;

    public DeleteColumnFamilyProcedure() {
        this.unmodifiedHTableDescriptor = null;
        this.regionInfoList = null;
        this.traceEnabled = null;
    }

    public DeleteColumnFamilyProcedure(MasterProcedureEnv env, TableName tableName, byte[] familyName) throws IOException {
        this.tableName = tableName;
        this.familyName = familyName;
        this.user = env.getRequestUser().getUGI();
        this.setOwner(this.user.getShortUserName());
        this.unmodifiedHTableDescriptor = null;
        this.regionInfoList = null;
        this.traceEnabled = null;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.DeleteColumnFamilyState state) {
        if (this.isTraceEnabled().booleanValue()) {
            LOG.trace((Object)(this + " execute state=" + state));
        }
        try {
            switch (state) {
                case DELETE_COLUMN_FAMILY_PREPARE: {
                    this.prepareDelete(env);
                    this.setNextState(MasterProcedureProtos.DeleteColumnFamilyState.DELETE_COLUMN_FAMILY_PRE_OPERATION);
                    break;
                }
                case DELETE_COLUMN_FAMILY_PRE_OPERATION: {
                    this.preDelete(env, state);
                    this.setNextState(MasterProcedureProtos.DeleteColumnFamilyState.DELETE_COLUMN_FAMILY_UPDATE_TABLE_DESCRIPTOR);
                    break;
                }
                case DELETE_COLUMN_FAMILY_UPDATE_TABLE_DESCRIPTOR: {
                    this.updateTableDescriptor(env);
                    this.setNextState(MasterProcedureProtos.DeleteColumnFamilyState.DELETE_COLUMN_FAMILY_DELETE_FS_LAYOUT);
                    break;
                }
                case DELETE_COLUMN_FAMILY_DELETE_FS_LAYOUT: {
                    this.deleteFromFs(env);
                    this.setNextState(MasterProcedureProtos.DeleteColumnFamilyState.DELETE_COLUMN_FAMILY_POST_OPERATION);
                    break;
                }
                case DELETE_COLUMN_FAMILY_POST_OPERATION: {
                    this.postDelete(env, state);
                    this.setNextState(MasterProcedureProtos.DeleteColumnFamilyState.DELETE_COLUMN_FAMILY_REOPEN_ALL_REGIONS);
                    break;
                }
                case DELETE_COLUMN_FAMILY_REOPEN_ALL_REGIONS: {
                    this.reOpenAllRegionsIfTableIsOnline(env);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException | InterruptedException e) {
            if (!this.isRollbackSupported(state)) {
                LOG.warn((Object)("Error trying to delete the column family " + this.getColumnFamilyName() + " from table " + this.tableName + "(in state=" + state + ")"), (Throwable)e);
            }
            LOG.error((Object)("Error trying to delete the column family " + this.getColumnFamilyName() + " from table " + this.tableName + "(in state=" + state + ")"), (Throwable)e);
            this.setFailure("master-delete-column-family", e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.DeleteColumnFamilyState state) throws IOException {
        if (this.isTraceEnabled().booleanValue()) {
            LOG.trace((Object)(this + " rollback state=" + state));
        }
        try {
            switch (state) {
                case DELETE_COLUMN_FAMILY_REOPEN_ALL_REGIONS: {
                    break;
                }
                case DELETE_COLUMN_FAMILY_POST_OPERATION: {
                    break;
                }
                case DELETE_COLUMN_FAMILY_DELETE_FS_LAYOUT: {
                    throw new UnsupportedOperationException(this + " rollback of state=" + state + " is unsupported.");
                }
                case DELETE_COLUMN_FAMILY_UPDATE_TABLE_DESCRIPTOR: {
                    this.restoreTableDescriptor(env);
                    break;
                }
                case DELETE_COLUMN_FAMILY_PRE_OPERATION: {
                    break;
                }
                case DELETE_COLUMN_FAMILY_PREPARE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed rollback attempt step " + state + " for deleting the column family" + this.getColumnFamilyName() + " to the table " + this.tableName), (Throwable)e);
            throw e;
        }
    }

    protected MasterProcedureProtos.DeleteColumnFamilyState getState(int stateId) {
        return MasterProcedureProtos.DeleteColumnFamilyState.valueOf((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.DeleteColumnFamilyState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.DeleteColumnFamilyState getInitialState() {
        return MasterProcedureProtos.DeleteColumnFamilyState.DELETE_COLUMN_FAMILY_PREPARE;
    }

    protected void setNextState(MasterProcedureProtos.DeleteColumnFamilyState state) {
        if (this.aborted.get() && this.isRollbackSupported(state)) {
            this.setAbortFailure("delete-columnfamily", "abort requested");
        } else {
            super.setNextState((Object)state);
        }
    }

    public boolean abort(MasterProcedureEnv env) {
        this.aborted.set(true);
        return true;
    }

    protected boolean acquireLock(MasterProcedureEnv env) {
        if (!env.isInitialized()) {
            return false;
        }
        return env.getProcedureQueue().tryAcquireTableWrite(this.tableName, EventType.C_M_DELETE_FAMILY.toString());
    }

    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureQueue().releaseTableWrite(this.tableName);
    }

    public void serializeStateData(OutputStream stream) throws IOException {
        super.serializeStateData(stream);
        MasterProcedureProtos.DeleteColumnFamilyStateData.Builder deleteCFMsg = MasterProcedureProtos.DeleteColumnFamilyStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.user)).setTableName(ProtobufUtil.toProtoTableName((TableName)this.tableName)).setColumnfamilyName(ByteStringer.wrap((byte[])this.familyName));
        if (this.unmodifiedHTableDescriptor != null) {
            deleteCFMsg.setUnmodifiedTableSchema(this.unmodifiedHTableDescriptor.convert());
        }
        deleteCFMsg.build().writeDelimitedTo(stream);
    }

    public void deserializeStateData(InputStream stream) throws IOException {
        super.deserializeStateData(stream);
        MasterProcedureProtos.DeleteColumnFamilyStateData deleteCFMsg = MasterProcedureProtos.DeleteColumnFamilyStateData.parseDelimitedFrom((InputStream)stream);
        this.user = MasterProcedureUtil.toUserInfo(deleteCFMsg.getUserInfo());
        this.tableName = ProtobufUtil.toTableName((TableProtos.TableName)deleteCFMsg.getTableName());
        this.familyName = deleteCFMsg.getColumnfamilyName().toByteArray();
        if (deleteCFMsg.hasUnmodifiedTableSchema()) {
            this.unmodifiedHTableDescriptor = HTableDescriptor.convert((HBaseProtos.TableSchema)deleteCFMsg.getUnmodifiedTableSchema());
        }
    }

    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (table=");
        sb.append(this.tableName);
        sb.append(", columnfamily=");
        if (this.familyName != null) {
            sb.append(this.getColumnFamilyName());
        } else {
            sb.append("Unknown");
        }
        sb.append(")");
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.EDIT;
    }

    private void prepareDelete(MasterProcedureEnv env) throws IOException {
        MasterDDLOperationHelper.checkTableModifiable(env, this.tableName);
        this.unmodifiedHTableDescriptor = env.getMasterServices().getTableDescriptors().get(this.tableName);
        if (this.unmodifiedHTableDescriptor == null) {
            throw new IOException("HTableDescriptor missing for " + this.tableName);
        }
        if (!this.unmodifiedHTableDescriptor.hasFamily(this.familyName)) {
            throw new InvalidFamilyOperationException("Family '" + this.getColumnFamilyName() + "' does not exist, so it cannot be deleted");
        }
        if (this.unmodifiedHTableDescriptor.getColumnFamilies().length == 1) {
            throw new InvalidFamilyOperationException("Family '" + this.getColumnFamilyName() + "' is the only column family in the table, so it cannot be deleted");
        }
        this.hasMob = this.unmodifiedHTableDescriptor.getFamily(this.familyName).isMobEnabled();
    }

    private void preDelete(MasterProcedureEnv env, MasterProcedureProtos.DeleteColumnFamilyState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private void updateTableDescriptor(MasterProcedureEnv env) throws IOException {
        LOG.info((Object)("DeleteColumn. Table = " + this.tableName + " family = " + this.getColumnFamilyName()));
        HTableDescriptor htd = env.getMasterServices().getTableDescriptors().get(this.tableName);
        if (!htd.hasFamily(this.familyName)) {
            return;
        }
        htd.removeFamily(this.familyName);
        env.getMasterServices().getTableDescriptors().add(htd);
    }

    private void restoreTableDescriptor(MasterProcedureEnv env) throws IOException {
        env.getMasterServices().getTableDescriptors().add(this.unmodifiedHTableDescriptor);
        this.reOpenAllRegionsIfTableIsOnline(env);
    }

    private void deleteFromFs(MasterProcedureEnv env) throws IOException {
        MasterDDLOperationHelper.deleteColumnFamilyFromFileSystem(env, this.tableName, this.getRegionInfoList(env), this.familyName, this.hasMob);
    }

    private void postDelete(MasterProcedureEnv env, MasterProcedureProtos.DeleteColumnFamilyState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private void reOpenAllRegionsIfTableIsOnline(MasterProcedureEnv env) throws IOException {
        if (!env.getMasterServices().getAssignmentManager().getTableStateManager().isTableState(this.getTableName(), ZooKeeperProtos.Table.State.ENABLED)) {
            return;
        }
        if (MasterDDLOperationHelper.reOpenAllRegions(env, this.getTableName(), this.getRegionInfoList(env))) {
            LOG.info((Object)("Completed delete column family operation on table " + this.getTableName()));
        } else {
            LOG.warn((Object)("Error on reopening the regions on table " + this.getTableName()));
        }
    }

    private Boolean isTraceEnabled() {
        if (this.traceEnabled == null) {
            this.traceEnabled = LOG.isTraceEnabled();
        }
        return this.traceEnabled;
    }

    private String getColumnFamilyName() {
        return Bytes.toString((byte[])this.familyName);
    }

    private void runCoprocessorAction(MasterProcedureEnv env, final MasterProcedureProtos.DeleteColumnFamilyState state) throws IOException, InterruptedException {
        final MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            this.user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    switch (state) {
                        case DELETE_COLUMN_FAMILY_PRE_OPERATION: {
                            cpHost.preDeleteColumnHandler(DeleteColumnFamilyProcedure.this.tableName, DeleteColumnFamilyProcedure.this.familyName);
                            break;
                        }
                        case DELETE_COLUMN_FAMILY_POST_OPERATION: {
                            cpHost.postDeleteColumnHandler(DeleteColumnFamilyProcedure.this.tableName, DeleteColumnFamilyProcedure.this.familyName);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException(this + " unhandled state=" + state);
                        }
                    }
                    return null;
                }
            });
        }
    }

    private boolean isRollbackSupported(MasterProcedureProtos.DeleteColumnFamilyState state) {
        switch (state) {
            case DELETE_COLUMN_FAMILY_DELETE_FS_LAYOUT: 
            case DELETE_COLUMN_FAMILY_POST_OPERATION: 
            case DELETE_COLUMN_FAMILY_REOPEN_ALL_REGIONS: {
                return false;
            }
        }
        return true;
    }

    private List<HRegionInfo> getRegionInfoList(MasterProcedureEnv env) throws IOException {
        if (this.regionInfoList == null) {
            this.regionInfoList = ProcedureSyncWait.getRegionsFromMeta(env, this.getTableName());
        }
        return this.regionInfoList;
    }
}

