/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicyEnforcement;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicyEnforcementFactory;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ActivePolicyEnforcement {
    private final Map<TableName, SpaceViolationPolicyEnforcement> activePolicies;
    private final Map<TableName, SpaceQuotaSnapshot> snapshots;
    private final RegionServerServices rss;
    private final SpaceViolationPolicyEnforcementFactory factory;
    private final Map<TableName, SpaceViolationPolicyEnforcement> locallyCachedPolicies;

    public ActivePolicyEnforcement(Map<TableName, SpaceViolationPolicyEnforcement> activePolicies, Map<TableName, SpaceQuotaSnapshot> snapshots, RegionServerServices rss) {
        this(activePolicies, snapshots, rss, SpaceViolationPolicyEnforcementFactory.getInstance());
    }

    public ActivePolicyEnforcement(Map<TableName, SpaceViolationPolicyEnforcement> activePolicies, Map<TableName, SpaceQuotaSnapshot> snapshots, RegionServerServices rss, SpaceViolationPolicyEnforcementFactory factory) {
        this.activePolicies = activePolicies;
        this.snapshots = snapshots;
        this.rss = rss;
        this.factory = factory;
        this.locallyCachedPolicies = new HashMap<TableName, SpaceViolationPolicyEnforcement>();
    }

    public SpaceViolationPolicyEnforcement getPolicyEnforcement(Region r) {
        return this.getPolicyEnforcement(Objects.requireNonNull(r).getTableDesc().getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpaceViolationPolicyEnforcement getPolicyEnforcement(TableName tableName) {
        SpaceViolationPolicyEnforcement policy = this.activePolicies.get(Objects.requireNonNull(tableName));
        if (policy == null) {
            Map<TableName, SpaceViolationPolicyEnforcement> map = this.locallyCachedPolicies;
            synchronized (map) {
                policy = this.locallyCachedPolicies.get(tableName);
                if (policy != null) {
                    return policy;
                }
                policy = this.factory.createWithoutViolation(this.rss, tableName, this.snapshots.get(tableName));
                this.locallyCachedPolicies.put(tableName, policy);
            }
        }
        return policy;
    }

    public Map<TableName, SpaceViolationPolicyEnforcement> getPolicies() {
        return Collections.unmodifiableMap(this.activePolicies);
    }

    Map<TableName, SpaceViolationPolicyEnforcement> getLocallyCachedPolicies() {
        return Collections.unmodifiableMap(this.locallyCachedPolicies);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.activePolicies;
    }
}

