/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.coprocessor.BaseMasterObserver;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaUtil;

@InterfaceAudience.Private
public class MasterSpaceQuotaObserver
extends BaseMasterObserver {
    public static final String REMOVE_QUOTA_ON_TABLE_DELETE = "hbase.quota.remove.on.table.delete";
    public static final boolean REMOVE_QUOTA_ON_TABLE_DELETE_DEFAULT = true;
    private CoprocessorEnvironment cpEnv;
    private Configuration conf;
    private boolean quotasEnabled = false;

    @Override
    public void start(CoprocessorEnvironment ctx) throws IOException {
        this.cpEnv = ctx;
        this.conf = this.cpEnv.getConfiguration();
        this.quotasEnabled = QuotaUtil.isQuotaEnabled(this.conf);
    }

    @Override
    public void postDeleteTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (!this.quotasEnabled) {
            return;
        }
        MasterServices master = ctx.getEnvironment().getMasterServices();
        ClusterConnection conn = master.getConnection();
        QuotaProtos.Quotas quotas = QuotaUtil.getTableQuota((Connection)master.getConnection(), (TableName)tableName);
        if (quotas != null && quotas.hasSpace()) {
            QuotaSettings settings = QuotaSettingsFactory.removeTableSpaceLimit((TableName)tableName);
            try (Admin admin = conn.getAdmin();){
                admin.setQuota(settings);
            }
        }
    }

    @Override
    public void postDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        if (!this.quotasEnabled) {
            return;
        }
        MasterServices master = ctx.getEnvironment().getMasterServices();
        ClusterConnection conn = master.getConnection();
        QuotaProtos.Quotas quotas = QuotaUtil.getNamespaceQuota((Connection)master.getConnection(), (String)namespace);
        if (quotas != null && quotas.hasSpace()) {
            QuotaSettings settings = QuotaSettingsFactory.removeNamespaceSpaceLimit((String)namespace);
            try (Admin admin = conn.getAdmin();){
                admin.setQuota(settings);
            }
        }
    }
}

