/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshotNotifier;
import org.apache.hadoop.hbase.quotas.TableSpaceQuotaSnapshotNotifier;

@InterfaceAudience.Private
public class SpaceQuotaSnapshotNotifierFactory {
    private static final SpaceQuotaSnapshotNotifierFactory INSTANCE = new SpaceQuotaSnapshotNotifierFactory();
    public static final String SNAPSHOT_NOTIFIER_KEY = "hbase.master.quota.snapshot.notifier.impl";
    public static final Class<? extends SpaceQuotaSnapshotNotifier> SNAPSHOT_NOTIFIER_DEFAULT = TableSpaceQuotaSnapshotNotifier.class;

    private SpaceQuotaSnapshotNotifierFactory() {
    }

    public static SpaceQuotaSnapshotNotifierFactory getInstance() {
        return INSTANCE;
    }

    public SpaceQuotaSnapshotNotifier create(Configuration conf) {
        Class clz = Objects.requireNonNull(conf).getClass(SNAPSHOT_NOTIFIER_KEY, SNAPSHOT_NOTIFIER_DEFAULT, SpaceQuotaSnapshotNotifier.class);
        try {
            return (SpaceQuotaSnapshotNotifier)clz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Failed to instantiate the implementation", e);
        }
    }
}

