/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsTable;
import org.apache.hadoop.hbase.regionserver.MetricsUserAggregate;
import org.apache.hadoop.hbase.regionserver.RegionServerTableMetrics;

@InterfaceStability.Evolving
@InterfaceAudience.Private
public class MetricsRegionServer {
    public static final String RS_ENABLE_TABLE_METRICS_KEY = "hbase.regionserver.enable.table.latencies";
    public static final boolean RS_ENABLE_TABLE_METRICS_DEFAULT = true;
    private final MetricsRegionServerSource serverSource;
    private final MetricsRegionServerWrapper regionServerWrapper;
    private final MetricsTable metricsTable;
    private final RegionServerTableMetrics tableMetrics;
    private final MetricsUserAggregate userAggregate;

    public MetricsRegionServer(Configuration conf, MetricsRegionServerWrapper regionServerWrapper, MetricsTable metricsTable) {
        this(conf, regionServerWrapper, ((MetricsRegionServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class)).createServer(regionServerWrapper), metricsTable, MetricsRegionServer.createTableMetrics(conf));
    }

    MetricsRegionServer(Configuration conf, MetricsRegionServerWrapper regionServerWrapper, MetricsRegionServerSource serverSource, MetricsTable metricsTable, RegionServerTableMetrics tableMetrics) {
        this.regionServerWrapper = regionServerWrapper;
        this.serverSource = serverSource;
        this.userAggregate = new MetricsUserAggregate(conf);
        this.metricsTable = metricsTable;
        this.tableMetrics = tableMetrics;
    }

    static RegionServerTableMetrics createTableMetrics(Configuration conf) {
        if (conf.getBoolean(RS_ENABLE_TABLE_METRICS_KEY, true)) {
            return new RegionServerTableMetrics();
        }
        return null;
    }

    public MetricsRegionServerSource getMetricsSource() {
        return this.serverSource;
    }

    @VisibleForTesting
    public MetricsUserAggregate getMetricsUserAggregate() {
        return this.userAggregate;
    }

    public MetricsRegionServerWrapper getRegionServerWrapper() {
        return this.regionServerWrapper;
    }

    public void updatePut(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updatePut(tn, t);
        }
        if (t > 1000L) {
            this.serverSource.incrSlowPut();
        }
        this.serverSource.updatePut(t);
        this.userAggregate.updatePut(t);
    }

    public void updateDelete(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateDelete(tn, t);
        }
        if (t > 1000L) {
            this.serverSource.incrSlowDelete();
        }
        this.serverSource.updateDelete(t);
        this.userAggregate.updateDelete(t);
    }

    public void updateGet(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateGet(tn, t);
        }
        if (t > 1000L) {
            this.serverSource.incrSlowGet();
        }
        this.serverSource.updateGet(t);
        this.userAggregate.updateGet(t);
    }

    public void updateIncrement(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateIncrement(tn, t);
        }
        if (t > 1000L) {
            this.serverSource.incrSlowIncrement();
        }
        this.serverSource.updateIncrement(t);
        this.userAggregate.updateIncrement(t);
    }

    public void updateAppend(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateAppend(tn, t);
        }
        if (t > 1000L) {
            this.serverSource.incrSlowAppend();
        }
        this.serverSource.updateAppend(t);
        this.userAggregate.updateAppend(t);
    }

    public void updateReplay(long t) {
        this.serverSource.updateReplay(t);
        this.userAggregate.updateReplay(t);
    }

    public void updateScanSize(TableName tn, long scanSize) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateScanSize(tn, scanSize);
        }
        this.serverSource.updateScanSize(scanSize);
    }

    public void updateScanTime(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateScanTime(tn, t);
        }
        this.serverSource.updateScanTime(t);
        this.userAggregate.updateScanTime(t);
    }

    public void updateSplitTime(long t) {
        this.serverSource.updateSplitTime(t);
    }

    public void incrSplitRequest() {
        this.serverSource.incrSplitRequest();
    }

    public void incrSplitSuccess() {
        this.serverSource.incrSplitSuccess();
    }

    public void updateFlush(String table, long t, long memstoreSize, long fileSize) {
        this.serverSource.updateFlushTime(t);
        this.serverSource.updateFlushMemstoreSize(memstoreSize);
        this.serverSource.updateFlushOutputSize(fileSize);
        if (table != null) {
            this.metricsTable.updateFlushTime(table, memstoreSize);
            this.metricsTable.updateFlushMemstoreSize(table, memstoreSize);
            this.metricsTable.updateFlushOutputSize(table, fileSize);
        }
    }

    public void updateCompaction(String table, boolean isMajor, long t, int inputFileCount, int outputFileCount, long inputBytes, long outputBytes) {
        this.serverSource.updateCompactionTime(isMajor, t);
        this.serverSource.updateCompactionInputFileCount(isMajor, (long)inputFileCount);
        this.serverSource.updateCompactionOutputFileCount(isMajor, (long)outputFileCount);
        this.serverSource.updateCompactionInputSize(isMajor, inputBytes);
        this.serverSource.updateCompactionOutputSize(isMajor, outputBytes);
        if (table != null) {
            this.metricsTable.updateCompactionTime(table, isMajor, t);
            this.metricsTable.updateCompactionInputFileCount(table, isMajor, inputFileCount);
            this.metricsTable.updateCompactionOutputFileCount(table, isMajor, outputFileCount);
            this.metricsTable.updateCompactionInputSize(table, isMajor, inputBytes);
            this.metricsTable.updateCompactionOutputSize(table, isMajor, outputBytes);
        }
    }
}

