/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.coprocessor.BaseMasterObserver;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class CoprocessorWhitelistMasterObserver
extends BaseMasterObserver {
    public static final String CP_COPROCESSOR_WHITELIST_PATHS_KEY = "hbase.coprocessor.region.whitelist.paths";
    private static final Log LOG = LogFactory.getLog(CoprocessorWhitelistMasterObserver.class);

    @Override
    public void preModifyTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HTableDescriptor htd) throws IOException {
        this.verifyCoprocessors(ctx, htd);
    }

    @Override
    public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor htd, HRegionInfo[] regions) throws IOException {
        this.verifyCoprocessors(ctx, htd);
    }

    private static boolean validatePath(Path coprocPath, Path wlPath, Configuration conf) throws IOException {
        if (wlPath.toString().equals("*")) {
            return true;
        }
        if (!wlPath.isAbsoluteAndSchemeAuthorityNull()) {
            String wlPathScheme = wlPath.toUri().getScheme();
            String coprocPathScheme = coprocPath.toUri().getScheme();
            String wlPathHost = wlPath.toUri().getHost();
            String coprocPathHost = coprocPath.toUri().getHost();
            wlPathScheme = wlPathScheme != null ? wlPathScheme.toString().toLowerCase() : "";
            wlPathHost = wlPathHost != null ? wlPathHost.toString().toLowerCase() : "";
            coprocPathScheme = coprocPathScheme != null ? coprocPathScheme.toString().toLowerCase() : "";
            coprocPathHost = coprocPathHost != null ? coprocPathHost.toString().toLowerCase() : "";
            if (!wlPathScheme.equals(coprocPathScheme) || !wlPathHost.equals(coprocPathHost)) {
                return false;
            }
        }
        if (wlPath.isRoot()) {
            return true;
        }
        return FilenameUtils.wildcardMatch((String)Path.getPathWithoutSchemeAndAuthority((Path)coprocPath).toString(), (String)Path.getPathWithoutSchemeAndAuthority((Path)wlPath).toString());
    }

    private void verifyCoprocessors(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor htd) throws IOException {
        MasterServices services = ctx.getEnvironment().getMasterServices();
        Configuration conf = services.getConfiguration();
        Collection paths = conf.getStringCollection(CP_COPROCESSOR_WHITELIST_PATHS_KEY);
        List coprocs = htd.getCoprocessors();
        for (int i = 0; i < coprocs.size(); ++i) {
            Matcher matcher;
            String coproc = (String)coprocs.get(i);
            String coprocSpec = Bytes.toString((byte[])htd.getValue(Bytes.toBytes((String)("coprocessor$" + (i + 1)))));
            if (coprocSpec == null || (matcher = HConstants.CP_HTD_ATTR_VALUE_PATTERN.matcher(coprocSpec)) == null || !matcher.matches()) continue;
            String coprocPathStr = matcher.group(1).trim();
            if (coprocPathStr.equals("")) break;
            Path coprocPath = new Path(coprocPathStr);
            String coprocessorClass = matcher.group(2).trim();
            boolean foundPathMatch = false;
            for (String pathStr : paths) {
                Path wlPath = new Path(pathStr);
                try {
                    foundPathMatch = CoprocessorWhitelistMasterObserver.validatePath(coprocPath, wlPath, conf);
                    if (!foundPathMatch) continue;
                    LOG.debug((Object)String.format("Coprocessor %s found in directory %s", coprocessorClass, pathStr));
                    break;
                }
                catch (IOException e) {
                    LOG.warn((Object)String.format("Failed to validate white list path %s for coprocessor path %s", pathStr, coprocPathStr));
                }
            }
            if (foundPathMatch) continue;
            throw new IOException(String.format("Loading %s DENIED in %s", coprocessorClass, CP_COPROCESSOR_WHITELIST_PATHS_KEY));
        }
    }
}

