/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.regionserver;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.StringUtils;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class RegionListTmplImpl
extends AbstractTemplateImpl
implements RegionListTmpl.Intf {
    private final HRegionServer regionServer;
    private final List<HRegionInfo> onlineRegions;

    protected static RegionListTmpl.ImplData __jamon_setOptionalArguments(RegionListTmpl.ImplData p_implData) {
        return p_implData;
    }

    public RegionListTmplImpl(TemplateManager p_templateManager, RegionListTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)RegionListTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.regionServer = p_implData.getRegionServer();
        this.onlineRegions = p_implData.getOnlineRegions();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        if (this.onlineRegions != null && this.onlineRegions.size() > 0) {
            jamonWriter.write("\n\n    ");
            Collections.sort(this.onlineRegions);
            jamonWriter.write("<div class=\"tabbable\">\n        <ul class=\"nav nav-pills\">\n            <li class=\"active\"><a href=\"#tab_regionBaseInfo\" data-toggle=\"tab\">Base Info</a> </li>\n            <li><a href=\"#tab_regionRequestStats\" data-toggle=\"tab\">Request metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionStoreStats\" data-toggle=\"tab\">Storefile Metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionMemstoreStats\" data-toggle=\"tab\">Memstore Metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionCompactStats\" data-toggle=\"tab\">Compaction Metrics</a></li>\n        </ul>\n        <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n            <div class=\"tab-pane active\" id=\"tab_regionBaseInfo\">\n                ");
            this.__jamon_innerUnit__baseInfo(jamonWriter, this.onlineRegions);
            jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionRequestStats\">\n                ");
            this.__jamon_innerUnit__requestStats(jamonWriter, this.onlineRegions);
            jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionStoreStats\">\n                ");
            this.__jamon_innerUnit__storeStats(jamonWriter, this.onlineRegions);
            jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionMemstoreStats\">\n                ");
            this.__jamon_innerUnit__memstoreStats(jamonWriter, this.onlineRegions);
            jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionCompactStats\">\n                ");
            this.__jamon_innerUnit__compactStats(jamonWriter, this.onlineRegions);
            jamonWriter.write("\n            </div>\n        </div>\n    </div>\n    <p>Region names are made of the containing table's name, a comma,\n    the start key, a comma, and a randomly generated region id.  To illustrate,\n    the region named\n    <em>domains,apache.org,5464829424211263407</em> is party to the table\n    <em>domains</em>, has an id of <em>5464829424211263407</em> and the first key\n    in the region is <em>apache.org</em>.  The <em>hbase:meta</em> 'table' is an internal\n    system table (or a 'catalog' table in db-speak).\n    The hbase:meta table keeps a list of all regions in the system. The empty key is used to denote\n    table start and table end.  A region with an empty start key is the first region in a table.\n    If a region has both an empty start key and an empty end key, it's the only region in the\n    table. See <a href=\"http://hbase.org\">HBase Home</a> for further explication.<p>\n");
        } else {
            jamonWriter.write("\n    <p>Not serving regions</p>\n");
        }
        jamonWriter.write("\n\n");
    }

    private void __jamon_innerUnit__baseInfo(Writer jamonWriter, List<HRegionInfo> onlineRegions) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Start Key</th>\n            <th>End Key</th>\n            <th>ReplicaID</th>\n        </tr>\n\n        ");
        for (HRegionInfo r : onlineRegions) {
            jamonWriter.write("\n        <tr>\n            <td><a href=\"region.jsp?name=");
            Escaping.HTML.write(StandardEmitter.valueOf((String)r.getEncodedName()), jamonWriter);
            jamonWriter.write("\">\n              ");
            Escaping.HTML.write(StandardEmitter.valueOf((String)r.getRegionNameAsString()), jamonWriter);
            jamonWriter.write("</a>\n            </td>\n            <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)Bytes.toStringBinary((byte[])r.getStartKey())), jamonWriter);
            jamonWriter.write("</td>\n            <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)Bytes.toStringBinary((byte[])r.getEndKey())), jamonWriter);
            jamonWriter.write("</td>\n            <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((int)r.getReplicaId()), jamonWriter);
            jamonWriter.write("</td>\n        </tr>\n        ");
        }
        jamonWriter.write("\n    </table>\n");
    }

    private void __jamon_innerUnit__storeStats(Writer jamonWriter, List<HRegionInfo> onlineRegions) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Num. Stores</th>\n            <th>Num. Storefiles</th>\n            <th>Storefile Size Uncompressed</th>\n            <th>Storefile Size</th>\n            <th>Index Size</th>\n            <th>Bloom Size</th>\n            <th>Data Locality</th>\n        </tr>\n\n        ");
        for (HRegionInfo r : onlineRegions) {
            jamonWriter.write("\n\n        <tr>\n        ");
            ClusterStatusProtos.RegionLoad load = this.regionServer.createRegionLoad(r.getEncodedName());
            jamonWriter.write("<td><a href=\"region.jsp?name=");
            Escaping.HTML.write(StandardEmitter.valueOf((String)r.getEncodedName()), jamonWriter);
            jamonWriter.write("\">\n              ");
            Escaping.HTML.write(StandardEmitter.valueOf((String)r.getRegionNameAsString()), jamonWriter);
            jamonWriter.write("</a>\n            </td>\n            ");
            if (load != null) {
                jamonWriter.write("\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((int)load.getStores()), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((int)load.getStorefiles()), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.TraditionalBinaryPrefix.long2String((long)((long)load.getStoreUncompressedSizeMB() * StringUtils.TraditionalBinaryPrefix.MEGA.value), (String)"B", (int)1)), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.TraditionalBinaryPrefix.long2String((long)((long)load.getStorefileSizeMB() * StringUtils.TraditionalBinaryPrefix.MEGA.value), (String)"B", (int)1)), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.TraditionalBinaryPrefix.long2String((long)((long)load.getTotalStaticIndexSizeKB() * StringUtils.TraditionalBinaryPrefix.KILO.value), (String)"B", (int)1)), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.TraditionalBinaryPrefix.long2String((long)((long)load.getTotalStaticBloomSizeKB() * StringUtils.TraditionalBinaryPrefix.KILO.value), (String)"B", (int)1)), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((float)load.getDataLocality()), jamonWriter);
                jamonWriter.write("</td>\n            ");
            }
            jamonWriter.write("\n        </tr>\n        ");
        }
        jamonWriter.write("\n    </table>\n");
    }

    private void __jamon_innerUnit__requestStats(Writer jamonWriter, List<HRegionInfo> onlineRegions) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Read Request Count</th>\n            <th>Write Request Count</th>\n        </tr>\n\n        ");
        for (HRegionInfo r : onlineRegions) {
            jamonWriter.write("\n\n        <tr>\n        ");
            ClusterStatusProtos.RegionLoad load = this.regionServer.createRegionLoad(r.getEncodedName());
            jamonWriter.write("<td><a href=\"region.jsp?name=");
            Escaping.HTML.write(StandardEmitter.valueOf((String)r.getEncodedName()), jamonWriter);
            jamonWriter.write("\">\n              ");
            Escaping.HTML.write(StandardEmitter.valueOf((String)r.getRegionNameAsString()), jamonWriter);
            jamonWriter.write("</a>\n            </td>\n            ");
            if (load != null) {
                jamonWriter.write("\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((long)load.getReadRequestsCount()), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((long)load.getWriteRequestsCount()), jamonWriter);
                jamonWriter.write("</td>\n            ");
            }
            jamonWriter.write("\n        </tr>\n        ");
        }
        jamonWriter.write("\n    </table>\n");
    }

    private void __jamon_innerUnit__memstoreStats(Writer jamonWriter, List<HRegionInfo> onlineRegions) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Memstore Size</th>\n        </tr>\n\n        ");
        for (HRegionInfo r : onlineRegions) {
            jamonWriter.write("\n\n        <tr>\n        ");
            ClusterStatusProtos.RegionLoad load = this.regionServer.createRegionLoad(r.getEncodedName());
            jamonWriter.write("<td><a href=\"region.jsp?name=");
            Escaping.HTML.write(StandardEmitter.valueOf((String)r.getEncodedName()), jamonWriter);
            jamonWriter.write("\">\n              ");
            Escaping.HTML.write(StandardEmitter.valueOf((String)r.getRegionNameAsString()), jamonWriter);
            jamonWriter.write("</a>\n            </td>\n            ");
            if (load != null) {
                jamonWriter.write("\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.TraditionalBinaryPrefix.long2String((long)((long)load.getMemstoreSizeMB() * StringUtils.TraditionalBinaryPrefix.MEGA.value), (String)"B", (int)1)), jamonWriter);
                jamonWriter.write("</td>\n            ");
            }
            jamonWriter.write("\n        </tr>\n        ");
        }
        jamonWriter.write("\n    </table>\n");
    }

    private void __jamon_innerUnit__compactStats(Writer jamonWriter, List<HRegionInfo> onlineRegions) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Num. Compacting KVs</th>\n            <th>Num. Compacted KVs</th>\n            <th>Compaction Progress</th>\n        </tr>\n\n        ");
        for (HRegionInfo r : onlineRegions) {
            jamonWriter.write("\n\n        <tr>\n        ");
            ClusterStatusProtos.RegionLoad load = this.regionServer.createRegionLoad(r.getEncodedName());
            String percentDone = "";
            if (load != null && load.getTotalCompactingKVs() > 0L) {
                percentDone = String.format("%.2f", Float.valueOf(100.0f * ((float)load.getCurrentCompactedKVs() / (float)load.getTotalCompactingKVs()))) + "%";
            }
            jamonWriter.write("<td><a href=\"region.jsp?name=");
            Escaping.HTML.write(StandardEmitter.valueOf((String)r.getEncodedName()), jamonWriter);
            jamonWriter.write("\">\n              ");
            Escaping.HTML.write(StandardEmitter.valueOf((String)r.getRegionNameAsString()), jamonWriter);
            jamonWriter.write("</a>\n            </td>\n            ");
            if (load != null) {
                jamonWriter.write("\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((long)load.getTotalCompactingKVs()), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((long)load.getCurrentCompactedKVs()), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)percentDone), jamonWriter);
                jamonWriter.write("</td>\n            ");
            }
            jamonWriter.write("\n        </tr>\n        ");
        }
        jamonWriter.write("\n    </table>\n");
    }
}

