/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Comparator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class StealJobQueue<T>
extends PriorityBlockingQueue<T> {
    private static final long serialVersionUID = -6334572230936888291L;
    private BlockingQueue<T> stealFromQueue;
    private final Lock lock = new ReentrantLock();
    private final transient Condition notEmpty = this.lock.newCondition();

    public StealJobQueue(Comparator<? super T> comparator) {
        this.stealFromQueue = new PriorityBlockingQueue<T>(11, comparator){
            private static final long serialVersionUID = -7070010365201826904L;

            @Override
            public boolean offer(T t) {
                StealJobQueue.this.lock.lock();
                try {
                    StealJobQueue.this.notEmpty.signal();
                    boolean bl = super.offer(t);
                    return bl;
                }
                finally {
                    StealJobQueue.this.lock.unlock();
                }
            }
        };
    }

    public StealJobQueue(int initCapacity, int stealFromQueueInitCapacity, Comparator<? super T> comparator) {
        super(initCapacity, comparator);
        this.stealFromQueue = new PriorityBlockingQueue<T>(stealFromQueueInitCapacity, comparator){
            private static final long serialVersionUID = -6805567216580184701L;

            @Override
            public boolean offer(T t) {
                StealJobQueue.this.lock.lock();
                try {
                    StealJobQueue.this.notEmpty.signal();
                    boolean bl = super.offer(t);
                    return bl;
                }
                finally {
                    StealJobQueue.this.lock.unlock();
                }
            }
        };
    }

    public BlockingQueue<T> getStealFromQueue() {
        return this.stealFromQueue;
    }

    @Override
    public boolean offer(T t) {
        this.lock.lock();
        try {
            this.notEmpty.signal();
            boolean bl = super.offer(t);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public T take() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (true) {
                Object retVal;
                if ((retVal = this.poll()) == null) {
                    retVal = this.stealFromQueue.poll();
                }
                if (retVal != null) {
                    Object e = retVal;
                    return (T)e;
                }
                this.notEmpty.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        this.lock.lockInterruptibly();
        try {
            while (true) {
                Object retVal;
                if ((retVal = this.poll()) == null) {
                    retVal = this.stealFromQueue.poll();
                }
                if (retVal == null) {
                    if (nanos <= 0L) {
                        T t = null;
                        return t;
                    }
                } else {
                    Object e = retVal;
                    return (T)e;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

