/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import com.google.protobuf.Message;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class RegionServerTracker
extends ZooKeeperListener {
    private static final Log LOG = LogFactory.getLog(RegionServerTracker.class);
    private NavigableMap<ServerName, HBaseProtos.RegionServerInfo> regionServers = new TreeMap<ServerName, HBaseProtos.RegionServerInfo>();
    private ServerManager serverManager;
    private MasterServices server;

    public RegionServerTracker(ZooKeeperWatcher watcher, MasterServices server, ServerManager serverManager) {
        super(watcher);
        this.server = server;
        this.serverManager = serverManager;
    }

    public void start() throws KeeperException, IOException {
        this.watcher.registerListener((ZooKeeperListener)this);
        List servers = ZKUtil.listChildrenAndWatchThem((ZooKeeperWatcher)this.watcher, (String)this.watcher.rsZNode);
        this.refresh(servers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(List<String> servers) throws IOException {
        NavigableMap<ServerName, HBaseProtos.RegionServerInfo> navigableMap = this.regionServers;
        synchronized (navigableMap) {
            this.regionServers.clear();
            for (String n : servers) {
                ServerName sn = ServerName.parseServerName((String)ZKUtil.getNodeName((String)n));
                if (this.regionServers.get(sn) != null) continue;
                HBaseProtos.RegionServerInfo.Builder rsInfoBuilder = HBaseProtos.RegionServerInfo.newBuilder();
                try {
                    String nodePath = ZKUtil.joinZNode((String)this.watcher.rsZNode, (String)n);
                    byte[] data = ZKUtil.getData((ZooKeeperWatcher)this.watcher, (String)nodePath);
                    if (data != null && data.length > 0 && ProtobufUtil.isPBMagicPrefix((byte[])data)) {
                        int magicLen = ProtobufUtil.lengthOfPBMagic();
                        ProtobufUtil.mergeFrom((Message.Builder)rsInfoBuilder, (byte[])data, (int)magicLen, (int)(data.length - magicLen));
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Added tracking of RS " + nodePath));
                    }
                }
                catch (KeeperException e) {
                    LOG.warn((Object)"Get Rs info port from ephemeral node", (Throwable)e);
                }
                catch (IOException e) {
                    LOG.warn((Object)"Illegal data from ephemeral node", (Throwable)e);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
                this.regionServers.put(sn, rsInfoBuilder.build());
            }
        }
        if (this.server.isInitialized()) {
            this.server.checkIfShouldMoveSystemRegionAsync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ServerName sn) {
        NavigableMap<ServerName, HBaseProtos.RegionServerInfo> navigableMap = this.regionServers;
        synchronized (navigableMap) {
            this.regionServers.remove(sn);
        }
    }

    public void nodeDeleted(String path) {
        if (path.startsWith(this.watcher.rsZNode)) {
            String serverName = ZKUtil.getNodeName((String)path);
            LOG.info((Object)("RegionServer ephemeral node deleted, processing expiration [" + serverName + "]"));
            ServerName sn = ServerName.parseServerName((String)serverName);
            if (!this.serverManager.isServerOnline(sn)) {
                LOG.warn((Object)(serverName.toString() + " is not online or isn't known to the master." + "The latter could be caused by a DNS misconfiguration."));
                return;
            }
            this.remove(sn);
            this.serverManager.expireServer(sn);
        }
    }

    public void nodeChildrenChanged(String path) {
        if (path.equals(this.watcher.rsZNode) && !this.server.isAborted() && !this.server.isStopped()) {
            try {
                List servers = ZKUtil.listChildrenAndWatchThem((ZooKeeperWatcher)this.watcher, (String)this.watcher.rsZNode);
                this.refresh(servers);
            }
            catch (IOException e) {
                this.server.abort("Unexpected zk exception getting RS nodes", e);
            }
            catch (KeeperException e) {
                this.server.abort("Unexpected zk exception getting RS nodes", e);
            }
        }
    }

    public HBaseProtos.RegionServerInfo getRegionServerInfo(ServerName sn) {
        return (HBaseProtos.RegionServerInfo)this.regionServers.get(sn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerName> getOnlineServers() {
        NavigableMap<ServerName, HBaseProtos.RegionServerInfo> navigableMap = this.regionServers;
        synchronized (navigableMap) {
            return new ArrayList<ServerName>(this.regionServers.keySet());
        }
    }
}

