/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public abstract class RpcExecutor {
    private static final Log LOG = LogFactory.getLog(RpcExecutor.class);
    private final AtomicInteger activeHandlerCount = new AtomicInteger(0);
    private final List<Handler> handlers;
    private final int handlerCount;
    private final String name;
    private final AtomicInteger failedHandlerCount = new AtomicInteger(0);
    private boolean running;
    private Configuration conf = null;
    private Abortable abortable = null;
    private static QueueBalancer ONE_QUEUE = new QueueBalancer(){

        @Override
        public int getNextQueue() {
            return 0;
        }
    };

    public RpcExecutor(String name, int handlerCount) {
        this.handlers = new ArrayList<Handler>(handlerCount);
        this.handlerCount = handlerCount;
        this.name = Strings.nullToEmpty((String)name);
    }

    public RpcExecutor(String name, int handlerCount, Configuration conf, Abortable abortable) {
        this(name, handlerCount);
        this.conf = conf;
        this.abortable = abortable;
    }

    public void start(int port) {
        this.running = true;
        this.startHandlers(port);
    }

    public void stop() {
        this.running = false;
        for (Thread thread : this.handlers) {
            thread.interrupt();
        }
    }

    public abstract boolean dispatch(CallRunner var1) throws InterruptedException;

    protected abstract List<BlockingQueue<CallRunner>> getQueues();

    protected void startHandlers(int port) {
        List<BlockingQueue<CallRunner>> callQueues = this.getQueues();
        this.startHandlers(null, this.handlerCount, callQueues, 0, callQueues.size(), port, this.activeHandlerCount);
    }

    protected Handler getHandler(String name, double handlerFailureThreshhold, BlockingQueue<CallRunner> q, AtomicInteger activeHandlerCount) {
        return new Handler(name, handlerFailureThreshhold, q, activeHandlerCount);
    }

    protected void startHandlers(String nameSuffix, int numHandlers, List<BlockingQueue<CallRunner>> callQueues, int qindex, int qsize, int port, AtomicInteger activeHandlerCount) {
        String threadPrefix = this.name + Strings.nullToEmpty((String)nameSuffix);
        double handlerFailureThreshhold = this.conf == null ? 1.0 : this.conf.getDouble("hbase.regionserver.handler.abort.on.error.percent", 0.5);
        for (int i = 0; i < numHandlers; ++i) {
            int index = qindex + i % qsize;
            String name = "RpcServer." + threadPrefix + ".handler=" + this.handlers.size() + ",queue=" + index + ",port=" + port;
            Handler handler = this.getHandler(name, handlerFailureThreshhold, callQueues.get(index), activeHandlerCount);
            handler.start();
            LOG.debug((Object)("Started " + name));
            this.handlers.add(handler);
        }
    }

    public static QueueBalancer getBalancer(int queueSize) {
        Preconditions.checkArgument((queueSize > 0 ? 1 : 0) != 0, (Object)"Queue size is <= 0, must be at least 1");
        if (queueSize == 1) {
            return ONE_QUEUE;
        }
        return new RandomQueueBalancer(queueSize);
    }

    public int getActiveHandlerCount() {
        return this.activeHandlerCount.get();
    }

    public int getActiveWriteHandlerCount() {
        return 0;
    }

    public int getActiveReadHandlerCount() {
        return 0;
    }

    public int getActiveScanHandlerCount() {
        return 0;
    }

    public abstract int getQueueLength();

    public int getReadQueueLength() {
        return 0;
    }

    public int getScanQueueLength() {
        return 0;
    }

    public int getWriteQueueLength() {
        return 0;
    }

    private static class RandomQueueBalancer
    extends QueueBalancer {
        private final int queueSize;

        public RandomQueueBalancer(int queueSize) {
            this.queueSize = queueSize;
        }

        @Override
        public int getNextQueue() {
            return ThreadLocalRandom.current().nextInt(this.queueSize);
        }
    }

    public static abstract class QueueBalancer {
        public abstract int getNextQueue();
    }

    protected class Handler
    extends Thread {
        final BlockingQueue<CallRunner> q;
        final double handlerFailureThreshhold;
        final AtomicInteger activeHandlerCount;

        Handler(String name, double handlerFailureThreshhold, BlockingQueue<CallRunner> q, AtomicInteger activeHandlerCount) {
            super(name);
            this.setDaemon(true);
            this.q = q;
            this.handlerFailureThreshhold = handlerFailureThreshhold;
            this.activeHandlerCount = activeHandlerCount;
        }

        protected CallRunner getCallRunner() throws InterruptedException {
            return this.q.take();
        }

        @Override
        public void run() {
            boolean interrupted = false;
            try {
                while (RpcExecutor.this.running) {
                    try {
                        this.run(this.getCallRunner());
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)e);
                throw e;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void run(CallRunner cr) {
            MonitoredRPCHandler status = RpcServer.getStatus();
            cr.setStatus(status);
            try {
                this.activeHandlerCount.incrementAndGet();
                cr.run();
                return;
            }
            catch (Throwable e) {
                if (!(e instanceof Error)) {
                    LOG.warn((Object)("Handler  exception " + StringUtils.stringifyException((Throwable)e)));
                    return;
                }
                int failedCount = RpcExecutor.this.failedHandlerCount.incrementAndGet();
                if (this.handlerFailureThreshhold >= 0.0 && (double)failedCount > (double)RpcExecutor.this.handlerCount * this.handlerFailureThreshhold) {
                    String message = "Number of failed RpcServer handler runs exceeded threshhold " + this.handlerFailureThreshhold + "; reason: " + StringUtils.stringifyException((Throwable)e);
                    if (RpcExecutor.this.abortable != null) {
                        RpcExecutor.this.abortable.abort(message, e);
                        return;
                    }
                    LOG.error((Object)("Error but can't abort because abortable is null: " + StringUtils.stringifyException((Throwable)e)));
                    throw e;
                }
                LOG.warn((Object)("Handler errors " + StringUtils.stringifyException((Throwable)e)));
                return;
            }
            finally {
                this.activeHandlerCount.decrementAndGet();
            }
        }
    }
}

