/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;

@InterfaceAudience.Private
class RegionUnassigner {
    private static final Log LOG = LogFactory.getLog(RegionUnassigner.class);
    private final RegionServerServices rsServices;
    private final HRegionInfo regionInfo;
    private boolean unassigning = false;

    RegionUnassigner(RegionServerServices rsServices, HRegionInfo regionInfo) {
        this.rsServices = rsServices;
        this.regionInfo = regionInfo;
    }

    synchronized void unassign() {
        if (this.unassigning) {
            return;
        }
        this.unassigning = true;
        new Thread("Unassign-" + this.regionInfo){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOG.info((Object)("Unassign " + RegionUnassigner.this.regionInfo.getRegionNameAsString()));
                try {
                    RegionUnassigner.this.rsServices.unassign(RegionUnassigner.this.regionInfo.getRegionName());
                }
                catch (IOException e) {
                    LOG.warn((Object)("Unassigned " + RegionUnassigner.this.regionInfo.getRegionNameAsString() + " failed"), (Throwable)e);
                }
                finally {
                    RegionUnassigner regionUnassigner = RegionUnassigner.this;
                    synchronized (regionUnassigner) {
                        RegionUnassigner.this.unassigning = false;
                    }
                }
            }
        }.start();
    }
}

