/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class RegionMover
extends AbstractHBaseTool {
    public static final String MOVE_RETRIES_MAX_KEY = "hbase.move.retries.max";
    public static final String MOVE_WAIT_MAX_KEY = "hbase.move.wait.max";
    public static final String SERVERSTART_WAIT_MAX_KEY = "hbase.serverstart.wait.max";
    public static final int DEFAULT_MOVE_RETRIES_MAX = 5;
    public static final int DEFAULT_MOVE_WAIT_MAX = 60;
    public static final int DEFAULT_SERVERSTART_WAIT_MAX = 180;
    static final Logger LOG = LoggerFactory.getLogger(RegionMover.class);
    private RegionMoverBuilder rmbuilder;
    private boolean ack = true;
    private int maxthreads = 1;
    private int timeout;
    private String loadUnload;
    private String hostname;
    private String filename;
    private String excludeFile;
    private int port;

    private RegionMover(RegionMoverBuilder builder) {
        this.hostname = builder.hostname;
        this.filename = builder.filename;
        this.excludeFile = builder.excludeFile;
        this.maxthreads = builder.maxthreads;
        this.ack = builder.ack;
        this.port = builder.port;
        this.timeout = builder.timeout;
        this.setConf(builder.conf);
    }

    private RegionMover() {
    }

    public boolean load() throws ExecutionException, InterruptedException, TimeoutException {
        ExecutorService loadPool = Executors.newFixedThreadPool(1);
        Future<Boolean> loadTask = loadPool.submit(new Load(this));
        loadPool.shutdown();
        try {
            if (!loadPool.awaitTermination(this.timeout, TimeUnit.SECONDS)) {
                LOG.warn("Timed out before finishing the loading operation. Timeout:" + this.timeout + "sec");
                loadPool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            loadPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
        try {
            return loadTask.get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while loading Regions on " + this.hostname, (Throwable)e);
            throw e;
        }
        catch (ExecutionException e) {
            LOG.error("Error while loading regions on RegionServer " + this.hostname, (Throwable)e);
            throw e;
        }
    }

    public boolean unload() throws InterruptedException, ExecutionException, TimeoutException {
        this.deleteFile(this.filename);
        ExecutorService unloadPool = Executors.newFixedThreadPool(1);
        Future<Boolean> unloadTask = unloadPool.submit(new Unload(this));
        unloadPool.shutdown();
        try {
            if (!unloadPool.awaitTermination(this.timeout, TimeUnit.SECONDS)) {
                LOG.warn("Timed out before finishing the unloading operation. Timeout:" + this.timeout + "sec");
                unloadPool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            unloadPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
        try {
            return unloadTask.get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while unloading Regions from " + this.hostname, (Throwable)e);
            throw e;
        }
        catch (ExecutionException e) {
            LOG.error("Error while unloading regions from RegionServer " + this.hostname, (Throwable)e);
            throw e;
        }
    }

    private void loadRegions(Admin admin, String hostname, int port, List<RegionInfo> regionsToMove, boolean ack) throws Exception {
        String server = null;
        List<RegionInfo> movedRegions = Collections.synchronizedList(new ArrayList());
        int maxWaitInSeconds = admin.getConfiguration().getInt(SERVERSTART_WAIT_MAX_KEY, 180);
        long maxWait = EnvironmentEdgeManager.currentTime() + (long)(maxWaitInSeconds * 1000);
        while (EnvironmentEdgeManager.currentTime() < maxWait && server == null) {
            try {
                ArrayList<String> regionServers = this.getServers(admin);
                server = this.stripServer(regionServers, hostname, port);
                if (server != null) {
                    break;
                }
            }
            catch (IOException e) {
                LOG.warn("Could not get list of region servers", (Throwable)e);
            }
            catch (Exception e) {
                LOG.info("hostname=" + hostname + " is not up yet, waiting");
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted while waiting for " + hostname + " to be up.Quitting now", (Throwable)e);
                throw e;
            }
        }
        if (server == null) {
            LOG.error("Host:" + hostname + " is not up.Giving up.");
            throw new Exception("Host to load regions not online");
        }
        LOG.info("Moving " + regionsToMove.size() + " regions to " + server + " using " + this.maxthreads + " threads.Ack mode:" + this.ack);
        ExecutorService moveRegionsPool = Executors.newFixedThreadPool(this.maxthreads);
        ArrayList<Future<Boolean>> taskList = new ArrayList<Future<Boolean>>();
        int counter = 0;
        while (counter < regionsToMove.size()) {
            Future<Boolean> task;
            RegionInfo region = regionsToMove.get(counter);
            String currentServer = this.getServerNameForRegion(admin, region);
            if (currentServer == null) {
                LOG.warn("Could not get server for Region:" + region.getEncodedName() + " moving on");
                ++counter;
                continue;
            }
            if (server.equals(currentServer)) {
                LOG.info("Region " + region.getRegionNameAsString() + " is already on target server=" + server);
                ++counter;
                continue;
            }
            if (ack) {
                task = moveRegionsPool.submit(new MoveWithAck(admin, region, currentServer, server, movedRegions));
                taskList.add(task);
            } else {
                task = moveRegionsPool.submit(new MoveWithoutAck(admin, region, currentServer, server, movedRegions));
                taskList.add(task);
            }
            ++counter;
        }
        moveRegionsPool.shutdown();
        long timeoutInSeconds = (long)regionsToMove.size() * admin.getConfiguration().getLong(MOVE_WAIT_MAX_KEY, 60L);
        try {
            if (!moveRegionsPool.awaitTermination(timeoutInSeconds, TimeUnit.SECONDS)) {
                moveRegionsPool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            moveRegionsPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
        for (Future future : taskList) {
            try {
                if (((Boolean)future.get(5L, TimeUnit.SECONDS)).booleanValue()) continue;
                LOG.error("Was Not able to move region....Exiting Now");
                throw new Exception("Could not move region Exception");
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted while waiting for Thread to Complete " + e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (ExecutionException e) {
                LOG.error("Got Exception From Thread While moving region " + e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (CancellationException e) {
                LOG.error("Thread for moving region cancelled. Timeout for cancellation:" + timeoutInSeconds + "secs", (Throwable)e);
                throw e;
            }
        }
    }

    /*
     * Exception decompiling
     */
    @SuppressWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="FB is wrong; its size is read")
    private void unloadRegions(Admin admin, String server, ArrayList<String> regionServers, boolean ack, List<RegionInfo> movedRegions) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP], 8[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<RegionInfo> readRegionsFromFile(String filename) throws IOException {
        ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>();
        File f = new File(filename);
        if (!f.exists()) {
            return regions;
        }
        FileInputStream fis = null;
        FilterInputStream dis = null;
        try {
            fis = new FileInputStream(f);
            dis = new DataInputStream(fis);
            int numRegions = ((DataInputStream)dis).readInt();
            for (int index = 0; index < numRegions; ++index) {
                regions.add(RegionInfo.parseFromOrNull((byte[])Bytes.readByteArray((DataInput)((Object)dis))));
            }
        }
        catch (IOException e) {
            LOG.error("Error while reading regions from file:" + filename, (Throwable)e);
            throw e;
        }
        finally {
            if (dis != null) {
                dis.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return regions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RegionInfo> getRegions(Configuration conf, String server) throws IOException {
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
            List list = conn.getAdmin().getRegions(ServerName.valueOf((String)server));
            return list;
        }
    }

    private void writeFile(String filename, List<RegionInfo> movedRegions) throws IOException {
        FileOutputStream fos = null;
        FilterOutputStream dos = null;
        try {
            fos = new FileOutputStream(filename);
            dos = new DataOutputStream(fos);
            ((DataOutputStream)dos).writeInt(movedRegions.size());
            for (RegionInfo region : movedRegions) {
                Bytes.writeByteArray((DataOutput)((Object)dos), (byte[])RegionInfo.toByteArray((RegionInfo)region));
            }
        }
        catch (IOException e) {
            LOG.error("ERROR: Was Not able to write regions moved to output file but moved " + movedRegions.size() + " regions", (Throwable)e);
            throw e;
        }
        finally {
            if (dos != null) {
                dos.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    private void stripExcludes(ArrayList<String> regionServers, String excludeFile) throws IOException {
        if (excludeFile != null) {
            ArrayList<String> excludes = this.readExcludes(excludeFile);
            Iterator<String> i = regionServers.iterator();
            while (i.hasNext()) {
                String rs = i.next();
                String rsPort = rs.split(",")[0] + ":" + rs.split(",")[1];
                if (!excludes.contains(rsPort)) continue;
                i.remove();
            }
            LOG.info("Valid Region server targets are:" + regionServers.toString());
            LOG.info("Excluded Servers are" + excludes.toString());
        }
    }

    private void stripMaster(ArrayList<String> regionServers, Admin admin) throws IOException {
        ServerName master = admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.MASTER)).getMasterName();
        String masterHostname = master.getHostname();
        int masterPort = master.getPort();
        try {
            this.stripServer(regionServers, masterHostname, masterPort);
        }
        catch (Exception e) {
            LOG.warn("Could not remove master from list of RS", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> readExcludes(String excludeFile) throws IOException {
        ArrayList<String> excludeServers = new ArrayList<String>();
        if (excludeFile == null) {
            return excludeServers;
        }
        File f = new File(excludeFile);
        try (BufferedReader br = null;){
            String line;
            br = new BufferedReader(new FileReader(f));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).equals("")) continue;
                excludeServers.add(line);
            }
        }
        return excludeServers;
    }

    private String stripServer(ArrayList<String> regionServers, String hostname, int port) throws Exception {
        String server = null;
        String portString = Integer.toString(port);
        Iterator<String> i = regionServers.iterator();
        int noOfRs = regionServers.size();
        while (i.hasNext()) {
            server = i.next();
            String[] splitServer = server.split(",");
            if (!splitServer[0].equalsIgnoreCase(hostname) || !splitServer[1].equals(portString)) continue;
            i.remove();
            return server;
        }
        if (regionServers.size() >= noOfRs) {
            throw new Exception("Server " + hostname + ":" + Integer.toString(port) + " is not in list of online servers(Offline/Incorrect)");
        }
        return server;
    }

    private ArrayList<String> getServers(Admin admin) throws IOException {
        ArrayList serverInfo = new ArrayList(admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet());
        ArrayList<String> regionServers = new ArrayList<String>(serverInfo.size());
        for (ServerName server : serverInfo) {
            regionServers.add(server.getServerName().toLowerCase());
        }
        return regionServers;
    }

    private void deleteFile(String filename) {
        File f = new File(filename);
        if (f.exists()) {
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void isSuccessfulScan(Admin admin, RegionInfo region) throws IOException {
        Scan scan = new Scan(region.getStartKey());
        scan.setBatch(1);
        scan.setCaching(1);
        scan.setFilter((Filter)new FirstKeyOnlyFilter());
        try (Table table = admin.getConnection().getTable(region.getTable());
             ResultScanner scanner = table.getScanner(scan);){
            scanner.next();
        }
        catch (IOException e) {
            LOG.error("Could not scan region:" + region.getEncodedName(), (Throwable)e);
            throw e;
        }
    }

    private boolean isSameServer(Admin admin, RegionInfo region, String serverName) throws IOException {
        String serverForRegion = this.getServerNameForRegion(admin, region);
        return serverForRegion != null && serverForRegion.equals(serverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getServerNameForRegion(Admin admin, RegionInfo region) throws IOException {
        String server = null;
        if (!admin.isTableEnabled(region.getTable())) {
            return null;
        }
        if (region.isMetaRegion()) {
            ZKWatcher zkw = new ZKWatcher(admin.getConfiguration(), "region_mover", null);
            MetaTableLocator locator = new MetaTableLocator();
            int maxWaitInSeconds = admin.getConfiguration().getInt(MOVE_WAIT_MAX_KEY, 60);
            try {
                server = locator.waitMetaRegionLocation(zkw, (long)(maxWaitInSeconds * 1000)).toString();
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted while waiting for location of Meta", (Throwable)e);
            }
            finally {
                if (zkw != null) {
                    zkw.close();
                }
            }
        } else {
            try (Table table = admin.getConnection().getTable(TableName.META_TABLE_NAME);){
                Get get = new Get(region.getRegionName());
                get.addColumn(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                get.addColumn(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER);
                Result result = table.get(get);
                if (result != null) {
                    byte[] servername = result.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                    byte[] startcode = result.getValue(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER);
                    if (servername != null) {
                        server = Bytes.toString((byte[])servername).replaceFirst(":", ",").toLowerCase() + "," + Bytes.toLong((byte[])startcode);
                    }
                }
            }
        }
        return server;
    }

    protected void addOptions() {
        this.addRequiredOptWithArg("r", "regionserverhost", "region server <hostname>|<hostname:port>");
        this.addRequiredOptWithArg("o", "operation", "Expected: load/unload");
        this.addOptWithArg("m", "maxthreads", "Define the maximum number of threads to use to unload and reload the regions");
        this.addOptWithArg("x", "excludefile", "File with <hostname:port> per line to exclude as unload targets; default excludes only target host; useful for rack decommisioning.");
        this.addOptWithArg("f", "filename", "File to save regions list into unloading, or read from loading; default /tmp/<usernamehostname:port>");
        this.addOptNoArg("n", "noack", "Turn on No-Ack mode(default: false) which won't check if region is online on target RegionServer, hence best effort. This is more performant in unloading and loading but might lead to region being unavailable for some time till master reassigns it in case the move failed");
        this.addOptWithArg("t", "timeout", "timeout in seconds after which the tool will exit irrespective of whether it finished or not;default Integer.MAX_VALUE");
    }

    protected void processOptions(CommandLine cmd) {
        String hostname = cmd.getOptionValue("r");
        this.rmbuilder = new RegionMoverBuilder(hostname);
        if (cmd.hasOption('m')) {
            this.rmbuilder.maxthreads(Integer.parseInt(cmd.getOptionValue('m')));
        }
        if (cmd.hasOption('n')) {
            this.rmbuilder.ack(false);
        }
        if (cmd.hasOption('f')) {
            this.rmbuilder.filename(cmd.getOptionValue('f'));
        }
        if (cmd.hasOption('x')) {
            this.rmbuilder.excludeFile(cmd.getOptionValue('x'));
        }
        if (cmd.hasOption('t')) {
            this.rmbuilder.timeout(Integer.parseInt(cmd.getOptionValue('t')));
        }
        this.loadUnload = cmd.getOptionValue("o").toLowerCase(Locale.ROOT);
    }

    protected int doWork() throws Exception {
        boolean success;
        RegionMover rm = this.rmbuilder.build();
        if (this.loadUnload.equalsIgnoreCase("load")) {
            success = rm.load();
        } else if (this.loadUnload.equalsIgnoreCase("unload")) {
            success = rm.unload();
        } else {
            this.printUsage();
            success = false;
        }
        return success ? 0 : 1;
    }

    public static void main(String[] args) {
        new RegionMover().doStaticMain(args);
    }

    private static class MoveWithoutAck
    implements Callable<Boolean> {
        private Admin admin;
        private RegionInfo region;
        private String targetServer;
        private List<RegionInfo> movedRegions;
        private String sourceServer;

        public MoveWithoutAck(Admin admin, RegionInfo regionInfo, String sourceServer, String targetServer, List<RegionInfo> movedRegions) {
            this.admin = admin;
            this.region = regionInfo;
            this.targetServer = targetServer;
            this.movedRegions = movedRegions;
            this.sourceServer = sourceServer;
        }

        @Override
        public Boolean call() {
            try {
                LOG.info("Moving region:" + this.region.getEncodedName() + " from " + this.sourceServer + " to " + this.targetServer);
                this.admin.move(this.region.getEncodedNameAsBytes(), Bytes.toBytes((String)this.targetServer));
                LOG.info("Moved " + this.region.getEncodedName() + " from " + this.sourceServer + " to " + this.targetServer);
            }
            catch (Exception e) {
                LOG.error("Error Moving Region:" + this.region.getEncodedName(), (Throwable)e);
            }
            finally {
                this.movedRegions.add(this.region);
            }
            return true;
        }
    }

    private class MoveWithAck
    implements Callable<Boolean> {
        private Admin admin;
        private RegionInfo region;
        private String targetServer;
        private List<RegionInfo> movedRegions;
        private String sourceServer;

        public MoveWithAck(Admin admin, RegionInfo regionInfo, String sourceServer, String targetServer, List<RegionInfo> movedRegions) {
            this.admin = admin;
            this.region = regionInfo;
            this.targetServer = targetServer;
            this.movedRegions = movedRegions;
            this.sourceServer = sourceServer;
        }

        @Override
        public Boolean call() throws IOException, InterruptedException {
            boolean moved = false;
            int count = 0;
            int retries = this.admin.getConfiguration().getInt(RegionMover.MOVE_RETRIES_MAX_KEY, 5);
            int maxWaitInSeconds = this.admin.getConfiguration().getInt(RegionMover.MOVE_WAIT_MAX_KEY, 60);
            long startTime = EnvironmentEdgeManager.currentTime();
            boolean sameServer = true;
            RegionMover.this.isSuccessfulScan(this.admin, this.region);
            LOG.info("Moving region:" + this.region.getEncodedName() + " from " + this.sourceServer + " to " + this.targetServer);
            while (count < retries && sameServer) {
                if (count > 0) {
                    LOG.info("Retry " + Integer.toString(count) + " of maximum " + Integer.toString(retries));
                }
                ++count;
                this.admin.move(this.region.getEncodedNameAsBytes(), Bytes.toBytes((String)this.targetServer));
                long maxWait = startTime + (long)(maxWaitInSeconds * 1000);
                while (EnvironmentEdgeManager.currentTime() < maxWait && (sameServer = RegionMover.this.isSameServer(this.admin, this.region, this.sourceServer))) {
                    Thread.sleep(100L);
                }
            }
            if (sameServer) {
                LOG.error("Region: " + this.region.getRegionNameAsString() + " stuck on " + this.sourceServer + ",newServer=" + this.targetServer);
            } else {
                RegionMover.this.isSuccessfulScan(this.admin, this.region);
                LOG.info("Moved Region " + this.region.getRegionNameAsString() + " cost:" + String.format("%.3f", Float.valueOf((float)(EnvironmentEdgeManager.currentTime() - startTime) / 1000.0f)));
                moved = true;
                this.movedRegions.add(this.region);
            }
            return moved;
        }
    }

    private class Unload
    implements Callable<Boolean> {
        List<RegionInfo> movedRegions = Collections.synchronizedList(new ArrayList());
        private RegionMover rm;

        public Unload(RegionMover rm) {
            this.rm = rm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws IOException {
            Connection conn = ConnectionFactory.createConnection((Configuration)this.rm.conf);
            try {
                Admin admin = conn.getAdmin();
                ArrayList regionServers = RegionMover.this.getServers(admin);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Online region servers:" + regionServers.toString());
                }
                String server = RegionMover.this.stripServer(regionServers, RegionMover.this.hostname, RegionMover.this.port);
                RegionMover.this.stripExcludes(regionServers, this.rm.excludeFile);
                RegionMover.this.stripMaster(regionServers, admin);
                RegionMover.this.unloadRegions(admin, server, regionServers, this.rm.ack, this.movedRegions);
            }
            catch (Exception e) {
                LOG.error("Error while unloading regions ", (Throwable)e);
                Boolean bl = false;
                return bl;
            }
            finally {
                try {
                    conn.close();
                }
                catch (IOException iOException) {}
                if (this.movedRegions != null) {
                    RegionMover.this.writeFile(this.rm.filename, this.movedRegions);
                }
            }
            return true;
        }
    }

    private class Load
    implements Callable<Boolean> {
        private RegionMover rm;

        public Load(RegionMover rm) {
            this.rm = rm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws IOException {
            try (Connection conn = ConnectionFactory.createConnection((Configuration)this.rm.conf);){
                List regionsToMove = RegionMover.this.readRegionsFromFile(this.rm.filename);
                if (regionsToMove.isEmpty()) {
                    LOG.info("No regions to load.Exiting");
                    Boolean bl = true;
                    return bl;
                }
                try (Admin admin = conn.getAdmin();){
                    RegionMover.this.loadRegions(admin, this.rm.hostname, this.rm.port, regionsToMove, this.rm.ack);
                }
            }
            return true;
        }
    }

    public static class RegionMoverBuilder {
        private boolean ack = true;
        private int maxthreads = 1;
        private int timeout = Integer.MAX_VALUE;
        private String hostname;
        private String filename;
        private String excludeFile = null;
        private String defaultDir = System.getProperty("java.io.tmpdir");
        @VisibleForTesting
        final int port;
        private final Configuration conf;

        public RegionMoverBuilder(String hostname) {
            this(hostname, RegionMoverBuilder.createConf());
        }

        private static Configuration createConf() {
            Configuration conf = HBaseConfiguration.create();
            conf.setInt("hbase.client.prefetch.limit", 1);
            conf.setInt("hbase.client.pause", 500);
            conf.setInt("hbase.client.retries.number", 100);
            return conf;
        }

        public RegionMoverBuilder(String hostname, Configuration conf) {
            String[] splitHostname = hostname.toLowerCase().split(":");
            this.hostname = splitHostname[0];
            this.port = splitHostname.length == 2 ? Integer.parseInt(splitHostname[1]) : conf.getInt("hbase.regionserver.port", 16020);
            this.filename = this.defaultDir + File.separator + System.getProperty("user.name") + this.hostname + ":" + Integer.toString(this.port);
            this.conf = conf;
        }

        public RegionMoverBuilder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public RegionMoverBuilder maxthreads(int threads) {
            this.maxthreads = threads;
            return this;
        }

        public RegionMoverBuilder excludeFile(String excludefile) {
            this.excludeFile = excludefile;
            return this;
        }

        public RegionMoverBuilder ack(boolean ack) {
            this.ack = ack;
            return this;
        }

        public RegionMoverBuilder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public RegionMover build() {
            return new RegionMover(this);
        }
    }
}

