/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.normalizer.MergeNormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizer;
import org.apache.hadoop.hbase.master.normalizer.SplitNormalizationPlan;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class AbstractRegionNormalizer
implements RegionNormalizer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRegionNormalizer.class);
    protected MasterServices masterServices;
    protected MasterRpcServices masterRpcServices;

    @Override
    public void setMasterServices(MasterServices masterServices) {
        this.masterServices = masterServices;
    }

    @Override
    public void setMasterRpcServices(MasterRpcServices masterRpcServices) {
        this.masterRpcServices = masterRpcServices;
    }

    protected long getRegionSize(RegionInfo hri) {
        ServerName sn = this.masterServices.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
        RegionMetrics regionLoad = (RegionMetrics)this.masterServices.getServerManager().getLoad(sn).getRegionMetrics().get(hri.getRegionName());
        if (regionLoad == null) {
            LOG.debug("{} was not found in RegionsLoad", (Object)hri.getRegionNameAsString());
            return -1L;
        }
        return (long)regionLoad.getStoreFileSize().get(Size.Unit.MEGABYTE);
    }

    protected boolean isMergeEnabled() {
        boolean mergeEnabled = true;
        try {
            mergeEnabled = this.masterRpcServices.isSplitOrMergeEnabled(null, RequestConverter.buildIsSplitOrMergeEnabledRequest((MasterSwitchType)MasterSwitchType.MERGE)).getEnabled();
        }
        catch (ServiceException e) {
            LOG.warn("Unable to determine whether merge is enabled", (Throwable)e);
        }
        return mergeEnabled;
    }

    protected boolean isSplitEnabled() {
        boolean splitEnabled = true;
        try {
            splitEnabled = this.masterRpcServices.isSplitOrMergeEnabled(null, RequestConverter.buildIsSplitOrMergeEnabledRequest((MasterSwitchType)MasterSwitchType.SPLIT)).getEnabled();
        }
        catch (ServiceException se) {
            LOG.warn("Unable to determine whether split is enabled", (Throwable)se);
        }
        return splitEnabled;
    }

    protected double getAverageRegionSize(List<RegionInfo> tableRegions) {
        long totalSizeMb = 0L;
        int actualRegionCnt = 0;
        for (RegionInfo hri : tableRegions) {
            long regionSize = this.getRegionSize(hri);
            if (regionSize <= 0L) continue;
            ++actualRegionCnt;
            totalSizeMb += regionSize;
        }
        TableName table = tableRegions.get(0).getTable();
        int targetRegionCount = -1;
        long targetRegionSize = -1L;
        try {
            TableDescriptor tableDescriptor = this.masterServices.getTableDescriptors().get(table);
            if (tableDescriptor != null) {
                targetRegionCount = tableDescriptor.getNormalizerTargetRegionCount();
                targetRegionSize = tableDescriptor.getNormalizerTargetRegionSize();
                LOG.debug("Table {}:  target region count is {}, target region size is {}", new Object[]{table, targetRegionCount, targetRegionSize});
            }
        }
        catch (IOException e) {
            LOG.warn("cannot get the target number and target size of table {}, they will be default value -1.", (Object)table, (Object)e);
        }
        double avgRegionSize = targetRegionSize > 0L ? (double)targetRegionSize : (targetRegionCount > 0 ? (double)totalSizeMb / (double)targetRegionCount : (actualRegionCnt == 0 ? 0.0 : (double)totalSizeMb / (double)actualRegionCnt));
        LOG.debug("Table {}, total aggregated regions size: {} and average region size {}", new Object[]{table, totalSizeMb, avgRegionSize});
        return avgRegionSize;
    }

    private static boolean skipForMerge(RegionState state) {
        return state == null || !Objects.equals(state.getState(), RegionState.State.OPEN);
    }

    protected List<NormalizationPlan> getMergeNormalizationPlan(TableName table) {
        RegionStates regionStates = this.masterServices.getAssignmentManager().getRegionStates();
        List<RegionInfo> tableRegions = regionStates.getRegionsOfTable(table);
        double avgRegionSize = this.getAverageRegionSize(tableRegions);
        LOG.debug("Table {}, average region size: {}. Computing normalization plan for table: {}, number of regions: {}", new Object[]{table, avgRegionSize, table, tableRegions.size()});
        ArrayList<NormalizationPlan> plans = new ArrayList<NormalizationPlan>();
        for (int candidateIdx = 0; candidateIdx < tableRegions.size() - 1; ++candidateIdx) {
            RegionInfo hri = tableRegions.get(candidateIdx);
            RegionInfo hri2 = tableRegions.get(candidateIdx + 1);
            if (AbstractRegionNormalizer.skipForMerge(regionStates.getRegionState(hri)) || AbstractRegionNormalizer.skipForMerge(regionStates.getRegionState(hri2))) continue;
            long regionSize = this.getRegionSize(hri);
            long regionSize2 = this.getRegionSize(hri2);
            if (regionSize >= 0L && regionSize2 >= 0L && (double)(regionSize + regionSize2) < avgRegionSize) {
                plans.add(new MergeNormalizationPlan(hri, hri2));
                ++candidateIdx;
                continue;
            }
            LOG.debug("Skipping region {} of table {} with size {}", new Object[]{hri.getRegionNameAsString(), table, regionSize});
        }
        return plans;
    }

    private static boolean skipForSplit(RegionState state) {
        return state == null || !Objects.equals(state.getState(), RegionState.State.OPEN);
    }

    protected List<NormalizationPlan> getSplitNormalizationPlan(TableName table) {
        RegionStates regionStates = this.masterServices.getAssignmentManager().getRegionStates();
        List<RegionInfo> tableRegions = regionStates.getRegionsOfTable(table);
        double avgRegionSize = this.getAverageRegionSize(tableRegions);
        LOG.debug("Table {}, average region size: {}", (Object)table, (Object)avgRegionSize);
        ArrayList<NormalizationPlan> plans = new ArrayList<NormalizationPlan>();
        for (RegionInfo hri : tableRegions) {
            long regionSize;
            if (AbstractRegionNormalizer.skipForSplit(regionStates.getRegionState(hri)) || !((double)(regionSize = this.getRegionSize(hri)) > 2.0 * avgRegionSize)) continue;
            LOG.info("Table {}, large region {} has size {}, more than twice avg size {}, splitting", new Object[]{table, hri.getRegionNameAsString(), regionSize, avgRegionSize});
            plans.add(new SplitNormalizationPlan(hri, null));
        }
        return plans;
    }
}

