/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.normalizer.AbstractRegionNormalizer;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.SplitNormalizationPlan;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SimpleRegionNormalizer
extends AbstractRegionNormalizer {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleRegionNormalizer.class);
    private int minRegionCount;
    private static long[] skippedCount = new long[NormalizationPlan.PlanType.values().length];
    private Comparator<NormalizationPlan> planComparator = new PlanComparator();

    public SimpleRegionNormalizer() {
        this.minRegionCount = HBaseConfiguration.create().getInt("hbase.normalizer.min.region.count", 3);
    }

    @Override
    public void planSkipped(RegionInfo hri, NormalizationPlan.PlanType type) {
        int n = type.ordinal();
        skippedCount[n] = skippedCount[n] + 1L;
    }

    @Override
    public long getSkippedCount(NormalizationPlan.PlanType type) {
        return skippedCount[type.ordinal()];
    }

    @Override
    public List<NormalizationPlan> computePlanForTable(TableName table) throws HBaseIOException {
        List<NormalizationPlan> mergePlans;
        List<NormalizationPlan> splitPlans;
        if (table == null || table.isSystemTable()) {
            LOG.debug("Normalization of system table {} isn't allowed", (Object)table);
            return null;
        }
        boolean splitEnabled = this.isSplitEnabled();
        boolean mergeEnabled = this.isMergeEnabled();
        if (!mergeEnabled && !splitEnabled) {
            LOG.debug("Both split and merge are disabled for table: {}", (Object)table);
            return null;
        }
        ArrayList<NormalizationPlan> plans = new ArrayList<NormalizationPlan>();
        List<RegionInfo> tableRegions = this.masterServices.getAssignmentManager().getRegionStates().getRegionsOfTable(table);
        if (tableRegions == null || tableRegions.size() < this.minRegionCount) {
            int nrRegions = tableRegions == null ? 0 : tableRegions.size();
            LOG.debug("Table {} has {} regions, required min number of regions for normalizer to run is {}, not running normalizer", new Object[]{table, nrRegions, this.minRegionCount});
            return null;
        }
        LOG.debug("Computing normalization plan for table:  {}, number of regions: {}", (Object)table, (Object)tableRegions.size());
        if (splitEnabled && (splitPlans = this.getSplitNormalizationPlan(table)) != null) {
            plans.addAll(splitPlans);
        }
        if (mergeEnabled && (mergePlans = this.getMergeNormalizationPlan(table)) != null) {
            plans.addAll(mergePlans);
        }
        if (plans.isEmpty()) {
            LOG.debug("No normalization needed, regions look good for table: {}", (Object)table);
            return null;
        }
        Collections.sort(plans, this.planComparator);
        return plans;
    }

    static class PlanComparator
    implements Comparator<NormalizationPlan> {
        PlanComparator() {
        }

        @Override
        public int compare(NormalizationPlan plan1, NormalizationPlan plan2) {
            boolean plan1IsSplit = plan1 instanceof SplitNormalizationPlan;
            boolean plan2IsSplit = plan2 instanceof SplitNormalizationPlan;
            if (plan1IsSplit && plan2IsSplit) {
                return 0;
            }
            if (plan1IsSplit) {
                return -1;
            }
            if (plan2IsSplit) {
                return 1;
            }
            return 0;
        }
    }
}

