/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.normalizer.AbstractRegionNormalizer;
import org.apache.hadoop.hbase.master.normalizer.MergeNormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MergeNormalizer
extends AbstractRegionNormalizer {
    private static final Logger LOG = LoggerFactory.getLogger(MergeNormalizer.class);
    private int minRegionCount;
    private int minRegionAge;
    private static long[] skippedCount = new long[NormalizationPlan.PlanType.values().length];

    public MergeNormalizer() {
        Configuration conf = HBaseConfiguration.create();
        this.minRegionCount = conf.getInt("hbase.normalizer.min.region.count", 3);
        this.minRegionAge = conf.getInt("hbase.normalizer.min.region.merge.age", 3);
    }

    @Override
    public void planSkipped(RegionInfo hri, NormalizationPlan.PlanType type) {
        int n = type.ordinal();
        skippedCount[n] = skippedCount[n] + 1L;
    }

    @Override
    public long getSkippedCount(NormalizationPlan.PlanType type) {
        return skippedCount[type.ordinal()];
    }

    @Override
    public List<NormalizationPlan> computePlanForTable(TableName table) throws HBaseIOException {
        ArrayList<NormalizationPlan> plans = new ArrayList<NormalizationPlan>();
        if (!this.shouldNormalize(table)) {
            return null;
        }
        List<NormalizationPlan> normalizationPlans = this.getMergeNormalizationPlan(table);
        for (NormalizationPlan plan : normalizationPlans) {
            if (!(plan instanceof MergeNormalizationPlan)) continue;
            RegionInfo hri = ((MergeNormalizationPlan)plan).getFirstRegion();
            RegionInfo hri2 = ((MergeNormalizationPlan)plan).getSecondRegion();
            if (this.isOldEnoughToMerge(hri) || this.isOldEnoughToMerge(hri2)) {
                plans.add(plan);
                continue;
            }
            LOG.debug("Skipping region {} and {} as they are both new", (Object)hri.getEncodedName(), (Object)hri2.getEncodedName());
        }
        if (plans.isEmpty()) {
            LOG.debug("No normalization needed, regions look good for table: {}", (Object)table);
            return null;
        }
        return plans;
    }

    private boolean isOldEnoughToMerge(RegionInfo hri) {
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        Timestamp hriTime = new Timestamp(hri.getRegionId());
        boolean isOld = new Timestamp(hriTime.getTime() + TimeUnit.DAYS.toMillis(this.minRegionAge)).before(currentTime);
        return isOld;
    }

    private boolean shouldNormalize(TableName table) {
        boolean normalize = false;
        if (table == null || table.isSystemTable()) {
            LOG.debug("Normalization of system table {} isn't allowed", (Object)table);
        } else if (!this.isMergeEnabled()) {
            LOG.debug("Merge disabled for table: {}", (Object)table);
        } else {
            List<RegionInfo> tableRegions = this.masterServices.getAssignmentManager().getRegionStates().getRegionsOfTable(table);
            if (tableRegions == null || tableRegions.size() < this.minRegionCount) {
                int nrRegions = tableRegions == null ? 0 : tableRegions.size();
                LOG.debug("Table {} has {} regions, required min number of regions for normalizer to run is {} , not running normalizer", new Object[]{table, nrRegions, this.minRegionCount});
            } else {
                normalize = true;
            }
        }
        return normalize;
    }
}

