/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.mob.ExpiredMobFileCleaner;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MobFileCleanerChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(MobFileCleanerChore.class);
    private final HMaster master;
    private ExpiredMobFileCleaner cleaner;

    public MobFileCleanerChore(HMaster master) {
        super(master.getServerName() + "-MobFileCleanerChore", (Stoppable)master, master.getConfiguration().getInt("hbase.master.mob.cleaner.period", 86400), (long)master.getConfiguration().getInt("hbase.master.mob.cleaner.period", 86400), TimeUnit.SECONDS);
        this.master = master;
        this.cleaner = new ExpiredMobFileCleaner();
        this.cleaner.setConf(master.getConfiguration());
        this.checkObsoleteConfigurations();
    }

    private void checkObsoleteConfigurations() {
        Configuration conf = this.master.getConfiguration();
        if (conf.get("hbase.mob.compaction.mergeable.threshold") != null) {
            LOG.warn("'hbase.mob.compaction.mergeable.threshold' is obsolete and not used anymore.");
        }
        if (conf.get("hbase.mob.delfile.max.count") != null) {
            LOG.warn("'hbase.mob.delfile.max.count' is obsolete and not used anymore.");
        }
        if (conf.get("hbase.mob.compaction.threads.max") != null) {
            LOG.warn("'hbase.mob.compaction.threads.max' is obsolete and not used anymore.");
        }
        if (conf.get("hbase.mob.compaction.batch.size") != null) {
            LOG.warn("'hbase.mob.compaction.batch.size' is obsolete and not used anymore.");
        }
    }

    @VisibleForTesting
    public MobFileCleanerChore() {
        this.master = null;
    }

    protected void chore() {
        TableDescriptors htds = this.master.getTableDescriptors();
        Map<String, TableDescriptor> map = null;
        try {
            map = htds.getAll();
        }
        catch (IOException e) {
            LOG.error("MobFileCleanerChore failed", (Throwable)e);
            return;
        }
        for (TableDescriptor htd : map.values()) {
            for (ColumnFamilyDescriptor hcd : htd.getColumnFamilies()) {
                if (!hcd.isMobEnabled() || hcd.getMinVersions() != 0) continue;
                try {
                    this.cleaner.cleanExpiredMobFiles(htd.getTableName().getNameAsString(), hcd);
                }
                catch (IOException e) {
                    LOG.error("Failed to clean the expired mob files table={} family={}", new Object[]{htd.getTableName().getNameAsString(), hcd.getNameAsString(), e});
                }
            }
            try {
                LOG.info("Cleaning obsolete MOB files from table={}", (Object)htd.getTableName());
                this.cleanupObsoleteMobFiles(this.master.getConfiguration(), htd.getTableName());
                LOG.info("Cleaning obsolete MOB files finished for table={}", (Object)htd.getTableName());
            }
            catch (IOException e) {
                LOG.error("Failed to clean the obsolete mob files for table={}", (Object)htd.getTableName(), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cleanupObsoleteMobFiles(Configuration conf, TableName table) throws IOException {
        minAgeToArchive = conf.getLong("hbase.mob.min.age.archive", 3600000L);
        maxCreationTimeToArchive = EnvironmentEdgeManager.currentTime() - minAgeToArchive;
        conn = ConnectionFactory.createConnection((Configuration)conf);
        var8_6 = null;
        try {
            admin = conn.getAdmin();
            var10_10 = null;
            try {
                htd = admin.getDescriptor(table);
                list = MobUtils.getMobColumnFamilies(htd);
                if (list.size() == 0) {
                    MobFileCleanerChore.LOG.info("Skipping non-MOB table [{}]", (Object)table);
                    return;
                }
                MobFileCleanerChore.LOG.info("Only MOB files whose creation time older than {} will be archived, table={}", (Object)maxCreationTimeToArchive, (Object)table);
                rootDir = FSUtils.getRootDir((Configuration)conf);
                tableDir = FSUtils.getTableDir((Path)rootDir, (TableName)table);
                regionDirs = FSUtils.getRegionDirs(FileSystem.get((Configuration)conf), tableDir);
                allActiveMobFileName = new HashSet<E>();
                fs = FileSystem.get((Configuration)conf);
                for (Path regionPath : regionDirs) {
                    for (ColumnFamilyDescriptor hcd : list) {
                        family = hcd.getNameAsString();
                        storePath = new Path(regionPath, family);
                        succeed = false;
                        regionMobs = new HashSet<E>();
                        while (!succeed) {
                            block54: {
                                if (!fs.exists(storePath)) {
                                    errMsg = String.format("Directory %s was deleted during MOB file cleaner chore execution, aborting MOB file cleaner chore.", new Object[]{storePath});
                                    throw new IOException(errMsg);
                                }
                                rit = fs.listLocatedStatus(storePath);
                                storeFiles = new ArrayList<Path>();
                                while (rit.hasNext()) {
                                    p = ((LocatedFileStatus)rit.next()).getPath();
                                    if (!fs.isFile(p)) continue;
                                    storeFiles.add(p);
                                }
                                MobFileCleanerChore.LOG.info("Found {} store files in: {}", (Object)storeFiles.size(), (Object)storePath);
                                currentPath = null;
                                try {
                                    var29_37 = storeFiles.iterator();
lbl42:
                                    // 3 sources

                                    while (var29_37.hasNext()) {
                                        currentPath = pp = (Path)var29_37.next();
                                        MobFileCleanerChore.LOG.trace("Store file: {}", (Object)pp);
                                        sf = new HStoreFile(fs, pp, conf, CacheConfig.DISABLED, BloomType.NONE, true);
                                        sf.initReader();
                                        mobRefData = sf.getMetadataValue(HStoreFile.MOB_FILE_REFS);
                                        bulkloadMarkerData = sf.getMetadataValue(HStoreFile.BULKLOAD_TASK_KEY);
                                        sf.closeStoreFile(true);
                                        if (mobRefData != null) ** GOTO lbl62
                                        if (bulkloadMarkerData == null) {
                                            MobFileCleanerChore.LOG.warn("Found old store file with no MOB_FILE_REFS: {} - can not proceed until all old files will be MOB-compacted.", (Object)pp);
                                            return;
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    break block54;
                                }
                                catch (FileNotFoundException e) {
                                    MobFileCleanerChore.LOG.warn("Missing file:{} Starting MOB cleaning cycle from the beginning due to error", currentPath, (Object)e);
                                    regionMobs.clear();
                                    continue;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    MobFileCleanerChore.LOG.debug("Skipping file without MOB references (bulkloaded file):{}", (Object)pp);
                                    ** GOTO lbl42
lbl62:
                                    // 1 sources

                                    try {
                                        mobs = MobUtils.deserializeMobFileRefs(mobRefData).build();
                                        MobFileCleanerChore.LOG.debug("Found {} mob references for store={}", (Object)mobs.size(), (Object)sf);
                                        MobFileCleanerChore.LOG.trace("Specific mob references found for store={} : {}", (Object)sf, (Object)mobs);
                                        regionMobs.addAll(mobs.values());
                                        ** GOTO lbl42
                                    }
                                    catch (RuntimeException exception) {
                                        throw new IOException("failure getting mob references for hfile " + sf, exception);
                                    }
                                }
                            }
                            succeed = true;
                        }
                        allActiveMobFileName.addAll(regionMobs);
                    }
                }
                if (allActiveMobFileName.size() > 1000000) {
                    MobFileCleanerChore.LOG.warn("Found too many active MOB files: {}, table={}, this may result in high memory pressure.", (Object)allActiveMobFileName.size(), (Object)table);
                }
                MobFileCleanerChore.LOG.debug("Found: {} active mob refs for table={}", (Object)allActiveMobFileName.size(), (Object)table);
                allActiveMobFileName.stream().forEach((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, trace(java.lang.String ), (Ljava/lang/String;)V)((Logger)MobFileCleanerChore.LOG));
                var18_22 = list.iterator();
                while (var18_22.hasNext() != false) {
                    hcd = (ColumnFamilyDescriptor)var18_22.next();
                    toArchive = new ArrayList<Path>();
                    family = hcd.getNameAsString();
                    dir = MobUtils.getMobFamilyPath(conf, table, family);
                    rit = fs.listLocatedStatus(dir);
                    while (rit.hasNext()) {
                        lfs = (LocatedFileStatus)rit.next();
                        p = lfs.getPath();
                        if (!allActiveMobFileName.contains(p.getName())) {
                            creationTime = fs.getFileStatus(p).getModificationTime();
                            if (creationTime < maxCreationTimeToArchive) {
                                MobFileCleanerChore.LOG.trace("Archiving MOB file {} creation time={}", (Object)p, (Object)fs.getFileStatus(p).getModificationTime());
                                toArchive.add(p);
                                continue;
                            }
                            MobFileCleanerChore.LOG.trace("Skipping fresh file: {}. Creation time={}", (Object)p, (Object)fs.getFileStatus(p).getModificationTime());
                            continue;
                        }
                        MobFileCleanerChore.LOG.trace("Keeping active MOB file: {}", (Object)p);
                    }
                    MobFileCleanerChore.LOG.info(" MOB Cleaner found {} files to archive for table={} family={}", new Object[]{toArchive.size(), table, family});
                    this.archiveMobFiles(conf, table, family.getBytes(), toArchive);
                    MobFileCleanerChore.LOG.info(" MOB Cleaner archived {} files, table={} family={}", new Object[]{toArchive.size(), table, family});
                }
                return;
            }
            catch (Throwable var11_13) {
                var10_10 = var11_13;
                throw var11_13;
            }
            finally {
                if (admin != null) {
                    if (var10_10 != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable var13_15) {
                            var10_10.addSuppressed(var13_15);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
        }
        catch (Throwable var9_9) {
            var8_6 = var9_9;
            throw var9_9;
        }
        finally {
            if (conn != null) {
                if (var8_6 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable var13_16) {
                        var8_6.addSuppressed(var13_16);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    public void archiveMobFiles(Configuration conf, TableName tableName, byte[] family, List<Path> storeFiles) throws IOException {
        if (storeFiles.size() == 0) {
            LOG.debug("Skipping archiving old MOB files - no files found for table={} cf={}", (Object)tableName, (Object)Bytes.toString((byte[])family));
            return;
        }
        Path mobTableDir = FSUtils.getTableDir((Path)MobUtils.getMobHome(conf), (TableName)tableName);
        FileSystem fs = storeFiles.get(0).getFileSystem(conf);
        for (Path p : storeFiles) {
            LOG.debug("MOB Cleaner is archiving: {}", (Object)p);
            HFileArchiver.archiveStoreFile(conf, fs, MobUtils.getMobRegionInfo(tableName), mobTableDir, family, p);
        }
    }

    static {
        Configuration.addDeprecation((String)"hbase.master.mob.ttl.cleaner.period", (String)"hbase.master.mob.cleaner.period");
    }
}

