/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CombinedBlockCache;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CacheConfig {
    private static final Logger LOG = LoggerFactory.getLogger((String)CacheConfig.class.getName());
    public static final CacheConfig DISABLED = new CacheConfig();
    public static final String CACHE_DATA_ON_READ_KEY = "hbase.block.data.cacheonread";
    public static final String CACHE_BLOCKS_ON_WRITE_KEY = "hbase.rs.cacheblocksonwrite";
    public static final String CACHE_INDEX_BLOCKS_ON_WRITE_KEY = "hfile.block.index.cacheonwrite";
    public static final String CACHE_BLOOM_BLOCKS_ON_WRITE_KEY = "hfile.block.bloom.cacheonwrite";
    public static final String CACHE_DATA_BLOCKS_COMPRESSED_KEY = "hbase.block.data.cachecompressed";
    public static final String EVICT_BLOCKS_ON_CLOSE_KEY = "hbase.rs.evictblocksonclose";
    public static final String PREFETCH_BLOCKS_ON_OPEN_KEY = "hbase.rs.prefetchblocksonopen";
    public static final String CACHE_COMPACTED_BLOCKS_ON_WRITE_KEY = "hbase.rs.cachecompactedblocksonwrite";
    public static final String CACHE_COMPACTED_BLOCKS_ON_WRITE_THRESHOLD_KEY = "hbase.rs.cachecompactedblocksonwrite.threshold";
    public static final String DROP_BEHIND_CACHE_COMPACTION_KEY = "hbase.hfile.drop.behind.compaction";
    public static final String PREFETCH_PERSISTENCE_PATH_KEY = "hbase.prefetch.file.list.path";
    public static final String BUCKETCACHE_PERSIST_INTERVAL_KEY = "hbase.bucketcache.persist.intervalinmillis";
    public static final boolean DEFAULT_CACHE_DATA_ON_READ = true;
    public static final boolean DEFAULT_CACHE_DATA_ON_WRITE = false;
    public static final boolean DEFAULT_IN_MEMORY = false;
    public static final boolean DEFAULT_CACHE_INDEXES_ON_WRITE = false;
    public static final boolean DEFAULT_CACHE_BLOOMS_ON_WRITE = false;
    public static final boolean DEFAULT_EVICT_ON_CLOSE = false;
    public static final boolean DEFAULT_CACHE_DATA_COMPRESSED = false;
    public static final boolean DEFAULT_PREFETCH_ON_OPEN = false;
    public static final boolean DEFAULT_CACHE_COMPACTED_BLOCKS_ON_WRITE = false;
    public static final boolean DROP_BEHIND_CACHE_COMPACTION_DEFAULT = true;
    public static final long DEFAULT_CACHE_COMPACTED_BLOCKS_ON_WRITE_THRESHOLD = Long.MAX_VALUE;
    private final boolean cacheDataOnRead;
    private final boolean inMemory;
    private boolean cacheDataOnWrite;
    private boolean cacheIndexesOnWrite;
    private boolean cacheBloomsOnWrite;
    private volatile boolean evictOnClose;
    private final boolean cacheDataCompressed;
    private final boolean prefetchOnOpen;
    private final boolean cacheCompactedDataOnWrite;
    private long cacheCompactedDataOnWriteThreshold;
    private final boolean dropBehindCompaction;
    private final BlockCache blockCache;
    private final ByteBuffAllocator byteBuffAllocator;

    public CacheConfig(Configuration conf) {
        this(conf, null);
    }

    public CacheConfig(Configuration conf, BlockCache blockCache) {
        this(conf, null, blockCache, ByteBuffAllocator.HEAP);
    }

    public CacheConfig(Configuration conf, ColumnFamilyDescriptor family, BlockCache blockCache, ByteBuffAllocator byteBuffAllocator) {
        this.cacheDataOnRead = conf.getBoolean(CACHE_DATA_ON_READ_KEY, true) && (family == null || family.isBlockCacheEnabled());
        this.inMemory = family == null ? false : family.isInMemory();
        this.cacheDataCompressed = conf.getBoolean(CACHE_DATA_BLOCKS_COMPRESSED_KEY, false);
        this.dropBehindCompaction = conf.getBoolean(DROP_BEHIND_CACHE_COMPACTION_KEY, true);
        this.cacheDataOnWrite = conf.getBoolean(CACHE_BLOCKS_ON_WRITE_KEY, false) || family != null && family.isCacheDataOnWrite();
        this.cacheIndexesOnWrite = conf.getBoolean(CACHE_INDEX_BLOCKS_ON_WRITE_KEY, false) || family != null && family.isCacheIndexesOnWrite();
        this.cacheBloomsOnWrite = conf.getBoolean(CACHE_BLOOM_BLOCKS_ON_WRITE_KEY, false) || family != null && family.isCacheBloomsOnWrite();
        this.evictOnClose = conf.getBoolean(EVICT_BLOCKS_ON_CLOSE_KEY, false) || family != null && family.isEvictBlocksOnClose();
        this.prefetchOnOpen = conf.getBoolean(PREFETCH_BLOCKS_ON_OPEN_KEY, false) || family != null && family.isPrefetchBlocksOnOpen();
        this.cacheCompactedDataOnWrite = conf.getBoolean(CACHE_COMPACTED_BLOCKS_ON_WRITE_KEY, false);
        this.cacheCompactedDataOnWriteThreshold = this.getCacheCompactedBlocksOnWriteThreshold(conf);
        this.blockCache = blockCache;
        this.byteBuffAllocator = byteBuffAllocator;
    }

    public CacheConfig(CacheConfig cacheConf) {
        this.cacheDataOnRead = cacheConf.cacheDataOnRead;
        this.inMemory = cacheConf.inMemory;
        this.cacheDataOnWrite = cacheConf.cacheDataOnWrite;
        this.cacheIndexesOnWrite = cacheConf.cacheIndexesOnWrite;
        this.cacheBloomsOnWrite = cacheConf.cacheBloomsOnWrite;
        this.evictOnClose = cacheConf.evictOnClose;
        this.cacheDataCompressed = cacheConf.cacheDataCompressed;
        this.prefetchOnOpen = cacheConf.prefetchOnOpen;
        this.cacheCompactedDataOnWrite = cacheConf.cacheCompactedDataOnWrite;
        this.cacheCompactedDataOnWriteThreshold = cacheConf.cacheCompactedDataOnWriteThreshold;
        this.dropBehindCompaction = cacheConf.dropBehindCompaction;
        this.blockCache = cacheConf.blockCache;
        this.byteBuffAllocator = cacheConf.byteBuffAllocator;
    }

    private CacheConfig() {
        this.cacheDataOnRead = false;
        this.inMemory = false;
        this.cacheDataOnWrite = false;
        this.cacheIndexesOnWrite = false;
        this.cacheBloomsOnWrite = false;
        this.evictOnClose = false;
        this.cacheDataCompressed = false;
        this.prefetchOnOpen = false;
        this.cacheCompactedDataOnWrite = false;
        this.dropBehindCompaction = false;
        this.blockCache = null;
        this.byteBuffAllocator = ByteBuffAllocator.HEAP;
    }

    public boolean shouldCacheDataOnRead() {
        return this.cacheDataOnRead;
    }

    public boolean shouldDropBehindCompaction() {
        return this.dropBehindCompaction;
    }

    public boolean shouldCacheBlockOnRead(BlockType.BlockCategory category) {
        return this.cacheDataOnRead || category == BlockType.BlockCategory.INDEX || category == BlockType.BlockCategory.BLOOM || this.prefetchOnOpen && category != BlockType.BlockCategory.META && category != BlockType.BlockCategory.UNKNOWN;
    }

    public boolean isInMemory() {
        return this.inMemory;
    }

    public boolean shouldCacheDataOnWrite() {
        return this.cacheDataOnWrite;
    }

    public void setCacheDataOnWrite(boolean cacheDataOnWrite) {
        this.cacheDataOnWrite = cacheDataOnWrite;
    }

    public void enableCacheOnWrite() {
        this.cacheDataOnWrite = true;
        this.cacheIndexesOnWrite = true;
        this.cacheBloomsOnWrite = true;
    }

    public boolean shouldCacheIndexesOnWrite() {
        return this.cacheIndexesOnWrite;
    }

    public boolean shouldCacheBloomsOnWrite() {
        return this.cacheBloomsOnWrite;
    }

    public boolean shouldEvictOnClose() {
        return this.evictOnClose;
    }

    public void setEvictOnClose(boolean evictOnClose) {
        this.evictOnClose = evictOnClose;
    }

    public boolean shouldCacheDataCompressed() {
        return this.cacheDataOnRead && this.cacheDataCompressed;
    }

    public boolean shouldCacheCompressed(BlockType.BlockCategory category) {
        switch (category) {
            case DATA: {
                return this.cacheDataOnRead && this.cacheDataCompressed;
            }
        }
        return false;
    }

    public boolean shouldPrefetchOnOpen() {
        return this.prefetchOnOpen;
    }

    public boolean shouldCacheCompactedBlocksOnWrite() {
        return this.cacheCompactedDataOnWrite;
    }

    public long getCacheCompactedBlocksOnWriteThreshold() {
        return this.cacheCompactedDataOnWriteThreshold;
    }

    public boolean shouldReadBlockFromCache(BlockType blockType) {
        if (this.cacheDataOnRead) {
            return true;
        }
        if (this.prefetchOnOpen) {
            return true;
        }
        if (this.cacheDataOnWrite) {
            return true;
        }
        if (blockType == null) {
            return true;
        }
        return blockType.getCategory() == BlockType.BlockCategory.BLOOM || blockType.getCategory() == BlockType.BlockCategory.INDEX;
    }

    public boolean shouldLockOnCacheMiss(BlockType blockType) {
        if (blockType == null) {
            return true;
        }
        return this.shouldCacheBlockOnRead(blockType.getCategory());
    }

    public Optional<BlockCache> getBlockCache() {
        return Optional.ofNullable(this.blockCache);
    }

    public boolean isCombinedBlockCache() {
        return this.blockCache instanceof CombinedBlockCache;
    }

    public ByteBuffAllocator getByteBuffAllocator() {
        return this.byteBuffAllocator;
    }

    private long getCacheCompactedBlocksOnWriteThreshold(Configuration conf) {
        long cacheCompactedBlocksOnWriteThreshold = conf.getLong(CACHE_COMPACTED_BLOCKS_ON_WRITE_THRESHOLD_KEY, Long.MAX_VALUE);
        if (cacheCompactedBlocksOnWriteThreshold < 0L) {
            LOG.warn("cacheCompactedBlocksOnWriteThreshold value : {} is less than 0, resetting it to: {}", (Object)cacheCompactedBlocksOnWriteThreshold, (Object)Long.MAX_VALUE);
            cacheCompactedBlocksOnWriteThreshold = Long.MAX_VALUE;
        }
        return cacheCompactedBlocksOnWriteThreshold;
    }

    public String toString() {
        return "cacheDataOnRead=" + this.shouldCacheDataOnRead() + ", cacheDataOnWrite=" + this.shouldCacheDataOnWrite() + ", cacheIndexesOnWrite=" + this.shouldCacheIndexesOnWrite() + ", cacheBloomsOnWrite=" + this.shouldCacheBloomsOnWrite() + ", cacheEvictOnClose=" + this.shouldEvictOnClose() + ", cacheDataCompressed=" + this.shouldCacheDataCompressed() + ", prefetchOnOpen=" + this.shouldPrefetchOnOpen();
    }
}

