/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.NettyServerRpcConnection;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.security.HBaseSaslRpcServer;
import org.apache.hadoop.hbase.security.SaslStatus;
import org.apache.hadoop.hbase.security.SaslUnwrapHandler;
import org.apache.hadoop.hbase.security.SaslWrapHandler;
import org.apache.hadoop.hbase.util.NettyFutureUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufOutputStream;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOutboundInvoker;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.hbase.thirdparty.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hbase.thirdparty.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NettyHBaseSaslRpcServerHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHBaseSaslRpcServerHandler.class);
    static final String DECODER_NAME = "SaslNegotiationDecoder";
    private final NettyRpcServer rpcServer;
    private final NettyServerRpcConnection conn;

    NettyHBaseSaslRpcServerHandler(NettyRpcServer rpcServer, NettyServerRpcConnection conn) {
        this.rpcServer = rpcServer;
        this.conn = conn;
    }

    private void doResponse(ChannelHandlerContext ctx, SaslStatus status, Writable rv, String errorClass, String error) throws IOException {
        ByteBuf resp = ctx.alloc().buffer(256);
        try (ByteBufOutputStream out = new ByteBufOutputStream(resp);){
            out.writeInt(status.state);
            if (status == SaslStatus.SUCCESS) {
                rv.write((DataOutput)out);
            } else {
                WritableUtils.writeString((DataOutput)out, (String)errorClass);
                WritableUtils.writeString((DataOutput)out, (String)error);
            }
        }
        NettyFutureUtils.safeWriteAndFlush((ChannelOutboundInvoker)ctx, (Object)resp);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        LOG.debug("Read input token of size={} for processing by saslServer.evaluateResponse()", (Object)msg.readableBytes());
        HBaseSaslRpcServer saslServer = this.conn.getOrCreateSaslServer();
        byte[] saslToken = new byte[msg.readableBytes()];
        msg.readBytes(saslToken, 0, saslToken.length);
        byte[] replyToken = saslServer.evaluateResponse(saslToken);
        if (replyToken != null) {
            LOG.debug("Will send token of size {} from saslServer.", (Object)replyToken.length);
            this.doResponse(ctx, SaslStatus.SUCCESS, (Writable)new BytesWritable(replyToken), null, null);
        }
        if (saslServer.isComplete()) {
            this.conn.finishSaslNegotiation();
            String qop = saslServer.getNegotiatedQop();
            boolean useWrap = qop != null && !"auth".equalsIgnoreCase(qop);
            ChannelPipeline p = ctx.pipeline();
            if (useWrap) {
                ChannelHandler[] channelHandlerArray = new ChannelHandler[2];
                channelHandlerArray[0] = new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4);
                channelHandlerArray[1] = new SaslUnwrapHandler(saslServer::unwrap);
                p.addBefore(DECODER_NAME, null, (ChannelHandler)new SaslWrapHandler(saslServer::wrap)).addLast(channelHandlerArray);
            }
            this.conn.setupHandler();
            p.remove((ChannelHandler)this);
            p.remove(DECODER_NAME);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error("Error when doing SASL handshade, provider={}", (Object)this.conn.provider, (Object)cause);
        Throwable sendToClient = HBaseSaslRpcServer.unwrap(cause);
        this.doResponse(ctx, SaslStatus.ERROR, null, sendToClient.getClass().getName(), sendToClient.getLocalizedMessage());
        this.rpcServer.metrics.authenticationFailure();
        String clientIP = ((Object)((Object)this)).toString();
        RpcServer.AUDITLOG.warn("{}{}: {}", new Object[]{"Auth failed for ", clientIP, this.conn.saslServer != null ? this.conn.saslServer.getAttemptingUser() : "Unknown"});
        NettyFutureUtils.safeClose((ChannelOutboundInvoker)ctx);
    }
}

