/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.ipc.NettyHBaseSaslRpcServerHandler;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.NettyServerRpcConnection;
import org.apache.hadoop.hbase.util.NettyFutureUtils;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOutboundInvoker;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.hbase.thirdparty.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hbase.thirdparty.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class NettyRpcServerPreambleHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    static final String DECODER_NAME = "preambleDecoder";
    private final NettyRpcServer rpcServer;

    public NettyRpcServerPreambleHandler(NettyRpcServer rpcServer) {
        this.rpcServer = rpcServer;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        NettyServerRpcConnection conn = this.createNettyServerRpcConnection(ctx.channel());
        ByteBuffer buf = ByteBuffer.allocate(msg.readableBytes());
        msg.readBytes(buf);
        buf.flip();
        if (!conn.processPreamble(buf)) {
            conn.close();
            return;
        }
        ChannelPipeline p = ctx.pipeline();
        if (conn.useSasl) {
            LengthFieldBasedFrameDecoder decoder = new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4);
            decoder.setSingleDecode(true);
            p.addLast("SaslNegotiationDecoder", (ChannelHandler)decoder);
            p.addLast(new ChannelHandler[]{new NettyHBaseSaslRpcServerHandler(this.rpcServer, conn)});
        } else {
            conn.setupHandler();
        }
        p.remove((ChannelHandler)this);
        p.remove(DECODER_NAME);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        NettyRpcServer.LOG.warn("Connection {}; caught unexpected downstream exception.", (Object)ctx.channel().remoteAddress(), (Object)cause);
        NettyFutureUtils.safeClose((ChannelOutboundInvoker)ctx);
    }

    protected NettyServerRpcConnection createNettyServerRpcConnection(Channel channel) {
        return new NettyServerRpcConnection(this.rpcServer, channel);
    }
}

