/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TagUtil;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CorruptHFileException;
import org.apache.hadoop.hbase.mob.MobCell;
import org.apache.hadoop.hbase.mob.MobConstants;
import org.apache.hadoop.hbase.mob.MobFile;
import org.apache.hadoop.hbase.mob.MobFileCache;
import org.apache.hadoop.hbase.mob.MobFileName;
import org.apache.hadoop.hbase.mob.MobStoreEngine;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MobReferenceOnlyFilter;
import org.apache.hadoop.hbase.regionserver.MobStoreScanner;
import org.apache.hadoop.hbase.regionserver.ReversedMobStoreScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.IdLock;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HMobStore
extends HStore {
    private static final Logger LOG = LoggerFactory.getLogger(HMobStore.class);
    private MobFileCache mobFileCache;
    private Path homePath;
    private Path mobFamilyPath;
    private AtomicLong cellsCountCompactedToMob = new AtomicLong();
    private AtomicLong cellsCountCompactedFromMob = new AtomicLong();
    private AtomicLong cellsSizeCompactedToMob = new AtomicLong();
    private AtomicLong cellsSizeCompactedFromMob = new AtomicLong();
    private AtomicLong mobFlushCount = new AtomicLong();
    private AtomicLong mobFlushedCellsCount = new AtomicLong();
    private AtomicLong mobFlushedCellsSize = new AtomicLong();
    private AtomicLong mobScanCellsCount = new AtomicLong();
    private AtomicLong mobScanCellsSize = new AtomicLong();
    private ColumnFamilyDescriptor family;
    private Map<TableName, List<Path>> map = new ConcurrentHashMap<TableName, List<Path>>();
    private final IdLock keyLock = new IdLock();
    private final byte[] refCellTags;

    public HMobStore(HRegion region, ColumnFamilyDescriptor family, Configuration confParam, boolean warmup) throws IOException {
        super(region, family, confParam, warmup);
        this.mobFileCache = region.getMobFileCache();
        this.homePath = MobUtils.getMobHome(this.conf);
        this.mobFamilyPath = MobUtils.getMobFamilyPath(this.conf, this.getTableName(), family.getNameAsString());
        ArrayList<Path> locations = new ArrayList<Path>(2);
        locations.add(this.mobFamilyPath);
        TableName tn = region.getTableDescriptor().getTableName();
        locations.add(HFileArchiveUtil.getStoreArchivePath(this.conf, tn, MobUtils.getMobRegionInfo(tn).getEncodedName(), family.getNameAsString()));
        this.map.put(tn, locations);
        ArrayList<Object> tags = new ArrayList<Object>(2);
        tags.add(MobConstants.MOB_REF_TAG);
        ArrayBackedTag tableNameTag = new ArrayBackedTag(6, this.getTableName().getName());
        tags.add(tableNameTag);
        this.refCellTags = TagUtil.fromList(tags);
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    protected KeyValueScanner createScanner(Scan scan, ScanInfo scanInfo, NavigableSet<byte[]> targetCols, long readPt) throws IOException {
        if (MobUtils.isRefOnlyScan(scan)) {
            MobReferenceOnlyFilter refOnlyFilter = new MobReferenceOnlyFilter();
            Filter filter = scan.getFilter();
            if (filter != null) {
                scan.setFilter((Filter)new FilterList(new Filter[]{filter, refOnlyFilter}));
            } else {
                scan.setFilter((Filter)refOnlyFilter);
            }
        }
        return scan.isReversed() ? new ReversedMobStoreScanner(this, scanInfo, scan, targetCols, readPt) : new MobStoreScanner(this, scanInfo, scan, targetCols, readPt);
    }

    @Override
    protected StoreEngine<?, ?, ?, ?> createStoreEngine(HStore store, Configuration conf, CellComparator cellComparator) throws IOException {
        MobStoreEngine engine = new MobStoreEngine();
        engine.createComponentsOnce(conf, store, cellComparator);
        return engine;
    }

    private Path getTempDir() {
        return new Path(this.homePath, ".tmp");
    }

    public StoreFileWriter createWriterInTmp(Date date, long maxKeyCount, Compression.Algorithm compression, byte[] startKey, boolean isCompaction) throws IOException {
        if (startKey == null) {
            startKey = HConstants.EMPTY_START_ROW;
        }
        Path path = this.getTempDir();
        return this.createWriterInTmp(MobUtils.formatDate(date), path, maxKeyCount, compression, startKey, isCompaction);
    }

    public StoreFileWriter createWriterInTmp(String date, Path basePath, long maxKeyCount, Compression.Algorithm compression, byte[] startKey, boolean isCompaction) throws IOException {
        MobFileName mobFileName = MobFileName.create(startKey, date, UUID.randomUUID().toString().replaceAll("-", ""), this.region.getRegionInfo().getEncodedName());
        return this.createWriterInTmp(mobFileName, basePath, maxKeyCount, compression, isCompaction);
    }

    public StoreFileWriter createWriterInTmp(MobFileName mobFileName, Path basePath, long maxKeyCount, Compression.Algorithm compression, boolean isCompaction) throws IOException {
        return MobUtils.createWriter(this.conf, this.getFileSystem(), this.getColumnFamilyDescriptor(), new Path(basePath, mobFileName.getFileName()), maxKeyCount, compression, this.getCacheConfig(), this.getStoreContext().getEncryptionContext(), StoreUtils.getChecksumType(this.conf), StoreUtils.getBytesPerChecksum(this.conf), this.getStoreContext().getBlockSize(), BloomType.NONE, isCompaction);
    }

    public void commitFile(Path sourceFile, Path targetPath) throws IOException {
        if (sourceFile == null) {
            return;
        }
        Path dstPath = new Path(targetPath, sourceFile.getName());
        this.validateMobFile(sourceFile);
        LOG.info(" FLUSH Renaming flushed file from {} to {}", (Object)sourceFile, (Object)dstPath);
        Path parent = dstPath.getParent();
        if (!this.getFileSystem().exists(parent)) {
            this.getFileSystem().mkdirs(parent);
        }
        if (!this.getFileSystem().rename(sourceFile, dstPath)) {
            throw new IOException("Failed rename of " + sourceFile + " to " + dstPath);
        }
    }

    private void validateMobFile(Path path) throws IOException {
        HStoreFile storeFile = null;
        try {
            storeFile = new HStoreFile(this.getFileSystem(), path, this.conf, this.getCacheConfig(), BloomType.NONE, this.isPrimaryReplicaStore());
            storeFile.initReader();
        }
        catch (IOException e) {
            LOG.error("Fail to open mob file[" + path + "], keep it in temp directory.", (Throwable)e);
            throw e;
        }
        finally {
            if (storeFile != null) {
                storeFile.closeStoreFile(false);
            }
        }
    }

    public MobCell resolve(Cell reference, boolean cacheBlocks) throws IOException {
        return this.resolve(reference, cacheBlocks, -1L, true);
    }

    public MobCell resolve(Cell reference, boolean cacheBlocks, boolean readEmptyValueOnMobCellMiss) throws IOException {
        return this.resolve(reference, cacheBlocks, -1L, readEmptyValueOnMobCellMiss);
    }

    public MobCell resolve(Cell reference, boolean cacheBlocks, long readPt, boolean readEmptyValueOnMobCellMiss) throws IOException {
        MobCell mobCell = null;
        if (MobUtils.hasValidMobRefCellValue(reference)) {
            String fileName = MobUtils.getMobFileName(reference);
            Optional<TableName> tableName = MobUtils.getTableName(reference);
            if (tableName.isPresent()) {
                List<Path> locations = this.getLocations(tableName.get());
                mobCell = this.readCell(locations, fileName, reference, cacheBlocks, readPt, readEmptyValueOnMobCellMiss);
            }
        }
        if (mobCell == null) {
            LOG.warn("The Cell result is null, assemble a new Cell with the same row,family,qualifier,timestamp,type and tags but with an empty value to return.");
            ExtendedCell cell = ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(reference.getRowArray(), reference.getRowOffset(), (int)reference.getRowLength()).setFamily(reference.getFamilyArray(), reference.getFamilyOffset(), (int)reference.getFamilyLength()).setQualifier(reference.getQualifierArray(), reference.getQualifierOffset(), reference.getQualifierLength()).setTimestamp(reference.getTimestamp()).setType(reference.getTypeByte()).setValue(HConstants.EMPTY_BYTE_ARRAY).setTags(reference.getTagsArray(), reference.getTagsOffset(), reference.getTagsLength()).build();
            mobCell = new MobCell((Cell)cell);
        }
        return mobCell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Path> getLocations(TableName tableName) throws IOException {
        List<Path> locations = this.map.get(tableName);
        if (locations == null) {
            IdLock.Entry lockEntry = this.keyLock.getLockEntry((long)tableName.hashCode());
            try {
                locations = this.map.get(tableName);
                if (locations == null) {
                    locations = new ArrayList<Path>(2);
                    locations.add(MobUtils.getMobFamilyPath(this.conf, tableName, this.getColumnFamilyName()));
                    locations.add(HFileArchiveUtil.getStoreArchivePath(this.conf, tableName, MobUtils.getMobRegionInfo(tableName).getEncodedName(), this.getColumnFamilyName()));
                    this.map.put(tableName, locations);
                }
            }
            finally {
                this.keyLock.releaseLockEntry(lockEntry);
            }
        }
        return locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MobCell readCell(List<Path> locations, String fileName, Cell search, boolean cacheMobBlocks, long readPt, boolean readEmptyValueOnMobCellMiss) throws IOException {
        FileSystem fs = this.getFileSystem();
        IOException ioe = null;
        for (Path location : locations) {
            MobFile file = null;
            Path path = new Path(location, fileName);
            try {
                file = this.mobFileCache.openFile(fs, path, this.getCacheConfig());
                MobCell mobCell = readPt != -1L ? file.readCell(search, cacheMobBlocks, readPt) : file.readCell(search, cacheMobBlocks);
                return mobCell;
            }
            catch (IOException e) {
                this.mobFileCache.evictFile(fileName);
                ioe = e;
                if (e instanceof FileNotFoundException || e.getCause() instanceof FileNotFoundException) {
                    LOG.debug("Fail to read the cell, the mob file " + path + " doesn't exist", (Throwable)e);
                    continue;
                }
                if (e instanceof CorruptHFileException) {
                    LOG.error("The mob file " + path + " is corrupt", (Throwable)e);
                    break;
                }
                throw e;
            }
            finally {
                if (file == null) continue;
                this.mobFileCache.closeFile(file);
            }
        }
        LOG.error("The mob file " + fileName + " could not be found in the locations " + locations + " or it is corrupt");
        if (readEmptyValueOnMobCellMiss) {
            return null;
        }
        if (ioe instanceof FileNotFoundException || ioe.getCause() instanceof FileNotFoundException) {
            throw new DoNotRetryIOException((Throwable)ioe);
        }
        throw ioe;
    }

    public Path getPath() {
        return this.mobFamilyPath;
    }

    public void updateCellsCountCompactedToMob(long count) {
        this.cellsCountCompactedToMob.addAndGet(count);
    }

    public long getCellsCountCompactedToMob() {
        return this.cellsCountCompactedToMob.get();
    }

    public void updateCellsCountCompactedFromMob(long count) {
        this.cellsCountCompactedFromMob.addAndGet(count);
    }

    public long getCellsCountCompactedFromMob() {
        return this.cellsCountCompactedFromMob.get();
    }

    public void updateCellsSizeCompactedToMob(long size) {
        this.cellsSizeCompactedToMob.addAndGet(size);
    }

    public long getCellsSizeCompactedToMob() {
        return this.cellsSizeCompactedToMob.get();
    }

    public void updateCellsSizeCompactedFromMob(long size) {
        this.cellsSizeCompactedFromMob.addAndGet(size);
    }

    public long getCellsSizeCompactedFromMob() {
        return this.cellsSizeCompactedFromMob.get();
    }

    public void updateMobFlushCount() {
        this.mobFlushCount.incrementAndGet();
    }

    public long getMobFlushCount() {
        return this.mobFlushCount.get();
    }

    public void updateMobFlushedCellsCount(long count) {
        this.mobFlushedCellsCount.addAndGet(count);
    }

    public long getMobFlushedCellsCount() {
        return this.mobFlushedCellsCount.get();
    }

    public void updateMobFlushedCellsSize(long size) {
        this.mobFlushedCellsSize.addAndGet(size);
    }

    public long getMobFlushedCellsSize() {
        return this.mobFlushedCellsSize.get();
    }

    public void updateMobScanCellsCount(long count) {
        this.mobScanCellsCount.addAndGet(count);
    }

    public long getMobScanCellsCount() {
        return this.mobScanCellsCount.get();
    }

    public void updateMobScanCellsSize(long size) {
        this.mobScanCellsSize.addAndGet(size);
    }

    public long getMobScanCellsSize() {
        return this.mobScanCellsSize.get();
    }

    public byte[] getRefCellTags() {
        return this.refCellTags;
    }
}

