/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.AbstractMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class AbstractMultiOutputCompactor<T extends AbstractMultiFileWriter>
extends Compactor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMultiOutputCompactor.class);

    public AbstractMultiOutputCompactor(Configuration conf, HStore store) {
        super(conf, store);
    }

    protected final void initMultiWriter(AbstractMultiFileWriter writer, InternalScanner scanner, final Compactor.FileDetails fd, final boolean shouldDropBehind, final Consumer<Path> writerCreationTracker) {
        AbstractMultiFileWriter.WriterFactory writerFactory = new AbstractMultiFileWriter.WriterFactory(){

            @Override
            public StoreFileWriter createWriter() throws IOException {
                return AbstractMultiOutputCompactor.this.createWriter(fd, shouldDropBehind, writerCreationTracker);
            }

            @Override
            public StoreFileWriter createWriterWithStoragePolicy(String fileStoragePolicy) throws IOException {
                return AbstractMultiOutputCompactor.this.createWriter(fd, shouldDropBehind, fileStoragePolicy, writerCreationTracker);
            }
        };
        StoreScanner storeScanner = scanner instanceof StoreScanner ? (StoreScanner)scanner : null;
        writer.init(storeScanner, writerFactory);
    }

    @Override
    protected void abortWriter(AbstractMultiFileWriter writer) throws IOException {
        FileSystem fs = this.store.getFileSystem();
        for (Path leftoverFile : writer.abortWriters()) {
            try {
                fs.delete(leftoverFile, false);
            }
            catch (IOException e) {
                LOG.warn("Failed to delete the leftover file " + leftoverFile + " after an unfinished compaction.", (Throwable)e);
            }
        }
    }
}

