/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.storefiletracker;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreContext;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.storefiletracker.DefaultStoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.FileBasedStoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.MigrationStoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerBase;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class StoreFileTrackerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(StoreFileTrackerFactory.class);
    public static final String TRACKER_IMPL = "hbase.store.file-tracker.impl";
    private static final Map<Class<? extends StoreFileTracker>, Trackers> CLASS_TO_ENUM = StoreFileTrackerFactory.reverse();

    private static Map<Class<? extends StoreFileTracker>, Trackers> reverse() {
        HashMap<Class<? extends StoreFileTracker>, Trackers> map = new HashMap<Class<? extends StoreFileTracker>, Trackers>();
        for (Trackers tracker : Trackers.values()) {
            map.put(tracker.clazz, tracker);
        }
        return Collections.unmodifiableMap(map);
    }

    private StoreFileTrackerFactory() {
    }

    public static String getStoreFileTrackerName(Configuration conf) {
        return conf.get(TRACKER_IMPL, Trackers.DEFAULT.name());
    }

    public static String getStoreFileTrackerName(Class<? extends StoreFileTracker> clazz) {
        Trackers name = CLASS_TO_ENUM.get(clazz);
        return name != null ? name.name() : clazz.getName();
    }

    public static Class<? extends StoreFileTracker> getTrackerClass(Configuration conf) {
        try {
            Trackers tracker = Trackers.valueOf(StoreFileTrackerFactory.getStoreFileTrackerName(conf).toUpperCase());
            return tracker.clazz;
        }
        catch (IllegalArgumentException e) {
            return conf.getClass(TRACKER_IMPL, Trackers.DEFAULT.clazz, StoreFileTracker.class);
        }
    }

    public static Class<? extends StoreFileTracker> getTrackerClass(String trackerNameOrClass) {
        try {
            Trackers tracker = Trackers.valueOf(trackerNameOrClass.toUpperCase());
            return tracker.clazz;
        }
        catch (IllegalArgumentException e) {
            try {
                return Class.forName(trackerNameOrClass).asSubclass(StoreFileTracker.class);
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    public static StoreFileTracker create(Configuration conf, boolean isPrimaryReplica, StoreContext ctx) {
        Class<? extends StoreFileTracker> tracker = StoreFileTrackerFactory.getTrackerClass(conf);
        LOG.info("instantiating StoreFileTracker impl {}", (Object)tracker.getName());
        return (StoreFileTracker)ReflectionUtils.newInstance(tracker, (Object[])new Object[]{conf, isPrimaryReplica, ctx});
    }

    public static StoreFileTracker create(Configuration conf, TableDescriptor td, ColumnFamilyDescriptor cfd, HRegionFileSystem regionFs) {
        StoreContext ctx = StoreContext.getBuilder().withColumnFamilyDescriptor(cfd).withRegionFileSystem(regionFs).withFamilyStoreDirectoryPath(regionFs.getStoreDir(cfd.getNameAsString())).build();
        return StoreFileTrackerFactory.create(StoreFileTrackerFactory.mergeConfigurations(conf, td, cfd), true, ctx);
    }

    private static Configuration mergeConfigurations(Configuration global, TableDescriptor table, ColumnFamilyDescriptor family) {
        return StoreUtils.createStoreConfiguration(global, table, family);
    }

    static Class<? extends StoreFileTrackerBase> getStoreFileTrackerClassForMigration(Configuration conf, String configName) {
        String trackerName = (String)Preconditions.checkNotNull((Object)conf.get(configName), (String)"config %s is not set", (Object)configName);
        try {
            return Trackers.valueOf((String)trackerName.toUpperCase()).clazz.asSubclass(StoreFileTrackerBase.class);
        }
        catch (IllegalArgumentException e) {
            try {
                return Class.forName(trackerName).asSubclass(StoreFileTrackerBase.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(cnfe);
            }
        }
    }

    static StoreFileTrackerBase createForMigration(Configuration conf, String configName, boolean isPrimaryReplica, StoreContext ctx) {
        Class<? extends StoreFileTrackerBase> tracker = StoreFileTrackerFactory.getStoreFileTrackerClassForMigration(conf, configName);
        if (MigrationStoreFileTracker.class.isAssignableFrom(tracker)) {
            throw new IllegalArgumentException("Should not specify " + configName + " as " + (Object)((Object)Trackers.MIGRATION) + " because it can not be nested");
        }
        LOG.info("instantiating StoreFileTracker impl {} as {}", (Object)tracker.getName(), (Object)configName);
        return (StoreFileTrackerBase)ReflectionUtils.newInstance(tracker, (Object[])new Object[]{conf, isPrimaryReplica, ctx});
    }

    public static TableDescriptor updateWithTrackerConfigs(Configuration conf, TableDescriptor descriptor) {
        if (StringUtils.isEmpty((CharSequence)descriptor.getValue(TRACKER_IMPL))) {
            StoreFileTracker tracker = StoreFileTrackerFactory.create(conf, true, null);
            TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableDescriptor)descriptor);
            return tracker.updateWithTrackerConfigs(builder).build();
        }
        return descriptor;
    }

    public static boolean isMigration(Class<?> clazz) {
        return MigrationStoreFileTracker.class.isAssignableFrom(clazz);
    }

    private static void checkForNewFamily(Configuration conf, TableDescriptor table, ColumnFamilyDescriptor family) throws IOException {
        Configuration mergedConf = StoreFileTrackerFactory.mergeConfigurations(conf, table, family);
        Class<? extends StoreFileTracker> tracker = StoreFileTrackerFactory.getTrackerClass(mergedConf);
        if (MigrationStoreFileTracker.class.isAssignableFrom(tracker)) {
            throw new DoNotRetryIOException("Should not use " + (Object)((Object)Trackers.MIGRATION) + " as store file tracker for new family " + family.getNameAsString() + " of table " + table.getTableName());
        }
    }

    public static void checkForCreateTable(Configuration conf, TableDescriptor table) throws IOException {
        for (ColumnFamilyDescriptor family : table.getColumnFamilies()) {
            StoreFileTrackerFactory.checkForNewFamily(conf, table, family);
        }
    }

    public static void checkForModifyTable(Configuration conf, TableDescriptor oldTable, TableDescriptor newTable) throws IOException {
        for (ColumnFamilyDescriptor newFamily : newTable.getColumnFamilies()) {
            ColumnFamilyDescriptor oldFamily = oldTable.getColumnFamily(newFamily.getName());
            if (oldFamily == null) {
                StoreFileTrackerFactory.checkForNewFamily(conf, newTable, newFamily);
                continue;
            }
            Configuration oldConf = StoreFileTrackerFactory.mergeConfigurations(conf, oldTable, oldFamily);
            Configuration newConf = StoreFileTrackerFactory.mergeConfigurations(conf, newTable, newFamily);
            Class<? extends StoreFileTracker> oldTracker = StoreFileTrackerFactory.getTrackerClass(oldConf);
            Class<? extends StoreFileTracker> newTracker = StoreFileTrackerFactory.getTrackerClass(newConf);
            if (MigrationStoreFileTracker.class.isAssignableFrom(oldTracker)) {
                Class<? extends StoreFileTracker> oldSrcTracker = MigrationStoreFileTracker.getSrcTrackerClass(oldConf);
                Class<? extends StoreFileTracker> oldDstTracker = MigrationStoreFileTracker.getDstTrackerClass(oldConf);
                if (oldTracker.equals(newTracker)) {
                    Class<? extends StoreFileTracker> newSrcTracker = MigrationStoreFileTracker.getSrcTrackerClass(newConf);
                    if (!oldSrcTracker.equals(newSrcTracker)) {
                        throw new DoNotRetryIOException("The src tracker has been changed from " + StoreFileTrackerFactory.getStoreFileTrackerName(oldSrcTracker) + " to " + StoreFileTrackerFactory.getStoreFileTrackerName(newSrcTracker) + " for family " + newFamily.getNameAsString() + " of table " + newTable.getTableName());
                    }
                    Class<? extends StoreFileTracker> newDstTracker = MigrationStoreFileTracker.getDstTrackerClass(newConf);
                    if (oldDstTracker.equals(newDstTracker)) continue;
                    throw new DoNotRetryIOException("The dst tracker has been changed from " + StoreFileTrackerFactory.getStoreFileTrackerName(oldDstTracker) + " to " + StoreFileTrackerFactory.getStoreFileTrackerName(newDstTracker) + " for family " + newFamily.getNameAsString() + " of table " + newTable.getTableName());
                }
                if (newTracker.equals(oldDstTracker)) continue;
                throw new DoNotRetryIOException("Should migrate tracker to " + StoreFileTrackerFactory.getStoreFileTrackerName(oldDstTracker) + " but got " + StoreFileTrackerFactory.getStoreFileTrackerName(newTracker) + " for family " + newFamily.getNameAsString() + " of table " + newTable.getTableName());
            }
            if (oldTracker.equals(newTracker)) continue;
            if (!MigrationStoreFileTracker.class.isAssignableFrom(newTracker)) {
                throw new DoNotRetryIOException("Should change to " + (Object)((Object)Trackers.MIGRATION) + " first when migrating from " + StoreFileTrackerFactory.getStoreFileTrackerName(oldTracker) + " for family " + newFamily.getNameAsString() + " of table " + newTable.getTableName());
            }
            Class<? extends StoreFileTracker> newSrcTracker = MigrationStoreFileTracker.getSrcTrackerClass(newConf);
            if (!oldTracker.equals(newSrcTracker)) {
                throw new DoNotRetryIOException("Should use src tracker " + StoreFileTrackerFactory.getStoreFileTrackerName(oldTracker) + " first but got " + StoreFileTrackerFactory.getStoreFileTrackerName(newSrcTracker) + " when migrating from " + StoreFileTrackerFactory.getStoreFileTrackerName(oldTracker) + " for family " + newFamily.getNameAsString() + " of table " + newTable.getTableName());
            }
            Class<? extends StoreFileTracker> newDstTracker = MigrationStoreFileTracker.getDstTrackerClass(newConf);
            if (!newSrcTracker.equals(newDstTracker)) continue;
            throw new DoNotRetryIOException("The src tracker and dst tracker are both " + StoreFileTrackerFactory.getStoreFileTrackerName(newSrcTracker) + " for family " + newFamily.getNameAsString() + " of table " + newTable.getTableName());
        }
    }

    public static void validatePreRestoreSnapshot(TableDescriptor currentTableDesc, TableDescriptor snapshotTableDesc, Configuration baseConf) throws RestoreSnapshotException {
        for (ColumnFamilyDescriptor cfDesc : currentTableDesc.getColumnFamilies()) {
            Class<? extends StoreFileTracker> snapSFT;
            ColumnFamilyDescriptor snapCFDesc = snapshotTableDesc.getColumnFamily(cfDesc.getName());
            if (snapCFDesc == null) continue;
            Configuration currentCompositeConf = StoreUtils.createStoreConfiguration(baseConf, currentTableDesc, cfDesc);
            Configuration snapCompositeConf = StoreUtils.createStoreConfiguration(baseConf, snapshotTableDesc, snapCFDesc);
            Class<? extends StoreFileTracker> currentSFT = StoreFileTrackerFactory.getTrackerClass(currentCompositeConf);
            if (currentSFT == (snapSFT = StoreFileTrackerFactory.getTrackerClass(snapCompositeConf))) continue;
            throw new RestoreSnapshotException("Restoring Snapshot is not possible because  the config for column family " + cfDesc.getNameAsString() + " has incompatible configuration. Current SFT: " + currentSFT + " SFT from snapshot: " + snapSFT);
        }
    }

    public static enum Trackers {
        DEFAULT(DefaultStoreFileTracker.class),
        FILE(FileBasedStoreFileTracker.class),
        MIGRATION(MigrationStoreFileTracker.class);

        final Class<? extends StoreFileTracker> clazz;

        private Trackers(Class<? extends StoreFileTracker> clazz) {
            this.clazz = clazz;
        }
    }
}

