/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import java.security.PrivilegedExceptionAction;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.GlobFilter;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfUtil;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Shell;
import org.apache.hive.common.util.ShutdownHookManager;

public final class FileUtils {
    private static final Log LOG;
    public static final PathFilter HIDDEN_FILES_PATH_FILTER;
    public static final PathFilter STAGING_DIR_PATH_FILTER;
    static BitSet charToEscape;

    public static Path makeQualified(Path path, Configuration conf) throws IOException {
        if (!path.isAbsolute()) {
            return path.makeQualified(FileSystem.get((Configuration)conf));
        }
        URI fsUri = FileSystem.getDefaultUri((Configuration)conf);
        URI pathUri = path.toUri();
        String scheme = pathUri.getScheme();
        String authority = pathUri.getAuthority();
        if (scheme == null) {
            scheme = fsUri.getScheme();
            authority = fsUri.getAuthority();
            if (authority == null) {
                authority = "";
            }
        } else if (authority == null) {
            authority = scheme.equals(fsUri.getScheme()) && fsUri.getAuthority() != null ? fsUri.getAuthority() : "";
        }
        return new Path(scheme, authority, pathUri.getPath());
    }

    private FileUtils() {
    }

    public static String makePartName(List<String> partCols, List<String> vals) {
        return FileUtils.makePartName(partCols, vals, null);
    }

    public static String makePartName(List<String> partCols, List<String> vals, String defaultStr) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < partCols.size(); ++i) {
            if (i > 0) {
                name.append("/");
            }
            name.append(FileUtils.escapePathName(partCols.get(i).toLowerCase(), defaultStr));
            name.append('=');
            name.append(FileUtils.escapePathName(vals.get(i), defaultStr));
        }
        return name.toString();
    }

    public static String makeDefaultListBucketingDirName(List<String> skewedCols, String name) {
        String defaultDir = FileUtils.escapePathName(name);
        StringBuilder defaultDirPath = new StringBuilder();
        for (int i = 0; i < skewedCols.size(); ++i) {
            if (i > 0) {
                defaultDirPath.append("/");
            }
            defaultDirPath.append(defaultDir);
        }
        String lbDirName = defaultDirPath.toString();
        return lbDirName;
    }

    public static String makeListBucketingDirName(List<String> lbCols, List<String> vals) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < lbCols.size(); ++i) {
            if (i > 0) {
                name.append("/");
            }
            name.append(FileUtils.escapePathName(lbCols.get(i).toLowerCase()));
            name.append('=');
            name.append(FileUtils.escapePathName(vals.get(i)));
        }
        return name.toString();
    }

    static boolean needsEscaping(char c) {
        return c >= '\u0000' && c < charToEscape.size() && charToEscape.get(c);
    }

    public static String escapePathName(String path) {
        return FileUtils.escapePathName(path, null);
    }

    public static String escapePathName(String path, String defaultPath) {
        if (path == null || path.length() == 0) {
            if (defaultPath == null) {
                return "__HIVE_DEFAULT_PARTITION__";
            }
            return defaultPath;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (FileUtils.needsEscaping(c)) {
                sb.append('%');
                sb.append(String.format("%1$02X", c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unescapePathName(String path) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '%' && i + 2 < path.length()) {
                int code = -1;
                try {
                    code = Integer.valueOf(path.substring(i + 1, i + 3), 16);
                }
                catch (Exception e) {
                    code = -1;
                }
                if (code >= 0) {
                    sb.append((char)code);
                    i += 2;
                    continue;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void listStatusRecursively(FileSystem fs, FileStatus fileStatus, List<FileStatus> results) throws IOException {
        if (fileStatus.isDir()) {
            for (FileStatus stat : fs.listStatus(fileStatus.getPath(), HIDDEN_FILES_PATH_FILTER)) {
                FileUtils.listStatusRecursively(fs, stat, results);
            }
        } else {
            results.add(fileStatus);
        }
    }

    public static Path getPathOrParentThatExists(FileSystem fs, Path path) throws IOException {
        if (!fs.exists(path)) {
            Path parentPath = path.getParent();
            return FileUtils.getPathOrParentThatExists(fs, parentPath);
        }
        return path;
    }

    public static void checkFileAccessWithImpersonation(final FileSystem fs, final FileStatus stat, final FsAction action, String user) throws IOException, AccessControlException, InterruptedException, Exception {
        UserGroupInformation ugi = Utils.getUGI();
        String currentUser = ugi.getShortUserName();
        if (user == null || currentUser.equals(user)) {
            ShimLoader.getHadoopShims().checkFileAccess(fs, stat, action);
            return;
        }
        UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser());
        proxyUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                FileSystem fsAsUser = FileSystem.get((URI)fs.getUri(), (Configuration)fs.getConf());
                ShimLoader.getHadoopShims().checkFileAccess(fsAsUser, stat, action);
                return null;
            }
        });
    }

    public static boolean isActionPermittedForFileHierarchy(FileSystem fs, FileStatus fileStatus, String userName, FsAction action) throws Exception {
        FileStatus[] childStatuses;
        boolean isDir = fileStatus.isDir();
        FsAction dirActionNeeded = action;
        if (isDir) {
            dirActionNeeded.and(FsAction.EXECUTE);
        }
        try {
            FileUtils.checkFileAccessWithImpersonation(fs, fileStatus, action, userName);
        }
        catch (AccessControlException err) {
            return false;
        }
        if (!isDir) {
            return true;
        }
        for (FileStatus childStatus : childStatuses = fs.listStatus(fileStatus.getPath())) {
            if (FileUtils.isActionPermittedForFileHierarchy(fs, childStatus, userName, action)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLocalFile(HiveConf conf, String fileName) {
        try {
            return FileUtils.isLocalFile(conf, new URI(fileName));
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)("Unable to create URI from " + fileName), (Throwable)e);
            return false;
        }
    }

    public static boolean isLocalFile(HiveConf conf, URI fileUri) {
        try {
            FileSystem fsForFile = FileSystem.get((URI)fileUri, (Configuration)conf);
            return LocalFileSystem.class.isInstance(fsForFile);
        }
        catch (IOException e) {
            LOG.warn((Object)("Unable to get FileSystem for " + fileUri), (Throwable)e);
            return false;
        }
    }

    public static boolean isOwnerOfFileHierarchy(FileSystem fs, FileStatus fileStatus, String userName) throws IOException {
        FileStatus[] childStatuses;
        if (!fileStatus.getOwner().equals(userName)) {
            return false;
        }
        if (!fileStatus.isDir()) {
            return true;
        }
        for (FileStatus childStatus : childStatuses = fs.listStatus(fileStatus.getPath())) {
            if (FileUtils.isOwnerOfFileHierarchy(fs, childStatus, userName)) continue;
            return false;
        }
        return true;
    }

    public static boolean mkdir(FileSystem fs, Path f, boolean inheritPerms, Configuration conf) throws IOException {
        LOG.info((Object)("Creating directory if it doesn't exist: " + f));
        if (!inheritPerms) {
            return fs.mkdirs(f);
        }
        try {
            return fs.getFileStatus(f).isDir();
        }
        catch (FileNotFoundException ignore) {
            Path lastExistingParent = f;
            Path firstNonExistentParent = null;
            while (!fs.exists(lastExistingParent)) {
                firstNonExistentParent = lastExistingParent;
                lastExistingParent = lastExistingParent.getParent();
            }
            boolean success = fs.mkdirs(f);
            if (!success) {
                return false;
            }
            HadoopShims shim = ShimLoader.getHadoopShims();
            HadoopShims.HdfsFileStatus fullFileStatus = shim.getFullFileStatus(conf, fs, lastExistingParent);
            shim.setFullFileStatus(conf, fullFileStatus, null, fs, firstNonExistentParent, true);
            return true;
        }
    }

    public static Path makeAbsolute(FileSystem fileSystem, Path path) throws IOException {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(fileSystem.getWorkingDirectory(), path);
    }

    public static boolean copy(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, HiveConf conf) throws IOException {
        boolean copied;
        HadoopShims shims = ShimLoader.getHadoopShims();
        if (srcFS.getUri().getScheme().equals("hdfs") && srcFS.getFileStatus(src).getLen() > conf.getLongVar(HiveConf.ConfVars.HIVE_EXEC_COPYFILE_MAXSIZE)) {
            LOG.info((Object)("Source is " + srcFS.getFileStatus(src).getLen() + " bytes. (MAX: " + conf.getLongVar(HiveConf.ConfVars.HIVE_EXEC_COPYFILE_MAXSIZE) + ")"));
            LOG.info((Object)"Launch distributed copy (distcp) job.");
            HiveConfUtil.updateJobCredentialProviders(conf);
            copied = shims.runDistCp(src, dst, (Configuration)conf);
            if (copied && deleteSource) {
                srcFS.delete(src, true);
            }
        } else {
            copied = FileUtil.copy((FileSystem)srcFS, (Path)src, (FileSystem)dstFS, (Path)dst, (boolean)deleteSource, (boolean)overwrite, (Configuration)conf);
        }
        boolean inheritPerms = conf.getBoolVar(HiveConf.ConfVars.HIVE_WAREHOUSE_SUBDIR_INHERIT_PERMS);
        if (copied && inheritPerms) {
            HadoopShims.HdfsFileStatus fullFileStatus = shims.getFullFileStatus((Configuration)conf, dstFS, dst);
            shims.setFullFileStatus((Configuration)conf, fullFileStatus, null, dstFS, dst, true);
        }
        return copied;
    }

    public static boolean moveToTrash(FileSystem fs, Path f, Configuration conf) throws IOException {
        LOG.info((Object)("deleting  " + f));
        HadoopShims hadoopShim = ShimLoader.getHadoopShims();
        boolean result = false;
        try {
            result = hadoopShim.moveToAppropriateTrash(fs, f, conf);
            if (result) {
                LOG.trace((Object)("Moved to trash: " + f));
                return true;
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)(ioe.getMessage() + "; Force to delete it."));
        }
        result = fs.delete(f, true);
        if (!result) {
            LOG.error((Object)("Failed to delete " + f));
        }
        return result;
    }

    public static boolean isSubDir(Path p1, Path p2, FileSystem fs) {
        String path2;
        String path1 = fs.makeQualified(p1).toString();
        return path1.startsWith(path2 = fs.makeQualified(p2).toString());
    }

    public static boolean renameWithPerms(FileSystem fs, Path sourcePath, Path destPath, boolean inheritPerms, Configuration conf) throws IOException {
        LOG.info((Object)("Renaming " + sourcePath + " to " + destPath));
        if (fs.exists(destPath)) {
            throw new IOException("Cannot rename the source path. The destination path already exists.");
        }
        if (!inheritPerms) {
            return fs.rename(sourcePath, destPath);
        }
        if (fs.rename(sourcePath, destPath)) {
            HadoopShims shims = ShimLoader.getHadoopShims();
            HadoopShims.HdfsFileStatus fullFileStatus = shims.getFullFileStatus(conf, fs, destPath.getParent());
            shims.setFullFileStatus(conf, fullFileStatus, null, fs, destPath, true);
            return true;
        }
        return false;
    }

    public static boolean equalsFileSystem(FileSystem fs1, FileSystem fs2) {
        return fs1.getUri().equals(fs2.getUri());
    }

    public static void checkDeletePermission(Path path, Configuration conf, String user) throws AccessControlException, InterruptedException, Exception {
        if (path == null) {
            return;
        }
        FileSystem fs = path.getFileSystem(conf);
        FileStatus stat = null;
        try {
            stat = fs.getFileStatus(path);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        if (stat == null) {
            return;
        }
        FileUtils.checkFileAccessWithImpersonation(fs, stat, FsAction.WRITE, user);
        HadoopShims shims = ShimLoader.getHadoopShims();
        if (!shims.supportStickyBit()) {
            return;
        }
        FileStatus parStatus = fs.getFileStatus(path.getParent());
        if (!shims.hasStickyBit(parStatus.getPermission())) {
            return;
        }
        if (parStatus.getOwner().equals(user)) {
            return;
        }
        FileStatus childStatus = fs.getFileStatus(path);
        if (childStatus.getOwner().equals(user)) {
            return;
        }
        String msg = String.format("Permission Denied: User %s can't delete %s because sticky bit is set on the parent dir and user does not own this file or its parent", user, path);
        throw new IOException(msg);
    }

    public static FileStatus getFileStatusOrNull(FileSystem fs, Path path) throws IOException {
        try {
            return fs.getFileStatus(path);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static void deleteDirectory(File directory) throws IOException {
        org.apache.commons.io.FileUtils.deleteDirectory((File)directory);
    }

    public static File createTempFile(String lScratchDir, String prefix, String suffix) throws IOException {
        File tmpDir;
        File file = tmpDir = lScratchDir == null ? null : new File(lScratchDir);
        if (!(tmpDir == null || tmpDir.exists() || tmpDir.mkdirs() || tmpDir.exists())) {
            throw new RuntimeException("Unable to create temp directory " + lScratchDir);
        }
        File tmpFile = File.createTempFile(prefix, suffix, tmpDir);
        ShutdownHookManager.deleteOnExit(tmpFile);
        return tmpFile;
    }

    public static boolean deleteTmpFile(File tempFile) {
        if (tempFile != null) {
            tempFile.delete();
            ShutdownHookManager.cancelDeleteOnExit(tempFile);
            return true;
        }
        return false;
    }

    public static URI getURI(String path) throws URISyntaxException {
        if (path == null) {
            return null;
        }
        URI uri = new URI(path);
        if (uri.getScheme() == null) {
            uri = new File(path).toURI();
        }
        return uri;
    }

    public static Set<String> getJarFilesByPath(String pathString, Configuration conf) {
        String[] paths;
        HashSet<String> result = new HashSet<String>();
        if (pathString == null || StringUtils.isBlank((String)pathString)) {
            return result;
        }
        for (String path : paths = pathString.split(",")) {
            try {
                Path p = new Path(FileUtils.getURI(path));
                FileSystem fs = p.getFileSystem(conf);
                if (!fs.exists(p)) {
                    LOG.error((Object)("The jar file path " + path + " doesn't exist"));
                    continue;
                }
                if (fs.isDirectory(p)) {
                    FileStatus[] files;
                    for (FileStatus file : files = fs.listStatus(p, (PathFilter)new GlobFilter("*.jar"))) {
                        result.add(file.getPath().toUri().toString());
                    }
                    continue;
                }
                result.add(p.toUri().toString());
            }
            catch (IOException | URISyntaxException e) {
                LOG.error((Object)("Invalid file path " + path), (Throwable)e);
            }
        }
        return result;
    }

    static {
        char[] clist;
        LOG = LogFactory.getLog((String)FileUtils.class.getName());
        HIDDEN_FILES_PATH_FILTER = new PathFilter(){

            public boolean accept(Path p) {
                String name = p.getName();
                return !name.startsWith("_") && !name.startsWith(".");
            }
        };
        STAGING_DIR_PATH_FILTER = new PathFilter(){

            public boolean accept(Path p) {
                String name = p.getName();
                return !name.startsWith(".");
            }
        };
        charToEscape = new BitSet(128);
        for (int c = 0; c < 32; c = (int)((char)(c + 1))) {
            charToEscape.set(c);
        }
        for (char c : clist = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '#', '%', '\'', '*', '/', ':', '=', '?', '\\', '\u007f', '{', '[', ']', '^'}) {
            charToEscape.set(c);
        }
        if (Shell.WINDOWS) {
            char[] winClist;
            for (char c : winClist = new char[]{' ', '<', '>', '|'}) {
                charToEscape.set(c);
            }
        }
    }
}

