/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampTZUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampTZ.class);
    private static final LocalTime DEFAULT_LOCAL_TIME = LocalTime.of(0, 0);
    private static final Pattern SINGLE_DIGIT_PATTERN = Pattern.compile("[\\+-]\\d:\\d\\d");
    static final DateTimeFormatter FORMATTER;
    private static final ThreadLocal<DateFormat> LEGACY_DATE_FORMATTER;

    public static TimestampTZ parse(String s) {
        return TimestampTZUtil.parse(s, null);
    }

    public static TimestampTZ parse(String s, ZoneId defaultTimeZone) {
        ZonedDateTime zonedDateTime;
        s = TimestampTZUtil.handleSingleDigitHourOffset(s);
        try {
            zonedDateTime = ZonedDateTime.parse(s, FORMATTER);
        }
        catch (DateTimeParseException e) {
            ZoneId zoneId;
            LocalTime localTime;
            TemporalAccessor accessor = FORMATTER.parse(s);
            LocalDate localDate = LocalDate.from(accessor);
            try {
                localTime = LocalTime.from(accessor);
            }
            catch (DateTimeException e1) {
                localTime = DEFAULT_LOCAL_TIME;
            }
            try {
                zoneId = ZoneId.from(accessor);
            }
            catch (DateTimeException e2) {
                if (defaultTimeZone == null) {
                    throw new DateTimeException("Time Zone not available");
                }
                zoneId = defaultTimeZone;
            }
            zonedDateTime = ZonedDateTime.of(localDate, localTime, zoneId);
        }
        if (defaultTimeZone == null) {
            return new TimestampTZ(zonedDateTime);
        }
        return new TimestampTZ(zonedDateTime.withZoneSameInstant(defaultTimeZone));
    }

    private static String handleSingleDigitHourOffset(String s) {
        Matcher matcher = SINGLE_DIGIT_PATTERN.matcher(s);
        if (matcher.find()) {
            int index = matcher.start() + 1;
            s = s.substring(0, index) + "0" + s.substring(index, s.length());
        }
        return s;
    }

    public static TimestampTZ parseOrNull(String s, ZoneId defaultTimeZone) {
        try {
            return TimestampTZUtil.parse(s, defaultTimeZone);
        }
        catch (DateTimeParseException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Invalid string " + s + " for TIMESTAMP WITH TIME ZONE", (Throwable)e);
            }
            return null;
        }
    }

    public static TimestampTZ convert(Date date, ZoneId defaultTimeZone) {
        return TimestampTZUtil.parse(date.toString(), defaultTimeZone);
    }

    public static TimestampTZ convert(Timestamp ts, ZoneId defaultTimeZone) {
        return TimestampTZUtil.parse(ts.toString(), defaultTimeZone);
    }

    public static ZoneId parseTimeZone(String timeZoneStr) {
        if (timeZoneStr == null || timeZoneStr.trim().isEmpty() || timeZoneStr.trim().toLowerCase().equals("local")) {
            return ZoneId.systemDefault();
        }
        try {
            return ZoneId.of(timeZoneStr);
        }
        catch (DateTimeException e1) {
            throw new RuntimeException("Invalid time zone displacement value", e1);
        }
    }

    private static DateFormat getLegacyDateFormatter() {
        if (LEGACY_DATE_FORMATTER.get() == null) {
            LEGACY_DATE_FORMATTER.set(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        }
        return LEGACY_DATE_FORMATTER.get();
    }

    public static Timestamp convertTimestampToZone(Timestamp ts, ZoneId fromZone, ZoneId toZone) {
        return TimestampTZUtil.convertTimestampToZone(ts, fromZone, toZone, false);
    }

    public static Timestamp convertTimestampToZone(Timestamp ts, ZoneId fromZone, ZoneId toZone, boolean legacyConversion) {
        if (legacyConversion) {
            try {
                DateFormat formatter = TimestampTZUtil.getLegacyDateFormatter();
                formatter.setTimeZone(TimeZone.getTimeZone(fromZone));
                java.util.Date date = formatter.parse(ts.toString());
                formatter.setTimeZone(TimeZone.getTimeZone(toZone));
                Timestamp result = Timestamp.valueOf(formatter.format(date));
                result.setNanos(ts.getNanos());
                return result;
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        Instant instant = TimestampTZUtil.convert(ts, fromZone).getZonedDateTime().toInstant();
        LocalDateTime localDateTimeAtToZone = LocalDateTime.ofInstant(instant, toZone);
        return Timestamp.ofEpochSecond(localDateTimeAtToZone.toEpochSecond(ZoneOffset.UTC), localDateTimeAtToZone.getNano());
    }

    static {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.append(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        builder.optionalStart().appendLiteral(" ").append(DateTimeFormatter.ofPattern("HH:mm:ss")).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, true).optionalEnd().optionalEnd();
        builder.optionalStart().appendLiteral(" ").optionalEnd();
        builder.optionalStart().appendZoneText(TextStyle.NARROW).optionalEnd();
        FORMATTER = builder.toFormatter();
        LEGACY_DATE_FORMATTER = new ThreadLocal();
    }
}

