/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.mr;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.common.io.CachingPrintStream;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.BucketMatcher;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.SecureCmdDoAs;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mapjoin.MapJoinMemoryExhaustionException;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHelper;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BucketMapJoinContext;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.OperationLog;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.common.util.StreamPrinter;

public class MapredLocalTask
extends Task<MapredLocalWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, FetchOperator> fetchOperators = new HashMap<String, FetchOperator>();
    protected HadoopJobExecHelper jobExecHelper;
    private JobConf job;
    public static final transient Log l4j = LogFactory.getLog(MapredLocalTask.class);
    static final String HIVE_LOCAL_TASK_CHILD_OPTS_KEY = "HIVE_LOCAL_TASK_CHILD_OPTS";
    public static MemoryMXBean memoryMXBean;
    private static final Log LOG;
    private ExecMapperContext execContext = null;
    private Process executor;
    private SecureCmdDoAs secureDoAs;

    public MapredLocalTask() {
    }

    public MapredLocalTask(MapredLocalWork plan, JobConf job, boolean isSilent) throws HiveException {
        this.setWork(plan);
        this.job = job;
        this.console = new SessionState.LogHelper(LOG, isSilent);
    }

    public void setExecContext(ExecMapperContext execContext) {
        this.execContext = execContext;
    }

    @Override
    public void updateTaskMetrics(Metrics metrics) {
        metrics.incrementCounter("hive_mapred_tasks");
    }

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext driverContext) {
        super.initialize(conf, queryPlan, driverContext);
        this.job = new JobConf((Configuration)conf, ExecDriver.class);
        this.execContext = new ExecMapperContext(this.job);
        this.jobExecHelper = new HadoopJobExecHelper(this.job, this.console, this, null);
    }

    public static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");
        return sdf.format(cal.getTime());
    }

    @Override
    public boolean requireLock() {
        return true;
    }

    @Override
    public int execute(DriverContext driverContext) {
        if (this.conf.getBoolVar(HiveConf.ConfVars.SUBMITLOCALTASKVIACHILD)) {
            return this.executeInChildVM(driverContext);
        }
        return this.executeInProcess(driverContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeInChildVM(DriverContext driverContext) {
        try {
            StreamPrinter errPrinter;
            StreamPrinter outPrinter;
            Context ctx = driverContext.getCtx();
            String hiveJar = this.conf.getJar();
            String hadoopExec = this.conf.getVar(HiveConf.ConfVars.HADOOPBIN);
            this.conf.setVar(HiveConf.ConfVars.HIVEADDEDJARS, Utilities.getResourceFiles(this.conf, SessionState.ResourceType.JAR));
            Path planPath = new Path(ctx.getLocalTmpPath(), "plan.xml");
            MapredLocalWork plan = (MapredLocalWork)this.getWork();
            LOG.info((Object)("Generating plan file " + planPath.toString()));
            FSDataOutputStream out = null;
            try {
                out = FileSystem.getLocal((Configuration)this.conf).create(planPath);
                Utilities.serializePlan(plan, (OutputStream)out, this.conf);
                out.close();
                out = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
            String isSilent = "true".equalsIgnoreCase(System.getProperty("test.silent")) ? "-nolog" : "";
            String libJars = ExecDriver.getResource(this.conf, SessionState.ResourceType.JAR);
            String libJarsOption = StringUtils.isEmpty(libJars) ? " " : " -libjars " + libJars + " ";
            String jarCmd = hiveJar + " " + ExecDriver.class.getName() + libJarsOption;
            String hiveConfArgs = ExecDriver.generateCmdLine(this.conf, ctx);
            String cmdLine = hadoopExec + " jar " + jarCmd + " -localtask -plan " + planPath.toString() + " " + isSilent + " " + hiveConfArgs;
            String workDir = new File(".").getCanonicalPath();
            String files = Utilities.getResourceFiles(this.conf, SessionState.ResourceType.FILE);
            if (!files.isEmpty()) {
                cmdLine = cmdLine + " -files " + files;
                workDir = ctx.getLocalTmpPath().toUri().getPath();
                if (!new File(workDir).mkdir()) {
                    throw new IOException("Cannot create tmp working dir: " + workDir);
                }
                for (String f : StringUtils.split(files, ',')) {
                    String link;
                    Path p = new Path(f);
                    String target = p.toUri().getPath();
                    if (FileUtil.symLink((String)target, (String)(link = workDir + "/" + p.getName())) == 0) continue;
                    throw new IOException("Cannot link to added file: " + target + " from: " + link);
                }
            }
            StringBuilder sb = new StringBuilder();
            Properties p = System.getProperties();
            for (String element : MapRedTask.HIVE_SYS_PROP) {
                if (!p.containsKey(element)) continue;
                sb.append(" -D" + element + "=" + p.getProperty(element));
            }
            String hadoopOpts = sb.toString();
            HashMap<String, String> variables = new HashMap<String, String>(System.getenv());
            int hadoopMem = this.conf.getIntVar(HiveConf.ConfVars.HIVEHADOOPMAXMEM);
            if (hadoopMem == 0) {
                variables.remove("HADOOP_HEAPSIZE");
            } else {
                this.console.printInfo(" set heap size\t" + hadoopMem + "MB");
                variables.put("HADOOP_HEAPSIZE", String.valueOf(hadoopMem));
            }
            String endUserName = Utils.getUGI().getShortUserName();
            LOG.debug((Object)("setting HADOOP_USER_NAME\t" + endUserName));
            variables.put("HADOOP_USER_NAME", endUserName);
            if (variables.containsKey("HADOOP_OPTS")) {
                variables.put("HADOOP_OPTS", (String)variables.get("HADOOP_OPTS") + hadoopOpts);
            } else {
                variables.put("HADOOP_OPTS", hadoopOpts);
            }
            if (HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVE_HADOOP_CLASSPATH) != null) {
                if (variables.containsKey("HADOOP_CLASSPATH")) {
                    variables.put("HADOOP_CLASSPATH", (String)variables.get("HADOOP_CLASSPATH") + ";" + HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVE_HADOOP_CLASSPATH));
                } else {
                    variables.put("HADOOP_CLASSPATH", HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVE_HADOOP_CLASSPATH));
                }
            }
            if (variables.containsKey("HIVE_DEBUG_RECURSIVE")) {
                MapRedTask.configureDebugVariablesForChildJVM(variables);
            }
            if (UserGroupInformation.isSecurityEnabled() && UserGroupInformation.isLoginKeytabBased()) {
                this.secureDoAs = new SecureCmdDoAs(this.conf);
                this.secureDoAs.addEnv(variables);
            }
            if (variables.containsKey(HIVE_LOCAL_TASK_CHILD_OPTS_KEY)) {
                String childOpts = (String)variables.get(HIVE_LOCAL_TASK_CHILD_OPTS_KEY);
                if (childOpts == null) {
                    childOpts = "";
                }
                String clientOpts = variables.put("HADOOP_CLIENT_OPTS", childOpts);
                String tmp = (String)variables.get("HADOOP_OPTS");
                if (tmp != null && !StringUtils.isBlank(clientOpts)) {
                    tmp = tmp.replace(clientOpts, childOpts);
                    variables.put("HADOOP_OPTS", tmp);
                }
            }
            String[] env = new String[variables.size()];
            int pos = 0;
            for (Map.Entry entry : variables.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                env[pos++] = name + "=" + value;
                LOG.debug((Object)("Setting env: " + name + "=" + LogUtils.maskIfPassword(name, value)));
            }
            LOG.info((Object)("Executing: " + cmdLine));
            this.executor = Runtime.getRuntime().exec(cmdLine, env, new File(workDir));
            CachingPrintStream errPrintStream = new CachingPrintStream(System.err);
            OperationLog operationLog = OperationLog.getCurrentOperationLog();
            if (operationLog != null) {
                outPrinter = new StreamPrinter(this.executor.getInputStream(), null, System.out, operationLog.getPrintStream());
                errPrinter = new StreamPrinter(this.executor.getErrorStream(), null, errPrintStream, operationLog.getPrintStream());
            } else {
                outPrinter = new StreamPrinter(this.executor.getInputStream(), null, System.out);
                errPrinter = new StreamPrinter(this.executor.getErrorStream(), null, errPrintStream);
            }
            outPrinter.start();
            errPrinter.start();
            int exitVal = this.jobExecHelper.progressLocal(this.executor, this.getId());
            outPrinter.join();
            errPrinter.join();
            if (exitVal != 0) {
                LOG.error((Object)("Execution failed with exit status: " + exitVal));
                if (SessionState.get() != null) {
                    SessionState.get().addLocalMapRedErrors(this.getId(), errPrintStream.getOutput());
                }
            } else {
                LOG.info((Object)"Execution completed successfully");
            }
            int n = exitVal;
            return n;
        }
        catch (Exception e) {
            LOG.error((Object)"Exception: ", (Throwable)e);
            int n = 1;
            return n;
        }
        finally {
            if (this.secureDoAs != null) {
                this.secureDoAs.close();
            }
        }
    }

    public int executeInProcess(DriverContext driverContext) {
        if (this.work == null) {
            return -1;
        }
        if (this.execContext == null) {
            this.execContext = new ExecMapperContext(this.job);
        }
        memoryMXBean = ManagementFactory.getMemoryMXBean();
        long startTime = System.currentTimeMillis();
        this.console.printInfo(Utilities.now() + "\tStarting to launch local task to process map join;\tmaximum memory = " + memoryMXBean.getHeapMemoryUsage().getMax());
        this.execContext.setJc(this.job);
        this.execContext.setLocalWork((MapredLocalWork)this.work);
        try {
            this.startForward(null);
            long currentTime = System.currentTimeMillis();
            long elapsed = currentTime - startTime;
            this.console.printInfo(Utilities.now() + "\tEnd of local task; Time Taken: " + Utilities.showTime(elapsed) + " sec.");
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError || throwable instanceof MapJoinMemoryExhaustionException) {
                l4j.error((Object)"Hive Runtime Error: Map local work exhausted memory", throwable);
                return 3;
            }
            l4j.error((Object)"Hive Runtime Error: Map local work failed", throwable);
            return 2;
        }
        return 0;
    }

    public void startForward(String bigTableBucket) throws Exception {
        boolean inputFileChangeSenstive = ((MapredLocalWork)this.work).getInputFileChangeSensitive();
        this.initializeOperators(new HashMap<FetchOperator, JobConf>());
        if (inputFileChangeSenstive) {
            for (Map<String, List<String>> bigTableBucketFiles : ((MapredLocalWork)this.work).getBucketMapjoinContext().getAliasBucketFileNameMapping().values()) {
                if (bigTableBucket == null) {
                    for (String bigTableBucketFile : bigTableBucketFiles.keySet()) {
                        this.startForward(inputFileChangeSenstive, bigTableBucketFile);
                    }
                    continue;
                }
                if (!bigTableBucketFiles.keySet().contains(bigTableBucket)) continue;
                this.startForward(inputFileChangeSenstive, bigTableBucket);
            }
        } else {
            this.startForward(inputFileChangeSenstive, null);
        }
    }

    private void startForward(boolean inputFileChangeSenstive, String bigTableBucket) throws Exception {
        for (Operator<? extends OperatorDesc> operator : ((MapredLocalWork)this.work).getAliasToWork().values()) {
            operator.reset();
        }
        if (inputFileChangeSenstive) {
            this.execContext.setCurrentBigBucketFile(bigTableBucket);
        }
        for (Map.Entry entry : this.fetchOperators.entrySet()) {
            InspectableObject row;
            String alias = (String)entry.getKey();
            FetchOperator fetchOp = (FetchOperator)entry.getValue();
            if (inputFileChangeSenstive) {
                fetchOp.clearFetchContext();
                this.setUpFetchOpContext(fetchOp, alias, bigTableBucket);
            }
            Operator<? extends OperatorDesc> forwardOp = ((MapredLocalWork)this.work).getAliasToWork().get(alias);
            while (!forwardOp.getDone() && (row = fetchOp.getNextRow()) != null) {
                forwardOp.processOp(row.o, 0);
            }
            forwardOp.flush();
        }
        for (Operator operator : ((MapredLocalWork)this.work).getAliasToWork().values()) {
            operator.close(false);
        }
    }

    private void initializeOperators(Map<FetchOperator, JobConf> fetchOpJobConfMap) throws HiveException {
        FetchOperator fetchOp;
        for (Map.Entry<String, Operator<? extends OperatorDesc>> entry : ((MapredLocalWork)this.work).getAliasToWork().entrySet()) {
            LOG.debug((Object)("initializeOperators: " + entry.getKey() + ", children = " + entry.getValue().getChildOperators()));
        }
        for (Map.Entry<String, Serializable> entry : ((MapredLocalWork)this.work).getAliasToFetchWork().entrySet()) {
            if (entry.getValue() == null) continue;
            JobConf jobClone = new JobConf((Configuration)this.job);
            TableScanOperator ts = (TableScanOperator)((MapredLocalWork)this.work).getAliasToWork().get(entry.getKey());
            ColumnProjectionUtils.appendReadColumns((Configuration)jobClone, ts.getNeededColumnIDs(), ts.getNeededColumns());
            HiveInputFormat.pushFilters(jobClone, ts);
            fetchOp = new FetchOperator((FetchWork)entry.getValue(), jobClone);
            fetchOpJobConfMap.put(fetchOp, jobClone);
            this.fetchOperators.put(entry.getKey(), fetchOp);
            l4j.info((Object)("fetchoperator for " + entry.getKey() + " created"));
        }
        for (Map.Entry<String, Serializable> entry : this.fetchOperators.entrySet()) {
            String alias = entry.getKey();
            Operator<? extends OperatorDesc> forwardOp = ((MapredLocalWork)this.work).getAliasToWork().get(alias);
            forwardOp.setExecContext(this.execContext);
            fetchOp = (FetchOperator)entry.getValue();
            JobConf jobConf = fetchOpJobConfMap.get(fetchOp);
            if (jobConf == null) {
                jobConf = this.job;
            }
            ObjectInspector objectInspector = fetchOp.getOutputObjectInspector();
            forwardOp.initialize((Configuration)jobConf, new ObjectInspector[]{objectInspector});
            l4j.info((Object)("fetchoperator for " + entry.getKey() + " initialized"));
        }
    }

    private void setUpFetchOpContext(FetchOperator fetchOp, String alias, String currentInputFile) throws Exception {
        BucketMapJoinContext bucketMatcherCxt = ((MapredLocalWork)this.work).getBucketMapjoinContext();
        Class<? extends BucketMatcher> bucketMatcherCls = bucketMatcherCxt.getBucketMatcherClass();
        BucketMatcher bucketMatcher = (BucketMatcher)ReflectionUtils.newInstance(bucketMatcherCls, null);
        bucketMatcher.setAliasBucketFileNameMapping(bucketMatcherCxt.getAliasBucketFileNameMapping());
        List<Path> aliasFiles = bucketMatcher.getAliasBucketFiles(currentInputFile, bucketMatcherCxt.getMapJoinBigTableAlias(), alias);
        fetchOp.setupContext(aliasFiles);
    }

    @Override
    public boolean isMapRedLocalTask() {
        return true;
    }

    @Override
    public Collection<Operator<? extends OperatorDesc>> getTopOperators() {
        return ((MapredLocalWork)this.getWork()).getAliasToWork().values();
    }

    @Override
    public String getName() {
        return "MAPREDLOCAL";
    }

    @Override
    public StageType getType() {
        return StageType.MAPREDLOCAL;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.executor != null) {
            this.executor.destroy();
            this.executor = null;
        }
    }

    static {
        LOG = LogFactory.getLog(MapredLocalTask.class);
    }
}

