/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.plan.RelOptAbstractTable;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ExprNodeConverter;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.stats.StatsUtils;

public class RelOptHiveTable
extends RelOptAbstractTable {
    private final Table hiveTblMetadata;
    private final String tblAlias;
    private final ImmutableList<ColumnInfo> hiveNonPartitionCols;
    private final ImmutableMap<Integer, ColumnInfo> hiveNonPartitionColsMap;
    private final ImmutableMap<Integer, ColumnInfo> hivePartitionColsMap;
    private final int noOfProjs;
    final HiveConf hiveConf;
    private double rowCount = -1.0;
    Map<Integer, ColStatistics> hiveColStatsMap = new HashMap<Integer, ColStatistics>();
    PrunedPartitionList partitionList;
    Map<String, PrunedPartitionList> partitionCache;
    AtomicInteger noColsMissingStats;
    protected static final Log LOG = LogFactory.getLog((String)RelOptHiveTable.class.getName());

    public RelOptHiveTable(RelOptSchema calciteSchema, String qualifiedTblName, String tblAlias, RelDataType rowType, Table hiveTblMetadata, List<ColumnInfo> hiveNonPartitionCols, List<ColumnInfo> hivePartitionCols, HiveConf hconf, Map<String, PrunedPartitionList> partitionCache, AtomicInteger noColsMissingStats) {
        super(calciteSchema, qualifiedTblName, rowType);
        this.hiveTblMetadata = hiveTblMetadata;
        this.tblAlias = tblAlias;
        this.hiveNonPartitionCols = ImmutableList.copyOf(hiveNonPartitionCols);
        this.hiveNonPartitionColsMap = RelOptHiveTable.getColInfoMap(hiveNonPartitionCols, 0);
        this.hivePartitionColsMap = RelOptHiveTable.getColInfoMap(hivePartitionCols, this.hiveNonPartitionColsMap.size());
        this.noOfProjs = hiveNonPartitionCols.size() + hivePartitionCols.size();
        this.hiveConf = hconf;
        this.partitionCache = partitionCache;
        this.noColsMissingStats = noColsMissingStats;
    }

    private static ImmutableMap<Integer, ColumnInfo> getColInfoMap(List<ColumnInfo> hiveCols, int startIndx) {
        ImmutableMap.Builder<Integer, ColumnInfo> bldr = ImmutableMap.builder();
        int indx = startIndx;
        for (ColumnInfo ci : hiveCols) {
            bldr.put(indx, ci);
            ++indx;
        }
        return bldr.build();
    }

    public boolean isKey(ImmutableBitSet arg0) {
        return false;
    }

    public RelNode toRel(RelOptTable.ToRelContext context) {
        return new LogicalTableScan(context.getCluster(), (RelOptTable)this);
    }

    public <T> T unwrap(Class<T> arg0) {
        return arg0.isInstance((Object)this) ? (T)arg0.cast((Object)this) : null;
    }

    public double getRowCount() {
        if (this.rowCount == -1.0) {
            if (null == this.partitionList) {
                this.computePartitionList(this.hiveConf, null);
            }
            if (this.hiveTblMetadata.isPartitioned()) {
                List<Long> rowCounts = StatsUtils.getBasicStatForPartitions(this.hiveTblMetadata, this.partitionList.getNotDeniedPartns(), "numRows");
                this.rowCount = StatsUtils.getSumIgnoreNegatives(rowCounts);
            } else {
                this.rowCount = StatsUtils.getNumRows(this.hiveTblMetadata);
            }
        }
        if (this.rowCount == -1.0) {
            this.noColsMissingStats.getAndIncrement();
        }
        return this.rowCount;
    }

    public Table getHiveTableMD() {
        return this.hiveTblMetadata;
    }

    public String getTableAlias() {
        if (this.tblAlias == null) {
            return this.hiveTblMetadata.getTableName();
        }
        return this.tblAlias;
    }

    private String getColNamesForLogging(Set<String> colLst) {
        StringBuffer sb = new StringBuffer();
        boolean firstEntry = true;
        for (String colName : colLst) {
            if (firstEntry) {
                sb.append(colName);
                firstEntry = false;
                continue;
            }
            sb.append(", " + colName);
        }
        return sb.toString();
    }

    public void computePartitionList(HiveConf conf, RexNode pruneNode) {
        try {
            if (!this.hiveTblMetadata.isPartitioned() || pruneNode == null || RelOptUtil.InputFinder.bits((RexNode)pruneNode).length() == 0) {
                this.partitionList = PartitionPruner.prune(this.hiveTblMetadata, null, conf, this.getName(), this.partitionCache);
                return;
            }
            ExprNodeDesc pruneExpr = (ExprNodeDesc)pruneNode.accept((RexVisitor)new ExprNodeConverter(this.getName(), this.getRowType(), true, this.getRelOptSchema().getTypeFactory()));
            this.partitionList = PartitionPruner.prune(this.hiveTblMetadata, pruneExpr, conf, this.getName(), this.partitionCache);
        }
        catch (HiveException he) {
            throw new RuntimeException(he);
        }
    }

    private void updateColStats(Set<Integer> projIndxLst) {
        ArrayList<String> nonPartColNamesThatRqrStats = new ArrayList<String>();
        ArrayList<Integer> nonPartColIndxsThatRqrStats = new ArrayList<Integer>();
        ArrayList<String> partColNamesThatRqrStats = new ArrayList<String>();
        ArrayList<Integer> partColIndxsThatRqrStats = new ArrayList<Integer>();
        HashSet<String> colNamesFailedStats = new HashSet<String>();
        for (Integer pi : projIndxLst) {
            if (this.hiveColStatsMap.get(pi) != null) continue;
            ColumnInfo tmp = this.hiveNonPartitionColsMap.get(pi);
            if (tmp != null) {
                nonPartColNamesThatRqrStats.add(tmp.getInternalName());
                nonPartColIndxsThatRqrStats.add(pi);
                continue;
            }
            tmp = this.hivePartitionColsMap.get(pi);
            if (tmp != null) {
                partColNamesThatRqrStats.add(tmp.getInternalName());
                partColIndxsThatRqrStats.add(pi);
                continue;
            }
            this.noColsMissingStats.getAndIncrement();
            String logMsg = "Unable to find Column Index: " + pi + ", in " + this.hiveTblMetadata.getCompleteName();
            LOG.error((Object)logMsg);
            throw new RuntimeException(logMsg);
        }
        if (null == this.partitionList) {
            this.computePartitionList(this.hiveConf, null);
        }
        if (nonPartColNamesThatRqrStats.size() > 0) {
            List<ColStatistics> hiveColStats;
            if (!this.hiveTblMetadata.isPartitioned()) {
                hiveColStats = StatsUtils.getTableColumnStats(this.hiveTblMetadata, this.hiveNonPartitionCols, nonPartColNamesThatRqrStats);
                if (hiveColStats == null) {
                    colNamesFailedStats.addAll(nonPartColNamesThatRqrStats);
                } else if (hiveColStats.size() != nonPartColNamesThatRqrStats.size()) {
                    HashSet<String> setOfFiledCols = new HashSet<String>(nonPartColNamesThatRqrStats);
                    HashSet<String> setOfObtainedColStats = new HashSet<String>();
                    for (ColStatistics cs : hiveColStats) {
                        setOfObtainedColStats.add(cs.getColumnName());
                    }
                    setOfFiledCols.removeAll(setOfObtainedColStats);
                    colNamesFailedStats.addAll(setOfFiledCols);
                }
            } else {
                try {
                    if (this.partitionList.getNotDeniedPartns().isEmpty()) {
                        this.rowCount = 0.0;
                        hiveColStats = new ArrayList<ColStatistics>();
                        for (String c : nonPartColNamesThatRqrStats) {
                            hiveColStats.add(new ColStatistics(c, null));
                        }
                        colNamesFailedStats.clear();
                    } else {
                        Statistics stats = StatsUtils.collectStatistics(this.hiveConf, this.partitionList, this.hiveTblMetadata, this.hiveNonPartitionCols, nonPartColNamesThatRqrStats, nonPartColNamesThatRqrStats, true, true);
                        this.rowCount = stats.getNumRows();
                        hiveColStats = new ArrayList<ColStatistics>();
                        for (String c : nonPartColNamesThatRqrStats) {
                            ColStatistics cs;
                            cs = stats.getColumnStatisticsFromColName(c);
                            if (cs != null) {
                                hiveColStats.add(cs);
                                continue;
                            }
                            colNamesFailedStats.add(c);
                        }
                    }
                }
                catch (HiveException e) {
                    String logMsg = "Collecting stats failed.";
                    LOG.error((Object)logMsg, (Throwable)e);
                    throw new RuntimeException(logMsg, e);
                }
            }
            if (hiveColStats != null && hiveColStats.size() == nonPartColNamesThatRqrStats.size()) {
                for (int i = 0; i < hiveColStats.size(); ++i) {
                    this.hiveColStatsMap.put((Integer)nonPartColIndxsThatRqrStats.get(i), hiveColStats.get(i));
                }
            }
        }
        if (colNamesFailedStats.isEmpty() && !partColNamesThatRqrStats.isEmpty()) {
            ColStatistics cStats = null;
            for (int i = 0; i < partColNamesThatRqrStats.size(); ++i) {
                cStats = new ColStatistics((String)partColNamesThatRqrStats.get(i), this.hivePartitionColsMap.get(partColIndxsThatRqrStats.get(i)).getTypeName());
                cStats.setCountDistint(this.getDistinctCount(this.partitionList.getPartitions(), (String)partColNamesThatRqrStats.get(i)));
                this.hiveColStatsMap.put((Integer)partColIndxsThatRqrStats.get(i), cStats);
            }
        }
        if (!colNamesFailedStats.isEmpty()) {
            String logMsg = "No Stats for " + this.hiveTblMetadata.getCompleteName() + ", Columns: " + this.getColNamesForLogging(colNamesFailedStats);
            LOG.error((Object)logMsg);
            this.noColsMissingStats.getAndAdd(colNamesFailedStats.size());
            throw new RuntimeException(logMsg);
        }
    }

    private int getDistinctCount(Set<Partition> partitions, String partColName) {
        HashSet<String> distinctVals = new HashSet<String>(partitions.size());
        for (Partition partition : partitions) {
            distinctVals.add(partition.getSpec().get(partColName));
        }
        return distinctVals.size();
    }

    public List<ColStatistics> getColStat(List<Integer> projIndxLst) {
        ImmutableList.Builder colStatsBldr = ImmutableList.builder();
        if (projIndxLst != null) {
            this.updateColStats(new HashSet<Integer>(projIndxLst));
            for (Integer i : projIndxLst) {
                colStatsBldr.add(this.hiveColStatsMap.get(i));
            }
        } else {
            ArrayList<Integer> pILst = new ArrayList<Integer>();
            Integer i = 0;
            while (i < this.noOfProjs) {
                pILst.add(i);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.updateColStats(new HashSet<Integer>(pILst));
            for (Integer pi : pILst) {
                colStatsBldr.add(this.hiveColStatsMap.get(pi));
            }
        }
        return colStatsBldr.build();
    }

    public boolean containsPartitionColumnsOnly(ImmutableBitSet cols) {
        int i = cols.nextSetBit(0);
        while (i >= 0) {
            if (!this.hivePartitionColsMap.containsKey(i)) {
                return false;
            }
            ++i;
            i = cols.nextSetBit(i + 1);
        }
        return true;
    }

    public Map<Integer, ColumnInfo> getPartColInfoMap() {
        return this.hivePartitionColsMap;
    }
}

